/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class PeriodicPaymentFileExport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportPayments(List<PeriodicPayment> payments, File exportFile, boolean externalFile) throws IOException, GeneralSecurityException {
        ZipOutputStream exportFileOutputStream = null;
        try {
            exportFileOutputStream = externalFile ? new ZipOutputStream(new FileOutputStream(exportFile)) : new ZipOutputStream(EncryptData.getInstance().openOutputStream(exportFile));
            for (PeriodicPayment exportPayment : payments) {
                if (exportPayment.getPaymentData() == null) continue;
                StringBuilder filenameBuilder = new StringBuilder("Payment").append(exportPayment.getId()).append('.');
                if (exportPayment.getPmtType() != null) {
                    filenameBuilder.append(exportPayment.getPmtType().name());
                } else if (exportPayment.getFileType() != null) {
                    filenameBuilder.append(exportPayment.getFileType());
                } else {
                    filenameBuilder.append(exportPayment.getOrderType());
                }
                exportFileOutputStream.putNextEntry(new ZipEntry(filenameBuilder.toString()));
                exportFileOutputStream.write(exportPayment.getPaymentData());
                exportFileOutputStream.putNextEntry(new ZipEntry(filenameBuilder.append(".SCHEDULE").toString()));
                this.writeScheduleInformation(exportFileOutputStream, exportPayment);
                if (exportPayment.getGenericPurpose() == null || exportPayment.getGenericPurpose().length() <= 0) continue;
                filenameBuilder.setLength(filenameBuilder.indexOf(".SCHEDULE"));
                filenameBuilder.append(".PURPOSE");
                exportFileOutputStream.putNextEntry(new ZipEntry(filenameBuilder.toString()));
                exportFileOutputStream.write(exportPayment.getGenericPurpose().getBytes("UTF-8"));
            }
        }
        catch (Throwable throwable) {
            Util.closeStream(exportFileOutputStream);
            throw throwable;
        }
        Util.closeStream(exportFileOutputStream);
    }

    private void writeScheduleInformation(OutputStream outputStream, PeriodicPayment periodicPayment) throws IOException {
        StringBuilder scheduleInfoBuilder = new StringBuilder();
        scheduleInfoBuilder.append(periodicPayment.getExecutionInterval().getCode());
        scheduleInfoBuilder.append("|");
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");
        if (periodicPayment.getFirstExecutionDate() != null) {
            scheduleInfoBuilder.append(yyyyMMdd.format(periodicPayment.getFirstExecutionDate()));
        }
        scheduleInfoBuilder.append('|');
        if (periodicPayment.getLastExecutionDate() != null) {
            scheduleInfoBuilder.append(yyyyMMdd.format(periodicPayment.getLastExecutionDate()));
        }
        scheduleInfoBuilder.append('|');
        if (periodicPayment.getPreviousExecutionDate() != null) {
            scheduleInfoBuilder.append(yyyyMMdd.format(periodicPayment.getPreviousExecutionDate()));
        }
        scheduleInfoBuilder.append('|');
        if (periodicPayment.getNextExecutionDate() != null) {
            scheduleInfoBuilder.append(yyyyMMdd.format(periodicPayment.getNextExecutionDate()));
        }
        outputStream.write(scheduleInfoBuilder.toString().getBytes("UTF-8"));
    }
}

