/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.GenericPurposeHandler;
import de.businesslogics.banking.payments.api.ScheduleHandler;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.util.DateUtils;
import io.ebean.Query;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class PeriodicPaymentExecutionRunner<PaymentType>
implements Runnable {
    protected final User user;

    public final int generatePayment(PeriodicPayment periodicPayment) {
        return this.generatePayment(periodicPayment, null);
    }

    public final int generatePayment(PeriodicPayment periodicPayment, Date executionDate) {
        int countGeneratedPayments;
        List<Object> executionDates;
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date today = cal.getTime();
        DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user, periodicPayment.getBank().getTenant());
        cal = DateUtils.addWorkingDays(cal, preferenceStore.getInt(PreferenceConstants.PERIODIC_PREFIX_IN_WORKING_DAYS));
        Date advanceDay = cal.getTime();
        if (executionDate == null) {
            executionDates = this.getExecutionDates(periodicPayment, advanceDay);
        } else {
            executionDates = new ArrayList();
            executionDates.add(executionDate);
        }
        if (executionDates.size() > 0 && (countGeneratedPayments = this.generatePayments(periodicPayment, executionDates, today)) > 0) {
            if (executionDate == null) {
                DB.update(periodicPayment);
                this.finished(countGeneratedPayments);
            }
            return countGeneratedPayments;
        }
        return 0;
    }

    public PeriodicPaymentExecutionRunner(User user) {
        this.user = user;
    }

    @Override
    public final void run() {
        int countGeneratedPayments = 0;
        Query<PeriodicPayment> query = this.user == null ? DB.find(PeriodicPayment.class) : PeriodicPayment.getDefaultQuery(this.user, new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user).getBoolean(PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION), !Util.displayOpenSalaries(this.user));
        for (PeriodicPayment periodicPayment : query.findList()) {
            int newCountGeneratedPayments;
            if (periodicPayment.getNextExecutionDate() == null) continue;
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            DatabasePreferenceStore preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user, periodicPayment.getBank().getTenant());
            Date advanceDay = (cal = DateUtils.addWorkingDays(cal, preferenceStore.getInt(PreferenceConstants.PERIODIC_PREFIX_IN_WORKING_DAYS))).getTime();
            List<Date> executionDates = this.getExecutionDates(periodicPayment, advanceDay);
            if (executionDates.size() <= 0 || (newCountGeneratedPayments = this.generatePayments(periodicPayment, executionDates, today)) <= 0) continue;
            DB.update(periodicPayment);
            countGeneratedPayments += newCountGeneratedPayments;
        }
        if (countGeneratedPayments > 0) {
            this.finished(countGeneratedPayments);
        }
    }

    protected abstract PaymentType getPayment(PeriodicPayment var1);

    protected abstract void setExecutionDate(PaymentType var1, Date var2, PaymentProperties var3);

    protected abstract void updatePurpose(PaymentType var1, List<String> var2);

    protected abstract void createOpenPayment(PaymentType var1, PeriodicPayment var2);

    protected abstract PaymentType updatePaymentAfterGeneration(PaymentType var1, PeriodicPayment var2);

    protected abstract void finished(int var1);

    private int generatePayments(PeriodicPayment periodicPayment, List<Date> executionDates, Date currentDate) {
        Date lastExecutionDate = null;
        int countGeneratedPayments = 0;
        PaymentType p = this.getPayment(periodicPayment);
        if (p == null) {
            return 0;
        }
        GenericPurposeHandler purposeHandler = GenericPurposeHandler.getGenericPurposeHandlerForPeriodicPayment(periodicPayment);
        PaymentProperties paymentProperties = PaymentProperties.findForBank(periodicPayment.getBank());
        for (Date executionDate : executionDates) {
            this.setExecutionDate(p, executionDate, periodicPayment, currentDate, paymentProperties);
            String purpose = purposeHandler.evaluatePurposeForDate(executionDate);
            if (purpose != null) {
                ArrayList<String> purposeLines = new ArrayList<String>();
                for (String purposeLine : purpose.split("\n")) {
                    purposeLines.add(purposeLine);
                }
                this.updatePurpose(p, purposeLines);
            }
            this.createOpenPayment(p, periodicPayment);
            p = this.updatePaymentAfterGeneration(p, periodicPayment);
            lastExecutionDate = executionDate;
            periodicPayment.setPreviousExecutionDate(new java.sql.Date(executionDate.getTime()));
            ++countGeneratedPayments;
        }
        if (lastExecutionDate != null) {
            return countGeneratedPayments;
        }
        return 0;
    }

    private List<Date> getExecutionDates(PeriodicPayment periodicPayment, Date advanceDate) {
        ArrayList<Date> executionDates = new ArrayList<Date>();
        if (periodicPayment.getNextExecutionDate() == null) {
            return executionDates;
        }
        ScheduleHandler scheduleHandler = new ScheduleHandler(periodicPayment);
        Calendar cal = Calendar.getInstance();
        while (!periodicPayment.getNextExecutionDate().after(advanceDate)) {
            java.sql.Date nextDate = periodicPayment.getNextExecutionDate();
            executionDates.add(nextDate);
            cal.setTime(nextDate);
            cal.add(5, 1);
            scheduleHandler.calculateNextExecutionDate(cal.getTime());
            if (periodicPayment.getNextExecutionDate() != null) continue;
            break;
        }
        return executionDates;
    }

    private void setExecutionDate(PaymentType p, Date date, PeriodicPayment periodicPayment, Date currentDate, PaymentProperties paymentProperties) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        switch (periodicPayment.getExecutionInterval()) {
            case MONTH_ULTIMO: {
                c = DateUtils.getMonthUltimoTargetDay(c);
                break;
            }
            case QUARTER_ULTIMO: {
                c = DateUtils.getQuarterUltimoTargetDay(c);
                break;
            }
            case YEAR_ULTIMO: {
                c = DateUtils.getYearsUltimoTargetDay(c);
                break;
            }
            default: {
                c = DateUtils.getNextWorkingDay(c);
            }
        }
        Calendar nextTargetDay = Calendar.getInstance();
        nextTargetDay.setTime(currentDate);
        nextTargetDay = DateUtils.getNextWorkingDay(nextTargetDay);
        if (c.before(nextTargetDay)) {
            this.setExecutionDate(p, nextTargetDay.getTime(), paymentProperties);
        } else {
            this.setExecutionDate(p, c.getTime(), paymentProperties);
        }
    }
}

