/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class PaymentTemplateImport<PaymentType> {
    private static final Pattern PAYMENT_FILE_PATTERN = Pattern.compile("[A-Za-z0-9]+\\.([A-Za-z0-9_]+)(?<!\\.NAME|\\.PURPOSE)$");
    private final BLLogger logger;

    public PaymentTemplateImport(BLLogger logger) {
        this.logger = logger;
    }

    public int importFromZipFile(File file) throws IOException {
        HashMap importPayments = new HashMap();
        ZipFile zipImportFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipEntries = zipImportFile.entries();
        while (zipEntries.hasMoreElements()) {
            PaymentTransferType.PmtType pmtType;
            ZipEntry currentZipEntry = zipEntries.nextElement();
            Matcher paymentFilenameMatcher = PAYMENT_FILE_PATTERN.matcher(currentZipEntry.getName());
            if (!paymentFilenameMatcher.matches() || (pmtType = this.getPaymentType(paymentFilenameMatcher.group(1))) != null && this.importPaymentTemplate(pmtType, zipImportFile, currentZipEntry, importPayments)) continue;
            return -1;
        }
        return this.storePayments(importPayments);
    }

    protected abstract PaymentType loadPaymentFromStream(InputStream var1, PaymentTransferType.PmtType var2) throws IOException;

    protected abstract int storePayments(Map<PaymentTemplate, PaymentType> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importPaymentTemplate(PaymentTransferType.PmtType pmtType, ZipFile importZipFile, ZipEntry paymentFileEntry, Map<PaymentTemplate, PaymentType> importPayments) throws IOException {
        ZipEntry purposeFileEntry;
        PaymentType payment;
        InputStream paymentFileInputStream = importZipFile.getInputStream(paymentFileEntry);
        try {
            payment = this.loadPaymentFromStream(paymentFileInputStream, pmtType);
        }
        finally {
            Util.closeStream(paymentFileInputStream);
        }
        if (payment == null) {
            return false;
        }
        PaymentTemplate paymentTemplate = new PaymentTemplate();
        ZipEntry nameFileEntry = importZipFile.getEntry(paymentFileEntry.getName() + ".NAME");
        if (nameFileEntry != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Streams.copy(importZipFile.getInputStream(nameFileEntry), baos, true);
            if (baos.size() > 0) {
                paymentTemplate.setName(this.getUniqueTemplateName(baos.toString("UTF-8")));
            }
        }
        if (paymentTemplate.getName() == null) {
            paymentTemplate.setName(this.getUniqueTemplateName("Template"));
            this.logger.logError("Failed to read name for payment " + paymentFileEntry.getName() + " from file " + importZipFile.getName() + "!");
        }
        if ((purposeFileEntry = importZipFile.getEntry(paymentFileEntry.getName() + ".PURPOSE")) != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Streams.copy(importZipFile.getInputStream(purposeFileEntry), baos, true);
            if (baos.size() > 0) {
                paymentTemplate.setGenericPurpose(baos.toString("UTF-8"));
            }
        }
        importPayments.put(paymentTemplate, payment);
        return true;
    }

    private String getUniqueTemplateName(String templateName) {
        if (PaymentTemplate.findTemplateByName(templateName) == null) {
            return templateName;
        }
        int counter = 1;
        while (counter < Integer.MAX_VALUE) {
            String newTemplateName;
            if (PaymentTemplate.findTemplateByName(newTemplateName = templateName.concat("." + counter++)) != null) continue;
            return newTemplateName;
        }
        return null;
    }

    private PaymentTransferType.PmtType getPaymentType(String orderOrPmtType) {
        PaymentTransferType.PmtType result = null;
        try {
            result = PaymentTransferType.PmtType.valueOf(orderOrPmtType);
        }
        catch (IllegalArgumentException e) {
            switch (orderOrPmtType) {
                case "CCT": {
                    result = PaymentTransferType.PmtType.SEPA_TRANSFER;
                    break;
                }
                case "CCU": {
                    result = PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER;
                    break;
                }
                case "CIP": {
                    result = PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER;
                    break;
                }
                case "XCT": {
                    result = PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER;
                    break;
                }
                case "AXZ": {
                    result = PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER;
                    break;
                }
                case "XXC": {
                    result = PaymentTransferType.PmtType.SEPA_VIRTUAL_ACCOUNT_TRANSFER;
                    break;
                }
                case "CDD": {
                    result = PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT;
                    break;
                }
                case "CD1": {
                    result = PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT;
                    break;
                }
                case "CDB": {
                    result = PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT;
                    break;
                }
                case "AZV": {
                    result = PaymentTransferType.PmtType.DTAZV_TRANSFER;
                    break;
                }
                case "RFT": {
                    result = PaymentTransferType.PmtType.MT101_TRANSFER;
                    break;
                }
                case "XE2": {
                    result = PaymentTransferType.PmtType.SWISS_ESR_TRANSFER;
                    break;
                }
                case "XDT": {
                    result = PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_EUR;
                    break;
                }
                case "XWT": {
                    result = PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_NON_EUR;
                    break;
                }
                case "XTG": {
                    result = PaymentTransferType.PmtType.BBK_HBV_TARGET2_TRANSFER;
                    break;
                }
                case "XG2": {
                    result = PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_SWIFT_TRANSFER;
                    break;
                }
                case "XG1": {
                    result = PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_DTA_TRANSFER;
                    break;
                }
                case "XGK": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_DTA_TRANSFER;
                    break;
                }
                case "XLK": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_DTA_DIRECT_DEBIT;
                    break;
                }
                case "XGS": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_STEP2_TRANSFER;
                    break;
                }
                case "XCG": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_TRANSFER;
                    break;
                }
                case "XCL": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_DIRECT_DEBIT;
                    break;
                }
                case "XCS": {
                    result = PaymentTransferType.PmtType.BBK_EMZ_PACKED_STEP2_TRANSFER;
                }
            }
        }
        return result;
    }
}

