/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.User;
import java.util.ArrayList;
import java.util.List;

public final class PaymentImportUtil {
    public static List<Account> loadAccounts(User user, BankSettings bankSettings) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        if (bankSettings == null) {
            for (BankUser bankUser : BankUser.findBanksForUser(user)) {
                PaymentImportUtil.loadAccountsForBankUser(accounts, bankUser);
            }
        } else {
            PaymentImportUtil.loadAccountsForBankUser(accounts, BankUser.findBankUser(bankSettings, user));
        }
        return accounts;
    }

    private static void loadAccountsForBankUser(List<Account> accounts, BankUser bankUser) {
        boolean foundHtdAccounts = false;
        for (AccountPermission permission : AccountPermission.findByBankUser(bankUser).findList()) {
            accounts.add(permission.getAccount());
            foundHtdAccounts = true;
        }
        if (!foundHtdAccounts && BankUserHtdInfo.findForBankUser(bankUser) == null) {
            accounts.addAll(Account.findAccountsForBank(bankUser.getBank()));
        }
    }

    public static boolean supportsRecipientImport(PaymentType paymentType, boolean isDesktopClient) {
        switch (paymentType) {
            case SEPA: 
            case MANDATE: 
            case SEPA_FOREIGN: {
                return true;
            }
            case CHEQUE: 
            case AUSTRIAN_TAX_OFFICE: 
            case AUSTRIAN_POSTBAR: 
            case SWISS_DOMESTIC: 
            case SWISS_ESR: 
            case SWISS_POST_ACCOUNT: 
            case SWISS_IID: {
                return false;
            }
            case DTAZV: 
            case DTAUS: {
                return true;
            }
            case MT101: 
            case SWIFT: {
                return false;
            }
            case CFONB160: {
                return true;
            }
            case CFONB320: {
                return false;
            }
        }
        return false;
    }

    private PaymentImportUtil() {
    }
}

