/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentApiMessages;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public abstract class PaymentImportHandler {
    protected final BLLogger logger;
    protected final Locale locale;
    protected List<Account> accounts;
    protected final boolean importRecipient;

    @Deprecated
    public PaymentImportHandler(BLLogger logger, Locale locale) {
        this.logger = logger;
        this.locale = locale;
        this.importRecipient = true;
    }

    public PaymentImportHandler(BLLogger logger, Locale locale, boolean importRecipient) {
        this.logger = logger;
        this.locale = locale;
        this.importRecipient = importRecipient;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Account> loadAccounts(User user, BankSettings selectedBank, PaymentTransferType.PmtType pmtType, PermissionsLoader.AccountType accountType) throws IOException {
        PermissionsLoader permissionLoader = new PermissionsLoader(user);
        ArrayList<Account> accounts = new ArrayList<Account>();
        if (selectedBank != null) {
            BankUser bankUser = BankUser.findBankUser(selectedBank, user);
            if (bankUser == null) throw new ImportException(PaymentApiMessages.getString("PaymentImportHandler.missingPermissionsForBank", new Object[0]));
            String[] transferTypes = new String[]{SendParameters.getOrderType(selectedBank, pmtType), SendParameters.getBTF(selectedBank, pmtType)};
            accounts.addAll(permissionLoader.loadAccounts(transferTypes, bankUser, accountType));
            if (!accounts.isEmpty()) return accounts;
            throw new ImportException(PaymentApiMessages.getString("PaymentImportHandler.missingPermissions", StringUtils.getStringFromStringArray(transferTypes, " / ")));
        }
        HashSet<String> allTransferTypes = new HashSet<String>();
        for (BankUser bankUser : BankUser.findActiveBanksForUser(user)) {
            BankSettings bank = bankUser.getBank();
            String[] transferTypes = new String[]{SendParameters.getOrderType(bank, pmtType), SendParameters.getBTF(bank, pmtType)};
            accounts.addAll(permissionLoader.loadAccounts(transferTypes, bankUser, accountType));
            for (String transferType : transferTypes) {
                allTransferTypes.add(transferType);
            }
        }
        if (!accounts.isEmpty()) return accounts;
        throw new ImportException(PaymentApiMessages.getString("PaymentImportHandler.missingPermissions", StringUtils.getStringFromStringArray(allTransferTypes.toArray(new String[allTransferTypes.size()]), " / ")));
    }

    protected abstract void addIgnoredPayment(String var1);

    public static class ImportException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ImportException(String message) {
            super(message);
        }
    }

    public static class AfterImportException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public AfterImportException(String message) {
            super(message);
        }
    }
}

