/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.format.csv.CSVConverterUtil;
import de.businesslogics.format.csv.FormatI;
import de.businesslogics.format.csv.XLSUtil;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class PaymentConversionHandler2<F extends FormatI> {
    protected final BLLogger logger;
    protected final File file;
    private int sheetIndex = -1;
    private boolean isExcelFile;

    protected PaymentConversionHandler2(BLLogger logger, File file) {
        this.logger = logger;
        this.file = file;
    }

    public final boolean canHandle() {
        try {
            this.isExcelFile = XLSUtil.isXLS(this.file);
            return this.isExcelFile || CSVConverterUtil.isCSVFile(this.file);
        }
        catch (IOException e) {
            this.logger.logError("Failed to check, if payment import file can be converted!", e);
            return false;
        }
    }

    public final ConverterFormat getConverterFormat(User user) {
        this.sheetIndex = -1;
        for (ConverterFormat vo : this.getFormats(user)) {
            try {
                F format = this.getFormat(vo);
                if (this.isExcelFile) {
                    this.sheetIndex = this.checkXls(format, vo.hasHeader());
                    if (this.sheetIndex < 0) continue;
                    return vo;
                }
                if (!this.checkCSVFile(format, vo.hasHeader())) continue;
                return vo;
            }
            catch (Throwable t) {
                this.logger.logWarning("Failed to check the converter format with ID " + vo.getId(), t);
            }
        }
        return null;
    }

    public final int getSheetIndex() {
        return this.sheetIndex;
    }

    public final boolean isExcelFile() {
        return this.isExcelFile;
    }

    public abstract F getDefaultFormat();

    protected abstract F getFormat(ConverterFormat var1);

    protected abstract int checkXls(F var1, boolean var2);

    protected abstract boolean checkCSVFile(F var1, boolean var2);

    protected abstract List<ConverterFormat> getFormats(User var1);
}

