/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

public abstract class OriginatorData {
    private PaymentOriginator paymentOriginator;

    public final void setPaymentOriginator(PaymentOriginator paymentOriginator) throws IOException {
        this.paymentOriginator = paymentOriginator;
        this.loadOriginatorInfo();
    }

    public final PaymentOriginator getPaymentOriginator() {
        return this.paymentOriginator;
    }

    public final String getName() {
        if (this.paymentOriginator != null) {
            return this.paymentOriginator.getName();
        }
        return null;
    }

    public final void setName(String name) {
        if (this.paymentOriginator != null) {
            this.paymentOriginator.setName(name);
        }
    }

    public final Tenant getTenant() {
        if (this.paymentOriginator != null) {
            return this.paymentOriginator.getTenant();
        }
        return null;
    }

    public final void setTenant(Tenant tenant) {
        if (this.paymentOriginator != null) {
            this.paymentOriginator.setTenant(tenant);
        }
    }

    public final Account getDefaultAccount() {
        if (this.paymentOriginator != null) {
            return this.paymentOriginator.getDefaultAccount();
        }
        return null;
    }

    public final void setDefaultAccount(Account account) {
        if (this.paymentOriginator != null) {
            this.paymentOriginator.setDefaultAccount(account);
        }
    }

    public final void save() throws IOException {
        if (this.paymentOriginator == null) {
            return;
        }
        this.buildOriginatorInfo();
        this.paymentOriginator.save();
    }

    protected final Properties loadOriginatorInfoProperties() throws IOException {
        Properties properties = new Properties();
        if (this.paymentOriginator != null && this.paymentOriginator.getOriginatorInfo() != null) {
            properties.load(new StringReader(this.paymentOriginator.getOriginatorInfo()));
        }
        return properties;
    }

    protected final void setOriginatorInfoProperties(Properties properties) throws IOException {
        StringWriter propsWriter = new StringWriter();
        properties.store(propsWriter, null);
        this.paymentOriginator.setOriginatorInfo(propsWriter.toString());
    }

    public abstract void loadFromMultiwebProperties(Properties var1);

    public abstract PaymentType getPaymentType();

    protected abstract void loadOriginatorInfo() throws IOException;

    protected abstract void buildOriginatorInfo() throws IOException;

    protected static enum MultiwebPropertiesKeys {
        NAME,
        STREET,
        CITY,
        FEDERAL_STATE_NO,
        COMPANY_CODE,
        CREDITOR_ID;

    }
}

