/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AbstractTableOverviewPrinter;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class OpenPaymentsTableOverviewPrinter
extends AbstractTableOverviewPrinter<OpenPayment> {
    public OpenPaymentsTableOverviewPrinter(User user, Locale locale, BLLogger logger) {
        super(user, locale, logger, Util.printLogo(user));
    }

    public OpenPaymentsTableOverviewPrinter(User user, Locale locale, BLLogger logger, boolean printLogo) {
        super(user, locale, logger, printLogo);
    }

    @Override
    protected final Map<String, Map<String, List<OpenPayment>>> groupPayments(List<OpenPayment> payments) {
        HashMap<String, Map<String, List<OpenPayment>>> splitMap = new HashMap<String, Map<String, List<OpenPayment>>>();
        for (OpenPayment payment : payments) {
            String account;
            ArrayList<OpenPayment> paymentsList;
            String orderType = this.getPaymentOrderType(payment);
            TreeMap<String, ArrayList<OpenPayment>> orderTypeMap = (TreeMap<String, ArrayList<OpenPayment>>)splitMap.get(orderType);
            if (orderTypeMap == null) {
                orderTypeMap = new TreeMap<String, ArrayList<OpenPayment>>();
                splitMap.put(orderType, orderTypeMap);
            }
            if ((paymentsList = (ArrayList<OpenPayment>)orderTypeMap.get(account = this.getPaymentAccountRepresentation(payment))) == null) {
                paymentsList = new ArrayList<OpenPayment>();
                orderTypeMap.put(account, paymentsList);
            }
            paymentsList.add(payment);
        }
        return splitMap;
    }

    @Override
    protected final int[] getTableColumnsWidths(boolean withOrderTypeColumn) {
        if (withOrderTypeColumn) {
            return new int[]{15, 15, 7, 17, 7, 12};
        }
        return new int[]{15, 15, 17, 7, 12};
    }

    @Override
    protected final void printTableHeader(BLTable table, boolean withOrderTypeColumn) throws PDFException {
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]), FONT);
        if (withOrderTypeColumn) {
            table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.orderType", new Object[0]), FONT);
        }
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.date", new Object[0]), FONT);
        table.addCell(BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]), FONT);
    }

    @Override
    protected final void printPayment(BLTable table, OpenPayment payment, boolean withOrderTypeColumn) throws PDFException {
        table.addCell(payment.getRecipient(), FONT);
        table.addCell(this.getRecipientAccountRepresentation(payment), FONT);
        if (withOrderTypeColumn) {
            table.addCell(this.getPaymentOrderType(payment), FONT);
        }
        table.addCell(payment.getPurpose(), FONT);
        if (payment.getExecutionDate() != null) {
            table.addCell(DateFormat.getDateInstance(2, this.locale).format(payment.getExecutionDate()), FONT);
        } else {
            table.addCell("", FONT);
        }
        if (this.displaySalaries || !this.isSalaryPayment(payment)) {
            table.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
            table.addCell(PaymentUtils.formatAmount(payment.getAmount(), Currency.getInstance(payment.getAmountCurrency()), this.locale), FONT);
            table.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        } else {
            table.addCell("");
        }
    }

    @Override
    protected final String getDocumentTitle() {
        return BankingApiMessages.getString(this.locale, "GeneralMessages.openPayments", new Object[0]);
    }

    @Override
    protected final String getTempFilePrefix() {
        return BankingApiMessages.getString(this.locale, "GeneralMessages.openPayments", new Object[0]);
    }

    @Override
    protected final String getPaymentOrderType(OpenPayment payment) {
        return payment.getOrderTypeOrFileType();
    }

    @Override
    protected final String getPaymentBankName(OpenPayment payment) {
        return payment.getBank().getDisplayName();
    }

    @Override
    protected final String getOrderState(OpenPayment payment) {
        return null;
    }

    @Override
    protected final String getPaymentAccountRepresentation(OpenPayment payment) {
        if (payment.getAccount() != null) {
            StringBuilder sb = new StringBuilder(payment.getAccount().getName());
            if (this.usePrefAccountNameAndIban && payment.getAccount().getIban() != null && !payment.getAccount().getIban().isEmpty()) {
                sb.append("(").append(payment.getAccount().getIban()).append(")");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    protected final BigDecimal getPaymentAmount(OpenPayment payment) {
        return this.getPaymentAmount(payment.getAmount(), this.isSalaryPayment(payment));
    }

    @Override
    protected final Currency getPaymentAmountCurrency(OpenPayment payment) {
        return Currency.getInstance(payment.getAmountCurrency());
    }
}

