/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public abstract class OpenPaymentsTableCsvExport
extends AbstractCsvExport<OpenPayment> {
    protected final Locale locale;
    private final boolean displaySalaryAmounts;
    private final boolean folderColumn;
    private final boolean ibanColumn;

    public OpenPaymentsTableCsvExport(Locale locale, boolean displaySalaryAmounts, boolean folderColumn) {
        this(locale, displaySalaryAmounts, folderColumn, false);
    }

    public OpenPaymentsTableCsvExport(Locale locale, boolean displaySalaryAmounts, boolean folderColumn, boolean ibanColumn) {
        this.locale = locale;
        this.displaySalaryAmounts = displaySalaryAmounts;
        this.folderColumn = folderColumn;
        this.ibanColumn = ibanColumn;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]));
        if (this.ibanColumn) {
            this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.iban", new Object[0]));
        }
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.paymentType", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.recipient", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.amount", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.currency", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.purpose", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.executionDate", new Object[0]));
        if (this.folderColumn) {
            this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.folder", new Object[0]));
        }
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, OpenPayment payment) throws IOException {
        if (payment.getAccount() != null) {
            this.addCell(writer, payment.getAccount().getName());
            if (this.ibanColumn) {
                this.addCell(writer, payment.getAccount().getIban());
            }
        } else {
            this.addCell(writer, "");
            if (this.ibanColumn) {
                this.addCell(writer, "");
            }
        }
        StringBuilder orderType = new StringBuilder(payment.getOrderTypeOrFileType());
        String orderTypeDescription = this.getPaymentTypeDescription(payment);
        if (orderTypeDescription != null && orderTypeDescription.length() > 0) {
            orderType.append(" (").append(orderTypeDescription).append(')');
        }
        this.addCell(writer, orderType.toString());
        this.addCell(writer, payment.getRecipient());
        if (this.displaySalaryAmounts || !this.isSalaryPayment(payment)) {
            Currency currency = Currency.getInstance(payment.getAmountCurrency());
            this.addCell(writer, PaymentUtils.formatAmount(payment.getAmount(), null, currency.getDefaultFractionDigits(), this.locale), true);
            this.addCell(writer, currency.getCurrencyCode());
        } else {
            this.addCell(writer, null);
            this.addCell(writer, null);
        }
        this.addCell(writer, payment.getPurpose());
        if (payment.getExecutionDate() != null) {
            this.addCell(writer, Util.getFormattedExecutionTime(payment.getExecutionDate(), this.locale));
        } else {
            this.addCell(writer, null);
        }
        if (this.folderColumn) {
            if (payment.getFolder() != null) {
                this.addCell(writer, payment.getFolder().getName());
            } else {
                this.addCell(writer, null);
            }
        }
        return true;
    }

    protected abstract String getPaymentTypeDescription(OpenPayment var1);

    protected abstract boolean isSalaryPayment(OpenPayment var1);
}

