/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.task.Substitution;
import java.util.Date;

public abstract class GenericPurposeHandler {
    private GenericPurposeHandler() {
    }

    public final String evaluatePurposeForDate(Date date) {
        if (this.getGenericPurpose() == null) {
            return null;
        }
        try {
            return new Substitution(date).substitute(this.getGenericPurpose());
        }
        catch (Exception e) {
            return this.getGenericPurpose();
        }
    }

    public final void setGenericPurpose(String purpose) {
        if (purpose == null || !purpose.contains("$(DATE")) {
            this.internalSetGenericPurpose(null);
        } else {
            this.internalSetGenericPurpose(purpose);
        }
    }

    public final boolean hasGenericPurpose() {
        return this.getGenericPurpose() != null;
    }

    protected abstract void internalSetGenericPurpose(String var1);

    protected abstract String getGenericPurpose();

    public static GenericPurposeHandler getGenericPurposeHandlerForPeriodicPayment(final PeriodicPayment periodicPayment) {
        return new GenericPurposeHandler(){

            @Override
            protected void internalSetGenericPurpose(String purpose) {
                periodicPayment.setGenericPurpose(purpose);
            }

            @Override
            protected String getGenericPurpose() {
                return periodicPayment.getGenericPurpose();
            }
        };
    }

    public static GenericPurposeHandler getGenericPurposeHandlerForPaymentTemplate(final PaymentTemplate paymentTemplate) {
        return new GenericPurposeHandler(){

            @Override
            protected void internalSetGenericPurpose(String purpose) {
                paymentTemplate.setGenericPurpose(purpose);
            }

            @Override
            protected String getGenericPurpose() {
                return paymentTemplate.getGenericPurpose();
            }
        };
    }
}

