/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.vo.BankUser;

public class FileNumberHandler {
    public static final int getNumber(BankUser bankUser, FileNumber type, int min, int max) {
        Integer toReturn = null;
        switch (type.ordinal()) {
            case 2: {
                if (bankUser == null) break;
                toReturn = bankUser.getBundesbankFileNumber();
                if (toReturn == null) {
                    toReturn = min;
                }
                bankUser.setBundesbankFileNumber(FileNumberHandler.getNextNumber(toReturn, min, max));
                bankUser.save();
                break;
            }
            case 0: {
                if (bankUser == null) break;
                toReturn = bankUser.getDtausReferenceNumber();
                if (toReturn == null) {
                    toReturn = min;
                }
                bankUser.setDtausReferenceNumber(FileNumberHandler.getNextNumber(toReturn, min, max));
                bankUser.save();
                break;
            }
            case 1: {
                toReturn = bankUser.getBank().getDtazvNumber();
                if (toReturn == null) {
                    toReturn = min;
                }
                bankUser.getBank().setDtazvNumber(FileNumberHandler.getNextNumber(toReturn, min, max));
                bankUser.getBank().save();
                break;
            }
            case 3: {
                if (bankUser == null) break;
                toReturn = bankUser.getSepaMessageId();
                if (toReturn == null) {
                    toReturn = min;
                }
                bankUser.setSepaMessageId(FileNumberHandler.getNextNumber(toReturn, min, max));
                bankUser.save();
                break;
            }
            case 4: {
                if (bankUser == null) break;
                toReturn = bankUser.getMt101SenderReference();
                if (toReturn == null) {
                    toReturn = min;
                }
                bankUser.setMt101SenderReference(FileNumberHandler.getNextNumber(toReturn, min, max));
                bankUser.save();
            }
        }
        return toReturn;
    }

    public static void storeNumber(BankUser bankUser, FileNumber type, int number) {
        switch (type.ordinal()) {
            case 2: {
                bankUser.setBundesbankFileNumber(number);
                bankUser.save();
                break;
            }
            case 0: {
                bankUser.setDtausReferenceNumber(number);
                bankUser.save();
                break;
            }
            case 1: {
                bankUser.getBank().setDtazvNumber(number);
                bankUser.getBank().save();
                break;
            }
            case 3: {
                bankUser.setSepaMessageId(number);
                bankUser.save();
                break;
            }
            case 4: {
                bankUser.setMt101SenderReference(number);
                bankUser.save();
            }
        }
    }

    private static Integer getNextNumber(Integer number, int min, int max) {
        if (number == null) {
            return min;
        }
        int nextNumber = number + 1;
        if (nextNumber > max) {
            nextNumber = min;
        }
        return nextNumber;
    }

    public static enum FileNumber {
        DTAUS_REFERENCE_NUMBER,
        DTAZV_SEQUENCE_NUMBER,
        BUNDESBANK_FILE_NUMBER,
        SEPA_MESSAGE_ID,
        MT101_SENDER_REFERENCE;

    }
}

