/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.Util;
import de.businesslogics.util.Currency;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Scanner;

public final class CurrenciesLoader {
    private static String[] CACHE = null;
    private static long lastModified = 0L;

    public static String[] getCurrencies() throws IOException {
        File properties = new File(new File(Util.WORKSPACEDIR, "payments"), "currency.properties");
        if (properties.exists() && properties.lastModified() != lastModified) {
            CACHE = null;
        }
        if (CACHE != null) {
            return CACHE;
        }
        HashSet<String> currencies = new HashSet<String>();
        if (properties.exists()) {
            Scanner scanner = new Scanner(properties);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.length() < 3) continue;
                currencies.add(line.substring(0, 3));
            }
            scanner.close();
            lastModified = properties.lastModified();
        }
        Iterator iterator = currencies.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Currency.getInstance(string);
            }
            catch (IllegalArgumentException e) {
                iterator.remove();
            }
        }
        if (currencies.isEmpty()) {
            ResourceBundle b = ResourceBundle.getBundle("de.businesslogics.banking.payments.api.currencies");
            currencies.addAll(b.keySet());
        }
        Object[] currencyCodesArray = currencies.toArray(new String[0]);
        Arrays.sort(currencyCodesArray);
        CACHE = currencyCodesArray;
        return currencyCodesArray;
    }

    private CurrenciesLoader() {
    }
}

