/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.SclDirectory;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Transaction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public final class BicLoader {
    private static final String BUNDESBANK_SCL_URL = "https://www.blbanking.de/license/scl";
    private static BicLoader instance;

    public static String getDisplayNameForService(Service service) {
        switch (service.ordinal()) {
            case 0: {
                return "SCT";
            }
            case 1: {
                return "CORE";
            }
            case 2: {
                return "COR1";
            }
            case 3: {
                return "B2B";
            }
        }
        return "";
    }

    public static BicLoader getInstance() {
        if (instance == null) {
            instance = new BicLoader();
            try {
                instance.checkForBics();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    private BicLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForBics() throws IOException {
        SclDirectory sclDirectory = (SclDirectory)DB.find(SclDirectory.class).setMaxRows(1).findOne();
        if (sclDirectory == null) {
            InputStream resourceInputStream = null;
            try {
                resourceInputStream = this.getClass().getResourceAsStream("/verzeichnis_scl_erreichbare_ki.csv");
                if (resourceInputStream != null) {
                    this.loadDataFromStream(resourceInputStream);
                    return;
                }
            }
            finally {
                if (resourceInputStream != null) {
                    try {
                        resourceInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        if (sclDirectory == null || cal.getTime().compareTo(sclDirectory.getValidDate()) > 0) {
            InputStream urlInputStream = null;
            try {
                URL url = new URL(BUNDESBANK_SCL_URL);
                URLConnection con = url.openConnection();
                if (con instanceof HttpsURLConnection) {
                    EbicsHttpEngineImpl.setSSLSocketFactory((HttpsURLConnection)con);
                }
                urlInputStream = con.getInputStream();
                this.loadDataFromStream(urlInputStream);
            }
            finally {
                if (urlInputStream != null) {
                    try {
                        urlInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public List<SclDirectory> findSclDirectoriesContaining(String searchString, Service service) {
        Object like = searchString == null ? "%" : "%" + searchString + "%";
        if (service != null) {
            return DB.find(SclDirectory.class).where().and(Expr.eq((String)service.name(), (Object)Boolean.TRUE), Expr.or((Expression)Expr.ilike((String)"name", (String)like), (Expression)Expr.ilike((String)"bic", (String)like))).orderBy("bic asc").findList();
        }
        return DB.find(SclDirectory.class).where().or(Expr.ilike((String)"name", (String)like), Expr.ilike((String)"bic", (String)like)).orderBy("bic asc").findList();
    }

    public boolean isBicSupported(String bic, Service service) {
        SclDirectory sclDirectory = SclDirectory.getForBIC(bic);
        if (sclDirectory == null || service == null) {
            return true;
        }
        switch (service.ordinal()) {
            case 0: {
                return sclDirectory.isSct();
            }
            case 1: {
                return sclDirectory.isSdd();
            }
            case 3: {
                return sclDirectory.isB2b();
            }
            case 2: {
                return sclDirectory.isCor1();
            }
        }
        return false;
    }

    public String getBankName(String bic) {
        if (bic == null) {
            return null;
        }
        SclDirectory directory = SclDirectory.getForBIC(bic);
        if (directory != null) {
            return directory.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataFromStream(InputStream inputStream) {
        try (Scanner scanner = new Scanner(inputStream, "ISO-8859-15");){
            Date validDate;
            String line = scanner.nextLine();
            if (line == null) {
                return;
            }
            Matcher dateMatcher = Pattern.compile(".*([0-9]{2})\\.([0-9]{2})\\.([0-9]{4})").matcher(line);
            if (dateMatcher.matches()) {
                Calendar cal = Calendar.getInstance();
                cal.set(1, Integer.parseInt(dateMatcher.group(3)));
                cal.set(2, Integer.parseInt(dateMatcher.group(2)) - 1);
                cal.set(5, Integer.parseInt(dateMatcher.group(1)));
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                validDate = new Date(cal.getTime().getTime());
            } else {
                validDate = new Date(System.currentTimeMillis());
            }
            scanner.nextLine();
            boolean updatedAtLeastOneElement = false;
            try (Transaction t = DB.beginTransaction();){
                while (scanner.hasNext()) {
                    line = scanner.nextLine();
                    StringTokenizer tokenizer = new StringTokenizer(line, ";");
                    if (tokenizer.countTokens() < 7) continue;
                    SclDirectory.updateEntry(tokenizer.nextToken().trim(), tokenizer.nextToken().trim(), "1".equals(tokenizer.nextToken()), "1".equals(tokenizer.nextToken()), "1".equals(tokenizer.nextToken()), "1".equals(tokenizer.nextToken()), "1".equals(tokenizer.nextToken()), validDate);
                    updatedAtLeastOneElement = true;
                }
                if (updatedAtLeastOneElement) {
                    SclDirectory.deleteOld(validDate);
                }
                t.commit();
            }
        }
    }

    public static enum Service {
        Sct,
        Sdd,
        Cor1,
        B2b;

    }
}

