/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.Printable;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.printer.BasePaymentPrinter;
import de.businesslogics.format.printer.PaymentPrinterMessages;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;

public abstract class BankingPaymentPrinter
extends BasePaymentPrinter {
    protected BankingPaymentPrinter(Locale locale) {
        super(locale);
    }

    @Deprecated
    protected void printOrderInfo(BLTable<?> table, Send send, String reference) throws PDFException {
        BankingPaymentPrinter.printOrderInfo(this, table, send, reference);
    }

    public static void printOrderInfo(BasePaymentPrinter printer, BLTable<?> table, Send send, String reference) throws PDFException {
        if (send != null) {
            printer.printOrderInfo(table, send.getSent(), send.getOriginalSendType(), send.getOrderNumber(), send.getSender(), send.getBank().getDisplayName(), reference);
        }
    }

    public static File printPayments(User user, BLLogger logger, Locale locale, Map<?, ? extends Printable> payments) throws PDFException, IOException {
        boolean printLogo = Util.printLogo(user);
        return BankingPaymentPrinter.printPayments(user, logger, locale, payments, printLogo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File printPayments(User user, BLLogger logger, Locale locale, Map<?, ? extends Printable> payments, boolean printLogo) throws PDFException, IOException {
        File result = Util.createTempFile(PaymentPrinterMessages.getString(locale, "PaymentPrinter.tempFilePrefix", new Object[0]), ".pdf", true);
        FileOutputStream resultOutputStream = null;
        BLDocument document = null;
        try {
            resultOutputStream = new FileOutputStream(result);
            document = Util.createBLDocument(resultOutputStream, BLDocument.PageLayout.A4, PaymentPrinterMessages.getString(locale, "PaymentPrinter.tempFilePrefix", new Object[0]), printLogo, locale);
            if (payments != null && payments.size() > 0) {
                boolean firstPayment = true;
                boolean newPage = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean(PreferenceConstants.NEW_PAGE_ON_PRINT);
                for (Object vo : payments.keySet()) {
                    Printable payment = payments.get(vo);
                    if (!firstPayment) {
                        if (newPage) {
                            document.newPage();
                        } else {
                            document.addNewLine();
                        }
                    } else {
                        firstPayment = false;
                    }
                    payment.print(document, locale);
                }
            }
        }
        finally {
            block16: {
                if (document != null) {
                    document.close();
                }
                if (resultOutputStream != null) {
                    try {
                        ((OutputStream)resultOutputStream).close();
                    }
                    catch (IOException e) {
                        if (logger == null) break block16;
                        logger.logError("Failed to close output stream on file " + result.getAbsolutePath(), e);
                    }
                }
            }
        }
        Util.applyPreferencesToPdf(result, user, null, locale, null, null, printLogo);
        return result;
    }

    public static String translateCountry(CountriesLoader loader, String isoCode) {
        String tmp = loader.getCountryName(isoCode);
        if (tmp != null) {
            return tmp;
        }
        return isoCode;
    }
}

