/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.BankDeleteNotifier;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.UrgentPaymentRecipient;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;

public class BankDelete
implements BankDeleteNotifier {
    @Override
    public String[] checkDataToBeDeleted(BankSettings bank, Locale locale) {
        int open = OpenPayment.getOpenPaymentsCount(bank);
        int periodic = PeriodicPayment.getNumberOfPeriodicPayments(bank);
        int template = PaymentTemplate.getNumberOfPaymentTemplates(bank);
        ArrayList<String> toReturn = new ArrayList<String>();
        if (open > 0) {
            toReturn.add(MessageFormat.format(BankingApiMessages.getString(locale, "GeneralMessages.countOpenPayments", new Object[0]), open));
        }
        if (periodic > 0) {
            toReturn.add(MessageFormat.format(BankingApiMessages.getString(locale, "GeneralMessages.countPeriodicPayments", new Object[0]), periodic));
        }
        if (template > 0) {
            toReturn.add(MessageFormat.format(BankingApiMessages.getString(locale, "GeneralMessages.countPaymentTemplates", new Object[0]), template));
        }
        if (toReturn.isEmpty()) {
            return null;
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    @Override
    public String[] checkDataToBeDeleted(BankSettings[] banks, Locale locale) {
        int open = 0;
        int periodic = 0;
        int template = 0;
        for (int i = 0; i < banks.length; ++i) {
            open += OpenPayment.getOpenPaymentsCount(banks[i]);
            periodic += PeriodicPayment.getNumberOfPeriodicPayments(banks[i]);
            periodic += PaymentTemplate.getNumberOfPaymentTemplates(banks[i]);
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        if (open > 0) {
            toReturn.add(MessageFormat.format(BankingApiMessages.getString(locale, "GeneralMessages.countOpenPayments", new Object[0]), open));
        }
        if (periodic > 0) {
            toReturn.add(MessageFormat.format(BankingApiMessages.getString(locale, "GeneralMessages.countPeriodicPayments", new Object[0]), periodic));
        }
        if (template > 0) {
            toReturn.add(MessageFormat.format(BankingApiMessages.getString(locale, "GeneralMessages.countPaymentTemplates", new Object[0]), template));
        }
        if (toReturn.isEmpty()) {
            return null;
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    @Override
    public void deleteBank(BankSettings bank, IProgressMonitorWrapper monitor) {
        OpenPayment.deleteAll(bank);
        PeriodicPayment.deleteAll(bank);
        PaymentTemplate.deleteAll(bank);
        UrgentPaymentRecipient.deleteByBank(bank);
        PaymentProperties paymentProperties = PaymentProperties.findExistingForBank(bank);
        if (paymentProperties != null) {
            DB.delete(paymentProperties);
        }
    }
}

