/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.util.Properties;
import java.util.StringTokenizer;

public class AddressPropertyHandler {
    private static final String ADDRESS_LINE_SEPARATOR = "|";

    public static AddressData getAddressData(Properties properties) {
        AddressData address = new AddressData();
        AddressPropertyHandler.setAddressLines(address, properties.getProperty(PropertiesKeys.ADDRESS_LINES.getKey()));
        address.setCountry(properties.getProperty(PropertiesKeys.COUNTRY.getKey()));
        address.setCountryOfResidence(properties.getProperty(PropertiesKeys.COUNTRY_OF_RESIDENCE.getKey()));
        address.setDepartment(properties.getProperty(PropertiesKeys.DEPARTMENT.getKey()));
        address.setSubDepartment(properties.getProperty(PropertiesKeys.SUB_DEPARTMENT.getKey()));
        address.setStreetName(properties.getProperty(PropertiesKeys.STREET_NAME.getKey()));
        address.setBuildingNumber(properties.getProperty(PropertiesKeys.BUILDING_NUMBER.getKey()));
        address.setBuildingName(properties.getProperty(PropertiesKeys.BUILDING_NAME.getKey()));
        address.setFloor(properties.getProperty(PropertiesKeys.FLOOR.getKey()));
        address.setPostBox(properties.getProperty(PropertiesKeys.POST_BOX.getKey()));
        address.setRoom(properties.getProperty(PropertiesKeys.ROOM.getKey()));
        address.setPostCode(properties.getProperty(PropertiesKeys.POST_CODE.getKey()));
        address.setTownName(properties.getProperty(PropertiesKeys.TOWN_NAME.getKey()));
        address.setTownLocationName(properties.getProperty(PropertiesKeys.TOWN_LOCATION_NAME.getKey()));
        address.setDistrictName(properties.getProperty(PropertiesKeys.DISTRICT_NAME.getKey()));
        address.setCountrySubDivision(properties.getProperty(PropertiesKeys.COUNTRY_SUB_DIVISION.getKey()));
        return address;
    }

    public static AddressData getBankAddressData(Properties properties) {
        AddressData address = new AddressData();
        AddressPropertyHandler.setAddressLines(address, properties.getProperty(PropertiesKeys.BANK_ADDRESS_LINES.getKey()));
        address.setCountry(properties.getProperty(PropertiesKeys.BANK_COUNTRY.getKey()));
        address.setDepartment(properties.getProperty(PropertiesKeys.BANK_DEPARTMENT.getKey()));
        address.setSubDepartment(properties.getProperty(PropertiesKeys.BANK_SUB_DEPARTMENT.getKey()));
        address.setStreetName(properties.getProperty(PropertiesKeys.BANK_STREET_NAME.getKey()));
        address.setBuildingNumber(properties.getProperty(PropertiesKeys.BANK_BUILDING_NUMBER.getKey()));
        address.setBuildingName(properties.getProperty(PropertiesKeys.BANK_BUILDING_NAME.getKey()));
        address.setFloor(properties.getProperty(PropertiesKeys.BANK_FLOOR.getKey()));
        address.setPostBox(properties.getProperty(PropertiesKeys.BANK_POST_BOX.getKey()));
        address.setRoom(properties.getProperty(PropertiesKeys.BANK_ROOM.getKey()));
        address.setPostCode(properties.getProperty(PropertiesKeys.BANK_POST_CODE.getKey()));
        address.setTownName(properties.getProperty(PropertiesKeys.BANK_TOWN_NAME.getKey()));
        address.setTownLocationName(properties.getProperty(PropertiesKeys.BANK_TOWN_LOCATION_NAME.getKey()));
        address.setDistrictName(properties.getProperty(PropertiesKeys.BANK_DISTRICT_NAME.getKey()));
        address.setCountrySubDivision(properties.getProperty(PropertiesKeys.BANK_COUNTRY_SUB_DIVISION.getKey()));
        return address;
    }

    private static void setAddressLines(AddressData address, String propertyValue) {
        if (propertyValue != null) {
            StringTokenizer st = new StringTokenizer(propertyValue, ADDRESS_LINE_SEPARATOR);
            while (st.hasMoreTokens()) {
                address.getAddressLines().add(st.nextToken());
            }
        }
    }

    public static void setAddressData(AddressData address, Properties properties) {
        if (address != null) {
            String addressLines = StringUtils.getStringFromStringList(address.getAddressLines(), ADDRESS_LINE_SEPARATOR);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.ADDRESS_LINES, addressLines);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.COUNTRY, address.getCountry());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.COUNTRY_OF_RESIDENCE, address.getCountryOfResidence());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.DEPARTMENT, address.getDepartment());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.SUB_DEPARTMENT, address.getSubDepartment());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.STREET_NAME, address.getStreetName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BUILDING_NUMBER, address.getBuildingNumber());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BUILDING_NAME, address.getBuildingName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.FLOOR, address.getFloor());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.POST_BOX, address.getPostBox());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.ROOM, address.getRoom());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.POST_CODE, address.getPostCode());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.TOWN_NAME, address.getTownName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.TOWN_LOCATION_NAME, address.getTownLocationName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.DISTRICT_NAME, address.getDistrictName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.COUNTRY_SUB_DIVISION, address.getCountrySubDivision());
        } else {
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.ADDRESS_LINES, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.COUNTRY, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.COUNTRY_OF_RESIDENCE, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.DEPARTMENT, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.SUB_DEPARTMENT, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.STREET_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BUILDING_NUMBER, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BUILDING_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.FLOOR, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.POST_BOX, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.ROOM, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.POST_CODE, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.TOWN_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.TOWN_LOCATION_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.DISTRICT_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.COUNTRY_SUB_DIVISION, null);
        }
    }

    public static void setBankAddressData(AddressData address, Properties properties) {
        if (address != null) {
            String addressLines = StringUtils.getStringFromStringList(address.getAddressLines(), ADDRESS_LINE_SEPARATOR);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_ADDRESS_LINES, addressLines);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_COUNTRY, address.getCountry());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_DEPARTMENT, address.getDepartment());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_SUB_DEPARTMENT, address.getSubDepartment());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_STREET_NAME, address.getStreetName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_BUILDING_NUMBER, address.getBuildingNumber());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_BUILDING_NAME, address.getBuildingName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_FLOOR, address.getFloor());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_POST_BOX, address.getPostBox());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_ROOM, address.getRoom());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_POST_CODE, address.getPostCode());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_TOWN_NAME, address.getTownName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_TOWN_LOCATION_NAME, address.getTownLocationName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_DISTRICT_NAME, address.getDistrictName());
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_COUNTRY_SUB_DIVISION, address.getCountrySubDivision());
        } else {
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_ADDRESS_LINES, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_COUNTRY, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_DEPARTMENT, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_SUB_DEPARTMENT, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_STREET_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_BUILDING_NUMBER, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_BUILDING_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_FLOOR, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_POST_BOX, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_ROOM, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_POST_CODE, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_TOWN_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_TOWN_LOCATION_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_DISTRICT_NAME, null);
            AddressPropertyHandler.setProperty(properties, PropertiesKeys.BANK_COUNTRY_SUB_DIVISION, null);
        }
    }

    private static void setProperty(Properties properties, PropertiesKeys key, String value) {
        if (value == null || value.trim().length() == 0) {
            properties.remove(key.getKey());
        } else {
            properties.setProperty(key.getKey(), value);
        }
    }

    private static enum PropertiesKeys {
        ADDRESS_LINES("addrLines"),
        COUNTRY("country"),
        COUNTRY_OF_RESIDENCE("countryOfResidence"),
        DEPARTMENT("department"),
        SUB_DEPARTMENT("subDepartment"),
        STREET_NAME("streetName"),
        BUILDING_NUMBER("buildingNumber"),
        BUILDING_NAME("buildingName"),
        FLOOR("floor"),
        POST_BOX("postBox"),
        ROOM("room"),
        POST_CODE("postCode"),
        TOWN_NAME("townName"),
        TOWN_LOCATION_NAME("townLocationName"),
        DISTRICT_NAME("districtName"),
        COUNTRY_SUB_DIVISION("countrySubDivision"),
        BANK_ADDRESS_LINES("bankAddrLines"),
        BANK_COUNTRY("bankCountry"),
        BANK_DEPARTMENT("bankDepartment"),
        BANK_SUB_DEPARTMENT("bankSubDepartment"),
        BANK_STREET_NAME("bankStreetName"),
        BANK_BUILDING_NUMBER("bankBuildingNumber"),
        BANK_BUILDING_NAME("bankBuildingName"),
        BANK_FLOOR("bankFloor"),
        BANK_POST_BOX("bankPostBox"),
        BANK_ROOM("bankRoom"),
        BANK_POST_CODE("bankPostCode"),
        BANK_TOWN_NAME("bankTownName"),
        BANK_TOWN_LOCATION_NAME("bankTownLocationName"),
        BANK_DISTRICT_NAME("bankDistrictName"),
        BANK_COUNTRY_SUB_DIVISION("bankCountrySubDivision");

        private final String key;

        private PropertiesKeys(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

