/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.AmountsSum;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractTableOverviewPrinter<PaymentType> {
    protected static final BLFont FONT = BLFont.FONT_NORMAL;
    protected static final BLFont BOLD_FONT = BLFont.FONT_BOLD;
    private final User user;
    protected final Locale locale;
    private final BLLogger logger;
    protected final boolean displaySalaries;
    protected final boolean usePrefAccountNameAndIban;
    protected boolean printLogo;

    protected AbstractTableOverviewPrinter(User user, Locale locale, BLLogger logger, boolean printLogo) {
        this.user = user;
        this.displaySalaries = Util.displaySalaries(user);
        this.locale = locale;
        this.logger = logger;
        this.printLogo = printLogo;
        this.usePrefAccountNameAndIban = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean(PreferenceConstants.SHOW_ACCOUNT_NAME_WITH_IBAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File print(List<PaymentType> payments) throws PDFException, IOException {
        File result = Util.createTempFile(this.getTempFilePrefix(), ".pdf", true);
        FileOutputStream resultOutputStream = null;
        BLDocument document = null;
        try {
            resultOutputStream = new FileOutputStream(result);
            document = Util.createBLDocument(resultOutputStream, BLDocument.PageLayout.A4_LANDSCAPE, this.getDocumentTitle(), this.printLogo, this.locale);
            document.addHeadline(this.getDocumentTitle(), FONT, Alignment.ALIGN_CENTER, 20.0f);
            if (new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user).getBoolean(PreferenceConstants.GROUP_PAYMENTS_IN_OVERVIEW)) {
                List paymentsList;
                TreeMap<String, ArrayList<PaymentType>> orderTypeMap;
                LinkedHashMap splitMap = new LinkedHashMap();
                for (PaymentType payment : payments) {
                    String account;
                    String orderType = this.getPaymentOrderType(payment);
                    orderTypeMap = (TreeMap<String, ArrayList<PaymentType>>)splitMap.get(orderType);
                    if (orderTypeMap == null) {
                        orderTypeMap = new TreeMap<String, ArrayList<PaymentType>>();
                        splitMap.put(orderType, orderTypeMap);
                    }
                    if ((paymentsList = (ArrayList<PaymentType>)orderTypeMap.get(account = this.getPaymentAccountRepresentation(payment))) == null) {
                        paymentsList = new ArrayList<PaymentType>();
                        orderTypeMap.put(account, (ArrayList<PaymentType>)paymentsList);
                    }
                    paymentsList.add(payment);
                }
                for (String mapOrderType : splitMap.keySet()) {
                    orderTypeMap = (Map)splitMap.get(mapOrderType);
                    for (String mapAccount : orderTypeMap.keySet()) {
                        paymentsList = (List)orderTypeMap.get(mapAccount);
                        Object firstPayment = paymentsList.get(0);
                        String bankName = this.getPaymentBankName(firstPayment);
                        String orderState = this.getOrderState(firstPayment);
                        this.printTable(document, paymentsList, mapOrderType, bankName, orderState, mapAccount);
                    }
                }
            } else {
                this.printTable(document, payments, null, null, null, null);
            }
        }
        finally {
            block17: {
                if (document != null) {
                    document.close();
                }
                if (resultOutputStream != null) {
                    try {
                        ((OutputStream)resultOutputStream).close();
                    }
                    catch (IOException e) {
                        if (this.logger == null) break block17;
                        this.logger.logError("Failed to close output stream on file " + result.getAbsolutePath(), e);
                    }
                }
            }
        }
        Util.applyPreferencesToPdf(result, this.user, null, this.locale, null, null, this.printLogo);
        return result;
    }

    protected abstract Map<String, Map<String, List<PaymentType>>> groupPayments(List<PaymentType> var1);

    protected abstract int[] getTableColumnsWidths(boolean var1);

    protected abstract void printTableHeader(BLTable<?> var1, boolean var2) throws PDFException;

    protected abstract void printPayment(BLTable<?> var1, PaymentType var2, boolean var3) throws PDFException;

    protected abstract String getDocumentTitle();

    protected abstract String getTempFilePrefix();

    protected abstract String getPaymentOrderType(PaymentType var1);

    protected abstract String getPaymentBankName(PaymentType var1);

    protected abstract String getOrderState(PaymentType var1);

    protected abstract String getPaymentAccountRepresentation(PaymentType var1);

    protected abstract BigDecimal getPaymentAmount(PaymentType var1);

    protected final BigDecimal getPaymentAmount(BigDecimal amount, boolean isSalaryPayment) {
        if (this.displaySalaries || !isSalaryPayment) {
            return amount;
        }
        return BigDecimal.ZERO;
    }

    protected abstract Currency getPaymentAmountCurrency(PaymentType var1);

    protected abstract boolean isSalaryPayment(PaymentType var1);

    protected abstract String getRecipientAccountRepresentation(PaymentType var1);

    private void printTable(BLDocument document, List<PaymentType> payments, String orderType, String bankName, String orderState, String account) throws PDFException {
        boolean withOrderTypeColumn = orderType == null;
        int[] widths = this.getTableColumnsWidths(withOrderTypeColumn);
        BLTable<?> table = PDFCreator.getInstance().createTable(widths.length);
        table.setWidth(95.0f);
        table.setPadding(3.0f);
        table.setHorizontalAlignment(Alignment.ALIGN_LEFT);
        table.setWidths(widths);
        if (orderType != null && bankName != null && account != null) {
            int colspan = widths.length / 2;
            table.setBorder(BLBorder.NO_BORDER);
            table.setDefaultColspan(colspan);
            table.addCell(account, BOLD_FONT);
            table.setDefaultColspan(widths.length - colspan);
            table.addCell(bankName, BOLD_FONT);
            table.setDefaultPaddingTop(2.0f);
            table.setDefaultColspan(colspan);
            table.addCell(orderType, FONT);
            table.setDefaultColspan(widths.length - colspan);
            if (orderState != null) {
                table.addCell(orderState, FONT);
            } else {
                table.addCell("", FONT);
            }
            table.setDefaultColspan(1);
            table.setBorder(BLBorder.BOX);
            table.setHeaderRows(3);
        }
        this.printTableHeader(table, withOrderTypeColumn);
        AmountsSum amountsSum = new AmountsSum();
        for (PaymentType payment : payments) {
            this.printPayment(table, payment, withOrderTypeColumn);
            amountsSum.addAmount(this.getPaymentAmount(payment), this.getPaymentAmountCurrency(payment));
        }
        amountsSum.addSumCells(table, widths.length, BOLD_FONT, this.locale);
        document.addTable(table);
    }
}

