/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import java.util.Locale;

public abstract class AbstractSendReportPaymentPrinter<PaymentType> {
    private BLFont font = BLFont.FONT_NORMAL;
    private BLTable<?> table;

    public final void prepare(BLDocument doc, Locale locale) throws PDFException {
        doc.setPageSize(BLDocument.PageLayout.A4_LANDSCAPE);
        doc.newPage();
        this.table = PDFCreator.getInstance().createTable(5);
        this.table.setWidth(100.0f);
        this.table.setPadding(3.0f);
        this.table.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        this.table.addCell(BankingApiMessages.getString(locale, "GeneralMessages.paymentDetails", new Object[0]), this.font, 5, Alignment.ALIGN_LEFT, null, null, BLBorder.NO_BORDER);
        this.table.addCell(BankingApiMessages.getString(locale, "GeneralMessages.recipient", new Object[0]), this.font);
        this.table.addCell(BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]), this.font);
        this.table.addCell(BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]), this.font);
        this.table.addCell(BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]), this.font);
        this.table.addCell(BankingApiMessages.getString(locale, "GeneralMessages.executionDate", new Object[0]), this.font);
        this.table.setHeaderRows(2);
    }

    public final void addPayment(PaymentType payment, Locale locale) throws PDFException {
        if (this.table == null) {
            return;
        }
        this.table.addCell(this.getRecipient(payment), this.font);
        this.table.addCell(this.getRecipientAccount(payment), this.font);
        this.table.addCell(this.getAmountString(payment, locale), this.font);
        this.table.addCell(this.getPurpose(payment), this.font);
        this.table.addCell(this.getExecutionDateString(payment, locale), this.font);
    }

    public final void finish(BLDocument doc) throws PDFException {
        if (this.table != null) {
            doc.addTable(this.table);
        }
    }

    protected abstract String getRecipient(PaymentType var1);

    protected abstract String getRecipientAccount(PaymentType var1);

    protected abstract String getAmountString(PaymentType var1, Locale var2);

    protected abstract String getPurpose(PaymentType var1);

    protected abstract String getExecutionDateString(PaymentType var1, Locale var2);
}

