/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.VopUtil;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.AbstractBankOrder;
import de.businesslogics.banking.payments.api.BankOrderPayment;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.transfer.api.SendUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBankOrderFactory<BankOrderType extends AbstractBankOrder, PaymentDataType> {
    private final List<BankOrderPayment<PaymentDataType>> tooOld = new ArrayList<BankOrderPayment<PaymentDataType>>();
    private final List<BankOrderPayment<PaymentDataType>> tooEarly = new ArrayList<BankOrderPayment<PaymentDataType>>();
    private final Map<String, List<BankOrderPayment<PaymentDataType>>> toFix = new HashMap<String, List<BankOrderPayment<PaymentDataType>>>();
    private int numberOfInactivePayments;

    public final List<BankOrderPayment<PaymentDataType>> checkOpenPayments(User user, List<BankOrderPayment<PaymentDataType>> bankOrderPayments) {
        this.numberOfInactivePayments = 0;
        this.tooOld.clear();
        this.tooEarly.clear();
        this.toFix.clear();
        ArrayList<BankOrderPayment<PaymentDataType>> result = new ArrayList<BankOrderPayment<PaymentDataType>>();
        HashMap<Integer, Boolean> bankActiveMap = new HashMap<Integer, Boolean>();
        HashMap<Integer, PaymentProperties> paymentPropertiesMap = new HashMap<Integer, PaymentProperties>();
        for (BankOrderPayment<PaymentDataType> payment : bankOrderPayments) {
            Boolean bankActive = (Boolean)bankActiveMap.get(payment.getOpenPayment().getBank().getBankId());
            if (bankActive == null) {
                BankUser bankUser = BankUser.findBankUser(payment.getOpenPayment().getBank(), user);
                bankActive = bankUser != null && !bankUser.isDeactivated();
                bankActiveMap.put(payment.getOpenPayment().getBank().getBankId(), bankActive);
            }
            if (Boolean.FALSE.equals(bankActive)) {
                ++this.numberOfInactivePayments;
                continue;
            }
            result.add(payment);
            if (payment.getOpenPayment().getExecutionDate() == null) continue;
            PaymentProperties paymentProperties = (PaymentProperties)paymentPropertiesMap.get(payment.getOpenPayment().getBank().getBankId());
            if (paymentProperties == null) {
                paymentProperties = PaymentProperties.findForBank(payment.getOpenPayment().getBank());
                paymentPropertiesMap.put(payment.getOpenPayment().getBank().getBankId(), paymentProperties);
            }
            if (this.isTooEarlyPaymentExecutionDate(payment, paymentProperties)) {
                this.tooEarly.add(payment);
                continue;
            }
            if (this.isExceededPaymentExecutionDate(payment, paymentProperties)) {
                this.tooOld.add(payment);
                continue;
            }
            String fixMessage = this.getCorrectionMessage(payment, paymentProperties);
            if (fixMessage == null) continue;
            if (!this.toFix.containsKey(fixMessage)) {
                this.toFix.put(fixMessage, new ArrayList());
            }
            this.toFix.get(fixMessage).add(payment);
        }
        return result;
    }

    public final Map<BankOrderType, List<OpenPayment>> createBankOrders(User user, List<BankOrderPayment<PaymentDataType>> payments) {
        HashMap<BankOrderType, List<OpenPayment>> bankOrders = new HashMap<BankOrderType, List<OpenPayment>>();
        this.newTask("", payments.size());
        if (new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean(PreferenceConstants.SEND_PAYMENTS_SEPARATELY)) {
            HashMap<Integer, BankUser> bankUserMap = new HashMap<Integer, BankUser>();
            for (BankOrderPayment<PaymentDataType> p : payments) {
                if (this.isCancelled()) {
                    return null;
                }
                this.reportProgress(1);
                ArrayList<BankOrderPayment<PaymentDataType>> singleOrderList = new ArrayList<BankOrderPayment<PaymentDataType>>();
                singleOrderList.add(p);
                BankSettings bank = p.getOpenPayment().getBank();
                BankUser bankUser = (BankUser)bankUserMap.get(bank.getBankId());
                if (bankUser == null) {
                    bankUser = BankUser.findBankUser(bank, user);
                    bankUserMap.put(bank.getBankId(), bankUser);
                }
                String orderTypeForTransfer = this.getTransferType(bank, p.getOpenPayment(), user);
                bankOrders.putAll(this.createBankOrder(bankUser, p.getOpenPayment().getPmtType(), orderTypeForTransfer, singleOrderList));
                this.reportProgress(1);
            }
        } else {
            HashMap ordersMap = new HashMap();
            HashMap<CallSite, String> orderTransferTypeMap = new HashMap<CallSite, String>();
            for (BankOrderPayment<PaymentDataType> p : payments) {
                if (this.isCancelled()) {
                    return null;
                }
                this.reportProgress(1);
                OpenPayment payment = p.getOpenPayment();
                BankSettings bank = payment.getBank();
                String orderKey = bank.getBankId() + "|";
                String transferType = this.getTransferType(bank, payment, user);
                orderKey = orderKey + transferType + "|";
                orderKey = orderKey + this.getDefaultPmtType(payment.getPmtType());
                ArrayList<BankOrderPayment<PaymentDataType>> orderPayments = (ArrayList<BankOrderPayment<PaymentDataType>>)ordersMap.get(orderKey);
                if (orderPayments != null) {
                    ((List)ordersMap.get(orderKey)).add(p);
                } else {
                    orderPayments = new ArrayList<BankOrderPayment<PaymentDataType>>();
                    orderPayments.add(p);
                    ordersMap.put((CallSite)((Object)orderKey), orderPayments);
                    orderTransferTypeMap.put((CallSite)((Object)orderKey), transferType);
                }
                this.reportProgress(1);
            }
            HashMap<Integer, BankUser> bankUserMap = new HashMap<Integer, BankUser>();
            for (String key : ordersMap.keySet()) {
                List orderPayments = (List)ordersMap.get(key);
                if (orderPayments == null || orderPayments.isEmpty()) continue;
                OpenPayment firstPayment = ((BankOrderPayment)orderPayments.get(0)).getOpenPayment();
                BankSettings bank = firstPayment.getBank();
                BankUser bankUser = (BankUser)bankUserMap.get(bank.getBankId());
                if (bankUser == null) {
                    bankUser = BankUser.findBankUser(bank, user);
                    bankUserMap.put(bank.getBankId(), bankUser);
                }
                bankOrders.putAll(this.createBankOrder(bankUser, firstPayment.getPmtType(), (String)orderTransferTypeMap.get(key), (List)ordersMap.get(key)));
            }
        }
        this.reportFinished();
        for (AbstractBankOrder bankOrder : bankOrders.keySet()) {
            Set<PaymentTransferType.PmtType> pmtTypes = this.getPmtTypes((List)bankOrders.get(bankOrder));
            if (pmtTypes == null) continue;
            if (pmtTypes.size() == 1) {
                bankOrder.setPmtType(pmtTypes.iterator().next());
                continue;
            }
            if (pmtTypes.size() <= 1) continue;
            bankOrder.setPmtType(SendParameters.getDefaultPmtType(pmtTypes.iterator().next()));
        }
        return bankOrders;
    }

    private String getDefaultPmtType(PaymentTransferType.PmtType pmtType) {
        PaymentTransferType.PmtType defaultPmtType;
        if (pmtType != null && (defaultPmtType = SendParameters.getDefaultPmtType(pmtType)) != null) {
            return defaultPmtType.name();
        }
        return "";
    }

    private Set<PaymentTransferType.PmtType> getPmtTypes(List<OpenPayment> openPayments) {
        if (openPayments != null && openPayments.size() > 0) {
            HashSet<PaymentTransferType.PmtType> pmtTypes = new HashSet<PaymentTransferType.PmtType>();
            for (OpenPayment openPayment : openPayments) {
                pmtTypes.add(openPayment.getPmtType());
            }
            return pmtTypes;
        }
        return null;
    }

    private String getTransferType(BankSettings bank, OpenPayment payment, User user) {
        PaymentTransferType.PmtType pmtType = payment.getPmtType();
        if (pmtType != null) {
            if (!SendUtil.isBeforeVopDate() && bank.isVopActivated() && VopUtil.hasVopPermission(user, bank, pmtType) && SendUtil.useVopByDefault(user)) {
                return SendParameters.getTransferTypeVopByBank(bank, pmtType);
            }
            return SendParameters.getTransferTypeByBank(bank, pmtType);
        }
        if (BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion())) {
            return payment.getFileType();
        }
        if (bank.isFrenchBank()) {
            return payment.getFileType();
        }
        return payment.getOrderType();
    }

    public final int getNumberOfInactivePayments() {
        return this.numberOfInactivePayments;
    }

    public final List<BankOrderPayment<PaymentDataType>> getExceededPayments() {
        return this.tooOld;
    }

    public final List<BankOrderPayment<PaymentDataType>> getTooEarlyPayments() {
        return this.tooEarly;
    }

    public final Map<String, List<BankOrderPayment<PaymentDataType>>> getPaymentsToCorrect() {
        return this.toFix;
    }

    protected abstract boolean isExceededPaymentExecutionDate(BankOrderPayment<PaymentDataType> var1, PaymentProperties var2);

    protected abstract boolean isTooEarlyPaymentExecutionDate(BankOrderPayment<PaymentDataType> var1, PaymentProperties var2);

    protected abstract String getCorrectionMessage(BankOrderPayment<PaymentDataType> var1, PaymentProperties var2);

    protected abstract Map<BankOrderType, List<OpenPayment>> createBankOrder(BankUser var1, PaymentTransferType.PmtType var2, String var3, List<BankOrderPayment<PaymentDataType>> var4);

    protected abstract void newTask(String var1, int var2);

    protected abstract void reportProgress(int var1);

    protected abstract void reportFinished();

    protected abstract boolean isCancelled();
}

