/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.payments.api;

import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.DisplayMessageAndDigest;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.payments.api.PaymentApiMessages;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractBankOrder {
    protected final BankSettings bank;
    protected String orderType;
    private PaymentTransferType.PmtType pmtType;
    private int countPayments;
    private final long orderFileSize;
    private DisplayMessageAndDigest displayMessage;

    public AbstractBankOrder(BankSettings bank, String orderType, long orderFileSize) {
        this(bank, SendParameters.getPmtType(bank, orderType), orderType, orderFileSize);
    }

    public AbstractBankOrder(BankSettings bank, PaymentTransferType.PmtType pmtType, long orderFileSize) {
        this(bank, pmtType, SendParameters.getTransferTypeByBank(bank, pmtType), orderFileSize);
    }

    public AbstractBankOrder(BankSettings bank, PaymentTransferType.PmtType pmtType, String orderType, long orderFileSize) {
        this.bank = bank;
        this.orderType = orderType;
        this.orderFileSize = orderFileSize;
        this.pmtType = pmtType;
    }

    public DisplayMessageAndDigest getDisplayMessage() throws DisplayFileException, KnownFormatException, IOException {
        if (this.displayMessage == null) {
            this.displayMessage = this.generateDisplayMessage();
        }
        return this.displayMessage;
    }

    public BankSettings getBank() {
        return this.bank;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public PaymentTransferType.PmtType getPmtType() {
        return this.pmtType;
    }

    public void setPmtType(PaymentTransferType.PmtType pmtType) {
        this.pmtType = pmtType;
    }

    public int getCountPayments() {
        return this.countPayments;
    }

    public void setCountPayments(int countPayments) {
        this.countPayments = countPayments;
    }

    public long getOrderFileSize() {
        return this.orderFileSize;
    }

    protected final void doLimitCheck(BankUser bankUser, Map<Account, BigDecimal> accountAmounts, BigDecimal totalAmount, String currency, List<String> messages, Locale locale) {
        List<UserPermission> userPermissions = UserPermission.findUserPermission(bankUser, OrderType.TransferType.SEND, this.getOrderType());
        ArrayList limits = new ArrayList();
        ArrayList foundAccountPermission = new ArrayList(1);
        boolean foundExceededPermission = false;
        for (Account a : accountAmounts.keySet()) {
            ApOverwrite apOverwrite = ApOverwrite.findByBankAndAccount(bankUser, a);
            if (apOverwrite != null && !apOverwrite.isPreviousEnabled() && apOverwrite.getAmountLimit() != null) {
                if (BigDecimal.ZERO.equals(apOverwrite.getAmountLimit())) continue;
                if (apOverwrite.getAmountLimit().compareTo(accountAmounts.get(a)) < 0) {
                    messages.add(PaymentApiMessages.getString(locale, "BankOrder.error.amountExceeded", Account.getDefaultDisplayName(a), PaymentUtils.formatAmount(apOverwrite.getAmountLimit(), Currency.getInstance(a.getCurrency()))));
                    foundExceededPermission = true;
                    continue;
                }
            }
            limits.clear();
            foundAccountPermission.clear();
            userPermissions.stream().filter(up -> up.getAccountPermission() != null && ((Object)a).equals(up.getAccountPermission().getAccount()) && (up.getMaxAmount() == null || a.getCurrency().equals(up.getMaxAmountCurrency()))).forEach(up -> {
                limits.add(up.getMaxAmount());
                if (up.getMaxAmount() == null || up.getMaxAmount().compareTo((BigDecimal)accountAmounts.get(a)) >= 0) {
                    foundAccountPermission.add(true);
                }
            });
            if (limits.isEmpty() || !foundAccountPermission.isEmpty() && ((Boolean)foundAccountPermission.get(0)).booleanValue()) continue;
            messages.add(PaymentApiMessages.getString(locale, "BankOrder.error.amountExceeded", Account.getDefaultDisplayName(a), PaymentUtils.formatAmount((BigDecimal)Collections.max(limits), Currency.getInstance(a.getCurrency()))));
            foundExceededPermission = true;
        }
        if (!foundExceededPermission && currency != null && !currency.isEmpty()) {
            limits.clear();
            foundAccountPermission.clear();
            userPermissions.stream().filter(up -> up.getAccountPermission() == null && (up.getMaxAmount() == null || currency.equals(up.getMaxAmountCurrency()))).forEach(up -> {
                limits.add(up.getMaxAmount());
                if (up.getMaxAmount() == null || up.getMaxAmount().compareTo(totalAmount) >= 0) {
                    foundAccountPermission.add(true);
                }
            });
            if (!(limits.isEmpty() || !foundAccountPermission.isEmpty() && ((Boolean)foundAccountPermission.get(0)).booleanValue())) {
                messages.add(PaymentApiMessages.getString(locale, "BankOrder.error.amountExceeded.noAccount", PaymentUtils.formatAmount((BigDecimal)Collections.max(limits), Currency.getInstance(currency))));
            }
        }
    }

    public static File createOrderFile(String bankId, String sendParameter, String param) throws IOException {
        File bankOrdersDir = new File(new File(new File(Util.WORKSPACEDIR, "payments"), "orders"), bankId);
        if (!bankOrdersDir.isDirectory()) {
            bankOrdersDir.mkdirs();
        }
        StringBuilder prefixBuilder = new StringBuilder("Order");
        if (param != null) {
            prefixBuilder.append('_').append(param).append('_');
        }
        String suffix = "." + AbstractBankOrder.getFileExtension(sendParameter);
        return File.createTempFile(prefixBuilder.toString(), suffix, bankOrdersDir);
    }

    public static String getFileExtension(String sendParameter) {
        if (BTFTranslator.isBTFString(sendParameter)) {
            String orderType = BTFTranslator.getSendOrderTypeFromBTF(sendParameter);
            if (orderType != null) {
                return orderType;
            }
            return "BTU";
        }
        if (Util.isOrderType(sendParameter)) {
            return sendParameter;
        }
        return SystemUtils.toFilename(sendParameter);
    }

    protected abstract DisplayMessageAndDigest generateDisplayMessage() throws DisplayFileException, KnownFormatException, IOException;
}

