/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.bka.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.Camt054ProcessingApi;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;

public abstract class BaseProcessing
implements Processing,
ZipProcessing {
    protected final EncryptData encrypt;
    protected final String exportDirectory;
    protected final BLLogger logger;
    protected boolean workDone = false;
    protected final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    protected BankSettings bank;
    private Locale locale;

    public BaseProcessing(EncryptData encrypt, String exportDirectory, BLLogger logger) {
        this.encrypt = encrypt;
        this.exportDirectory = exportDirectory;
        this.logger = logger;
        this.locale = Locale.getDefault();
    }

    protected void exportFile(File localFile, CmPdfStatement stmt, String entryName) {
        try {
            File file = this.getTargetFile(stmt, entryName);
            if (this.isPdfExtension(file)) {
                file.getParentFile().mkdirs();
            } else {
                file.mkdirs();
                file = new File(file, entryName);
            }
            file = Camt054ProcessingApi.uniqueFilename(file);
            FileOutputStream fos = new FileOutputStream(file);
            InputStream fin = this.encrypt.openInputStream(localFile);
            Streams.copy(fin, fos);
            this.recordExport();
            this.recordExport(file.getPath());
        }
        catch (Exception e) {
            this.logger.logError("Entry '" + entryName + "' could not be exported. Exception occurred!", e);
        }
    }

    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        String fetchType = this.getFetchType(CMBank.get(item.getBank()));
        if (!fetchType.equals(item.getFetchType())) {
            return;
        }
        this.bank = item.getBank();
        ZipHandler zipHandler = new ZipHandler(this, this.logger);
        zipHandler.process(this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile())));
        ZipProcessingResult processingResult = zipHandler.getProcessingResult();
        this.workDone = true;
        this.refreshView();
        if (processingResult != null && processingResult.hasErrors()) {
            processingResult.evaluateResult(this.logger, this.locale);
        }
    }

    protected abstract String getFetchType(CMBank var1);

    protected abstract File getTargetFile(CmPdfStatement var1, String var2);

    protected Date getDate(String s, SimpleDateFormat sdf, String entryName) {
        try {
            return new Date(sdf.parse(s).getTime());
        }
        catch (Exception e) {
            this.logger.logError("Could not process entry '" + entryName + "' due to invalid date '" + s + "' in file name.", null);
            return null;
        }
    }

    protected String getIban(String s, String entryName) {
        if (IbanUtil.checkIban(s, false)) {
            return s;
        }
        this.logger.logError("Could not process entry '" + entryName + "' due to invalid IBAN '" + s + "' in file name.", null);
        return null;
    }

    protected Currency getCurrency(String s, String entryName) {
        try {
            return Currency.getInstance(s);
        }
        catch (Exception e) {
            this.logger.logError("Could not process entry '" + entryName + "' due to invalid currency '" + s + "' in file name.", null);
            return null;
        }
    }

    protected Integer getStatementNumber(String s, String entryName) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            this.logger.logWarning("Could not extract statementNumber from '" + s + "' from the entry '" + entryName + "'.", null);
            return null;
        }
    }

    protected String transform(String in) {
        if (in == null) {
            return "";
        }
        in = in.replace('/', '_');
        in = in.replace('\\', '_');
        return in;
    }

    private boolean isPdfExtension(File file) {
        if (file == null) {
            return false;
        }
        int lastDot = file.getPath().lastIndexOf(46);
        return "pdf".equalsIgnoreCase(file.getPath().substring(lastDot + 1));
    }

    protected String createLocalFilename(String entryName, CmPdfStatement stmt) {
        if (stmt == null || stmt.getId() == null) {
            if (!entryName.endsWith("pdf")) {
                return entryName + ".pdf";
            }
            return entryName;
        }
        int k = entryName.lastIndexOf(46);
        int j = Math.max(entryName.lastIndexOf(47), entryName.lastIndexOf(92));
        if (j < 0) {
            j = 0;
        }
        String start = k > j ? entryName.substring(j, k) : entryName;
        String extension = k > j ? entryName.substring(k) : "";
        String toReturn = String.format("%s_%d%s", start, stmt.getId(), extension);
        if (!toReturn.endsWith("pdf")) {
            return toReturn + ".pdf";
        }
        return toReturn;
    }

    protected void recordNewStatement() {
    }

    protected void recordNewStatement(CmPdfStatement stmt) {
    }

    protected void recordExport() {
    }

    protected void recordExport(String path) {
    }

    protected void refreshView() {
    }

    public boolean isWorkDone() {
        return this.workDone;
    }
}

