/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.bka.api;

import de.businesslogics.banking.api.BankDeleteNotifier;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Transaction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class BankDelete
implements BankDeleteNotifier {
    @Override
    public String[] checkDataToBeDeleted(BankSettings bank, Locale locale) {
        return this.checkDataToBeDeleted(new BankSettings[]{bank}, locale);
    }

    @Override
    public String[] checkDataToBeDeleted(BankSettings[] banks, Locale locale) {
        ArrayList myBanks = new ArrayList();
        Collections.addAll(myBanks, banks);
        int count = DB.find(CmPdfStatement.class).where().in("bank", myBanks).findCount();
        if (count > 0) {
            return new String[]{MessageFormat.format(Messages.getString(locale, "PreferencePage.cleanUp.bkaStatements", new Object[0]), count)};
        }
        return null;
    }

    @Override
    public void deleteBank(BankSettings bank, IProgressMonitorWrapper monitor) {
        List list = DB.find(CmPdfStatement.class).where().eq("bank", (Object)bank).findList();
        try (Transaction t = DB.beginTransaction();){
            for (CmPdfStatement stmt : list) {
                WorkspaceFileSystem.delete(stmt.getLocalFile());
                DB.delete(stmt);
            }
            t.commit();
            this.refresh();
        }
    }

    protected abstract void refresh();
}

