/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.bka.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.bka.api.BaseProcessing;
import de.businesslogics.io.Streams;
import de.businesslogics.task.Substitution;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BKIProcessing
extends BaseProcessing {
    public BKIProcessing(EncryptData encrypt, String exportDirectory, BLLogger logger) {
        super(encrypt, exportDirectory, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        File dir = new File(WorkspaceFileSystem.BKI_DIRECTORY, this.bank.getBankId().toString());
        dir.mkdirs();
        Pattern accountRelatedPattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})_.*_([A-Z]{2}\\d{2}[a-zA-Z0-9]{1,30})_([A-Z]{3})_(\\d{1,6})(_[A-Z]{3})?.*");
        Pattern nonAccountRelatedPattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})_.*_.*_.*_(\\d{1,6})_([A-Z]{3}).*");
        CmPdfStatement stmt = CmPdfStatement.findByBankAndName(this.bank, originalFilename);
        if (stmt == null) {
            Matcher filenameMatcher = accountRelatedPattern.matcher(originalFilename);
            boolean isAccountRelated = filenameMatcher.find();
            if (isAccountRelated) {
                stmt = this.processAccountRelatedEntry(originalFilename, this.bank, filenameMatcher, this.sdf);
            } else {
                filenameMatcher = nonAccountRelatedPattern.matcher(originalFilename);
                boolean isNonAccountRelated = filenameMatcher.find();
                if (isNonAccountRelated) {
                    stmt = this.processNonAccountRelatedEntry(originalFilename, this.bank, filenameMatcher, this.sdf);
                } else {
                    String message = "Could not process entry '" + originalFilename + "' due to unexpected filename pattern!";
                    this.logger.logError(message);
                    throw new IOException(message);
                }
            }
            if (stmt != null) {
                File localFile = new File(dir, this.createLocalFilename(originalFilename, stmt));
                DigestOutputStream dout = null;
                try (Transaction t = DB.beginTransaction();){
                    dout = new DigestOutputStream(this.encrypt.openOutputStream(localFile), MessageDigest.getInstance("SHA-256"));
                    long size = Streams.copy(in, dout);
                    WorkspaceFile workspaceFile = WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.BKI, localFile, size, null, HexTool.toHex(dout.getMessageDigest().digest()));
                    stmt.setLocalFile(workspaceFile);
                    DB.update(stmt);
                    t.commit();
                }
                catch (Throwable throwable) {
                    SystemUtils.close(dout);
                    throw throwable;
                }
                SystemUtils.close(dout);
                if (this.exportDirectory != null && localFile != null) {
                    this.exportFile(localFile, stmt, originalFilename);
                }
            }
        }
    }

    private CmPdfStatement processAccountRelatedEntry(String entryName, BankSettings bank, Matcher filenameMatcher, SimpleDateFormat sdf) {
        Date date = this.getDate(filenameMatcher.group(1), sdf, entryName);
        String iban = this.getIban(filenameMatcher.group(2), entryName);
        Currency currency = this.getCurrency(filenameMatcher.group(3), entryName);
        Integer statementNumber = this.getStatementNumber(filenameMatcher.group(4), entryName);
        CmPdfStatement.Type type = this.getType(filenameMatcher.group(5), entryName);
        if (date != null && iban != null && currency != null && statementNumber != null && type != null) {
            CmPdfStatement stmt = new CmPdfStatement();
            stmt.setType(type);
            stmt.setAccount(CMProcessingDb.findOrCreateAccountByIban(bank, iban, currency));
            stmt.setBank(bank);
            stmt.setStatementDate(date);
            stmt.setStatementNumber(statementNumber);
            stmt.setZipFileName(entryName);
            DB.save(stmt);
            this.recordNewStatement();
            this.recordNewStatement(stmt);
            return stmt;
        }
        return null;
    }

    private CmPdfStatement processNonAccountRelatedEntry(String entryName, BankSettings bank, Matcher filenameMatcher, SimpleDateFormat sdf) {
        Date date = this.getDate(filenameMatcher.group(1), sdf, entryName);
        Integer statementNumber = this.getStatementNumber(filenameMatcher.group(2), entryName);
        CmPdfStatement.Type type = this.getType(filenameMatcher.group(3), entryName);
        if (date != null && statementNumber != null && type != null) {
            CmPdfStatement stmt = new CmPdfStatement();
            stmt.setType(type);
            stmt.setBank(bank);
            stmt.setStatementDate(date);
            stmt.setStatementNumber(statementNumber);
            stmt.setZipFileName(entryName);
            DB.save(stmt);
            this.recordNewStatement();
            this.recordNewStatement(stmt);
            return stmt;
        }
        return null;
    }

    private CmPdfStatement.Type getType(String s, String entryName) {
        try {
            if (s == null) {
                return CmPdfStatement.Type.MIS;
            }
            return CmPdfStatement.Type.valueOf(s.substring(1));
        }
        catch (Exception e) {
            this.logger.logError("Could not process BKI entry '" + entryName + "' due to invalid document type '" + s + "' in file name.", null);
            return null;
        }
    }

    private String getRelativePath(File localFile) {
        Path bkiDir = WorkspaceFileSystem.BKI_DIRECTORY.toPath();
        Path localPath = localFile.toPath();
        return bkiDir.relativize(localPath).toString();
    }

    @Override
    protected File getTargetFile(CmPdfStatement stmt, String origFileName) {
        Substitution s = new Substitution(stmt.getStatementDate());
        s.addPlaceHolder("TYPE", stmt.getType().name());
        s.addPlaceHolder("BANK", this.transform(stmt.getBank().getDisplayName()));
        Account account = stmt.getAccount();
        if (account != null) {
            s.addPlaceHolder("ACCOUNT", this.transform(Account.getDefaultDisplayName(account)));
            s.addPlaceHolder("IBAN", this.transform(account.getIban()));
            s.addPlaceHolder("CURRENCY", account.getCurrency());
            CmFolder folder = account.getFolder();
            String folderName = folder != null ? this.transform(folder.getName()) : "";
            s.addPlaceHolder("ACCOUNTGROUP", folderName);
        } else {
            s.addPlaceHolder("ACCOUNT", "");
            s.addPlaceHolder("IBAN", "");
            s.addPlaceHolder("CURRENCY", "");
            s.addPlaceHolder("ACCOUNTGROUP", "");
        }
        s.addPlaceHolder("NUMBER", stmt.getStatementNumber() != null ? stmt.getStatementNumber() : "");
        s.addPlaceHolder("FILENAME", origFileName);
        return new File(s.substitute(this.exportDirectory));
    }

    public static Substitution getExample() {
        Substitution s = new Substitution(new java.util.Date());
        s.addPlaceHolder("TYPE", "RNG");
        s.addPlaceHolder("BANK", "Business-Logics Testbank");
        s.addPlaceHolder("ACCOUNT", "Testkonto");
        s.addPlaceHolder("IBAN", "DE87123456781234567890");
        s.addPlaceHolder("CURRENCY", "EUR");
        s.addPlaceHolder("NUMBER", "42");
        s.addPlaceHolder("FILENAME", String.format("%s_BKI_DE87123456781234567890_EUR_000001.pdf", new SimpleDateFormat("yyyy-MM-dd").format(new java.util.Date())));
        s.addPlaceHolder("ACCOUNTGROUP", "EUR-Konten");
        return s;
    }

    @Override
    protected String getFetchType(CMBank cmBank) {
        return cmBank.getDefaultBkiFetchType();
    }
}

