/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.IProgressMonitorWrapper;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ValueBalancesDataProvider {
    private final CmValueGroup group;
    private final Calendar startDay;
    private final int dateColumns;
    private boolean displayValueBalances = true;
    private final DatabasePreferenceStore preferences;
    private final IProgressMonitorWrapper monitor;

    public static Data[] sort(Data[] data, Integer sortColumn, final boolean sortAsc) {
        int columnOffset = 3;
        if (sortColumn != null && sortColumn >= 3 && data.length > 0) {
            Data first = data[0];
            if (first.balances.length <= sortColumn - 3) {
                sortColumn = null;
            }
        }
        final Integer finalSortColumn = sortColumn;
        Arrays.sort(data, new Comparator<Data>(){

            @Override
            public int compare(Data o1, Data o2) {
                int toReturn = 0;
                if (o1.currency != null && o2.currency == null) {
                    return 1;
                }
                if (o1.currency == null && o2.currency != null) {
                    return -1;
                }
                if (o1.currency != null && o2.currency != null) {
                    if (o1.currency.length() == 0) {
                        return -1;
                    }
                    if (o2.currency.length() == 0) {
                        return 1;
                    }
                    toReturn = o2.currency.compareTo(o1.currency);
                } else {
                    if (finalSortColumn == null) {
                        if (o1.account == null) {
                            return 1;
                        }
                        if (o2.account == null) {
                            return -1;
                        }
                        int i = o1.account.getBank().getBankId().compareTo(o2.account.getBank().getBankId());
                        if (i == 0) {
                            return Account.getDefaultDisplayName(o1.account).compareTo(Account.getDefaultDisplayName(o2.account));
                        }
                        return i;
                    }
                    switch (finalSortColumn) {
                        case 0: {
                            if (o1.account == null) {
                                return 1;
                            }
                            if (o2.account == null) {
                                return -1;
                            }
                            toReturn = Account.getDefaultDisplayName(o1.account).compareTo(Account.getDefaultDisplayName(o2.account));
                            break;
                        }
                        case 1: {
                            if (o1.account == null) {
                                return 1;
                            }
                            if (o2.account == null) {
                                return -1;
                            }
                            toReturn = Account.getCmDisplayName(o1.account).compareTo(Account.getCmDisplayName(o2.account));
                            break;
                        }
                        case 2: {
                            if (o1.account == null) {
                                toReturn = 1;
                                break;
                            }
                            if (o2.account == null) {
                                toReturn = -1;
                                break;
                            }
                            String d1 = o1.account.getDescription();
                            String d2 = o2.account.getDescription();
                            if (d1 == null) {
                                toReturn = 1;
                                break;
                            }
                            if (d2 == null) {
                                toReturn = -1;
                                break;
                            }
                            toReturn = d1.compareTo(d2);
                            break;
                        }
                        default: {
                            CmBalance b1 = o1.balances[finalSortColumn - 3];
                            CmBalance b2 = o2.balances[finalSortColumn - 3];
                            BigDecimal a1 = BigDecimal.ZERO;
                            if (b1 != null && (a1 = b1.getValueBalance()) == null) {
                                a1 = b1.getBookingBalance();
                            }
                            BigDecimal a2 = BigDecimal.ZERO;
                            if (b2 != null && (a2 = b2.getValueBalance()) == null) {
                                a2 = b2.getBookingBalance();
                            }
                            toReturn = a1.compareTo(a2);
                        }
                    }
                }
                if (sortAsc) {
                    return toReturn;
                }
                return -toReturn;
            }
        });
        return data;
    }

    public ValueBalancesDataProvider(CmValueGroup group, Calendar startDay, int dateColumns, boolean displayValueBalances, DatabasePreferenceStore preferences, IProgressMonitorWrapper monitor) {
        this.group = group;
        this.startDay = startDay;
        this.dateColumns = dateColumns;
        this.displayValueBalances = displayValueBalances;
        this.preferences = preferences;
        this.monitor = monitor;
    }

    public Data[] getData(User currentUser) {
        List<Account> accounts = Account.findAccounts(currentUser, null, null, this.preferences.getBoolean(CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS));
        if (this.group != null) {
            HashSet<Integer> accountIds = new HashSet<Integer>();
            HashSet<Integer> groupIds = new HashSet<Integer>();
            for (Account a : this.group.getAccounts()) {
                accountIds.add(a.getId());
            }
            for (CmFolder f : this.group.getFolders()) {
                groupIds.add(f.getId());
            }
            Iterator<Account> iterator = accounts.iterator();
            while (iterator.hasNext()) {
                Account a;
                a = iterator.next();
                if (accountIds.contains(a.getId()) || a.getFolder() != null && groupIds.contains(a.getFolder().getId())) continue;
                iterator.remove();
            }
        }
        HashMap<String, BigDecimal> creditLimitMap = new HashMap<String, BigDecimal>();
        Date startDate = new Date(this.startDay.getTime().getTime());
        Calendar c2 = Calendar.getInstance();
        c2.setTime(startDate);
        c2.add(5, this.dateColumns);
        Date endDate = new Date(c2.getTime().getTime());
        ArrayList<Data> data = new ArrayList<Data>();
        HashMap<String, Data> sums = new HashMap<String, Data>();
        this.monitor.beginTask(Messages.getString("ValueBalancesView.jobName", new Object[0]), accounts.size());
        for (Account a : accounts) {
            this.monitor.subTask(Account.getDefaultDisplayName(a));
            if (this.monitor.isCanceled()) {
                return null;
            }
            Data d = new Data();
            d.account = a;
            List<CmBalance> b = CmBalance.findByDateRange(a, startDate, endDate, this.displayValueBalances);
            if (b.isEmpty()) {
                CmBalance balance = CmBalance.getForDate(a, startDate, this.displayValueBalances);
                if (balance == null) continue;
                for (i = 0; i < d.balances.length; ++i) {
                    d.balances[i] = balance;
                }
            } else {
                CmBalance previous = null;
                i = 0;
                c2.setTime(startDate);
                for (CmBalance balance : b) {
                    if (this.monitor.isCanceled()) {
                        return null;
                    }
                    Date date = new Date(c2.getTime().getTime());
                    while (balance.getVauleDate().after(date)) {
                        if (this.monitor.isCanceled()) {
                            return null;
                        }
                        if (previous == null) {
                            previous = CmBalance.getForDate(a, date, this.displayValueBalances);
                        }
                        d.balances[i] = previous;
                        ++i;
                        c2.add(5, 1);
                        date = new Date(c2.getTime().getTime());
                    }
                    if (i < d.balances.length) {
                        d.balances[i] = balance;
                    }
                    previous = balance;
                    ++i;
                    c2.add(5, 1);
                }
                if (i < d.balances.length) {
                    while (i < d.balances.length) {
                        if (this.monitor.isCanceled()) {
                            return null;
                        }
                        d.balances[i] = d.balances[i - 1];
                        ++i;
                    }
                }
            }
            data.add(d);
            String currency = d.account.getCurrency();
            Data sum = (Data)sums.get(currency);
            boolean balancesWithAdvices = this.preferences.getBoolean(CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO);
            if (sum == null) {
                sum = new Data();
                sum.account = null;
                sum.currency = currency;
                for (i = 0; i < d.balances.length; ++i) {
                    sum.balances[i] = new CmBalance();
                    if (d.balances[i] == null) {
                        this.setBalance(sum.balances[i], BigDecimal.ZERO);
                        continue;
                    }
                    this.setBalance(sum.balances[i], EclipseFreeHelper.getBalance(d.balances[i], this.displayValueBalances, balancesWithAdvices));
                }
                sums.put(currency, sum);
            } else {
                for (i = 0; i < d.balances.length; ++i) {
                    if (d.balances[i] == null) continue;
                    this.setBalance(sum.balances[i], EclipseFreeHelper.getBalance(sum.balances[i], balancesWithAdvices).add(EclipseFreeHelper.getBalance(d.balances[i], this.displayValueBalances, balancesWithAdvices)));
                }
            }
            BigDecimal creditLimit = d.account.getCreditLimit();
            String accountCurrency = d.account.getCurrency();
            if (creditLimit != null && accountCurrency != null) {
                BigDecimal creditLimitSum = (BigDecimal)creditLimitMap.get(accountCurrency);
                if (creditLimitSum == null) {
                    creditLimitMap.put(accountCurrency, creditLimit);
                } else {
                    creditLimitMap.put(accountCurrency, creditLimitSum.add(creditLimit));
                }
            }
            this.monitor.worked(1);
        }
        Data emptyLine = new Data();
        emptyLine.currency = "";
        data.add(emptyLine);
        if (sums.size() == 1) {
            Data d = (Data)sums.get(sums.keySet().iterator().next());
            d.onlyOneSum = true;
        }
        for (String s : sums.keySet()) {
            Data sumRow = (Data)sums.get(s);
            data.add(sumRow);
            BigDecimal creditLimitSum = (BigDecimal)creditLimitMap.get(sumRow.currency);
            if (!this.preferences.getBoolean(CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_LIMIT) || creditLimitSum == null) continue;
            this.addAdditionalSumRows(data, sumRow, creditLimitSum);
        }
        return data.toArray(new Data[data.size()]);
    }

    private void addAdditionalSumRows(List<Data> dataList, Data sumEntry, BigDecimal creditLimitSum) {
        Data creditLimitRow = new Data();
        creditLimitRow.currency = sumEntry.currency;
        creditLimitRow.onlyOneSum = sumEntry.onlyOneSum;
        creditLimitRow.creditLimit = true;
        Data freeLiquidityRow = new Data();
        freeLiquidityRow.currency = sumEntry.currency;
        freeLiquidityRow.onlyOneSum = sumEntry.onlyOneSum;
        freeLiquidityRow.freeLiquidity = true;
        CmBalance b = new CmBalance();
        this.setBalance(b, creditLimitSum);
        for (int i = 0; i < creditLimitRow.balances.length; ++i) {
            creditLimitRow.balances[i] = b;
            BigDecimal sum = EclipseFreeHelper.getBalance(sumEntry.balances[i], this.displayValueBalances, this.preferences.getBoolean(CmPreferenceConstants.BALANCES_WITH_ADVICE_INFO));
            BigDecimal freeLiquidity = sum != null ? creditLimitSum.add(sum) : creditLimitSum;
            CmBalance b2 = new CmBalance();
            this.setBalance(b2, freeLiquidity);
            freeLiquidityRow.balances[i] = b2;
        }
        dataList.add(creditLimitRow);
        dataList.add(freeLiquidityRow);
    }

    private void setBalance(CmBalance balance, BigDecimal amount) {
        balance.setValueBalance(amount);
        balance.setValueBalanceWithAdvice(amount);
        balance.setBookingBalance(amount);
    }

    public class Data {
        public Account account;
        public String currency;
        public boolean onlyOneSum = false;
        public boolean creditLimit = false;
        public boolean freeLiquidity = false;
        public CmBalance[] balances;

        public Data() {
            this.balances = new CmBalance[ValueBalancesDataProvider.this.dateColumns];
        }
    }
}

