/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.CmDeleter;
import de.businesslogics.banking.mt940.api.CmLogger;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import io.ebean.SqlQuery;
import io.ebean.SqlRow;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ValueBalanceCalculator {
    private static final long ONEDAY = 86400000L;

    public static void recalculate(Account account, Date earliestValueDate) {
        if (account.getUseVirtualBalances()) {
            ValueBalanceCalculator.recalculateVirtualBalances(account);
            return;
        }
        try (Transaction t = DB.beginTransaction();){
            CmStatement newest;
            SqlUpdate delete = DB.sqlUpdate("DELETE FROM cm_balance WHERE account_id = :account AND value_date >=  :valueDate");
            delete.setParameter("account", (Object)account.getId());
            delete.setParameter("valueDate", (Object)earliestValueDate);
            int countDeleted = delete.execute();
            CmLogger logger = CmLogger.getCmLogger();
            if (logger != null && logger.contains(account)) {
                logger.logInfo(account, "VBCalculator-Delta with earliestValueDate " + String.valueOf(earliestValueDate) + ": Deleted " + countDeleted + " cm_balance-entries");
            }
            if ((newest = CmStatement.findNewestStatement(account, (Date)null)) == null) {
                t.commit();
                if (logger != null && logger.contains(account)) {
                    logger.logError(account, "VBCalculator-Delta: Could not find the newest statement");
                }
                return;
            }
            BigDecimal currentBalance = newest.getClosingBalance();
            if (currentBalance == null) {
                t.commit();
                if (logger != null && logger.contains(account)) {
                    logger.logError(account, "VBCalculator-Delta: Newest statement with cmStatementId = " + newest.getId() + " has no closingBalance.");
                }
                return;
            }
            SqlQuery grouping = DB.sqlQuery("SELECT value_date, sum(amount) AS sum_amount FROM cm_booking JOIN cm_statement ON cm_booking.statement_id = cm_statement.id WHERE cm_booking.account_id = :account AND cm_booking.parent_booking_id is null AND cm_statement.type in (" + ValueBalanceCalculator.getTypes(CmStatement.StatementTypes) + ") AND cm_booking.value_date >= :valueDate GROUP BY value_date ORDER BY value_date DESC");
            grouping.setParameter("account", (Object)account.getId());
            ValueBalanceCalculator.setParameter(grouping, CmStatement.StatementTypes);
            grouping.setParameter("valueDate", (Object)earliestValueDate);
            List list = grouping.findList();
            BigDecimal sumAmount = null;
            for (SqlRow row : list) {
                if (sumAmount != null) {
                    currentBalance = currentBalance.subtract(sumAmount);
                }
                Date valueDate = row.getDate("value_date");
                sumAmount = row.getBigDecimal("sum_amount");
                ValueBalanceCalculator.createBalance(account, valueDate, currentBalance);
            }
            ValueBalanceCalculator.calculateVBwithAdvices(account);
            t.commit();
            if (logger != null && logger.contains(account)) {
                logger.logInfo(account, "VBCalculator-Delta: Created " + CmBalance.findTotalCountForAccount(account) + " cm_balance-entries");
            }
        }
    }

    private static void recalculateVirtualBalances(Account account) {
        try (Transaction t = DB.beginTransaction();){
            SqlUpdate delete = DB.sqlUpdate("DELETE FROM cm_balance WHERE account_id = :account");
            delete.setParameter("account", (Object)account.getId());
            delete.execute();
            SqlQuery grouping = DB.sqlQuery("SELECT value_date, sum(amount) AS sum_amount FROM cm_booking JOIN cm_statement ON cm_booking.statement_id = cm_statement.id WHERE cm_booking.account_id = :account AND cm_booking.parent_booking_id is null AND cm_booking.gvc not in ('833', '834') AND cm_statement.type in (" + ValueBalanceCalculator.getTypes(CmStatement.StatementTypes) + ") GROUP BY value_date ORDER BY value_date ASC");
            grouping.setParameter("account", (Object)account.getId());
            ValueBalanceCalculator.setParameter(grouping, CmStatement.StatementTypes);
            BigDecimal startBalance = account.getVirtualStartBalance();
            Date startDate = account.getVirtualStartDate();
            ValueBalanceCalculator.createBalance(account, startDate, startBalance);
            List list = grouping.findList();
            BigDecimal virtualBalance = startBalance;
            ArrayList<Date> oldDates = new ArrayList<Date>();
            HashMap<Date, BigDecimal> oldDateAmountMap = new HashMap<Date, BigDecimal>();
            for (SqlRow row : list) {
                Date valueDate = row.getDate("value_date");
                BigDecimal sumAmount = row.getBigDecimal("sum_amount");
                if (valueDate.after(startDate)) {
                    virtualBalance = virtualBalance.add(sumAmount);
                    ValueBalanceCalculator.createBalance(account, valueDate, virtualBalance);
                    continue;
                }
                oldDates.add(valueDate);
                oldDateAmountMap.put(valueDate, sumAmount);
            }
            if (oldDates.size() > 0) {
                Date oldestDate = (Date)oldDates.get(0);
                Date lastDate = new Date(oldestDate.getTime() - 86400000L);
                Collections.reverse(oldDates);
                virtualBalance = null;
                for (Date oldDate : oldDates) {
                    if (virtualBalance == null) {
                        if (oldDate.before(startDate)) {
                            ValueBalanceCalculator.createBalance(account, oldDate, startBalance);
                        }
                        virtualBalance = startBalance.subtract((BigDecimal)oldDateAmountMap.get(oldDate));
                        continue;
                    }
                    ValueBalanceCalculator.createBalance(account, oldDate, virtualBalance);
                    virtualBalance = virtualBalance.subtract((BigDecimal)oldDateAmountMap.get(oldDate));
                }
                ValueBalanceCalculator.createBalance(account, lastDate, virtualBalance);
            }
            ValueBalanceCalculator.calculateVBwithAdvices(account);
            t.commit();
        }
    }

    private static void setParameter(SqlQuery query, Set<CmStatement.Type> types) {
        for (CmStatement.Type t : types) {
            query.setParameter(t.name(), (Object)t.ordinal());
        }
    }

    private static String getTypes(Set<CmStatement.Type> types) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (CmStatement.Type t : types) {
            if (!first) {
                b.append(",");
            } else {
                first = false;
            }
            b.append(":").append(t.name());
        }
        return b.toString();
    }

    private static Date getEarliestValueDate(Set<CmStatement> statements, Set<CmPage> pages) {
        Date minValueDate;
        List list;
        SqlQuery query;
        Date earliestValueDate = null;
        if (statements != null && statements.size() > 0) {
            if (statements.size() >= 1000) {
                return null;
            }
            HashSet<Integer> statementIds = new HashSet<Integer>();
            for (CmStatement statement : statements) {
                statementIds.add(statement.getId());
            }
            query = DB.sqlQuery("SELECT min(value_date) AS min_value_date FROM cm_booking WHERE statement_id IN (:statementIds)");
            query.setParameter("statementIds", statementIds);
            list = query.findList();
            for (SqlRow row : list) {
                minValueDate = row.getDate("min_value_date");
                if (earliestValueDate != null && !minValueDate.before(earliestValueDate)) continue;
                earliestValueDate = minValueDate;
            }
        }
        if (pages != null && pages.size() > 0) {
            if (pages.size() >= 1000) {
                return null;
            }
            HashSet<Integer> pageIds = new HashSet<Integer>();
            for (CmPage page : pages) {
                pageIds.add(page.getId());
            }
            query = DB.sqlQuery("SELECT min(value_date) AS min_value_date FROM cm_booking WHERE page_id IN (:pageIds)");
            query.setParameter("pageIds", pageIds);
            list = query.findList();
            for (SqlRow row : list) {
                minValueDate = row.getDate("min_value_date");
                if (earliestValueDate != null && !minValueDate.before(earliestValueDate)) continue;
                earliestValueDate = minValueDate;
            }
        }
        return earliestValueDate;
    }

    public static void recalculate(Account account) {
        if (account.getUseVirtualBalances()) {
            ValueBalanceCalculator.recalculateVirtualBalances(account);
            return;
        }
        try (Transaction t = DB.beginTransaction();){
            CmStatement newest;
            SqlUpdate delete = DB.sqlUpdate("DELETE FROM cm_balance WHERE account_id = :account ");
            delete.setParameter("account", (Object)account.getId());
            int countDeleted = delete.execute();
            CmLogger logger = CmLogger.getCmLogger();
            if (logger != null && logger.contains(account)) {
                logger.logInfo(account, "VBCalculator-Complete: Deleted " + countDeleted + " cm_balance-entries");
            }
            if ((newest = CmStatement.findNewestStatement(account, (Date)null)) == null) {
                t.commit();
                if (logger != null && logger.contains(account)) {
                    logger.logError(account, "VBCalculator-Complete: Could not find the newest statement");
                }
                return;
            }
            BigDecimal currentBalance = newest.getClosingBalance();
            if (currentBalance == null) {
                t.commit();
                if (logger != null && logger.contains(account)) {
                    logger.logError(account, "VBCalculator-Complete: Newest statement with cmStatementId = " + newest.getId() + " has no closingBalance.");
                }
                return;
            }
            SqlQuery grouping = DB.sqlQuery("SELECT value_date, sum(amount) AS sum_amount FROM cm_booking JOIN cm_statement ON cm_booking.statement_id = cm_statement.id WHERE cm_booking.account_id = :account AND cm_booking.parent_booking_id is null AND cm_statement.type in (" + ValueBalanceCalculator.getTypes(CmStatement.StatementTypes) + ") GROUP BY value_date ORDER BY value_date DESC");
            grouping.setParameter("account", (Object)account.getId());
            ValueBalanceCalculator.setParameter(grouping, CmStatement.StatementTypes);
            List list = grouping.findList();
            BigDecimal sumAmount = null;
            java.util.Date valueDate = null;
            for (SqlRow row : list) {
                if (sumAmount != null) {
                    currentBalance = currentBalance.subtract(sumAmount);
                }
                valueDate = row.getDate("value_date");
                sumAmount = row.getBigDecimal("sum_amount");
                ValueBalanceCalculator.createBalance(account, (Date)valueDate, currentBalance);
            }
            if (valueDate != null && sumAmount != null) {
                valueDate = new Date(valueDate.getTime() - 86400000L);
                currentBalance = currentBalance.subtract(sumAmount);
                ValueBalanceCalculator.createBalance(account, (Date)valueDate, currentBalance);
            }
            ValueBalanceCalculator.calculateVBwithAdvices(account);
            t.commit();
            if (logger != null && logger.contains(account)) {
                logger.logInfo(account, "VBCalculator-Complete: Created " + CmBalance.findTotalCountForAccount(account) + " cm_balance-entries");
            }
        }
    }

    private static void createBalance(Account account, Date valueDate, BigDecimal balance) {
        CmBalance b = new CmBalance();
        b.setAccount(account);
        b.setVauleDate(valueDate);
        b.setValueBalance(balance);
        b.setValueBalanceWithAdvice(balance);
        DB.save(b);
    }

    private static Date getObsoleteDateForAdvices(CmStatement stmt) {
        return new Date(stmt.getCreationDate().getTime());
    }

    public static Date getObsoleteDateForAdvices(Account a) {
        CmStatement stmt;
        if (a != null && (stmt = CmStatement.findNewestStatement(a, (Date)null)) != null) {
            return ValueBalanceCalculator.getObsoleteDateForAdvices(stmt);
        }
        return null;
    }

    public static void updateVBwithAdvicesForBank(BankSettings bank) {
        List<Account> accounts = Account.findAccountsForBank(bank);
        for (Account a : accounts) {
            ValueBalanceCalculator.updateNewAdvices(a);
        }
    }

    private static void calculateVBwithAdvices(Account account) {
        CmStatement newestStatement = CmStatement.findNewestStatement(account, (Date)null);
        if (newestStatement == null) {
            return;
        }
        LocalDate obsoleteDate = newestStatement.getCreationDate().toLocalDateTime().toLocalDate();
        CMBank cmBank = CMBank.get(account.getBank());
        CmStatement newestAdvice = null;
        java.util.Date newestAdviceCreationDate = null;
        if (cmBank.getCumulativeAdviceProvision() || cmBank.getMultidaysAdviceRepeated()) {
            newestAdvice = cmBank.vbCalculationWithCreditAdvices() ? CmStatement.findNewestAdvice(account, null) : CmStatement.findNewestNonCreditAdvice(account, null);
        }
        SqlUpdate delete = DB.sqlUpdate("update cm_booking set balance=null where statement_id in (select id from cm_statement where account_id = :account and type in (" + CmStatement.getRawTypes(cmBank.getAdviceTypesForVBCalculation()) + "))");
        delete.setParameter("account", (Object)account.getId());
        delete.execute();
        ExpressionList query = DB.find(CmBooking.class).where().eq("account", (Object)account).in("statement.type", cmBank.getAdviceTypesForVBCalculation()).ge("bookingDate", (Object)obsoleteDate);
        if (account.getUseVirtualBalances()) {
            query.not(Expr.in((String)"gvc", Arrays.asList("833", "834")));
        }
        if (!cmBank.vbCalculationWithPendingAdvices()) {
            query.ne("sts", (Object)"PDNG");
        }
        if (cmBank.getCumulativeAdviceProvision() && newestAdvice != null) {
            query.eq("statement", (Object)newestAdvice);
            query.add(Expr.or((Expression)Expr.isNull((String)"page.old"), (Expression)Expr.eq((String)"page.old", (Object)false)));
        }
        if (cmBank.getMultidaysAdviceRepeated() && newestAdvice != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(newestAdvice.getCreationDate());
            Calendar day = Calendar.getInstance();
            day.clear();
            day.set(c.get(1), c.get(2), c.get(5));
            newestAdviceCreationDate = day.getTime();
            query.add(Expr.or((Expression)Expr.ge((String)"statement.creationDate", (Object)newestAdviceCreationDate), (Expression)Expr.raw((String)"booking_date <= t1.creation_date")));
        }
        List advicesList = query.orderBy("statement.creationDate ASC, page.creationDate ASC, statement.statementNumber ASC, page_id ASC, pos ASC, id ASC").findList();
        BigDecimal sum = newestStatement.getClosingBalance();
        BigDecimal previousAmount = null;
        boolean previousWasCollective = false;
        for (CmBooking b : advicesList) {
            if (previousWasCollective && !b.isCollective()) {
                sum = sum.subtract(previousAmount);
            }
            sum = sum.add(b.getAmount());
            b.setBalance(sum);
            previousAmount = b.getAmount();
            previousWasCollective = b.isCollective();
        }
        DB.saveAll(advicesList);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT value_date, sum(amount) AS sum_amount FROM cm_booking JOIN cm_statement ON cm_booking.statement_id = cm_statement.id LEFT JOIN cm_page ON cm_booking.page_id = cm_page.id WHERE cm_booking.account_id = :account AND cm_booking.parent_booking_id is null AND cm_statement.type in (").append(ValueBalanceCalculator.getTypes(cmBank.getAdviceTypesForVBCalculation())).append(") AND cm_statement.creation_date >= :creationDate AND cm_booking.booking_date >= :newestBookingDate ");
        if (account.getUseVirtualBalances()) {
            builder.append("AND cm_booking.gvc not in ('833', '834') ");
        }
        if (cmBank.getCumulativeAdviceProvision() && newestAdvice != null) {
            builder.append("AND cm_statement.id = :newestAdviceId ");
            builder.append("AND (cm_page.old IS NULL OR cm_page.old = :false) ");
        }
        if (cmBank.getMultidaysAdviceRepeated() && newestAdvice != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(newestAdvice.getCreationDate());
            Calendar day = Calendar.getInstance();
            day.clear();
            day.set(c.get(1), c.get(2), c.get(5));
            newestAdviceCreationDate = day.getTime();
            builder.append("AND (cm_statement.creation_date >= :newestDate OR cm_booking.booking_date<=cm_statement.creation_date) ");
        }
        if (!cmBank.vbCalculationWithPendingAdvices()) {
            builder.append("AND cm_booking.sts != 'PDNG'");
        }
        builder.append("GROUP BY value_date ORDER BY value_date ASC");
        SqlQuery advices = DB.sqlQuery(builder.toString());
        if (newestAdvice != null) {
            advices.setParameter("newestAdviceId", (Object)newestAdvice.getId());
        }
        if (cmBank.getCumulativeAdviceProvision()) {
            advices.setParameter("false", (Object)Boolean.FALSE);
        }
        if (newestAdviceCreationDate != null) {
            advices.setParameter("newestDate", (Object)newestAdviceCreationDate);
        }
        advices.setParameter("creationDate", (Object)newestStatement.getCreationDate());
        advices.setParameter("account", (Object)account.getId());
        ValueBalanceCalculator.setParameter(advices, cmBank.getAdviceTypesForVBCalculation());
        advices.setParameter("newestBookingDate", (Object)obsoleteDate);
        List list = advices.findList();
        SqlUpdate update = DB.sqlUpdate("UPDATE cm_balance SET value_balance_with_advice = value_balance + :amount WHERE value_date >= :date AND account_id = :account ");
        update.setParameter("account", (Object)account.getId());
        BigDecimal sumAdvice = BigDecimal.ZERO;
        for (SqlRow row : list) {
            Date date = row.getDate("value_date");
            sumAdvice = sumAdvice.add(row.getBigDecimal("sum_amount"));
            update.setParameter("date", (Object)date);
            update.setParameter("amount", (Object)sumAdvice);
            update.execute();
            CmBalance b = (CmBalance)DB.find(CmBalance.class).where().eq("account", (Object)account).eq("valueDate", (Object)date).findOne();
            if (b != null) continue;
            CmBalance tmp = (CmBalance)DB.find(CmBalance.class).where().eq("account", (Object)account).le("valueDate", (Object)date).order("valueDate DESC").setMaxRows(1).findOne();
            if (tmp == null) {
                tmp = (CmBalance)DB.find(CmBalance.class).where().eq("account", (Object)account).ge("valueDate", (Object)date).order("valueDate ASC").setMaxRows(1).findOne();
                if (tmp == null) {
                    return;
                }
                tmp.setVauleDate(date);
                DB.update(tmp);
                b = new CmBalance();
                b.setAccount(account);
                b.setVauleDate(new Date(date.getTime() - 86400000L));
                b.setValueBalance(tmp.getValueBalance());
                b.setValueBalanceWithAdvice(tmp.getValueBalance());
                DB.save(b);
                continue;
            }
            b = new CmBalance();
            b.setAccount(account);
            b.setVauleDate(date);
            b.setValueBalance(tmp.getValueBalance());
            b.setValueBalanceWithAdvice(tmp.getValueBalance().add(sumAdvice));
            DB.save(b);
        }
    }

    public static void updateFull(Set<CmStatement> statements, Set<CmPage> pages) {
        Account a;
        HashSet<Account> accounts = new HashSet<Account>();
        for (CmStatement stmt : statements) {
            a = ValueBalanceCalculator.getAccount(stmt, null);
            if (a == null) continue;
            accounts.add(a);
        }
        for (CmPage page : pages) {
            a = ValueBalanceCalculator.getAccount(null, page);
            if (a == null) continue;
            accounts.add(a);
        }
        CmLogger logger = CmLogger.getCmLogger();
        for (Account account : accounts) {
            if (logger != null && logger.contains(account)) {
                logger.logError(account, "VBCalculator-UpdateFull (MIGRATION) -> Complete calculation.");
            }
            ValueBalanceCalculator.recalculate(account);
        }
    }

    private static Account getAccount(CmStatement stmt, CmPage page) {
        if (page != null) {
            stmt = page.getStatement();
        }
        return stmt.getAccount();
    }

    public static void updateStatements(Set<CmStatement> statements, Set<CmPage> pages, boolean deleteOldAdvices) {
        HashMap<Account, Set> stmtMap = new HashMap<Account, Set>();
        for (CmStatement cmStatement : statements) {
            Account a = ValueBalanceCalculator.getAccount(cmStatement, null);
            if (a == null) continue;
            Set set = stmtMap.computeIfAbsent(a, k -> new HashSet());
            set.add(cmStatement);
        }
        HashMap<Account, Set> pageMap = new HashMap<Account, Set>();
        for (CmPage page : pages) {
            Account a = ValueBalanceCalculator.getAccount(null, page);
            if (a == null) continue;
            Set set = pageMap.computeIfAbsent(a, k -> new HashSet());
            set.add(page);
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(stmtMap.keySet());
        hashSet.addAll(pageMap.keySet());
        for (Account account : hashSet) {
            int countPages;
            int countStatements;
            Set pageSet;
            CmStatement stmt = CmStatement.findNewestStatement(account, (Date)null);
            if (stmt != null && deleteOldAdvices) {
                CmDeleter.deleteObsoleteAdvices(ValueBalanceCalculator.getObsoleteAdviceIds(account, stmt));
            }
            CmLogger logger = CmLogger.getCmLogger();
            Set statementSet = (Set)stmtMap.get(account);
            Date earliestValueDate = ValueBalanceCalculator.getEarliestValueDate(statementSet, pageSet = (Set)pageMap.get(account));
            if (earliestValueDate != null && CmBalance.findCountForAccountBeforeDate(account, earliestValueDate) > 0) {
                if (logger != null && logger.contains(account)) {
                    countStatements = statementSet != null ? statementSet.size() : 0;
                    countPages = pageSet != null ? pageSet.size() : 0;
                    logger.logError(account, "VBCalculator-UpdateStatements -> Delta calculation due to " + countStatements + " new statements and " + countPages + " new pages");
                }
                ValueBalanceCalculator.recalculate(account, earliestValueDate);
                continue;
            }
            if (logger != null && logger.contains(account)) {
                countStatements = statementSet != null ? statementSet.size() : 0;
                countPages = pageSet != null ? pageSet.size() : 0;
                logger.logError(account, "VBCalculator-UpdateStatements -> Complete calculation due to " + countStatements + " new statements and " + countPages + " new pages");
            }
            ValueBalanceCalculator.recalculate(account);
        }
    }

    public static List<Integer> getObsoleteAdviceIds(Account account, CmStatement newestStatement) {
        if (newestStatement == null) {
            return Collections.emptyList();
        }
        Date date = ValueBalanceCalculator.getObsoleteDateForAdvices(newestStatement);
        if (date == null) {
            return Collections.emptyList();
        }
        CMBank cmBank = CMBank.get(account.getBank());
        SqlQuery query = DB.sqlQuery("SELECT cm_statement.id AS id, max(cm_booking.booking_date) AS maxdate FROM cm_statement JOIN cm_booking ON cm_statement.id = cm_booking.statement_id WHERE cm_statement.account_id = :account AND cm_statement.type in (" + ValueBalanceCalculator.getTypes(cmBank.getAdviceTypesForVBCalculation()) + ") AND cm_statement.creation_date < :creationDate GROUP BY cm_statement.id HAVING max(cm_booking.booking_date) <= :date");
        query.setParameter("account", (Object)account.getId());
        query.setParameter("date", (Object)date);
        query.setParameter("creationDate", (Object)newestStatement.getCreationDate());
        ValueBalanceCalculator.setParameter(query, cmBank.getAdviceTypesForVBCalculation());
        List list = query.findList();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SqlRow row : list) {
            ids.add(row.getInteger("id"));
        }
        return ids;
    }

    public static void delete(Set<CmStatement> statements, Set<CmPage> pages) {
        Account a;
        HashSet<Account> accounts = new HashSet<Account>();
        for (CmStatement stmt : statements) {
            a = ValueBalanceCalculator.getAccount(stmt, null);
            if (a == null) continue;
            accounts.add(a);
        }
        for (CmPage page : pages) {
            a = ValueBalanceCalculator.getAccount(null, page);
            if (a == null) continue;
            accounts.add(a);
        }
        CmLogger logger = CmLogger.getCmLogger();
        for (Account account : accounts) {
            if (logger != null && logger.contains(account)) {
                logger.logError(account, "VBCalculator-DELETE -> Complete calculation.");
            }
            ValueBalanceCalculator.recalculate(account);
        }
    }

    private static void updateNewAdvices(Account account) {
        SqlUpdate update = DB.sqlUpdate("UPDATE cm_balance SET value_balance_with_advice = value_balance WHERE account_id=:accountId");
        update.setParameter("accountId", (Object)account.getId());
        update.execute();
        ValueBalanceCalculator.calculateVBwithAdvices(account);
    }

    public static void updateAdvices(Set<CmStatement> statements, Set<CmPage> pages, boolean deleteOldAdvices) {
        Account a;
        HashSet<Account> keys = new HashSet<Account>();
        for (CmStatement stmt : statements) {
            a = ValueBalanceCalculator.getAccount(stmt, null);
            if (a == null) continue;
            keys.add(a);
        }
        for (CmPage page : pages) {
            a = ValueBalanceCalculator.getAccount(null, page);
            if (a == null) continue;
            keys.add(a);
        }
        for (Account account : keys) {
            ValueBalanceCalculator.updateNewAdvices(account);
        }
        if (deleteOldAdvices) {
            for (Account account : keys) {
                CmStatement stmt = CmStatement.findNewestStatement(account, (Date)null);
                if (stmt == null) continue;
                CmDeleter.deleteObsoleteAdvices(ValueBalanceCalculator.getObsoleteAdviceIds(account, stmt));
            }
        }
    }
}

