/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.AlternativePreScheduler;
import de.businesslogics.bcs.core.YYMMDD;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

public class StatementsPreScheduler
implements AlternativePreScheduler {
    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        HashSet<String> result = new HashSet<String>();
        if (cmBank.isStatementFetchActivated()) {
            result.add(cmBank.getStatementFetchType());
        }
        return result;
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        if (CmBank.FetchMode.NEW.equals((Object)cmBank.getStaFetchMode())) {
            return null;
        }
        if (cmBank.getLastStaFetchDate() != null) {
            return new YYMMDD(cmBank.getLastStaFetchDate().getTime());
        }
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.CM, s.getLoginUser(), s.getBank().getTenant());
        Calendar c = Calendar.getInstance();
        c.add(5, 0 - store.getInt(CmPreferenceConstants.HISTORY_TIME_RANGE));
        return new YYMMDD(c.getTimeInMillis());
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
        CMBank cmBank = CMBank.get(s.getBank());
        cmBank.setLastStaFetchDate(date);
        cmBank.save();
    }

    @Override
    public String getAlternativeOrderFileType(Scheduler scheduler, String orderOrFileType) {
        boolean tryNext;
        CMBank cmBank = CMBank.get(scheduler.getBank());
        if (cmBank.getStatementFetchType().equals(orderOrFileType) && (tryNext = cmBank.tryNextStatementFetchParameters())) {
            return cmBank.getStatementFetchType();
        }
        return null;
    }

    @Override
    public void saveNewOrderOrFileType(Scheduler scheduler, String oldOrderOrFileType, String newOrderOrFileType) {
        CMBank cmBank = CMBank.get(scheduler.getBank());
        cmBank.tryNextStatementFetchParameters();
        cmBank.save();
    }
}

