/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.mt940.BundesbankOrderTypes;
import de.businesslogics.format.dta.BundesbankDtaToDTAUSConverter;
import de.businesslogics.format.dta.EBCDICConverter;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class StatementExporter {
    public static void doExport(EncryptData encrypt, File exportFile, boolean append, List<File> filesToExport, BLLogger logger) throws IOException {
        StatementExporter.doExport(encrypt, exportFile, append, filesToExport, false, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doExport(EncryptData encrypt, File exportFile, boolean append, List<File> filesToExport, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        FileOutputStream os = null;
        InputStream is = null;
        try {
            os = new FileOutputStream(exportFile, append);
            for (File file : filesToExport) {
                try {
                    is = encrypt.openInputStream(file);
                    StatementExporter.writeFile(file, is, os, convertEbcdicToAscii, logger);
                }
                finally {
                    SystemUtils.close(is);
                }
            }
        }
        catch (Throwable throwable) {
            SystemUtils.close(os);
            throw throwable;
        }
        SystemUtils.close(os);
    }

    private static void writeFile(File file, InputStream in, OutputStream out, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        if (StatementExporter.isBundesbankDtaFile(file) && convertEbcdicToAscii) {
            try {
                new BundesbankDtaToDTAUSConverter().convertToDTAUS(true, in, out);
            }
            catch (ParseException e) {
                logger.logError("ParseException while converting " + file.getAbsolutePath() + " to DTAUS", e);
            }
        } else if (StatementExporter.isBundesbankSwiftFile(file) && convertEbcdicToAscii) {
            try {
                EBCDICConverter.ebcdicToDtaus(in, out, false);
            }
            catch (IOException e) {
                logger.logError("IOException while converting " + file.getAbsolutePath() + " to ASCII", e);
            }
        } else {
            Streams.copy(in, out, false);
        }
    }

    public static void doZipExport(EncryptData encrypt, File exportFile, boolean append, List<File> filesToExport, boolean batchedTransactionFiles, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        if (append && exportFile.exists() && exportFile.length() > 0L) {
            StatementExporter.appendToZipFile(encrypt, exportFile, filesToExport, batchedTransactionFiles, convertEbcdicToAscii, logger);
        } else {
            StatementExporter.createNewZipFile(encrypt, exportFile, filesToExport, batchedTransactionFiles, convertEbcdicToAscii, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createNewZipFile(EncryptData encrypt, File zipFile, List<File> filesToExport, boolean batchedTransactionFiles, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            for (File file : filesToExport) {
                StatementExporter.writeNewZipEntry(encrypt, out, file, batchedTransactionFiles, convertEbcdicToAscii, logger);
            }
        }
        catch (Throwable throwable) {
            SystemUtils.close(out);
            throw throwable;
        }
        SystemUtils.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNewZipEntry(EncryptData encrypt, ZipOutputStream out, File file, boolean isBatchedTransactionFile, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        String entryName = StatementExporter.getUniqueEntryName(file, isBatchedTransactionFile);
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        InputStream in = null;
        try {
            in = encrypt.openInputStream(file);
            StatementExporter.writeFile(file, in, out, convertEbcdicToAscii, logger);
        }
        finally {
            SystemUtils.close(in);
        }
        out.closeEntry();
    }

    private static String getUniqueEntryName(File file, boolean isBatchedTransactionFile) {
        String fileName = file.getName();
        boolean isXmlFile = fileName.endsWith(".camt053") || fileName.endsWith(".camt052") || fileName.endsWith(".C54");
        File accountDir = isBatchedTransactionFile ? file.getParentFile() : file.getParentFile().getParentFile();
        File bankDir = isBatchedTransactionFile ? accountDir.getParentFile() : accountDir.getParentFile().getParentFile();
        StringBuilder sb = new StringBuilder(bankDir.getName());
        sb.append("-");
        sb.append(accountDir.getName());
        sb.append("-");
        sb.append(file.getName());
        if (isXmlFile) {
            sb.append(".xml");
        }
        return sb.toString();
    }

    private static void appendToZipFile(EncryptData encrypt, File zipFile, List<File> filesToExport, boolean batchedTransactionFiles, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        File tempFile = StatementExporter.createTempZipFile(encrypt, zipFile, filesToExport, batchedTransactionFiles, convertEbcdicToAscii, logger);
        boolean success = zipFile.delete();
        if (success) {
            success = tempFile.renameTo(zipFile);
        }
        if (!success) {
            SystemUtils.copyFile(tempFile, zipFile);
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempZipFile(EncryptData encrypt, File exportFile, List<File> filesToExport, boolean batchedTransactionFiles, boolean convertEbcdicToAscii, BLLogger logger) throws IOException {
        File f = Util.createTempFile("Export", ".zip", false);
        HashSet<String> entryNames = new HashSet<String>();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(f));
            ZipInputStream zip = new ZipInputStream(new FileInputStream(exportFile));
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                StatementExporter.writeExistingZipEntry(out, zip, entry);
                entryNames.add(entry.getName());
                entry = zip.getNextEntry();
            }
            zip.close();
            for (File file : filesToExport) {
                String entryName = StatementExporter.getUniqueEntryName(file, batchedTransactionFiles);
                if (entryNames.contains(entryName)) continue;
                StatementExporter.writeNewZipEntry(encrypt, out, file, batchedTransactionFiles, convertEbcdicToAscii, logger);
                entryNames.add(entryName);
            }
        }
        catch (Throwable throwable) {
            SystemUtils.close(out);
            throw throwable;
        }
        SystemUtils.close(out);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeExistingZipEntry(ZipOutputStream out, ZipInputStream in, ZipEntry entry) throws IOException {
        ZipEntry newEntry = new ZipEntry(entry.getName());
        out.putNextEntry(newEntry);
        try {
            Streams.copy(in, out, false);
        }
        finally {
            in.closeEntry();
        }
        out.closeEntry();
    }

    private static boolean isBundesbankDtaFile(File file) {
        String fileName = file.getName();
        int length = fileName.length();
        if (length >= 3) {
            String orderType = fileName.substring(length - 3);
            return BundesbankOrderTypes.isValidDtaOrderType(orderType);
        }
        return false;
    }

    private static boolean isBundesbankSwiftFile(File file) {
        String fileName = file.getName();
        int length = fileName.length();
        if (length >= 3) {
            String orderType = fileName.substring(length - 3);
            return BundesbankOrderTypes.isValidForeignOrderType(orderType) || BundesbankOrderTypes.isValidDomesticOrderType(orderType);
        }
        return false;
    }
}

