/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.StreamHandler;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.nio.charset.MT940;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class MT94XProcessing {
    protected List<MT940Booking> bookings = new ArrayList<MT940Booking>();
    protected Account latestAccount = null;
    protected boolean doNotProcess = false;
    private File tempFile;
    protected OutputStreamWriter currentWriter = null;
    private File targetFile;
    protected File existingFile = null;
    protected BankSettings bank;
    private File mainDir = null;
    private String namePrefix;
    protected CmReporter reporter = null;
    private StreamHandler streamHandler;
    protected BLLogger logger;
    protected EncryptData encrypt;
    protected DatabasePreferenceStore preferences;

    protected MT94XProcessing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        this.bank = bank;
        this.mainDir = new File(new File(WorkspaceFileSystem.CM_DIRECTORY, bank.getUniqueKey()), "mt940");
        this.namePrefix = WorkspaceFileSystem.CM_DIRECTORY.toString();
        this.reporter = reporter;
        this.streamHandler = new StreamHandler();
        this.logger = logger;
        this.encrypt = encrypt;
        this.preferences = preferences;
    }

    protected InputStream createExistingFileInputStream(File existingFile) throws IOException {
        return this.streamHandler.createExistingFileInputStream(existingFile, this.encrypt);
    }

    private OutputStream createTempFileOutputStream(File tempFile) throws IOException {
        return this.streamHandler.createTempFileOutputStream(tempFile, this.encrypt);
    }

    protected OutputStreamWriter createTempFileWriter() throws IOException {
        this.tempFile = Util.createTempFile("MT94X", ".MT94X", false);
        return new OutputStreamWriter(this.createTempFileOutputStream(this.tempFile), new MT940());
    }

    protected void setFile(CmStatement s) {
        long fileSize = this.streamHandler.getFileSize();
        String hash = this.streamHandler.getMD5Hash();
        WorkspaceFile file = WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.CM, this.getDbFile(), fileSize, hash, null);
        s.setFile(file);
    }

    protected void setFile(CmPage p) {
        long fileSize = this.streamHandler.getFileSize();
        String hash = this.streamHandler.getMD5Hash();
        WorkspaceFile file = WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.CM, this.getDbFile(), fileSize, hash, null);
        p.setFile(file);
    }

    protected File getDbFile() {
        return this.targetFile == null ? this.existingFile : this.targetFile;
    }

    private String getDbFileName(File file) {
        return file.getAbsolutePath().substring(this.namePrefix.length());
    }

    protected File createAccountDir(Field25 field25) {
        File accountDir = new File(this.mainDir, MT940Processing.transform(field25.getPlainValue()));
        accountDir.mkdirs();
        return accountDir;
    }

    protected void createTargetFile(File targetDir, String targetFileName) {
        this.targetFile = new File(targetDir, targetFileName.toString());
        try {
            SystemUtils.renameFile(this.tempFile, this.targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getMD5Hash() {
        return this.streamHandler.getMD5Hash();
    }

    protected void deleteTempFile() {
        if (this.tempFile != null && !this.tempFile.delete()) {
            this.logger.logWarning("Can not delete temporary file: " + this.tempFile.getName(), null);
            this.tempFile.deleteOnExit();
        }
    }

    protected boolean hasDifferentContent(String newHash, String oldHash) {
        if (newHash.equals(oldHash)) {
            this.deleteTempFile();
            return false;
        }
        return true;
    }
}

