/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.banking.mt940.api.MT94XProcessing;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.Field28C;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.format.swift.mt942.MT942Header;
import de.businesslogics.format.swift.mt942.MT942Listener;
import de.businesslogics.format.swift.mt942.MT942Parser;
import de.businesslogics.format.swift.mt942.MT942Trailer;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class MT942Processing
extends MT94XProcessing
implements MT942Listener {
    private MT942Header currentHeader = null;
    private final boolean ignoreOldAdvices;
    private Date obsoleteDate = null;
    private Date defaultBookingDate = null;
    private boolean hasNewBookings = false;
    private final SimpleDateFormat yyyyMMddHHmmFormat = new SimpleDateFormat("yyyyMMddHHmm");

    public MT942Processing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(bank, reporter, logger, encrypt, preferences);
        this.ignoreOldAdvices = preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
    }

    public Account importExistingFile(File existingFile) throws IOException, ParseException {
        this.existingFile = existingFile;
        this.process(this.createExistingFileInputStream(existingFile));
        return this.latestAccount;
    }

    public void process(InputStream in) throws IOException, ParseException {
        MT942Parser p = new MT942Parser(this);
        p.parse(in);
    }

    @Override
    public void handle(MT942Header header) {
        this.latestAccount = MT940Processing.findOrCreateAccount(this.bank, header.getField25(), header.getField34F_1().getCurrency().getCurrencyCode());
        boolean bl = this.doNotProcess = this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode();
        if (this.doNotProcess) {
            return;
        }
        this.bookings.clear();
        this.currentHeader = header;
        if (this.ignoreOldAdvices) {
            this.obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(this.latestAccount);
            this.defaultBookingDate = new Date(header.getField13().getTime().getTime());
            this.hasNewBookings = false;
        }
        if (this.existingFile == null) {
            try {
                this.currentWriter = this.createTempFileWriter();
                header.writeTo(this.currentWriter);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
        }
    }

    @Override
    public void handle(MT940Booking booking) {
        if (this.doNotProcess) {
            return;
        }
        if (this.currentWriter != null) {
            try {
                booking.writeTo(this.currentWriter);
                if (this.ignoreOldAdvices && !this.hasNewBookings) {
                    this.hasNewBookings = !this.hasObsoleteBookingDate(booking, this.defaultBookingDate, this.obsoleteDate);
                }
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        this.bookings.add(booking);
    }

    @Override
    public void handle(MT942Trailer trailer) {
        if (this.doNotProcess) {
            return;
        }
        if (this.currentWriter != null) {
            try {
                trailer.writeTo(this.currentWriter);
                SystemUtils.close(this.currentWriter);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.ignoreOldAdvices && !this.hasNewBookings) {
            this.deleteTempFile();
            return;
        }
        Field25 field25 = this.currentHeader.getField25();
        Field28C field28C = this.currentHeader.getField28C();
        int number = field28C.getNumber();
        int pageNumber = field28C.getSheet();
        java.util.Date creationDate = this.currentHeader.getField13().getTime();
        Object uniqueId = CMProcessingDb.getUniqueStatementId(creationDate, Integer.toString(number), "_VMK");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, (String)uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(field25, field28C, creationDate, number);
            }
            this.createStatement((String)uniqueId, this.currentHeader, creationDate, number, pageNumber);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, pageNumber, new Timestamp(creationDate.getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(field25, field28C, creationDate, number);
                }
                this.createPage(c, this.currentHeader);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                String newHash = this.getMD5Hash();
                CmPage existingPage = CmPage.findByHash(c.getAccount(), newHash);
                if (existingPage == null) {
                    if (this.existingFile == null) {
                        this.createTargetFile(field25, field28C, creationDate, number + newHash.hashCode());
                    }
                    this.createPage(c, this.currentHeader);
                }
            }
        } else if (this.isSecondPage(c, pageNumber, creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(field25, field28C, creationDate, number);
            }
            this.createPage(c, this.currentHeader);
        } else {
            CmPage existingPage;
            String newHash = this.getMD5Hash();
            if (this.hasDifferentContent(newHash, c.getMd5Hash()) && (existingPage = CmPage.findByHash(c.getAccount(), newHash)) == null) {
                if (this.existingFile == null) {
                    uniqueId = (String)uniqueId + newHash.hashCode();
                    this.createTargetFile(field25, field28C, creationDate, number + newHash.hashCode());
                }
                CMProcessingDb.createPageFromStatement(c);
                this.createPage(c, this.currentHeader);
            }
        }
    }

    private void createTargetFile(Field25 field25, Field28C field28C, java.util.Date creationDate, int number) {
        File accountDir = this.createAccountDir(field25);
        String adviceTimeStamp = this.yyyyMMddHHmmFormat.format(creationDate);
        String adviceDateYYMMDD = adviceTimeStamp.substring(2, 8);
        String adviceTimeHHMm = adviceTimeStamp.substring(8, 12);
        String targetDirName = adviceDateYYMMDD + "_" + number + ".VMK";
        File targetDir = new File(accountDir, targetDirName);
        targetDir.mkdir();
        StringBuffer targetFileName = new StringBuffer(adviceDateYYMMDD);
        targetFileName.append('_');
        targetFileName.append(MT940Processing.transform(field28C.toString()));
        targetFileName.append('-');
        targetFileName.append(adviceTimeHHMm);
        targetFileName.append(".VMK");
        this.createTargetFile(targetDir, targetFileName.toString());
    }

    private void createStatement(String uniqueId, MT942Header header, java.util.Date creationDate, int number, int page) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.MT942, this.latestAccount);
        this.setStatementData(c, header, creationDate, number, page);
        DB.save(c);
        MT940Processing.processBookings(this.latestAccount, c, null, this.bookings, this.preferences);
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement c, MT942Header header) {
        CmPage p = CMProcessingDb.createPage(c);
        this.setPageData(p, header, c.getCurrency());
        DB.save(p);
        MT940Processing.processBookings(this.latestAccount, c, p, this.bookings, this.preferences);
        this.reporter.newStatement(c, p);
        this.setOldFlagForPages(c);
    }

    private void setStatementData(CmStatement c, MT942Header header, java.util.Date creationDate, int number, int page) {
        this.setFile(c);
        c.setCreationDate(new Timestamp(creationDate.getTime()));
        c.setStatementNumber(number);
        c.setPageNumberAsInt(page);
        c.setCurrency(header.getField34F_1().getCurrency());
        c.setReference1(header.getField20().getReference());
        if (header.getField21() != null) {
            c.setReference2(header.getField21().getReference());
        }
    }

    private void setPageData(CmPage p, MT942Header header, Currency currency) {
        this.setFile(p);
        p.setCreationDate(new Timestamp(header.getField13().getTime().getTime()));
        p.setPageNumberAsInt(header.getField28C().getSheet());
        p.setReference1(header.getField20().getReference());
        if (header.getField21() != null) {
            p.setReference2(header.getField21().getReference());
        }
        p.setCurrency(currency);
    }

    private boolean isSecondPage(CmStatement s, int pageNumber, java.util.Date creationDate) {
        String timeStampDb;
        if (pageNumber != s.getPageNumberAsInt()) {
            return true;
        }
        String timeStamp = this.yyyyMMddHHmmFormat.format(creationDate);
        return !timeStamp.equals(timeStampDb = this.yyyyMMddHHmmFormat.format(s.getCreationDate()));
    }

    private void setOldFlagForPages(CmStatement advice) {
        CmPage.markOtherAsOld(advice);
    }

    private boolean hasObsoleteBookingDate(MT940Booking booking, Date defaultBookingDate, Date obsoleteDate) {
        if (obsoleteDate != null) {
            if (booking.getField61() != null && booking.getField61().getBooking(null) != null) {
                return booking.getField61().getBooking(null).before(obsoleteDate);
            }
            return defaultBookingDate.before(obsoleteDate);
        }
        return false;
    }
}

