/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.MT942Processing;
import de.businesslogics.banking.mt940.api.MT94XProcessing;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.format.swift.Field25;
import de.businesslogics.format.swift.Field28C;
import de.businesslogics.format.swift.Field60M;
import de.businesslogics.format.swift.Field61;
import de.businesslogics.format.swift.Field62F;
import de.businesslogics.format.swift.Field62M;
import de.businesslogics.format.swift.Field86;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.StructuredField86;
import de.businesslogics.format.swift.mt940.CMUtil;
import de.businesslogics.format.swift.mt940.Field86HandlerSG;
import de.businesslogics.format.swift.mt940.MT940Booking;
import de.businesslogics.format.swift.mt940.MT940Header;
import de.businesslogics.format.swift.mt940.MT940Listener;
import de.businesslogics.format.swift.mt940.MT940Parser;
import de.businesslogics.format.swift.mt940.MT940Trailer;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.nio.charset.MT940;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import io.ebean.Query;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MT940Processing
extends MT94XProcessing
implements MT940Listener {
    private static final boolean STORE_FULL_PURPOSE = Boolean.getBoolean("de.businesslogics.banking.mt940.storeFullPurpose");
    private static final String[] otherEvaluatedIdentifiers = new String[]{"EREF", "KREF", "MREF", "CRED", "OAMT"};
    public static final String DIR_NAME = "mt940";
    private MT940Header currentHeader = null;

    public MT940Processing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(bank, reporter, logger, encrypt, preferences);
    }

    public void process(InputStream in) throws Exception {
        File[] tempFiles = this.splitMixedData(in);
        if (tempFiles[0] == null && tempFiles[1] == null) {
            throw new IOException("File has not the valid MT940 format");
        }
        if (tempFiles[1] != null) {
            this.processMT942(tempFiles[1]);
        }
        if (tempFiles[0] != null) {
            this.processMT940(tempFiles[0]);
        }
    }

    public Account importExistingFile(File in) throws IOException, ParseException {
        this.existingFile = in;
        MT940Parser p = new MT940Parser(this);
        p.parse(this.createExistingFileInputStream(in));
        this.existingFile = null;
        return this.latestAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMT940(File mt940File) throws IOException, ParseException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(mt940File);
            MT940Parser p = new MT940Parser(this);
            p.parse(in);
        }
        catch (Throwable throwable) {
            SystemUtils.close(in);
            if (!mt940File.delete()) {
                this.logger.logWarning("Can not delete temporary file: " + mt940File.getName(), null);
                mt940File.deleteOnExit();
            }
            throw throwable;
        }
        SystemUtils.close(in);
        if (!mt940File.delete()) {
            this.logger.logWarning("Can not delete temporary file: " + mt940File.getName(), null);
            mt940File.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMT942(File mt942File) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(mt942File);
            MT942Processing mt942Processing = new MT942Processing(this.bank, this.reporter.getAdviceSubReporter(), this.logger, this.encrypt, this.preferences);
            mt942Processing.process(in);
            if (!mt942File.delete()) {
                mt942File.deleteOnExit();
            }
        }
        catch (Throwable throwable) {
            SystemUtils.close(in);
            throw throwable;
        }
        SystemUtils.close(in);
    }

    private Account findOrCreateAccount(Field25 field25, Currency currency) {
        return MT940Processing.findOrCreateAccount(this.bank, field25, currency.getCurrencyCode());
    }

    public static Account findOrCreateAccount(BankSettings bank, Field25 field25, String currency) {
        List matchingAccounts;
        String iban;
        String[] plain;
        String cmIdentifier = field25.getPlainValue();
        Account a = Account.findAccountByCmIdentification(bank, cmIdentifier);
        if (a != null) {
            return a;
        }
        if (IbanUtil.checkIban(cmIdentifier)) {
            return MT940Processing.findIbanAccount(bank, cmIdentifier, currency);
        }
        String blz = MT940Processing.getGermanBankCode(field25);
        String germanAccountNumber = MT940Processing.getGermanAccountNumber(field25);
        if (blz != null && germanAccountNumber != null) {
            return MT940Processing.findGermanAccount(bank, blz, germanAccountNumber, currency, cmIdentifier);
        }
        String bic = MT940Processing.getBIC(field25);
        if (bic != null) {
            if (bic.startsWith("DE", 4)) {
                if (germanAccountNumber != null) {
                    return MT940Processing.findGermanBICAccount(bank, bic, germanAccountNumber, currency, cmIdentifier);
                }
            } else {
                String nationalAccountNumber = field25.getAccount();
                if (nationalAccountNumber != null) {
                    if (IbanUtil.checkIban(nationalAccountNumber)) {
                        return MT940Processing.findIbanAccount(bank, nationalAccountNumber, currency);
                    }
                    return MT940Processing.findNationalBICAccount(bank, bic, nationalAccountNumber, currency, cmIdentifier);
                }
            }
        }
        if (field25.getPlainValue().startsWith("//AT") && (plain = field25.getPlainValue().split("/")).length >= 3) {
            while (plain[3].length() < 11) {
                plain[3] = "0" + plain[3];
            }
            String iban2 = IbanUtil.calculateIban("AT", plain[2].substring(2) + plain[3]);
            a = MT940Processing.findIbanAccount(bank, iban2, currency);
            if (a != null) {
                MT940Processing.saveCMIdentifier(a, field25.getPlainValue());
                return a;
            }
        }
        if (field25.getBankcode() != null && field25.getBankcode().length() == 5 && (a = MT940Processing.findIbanAccount(bank, iban = IbanUtil.calculateIban("AT", field25.getBankcode() + field25.getAccount()), currency)) != null) {
            MT940Processing.saveCMIdentifier(a, field25.getPlainValue());
            return a;
        }
        if (field25.getBankcode() == null && germanAccountNumber != null && (matchingAccounts = DB.find(Account.class).where().eq("bank", (Object)bank).eq("germanAccountNumber", (Object)germanAccountNumber).eq("currency", (Object)currency).findList()).size() == 1) {
            a = (Account)matchingAccounts.get(0);
            MT940Processing.saveCMIdentifier(a, field25.getPlainValue());
            return a;
        }
        a = new Account();
        MT940Processing.createCMAccount(a, bank, currency, cmIdentifier);
        return a;
    }

    private static Account findIbanAccount(BankSettings bank, String iban, String currency) {
        Account a = Account.findAccountByIban(bank, iban, currency);
        if (a == null) {
            a = new Account();
            a.setIban(iban);
            MT940Processing.createCMAccount(a, bank, currency, iban);
        } else {
            MT940Processing.saveCMIdentifier(a, iban);
        }
        return a;
    }

    private static Account findGermanAccount(BankSettings bank, String blz, String germanAccountNumber, String currency, String cmIdentifier) {
        Account a;
        SEPABankConnection c = BLZCache.CACHE.getSEPABankConnection(blz, germanAccountNumber);
        if (c != null && (a = Account.findAccountByIban(bank, c.getIban(), currency)) != null) {
            if (a.getGermanAccountNumber() == null || a.getGermanBankCode() == null || a.getCmIdentification() == null) {
                a.setGermanBankCode(blz);
                a.setGermanAccountNumber(germanAccountNumber);
                a.setCmIdentification(cmIdentifier);
                a.save();
            }
            return a;
        }
        a = Account.findGermanAccount(bank, blz, germanAccountNumber, currency);
        if (a == null) {
            a = new Account();
            if (c != null) {
                a.setBic(c.getBic());
                a.setIban(c.getIban());
            }
            a.setGermanBankCode(blz);
            a.setGermanAccountNumber(germanAccountNumber);
            MT940Processing.createCMAccount(a, bank, currency, cmIdentifier);
        }
        return a;
    }

    private static Account findGermanBICAccount(BankSettings bank, String bic, String germanAccountNumber, String currency, String cmIdentifier) {
        Account a = Account.findAccountByGermanAccountNumberBic(bank, germanAccountNumber, bic, currency);
        if (a == null) {
            a = new Account();
            a.setBic(bic);
            a.setGermanAccountNumber(germanAccountNumber);
            MT940Processing.createCMAccount(a, bank, currency, cmIdentifier);
        }
        return a;
    }

    private static Account findNationalBICAccount(BankSettings bank, String bic, String nationalAccountNumber, String currency, String cmIdentifier) {
        Account a = Account.findAccountByNationalAccountNumberBic(bank, bic, nationalAccountNumber, currency);
        if (a == null) {
            a = new Account();
            a.setBic(bic);
            a.setNationalAccountNumber(nationalAccountNumber);
            MT940Processing.createCMAccount(a, bank, currency, cmIdentifier);
        }
        return a;
    }

    private static void createCMAccount(Account a, BankSettings bank, String currency, String cmIdentifier) {
        a.setBank(bank);
        a.setCurrency(currency);
        a.setCmIdentification(cmIdentifier);
        a.setType(Account.Type.CASH_MANAGEMENT);
        a.save();
        AccountPermission.createPermissionForAllUsers(a);
    }

    private static void saveCMIdentifier(Account a, String cmIdentifier) {
        if (cmIdentifier != null && !cmIdentifier.equals(a.getCmIdentification())) {
            a.setCmIdentification(cmIdentifier);
            a.save();
        }
    }

    public static String getBIC(Field25 field25) {
        String bankCode = field25.getBankcode();
        if (PaymentUtils.isBIC(bankCode)) {
            return bankCode;
        }
        return null;
    }

    public static String getGermanBankCode(Field25 field25) {
        String bankCode = field25.getBankcode();
        if (bankCode != null && PaymentUtils.isGermanBLZ(bankCode)) {
            return bankCode;
        }
        return null;
    }

    public static String getGermanAccountNumber(Field25 field25) {
        String accountNumber = field25.getAccount();
        if (accountNumber != null) {
            String germanAccountNumber = StringUtils.removeLeadingChars(accountNumber, '0');
            if (germanAccountNumber.endsWith("/")) {
                germanAccountNumber = germanAccountNumber.substring(0, germanAccountNumber.length() - 1);
            }
            if (PaymentUtils.isGermanAccountNumber(germanAccountNumber)) {
                return germanAccountNumber;
            }
        }
        return null;
    }

    @Override
    public void handle(MT940Header header) {
        this.latestAccount = this.findOrCreateAccount(header.getField25(), header.getField60F().getCurrency());
        boolean bl = this.doNotProcess = this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode();
        if (this.doNotProcess) {
            return;
        }
        this.currentHeader = header;
        this.bookings.clear();
        if (this.existingFile == null) {
            try {
                this.currentWriter = this.createTempFileWriter();
                header.writeTo(this.currentWriter);
            }
            catch (Exception io) {
                throw new RuntimeException(io);
            }
        } else {
            this.currentWriter = null;
        }
    }

    @Override
    public void handle(MT940Booking booking) {
        if (this.doNotProcess) {
            return;
        }
        if (this.currentWriter != null) {
            try {
                booking.writeTo(this.currentWriter);
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
        this.bookings.add(booking);
    }

    @Override
    public void handle(MT940Trailer trailer) {
        if (this.doNotProcess) {
            return;
        }
        if (this.currentWriter != null) {
            try {
                trailer.writeTo(this.currentWriter);
                SystemUtils.close(this.currentWriter);
                this.currentWriter = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Field25 field25 = this.currentHeader.getField25();
        Field28C field28C = this.currentHeader.getField28C();
        int number = field28C.getNumber();
        int pageNumber = field28C.getSheet();
        Field62F field62 = trailer.getField62F();
        String uniqueId = CMProcessingDb.getUniqueStatementId(trailer.getField62F().getBooking(), String.valueOf(number), "_STA");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(field25, field28C, field62);
            }
            this.createStatement(uniqueId, this.currentHeader, field62);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumber(c, pageNumber);
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(field25, field28C, field62);
                }
                this.createPage(c, this.currentHeader, trailer);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(field25, field28C, field62);
                }
                this.updatePage(c, cmPage, this.currentHeader, trailer);
            }
        } else if (pageNumber != c.getPageNumberAsInt()) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(field25, field28C, field62);
            }
            this.createPage(c, this.currentHeader, trailer);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(field25, field28C, field62);
            }
            this.updateStatement(c, this.currentHeader, field62);
        }
    }

    private void createTargetFile(Field25 field25, Field28C field28C, Field62F field62) {
        File accountDir = this.createAccountDir(field25);
        String dirName = MT940Processing.transform(field62.getBookingDate() + "_" + field28C.getNumber() + ".STA");
        String fileName = MT940Processing.transform(field62.getBookingDate() + "_" + String.valueOf(field28C) + ".STA");
        File targetDir = new File(accountDir, dirName);
        targetDir.mkdir();
        this.createTargetFile(targetDir, fileName);
    }

    private void createStatement(String uniqueId, MT940Header header, Field62F field62) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.MT940, this.latestAccount);
        this.setStatementData(c, header, field62);
        DB.save(c);
        MT940Processing.processBookings(this.latestAccount, c, null, this.bookings, this.preferences);
        this.reporter.newStatement(c, null);
    }

    private void updateStatement(CmStatement c, MT940Header header, Field62F field62) {
        this.setStatementData(c, header, field62);
        DB.update(c);
        MT940Processing.processBookings(this.latestAccount, c, null, this.bookings, this.preferences);
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement c, MT940Header header, MT940Trailer trailer) {
        CmPage p = CMProcessingDb.createPage(c);
        this.setPageData(p, header, trailer);
        DB.save(p);
        this.updateStatementByPage(c, header, trailer);
        MT940Processing.processBookings(this.latestAccount, c, p, this.bookings, this.preferences);
        this.reporter.newStatement(c, p);
    }

    private void updatePage(CmStatement c, CmPage p, MT940Header header, MT940Trailer trailer) {
        this.setPageData(p, header, trailer);
        DB.update(p);
        this.updateStatementByPage(c, header, trailer);
        MT940Processing.processBookings(this.latestAccount, c, p, this.bookings, this.preferences);
        this.reporter.newStatement(c, p);
    }

    private void setStatementData(CmStatement c, MT940Header header, Field62F field62) {
        this.setFile(c);
        c.setReference1(header.getField20().getReference());
        if (header.getField21() != null) {
            c.setReference2(header.getField21().getReference());
        }
        c.setCurrency(header.getField60F().getCurrency());
        c.setOpeningBalance(header.getField60F().getBalance());
        c.setOpeningFinal(!(header.getField60F() instanceof Field60M));
        java.util.Date openingDate = header.getField60F().getBooking();
        if (openingDate != null) {
            c.setOpeningDate(new Date(openingDate.getTime()));
        } else {
            c.setOpeningDate(null);
        }
        c.setStatementNumber(header.getField28C().getNumber());
        c.setPageNumberAsInt(header.getField28C().getSheet());
        c.setClosingBalance(field62.getBalance());
        c.setClosingFinal(!(field62 instanceof Field62M));
        c.setClosingDate(new Date(field62.getBooking().getTime()));
        c.setCreationDate(this.endOfDay(c.getClosingDate()));
        c.setCurrency(field62.getCurrency());
    }

    private Timestamp endOfDay(java.util.Date date) {
        return new Timestamp(date.getTime() + 86400000L - 1L);
    }

    private void setPageData(CmPage p, MT940Header header, MT940Trailer trailer) {
        this.setFile(p);
        p.setPageNumberAsInt(header.getField28C().getSheet());
        p.setReference1(header.getField20().getReference());
        if (header.getField21() != null) {
            p.setReference2(header.getField21().getReference());
        }
        p.setOpeningBalance(header.getField60F().getBalance());
        p.setOpeningFinal(!(header.getField60F() instanceof Field60M));
        if (header.getField60F().getBooking() != null) {
            p.setOpeningDate(new Date(header.getField60F().getBooking().getTime()));
        } else {
            p.setOpeningDate(null);
        }
        p.setClosingBalance(trailer.getField62F().getBalance());
        p.setClosingFinal(!(trailer.getField62F() instanceof Field62M));
        p.setClosingDate(new Date(trailer.getField62F().getBooking().getTime()));
        if (trailer.getField62F().getCurrency() != null) {
            p.setCurrency(trailer.getField62F().getCurrency());
        }
        p.setCreationDate(this.endOfDay(p.getClosingDate()));
    }

    private void updateStatementByPage(CmStatement c, MT940Header header, MT940Trailer trailer) {
        if (!(header.getField60F() instanceof Field60M)) {
            c.setOpeningBalance(header.getField60F().getBalance());
            c.setOpeningFinal(true);
            java.util.Date openingDate = header.getField60F().getBooking();
            if (openingDate != null) {
                c.setOpeningDate(new Date(openingDate.getTime()));
            } else {
                c.setOpeningDate(null);
            }
        }
        int pageNumber = header.getField28C().getSheet();
        if (!(trailer.getField62F() instanceof Field62M) || pageNumber >= c.getPageNumberAsInt()) {
            c.setClosingBalance(trailer.getField62F().getBalance());
            c.setClosingFinal(true);
            c.setClosingDate(new Date(trailer.getField62F().getBooking().getTime()));
            c.setCreationDate(this.endOfDay(c.getClosingDate()));
            c.setReference1(header.getField20().getReference());
            c.setPageNumberAsInt(pageNumber);
            if (header.getField21() != null) {
                c.setReference2(header.getField21().getReference());
            }
        }
    }

    public static void processBookings(Account a, CmStatement c, CmPage p, List<MT940Booking> bookings, DatabasePreferenceStore preferences) {
        boolean splitPurposeIntoSepaTags = preferences.getBoolean(CmPreferenceConstants.SPLIT_MT940_PURPOSE_INTO_SEPA_TAGS);
        int pos = 0;
        BigDecimal balance = p == null ? c.getOpeningBalance() : p.getOpeningBalance();
        BookingStatistics statistics = new BookingStatistics();
        for (MT940Booking booking : bookings) {
            java.util.Date date;
            String firstLine;
            String chgs;
            Field61 f61 = booking.getField61();
            if (f61 == null) continue;
            Query q = DB.find(CmBooking.class).where().eq("statement", (Object)c).eq("pos", (Object)(++pos)).query();
            if (p != null) {
                q.where().eq("page", (Object)p);
            } else {
                q.where().isNull("page");
            }
            CmBooking b = (CmBooking)q.findOne();
            if (b == null) {
                b = new CmBooking();
                b.setPos(pos);
            }
            b.setAccount(a);
            b.setAmount(f61.getAmount());
            b.setReversal(f61.isReversal());
            if (balance != null) {
                balance = balance.add(f61.getAmount());
                b.setBalance(balance);
            }
            if (f61.getBookingDate(c.getClosingDate()) != null) {
                b.setBookingDate(new Date(f61.getBookingDate(c.getClosingDate()).getTime()));
            } else if (c.isAdvice()) {
                b.setBookingDate(new Date(c.getCreationDate().getTime()));
            } else {
                b.setBookingDate(c.getClosingDate());
            }
            b.setCollective(false);
            b.setCurrency(c.getCurrency());
            b.setPage(p);
            b.setStatement(c);
            b.setValueDate(new Date(f61.getValuta().getTime()));
            b.setBookingKey(f61.getBookingKey());
            String customerRef61 = f61.getCustomerReference();
            if (customerRef61 != null) {
                customerRef61 = customerRef61.trim();
            }
            String customerRef86 = null;
            b.setBankReference(StringUtils.shorten(f61.getBankReference(), 35));
            b.setAdditionalInformation(StringUtils.shorten(f61.getAdditionalInformation(), 500));
            String ocmt = booking.getOCMT();
            if (ocmt != null) {
                try {
                    b.setOriginalCurrency(ocmt.substring(0, 3));
                    b.setOriginalAmount(booking.parseAmount(ocmt));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((chgs = booking.getCHGS()) != null) {
                try {
                    b.setChargesCurrency(chgs.substring(0, 3));
                    b.setChargesAmount(booking.parseAmount(chgs));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean purposeInSVWZ = false;
            Field86 f86 = booking.getField86();
            Map<String, String> identifierMapSG = null;
            if (f86 != null) {
                if (f86 instanceof StructuredField86) {
                    String oamt;
                    StructuredField86 sf86 = (StructuredField86)f86;
                    String gvc = sf86.getGeschaeftsvorfallcode();
                    b.setGvc(StringUtils.shorten(gvc, 3));
                    b.setBookingText(StringUtils.shorten(sf86.getBookingText(), 27));
                    b.setPrimanota(StringUtils.shorten(sf86.getPrimaNota(), 10));
                    b.setTextKeyAppendix(StringUtils.shorten(sf86.getTextKeyAppendix(), 3));
                    b.setDebit(CMUtil.isDirectDebit(gvc));
                    if (CMUtil.isCollectiveBooking(gvc)) {
                        b.setLocalParty(StringUtils.shorten(StringUtils.getStringFromStringArray(sf86.getOtherName(), "\n"), 140));
                        b.setLocalPartyAccountNumber(StringUtils.shorten(sf86.getOtherAccount(), 40));
                        b.setLocalPartyBankCode(StringUtils.shorten(sf86.getOtherBankcode(), 30));
                    } else {
                        b.setCounterParty(StringUtils.shorten(StringUtils.getStringFromStringArray(sf86.getOtherName(), "\n"), 140));
                        b.setCounterPartyAccountNumber(StringUtils.shorten(sf86.getOtherAccount(), 40));
                        b.setCounterPartyBankCode(StringUtils.shorten(sf86.getOtherBankcode(), 30));
                    }
                    String[] purposeLines = sf86.getPurpose();
                    Map<String, String> identifier = MT940Booking.extractIdentifiers(purposeLines);
                    boolean valuesInAllowedRange = MT940Processing.valuesInAllowedRange(identifier);
                    b.setEndToEndId(StringUtils.shorten(identifier.get("EREF"), 35));
                    customerRef86 = identifier.get("KREF");
                    b.setCounterPartyCreditorId(StringUtils.shorten(identifier.get("CRED"), 35));
                    b.setLocalPartyMandateReference(StringUtils.shorten(identifier.get("MREF"), 35));
                    if (b.getOriginalAmount() == null && (oamt = identifier.get("OAMT")) != null) {
                        try {
                            b.setOriginalAmount(new BigDecimal(oamt.replace(',', '.')));
                            b.setOriginalCurrency(b.getCurrencyCode());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (splitPurposeIntoSepaTags) {
                        String svwz = identifier.get("SVWZ");
                        if (svwz != null && svwz.trim().length() > 0) {
                            b.setPurposeOverview(StringUtils.shorten(svwz, 140));
                            purposeInSVWZ = true;
                        }
                        if (valuesInAllowedRange) {
                            purposeLines = MT940Processing.removeRedundantPurposeLines(purposeLines);
                        }
                    }
                    b.setPurpose(StringUtils.shorten(StringUtils.getStringFromStringArray(purposeLines, "\n"), 400));
                } else {
                    identifierMapSG = Field86HandlerSG.evaluateStructuredPurpose(f86.getRawLines());
                    if (identifierMapSG != null) {
                        MT940Processing.setDataFromSGStructuredPurpose(b, identifierMapSG);
                    }
                    if (STORE_FULL_PURPOSE || identifierMapSG == null) {
                        String firstLine2;
                        String purposeForDB = StringUtils.getStringFromStringArray(f86.getRawLines(), "\n");
                        b.setPurpose(StringUtils.shorten(purposeForDB, 400));
                        if (purposeForDB != null && purposeForDB.length() > 400 && b.getAdditionalInformation() == null) {
                            b.setAdditionalInformation(StringUtils.shorten(purposeForDB.substring(400), 500));
                        }
                        if (identifierMapSG != null && (firstLine2 = b.getFirstLine(b.getPurpose())) != null) {
                            b.setPurposeOverview(StringUtils.shorten(firstLine2, 140));
                        }
                    }
                }
            }
            if (!purposeInSVWZ && identifierMapSG == null && (firstLine = b.getFirstLine(b.getPurpose())) != null) {
                b.setPurposeOverview(StringUtils.shorten(firstLine, 140));
            }
            String customerRef = "NONREF".equals(customerRef61) ? customerRef86 : ("KREF+".equals(customerRef61) ? (customerRef86 != null ? customerRef86 : b.getPurposeOverview()) : customerRef61);
            if (customerRef != null && customerRef.length() > 19 && PaymentUtils.isBIC(customerRef.substring(0, 11)) && (date = CMProcessingDb.startsWithYYYYMMDD(customerRef = customerRef.substring(11))) != null) {
                b.setCustomerReferenceDate(new Date(date.getTime()));
                customerRef = customerRef.substring(8);
            }
            b.setCustomerReference(StringUtils.shorten(customerRef, 35));
            if (b.getId() == null) {
                DB.save(b);
            } else {
                DB.update(b);
            }
            if (customerRef != null) {
                CMProcessingDb.connectToSingleBookings(b, customerRef, preferences);
            }
            statistics.addBooking(b.getAmount());
        }
        CMProcessingDb.deleteHigherPositionedBookings(c, p, pos);
        CMProcessingDb.storeStatistics(c, p, statistics);
    }

    private static boolean valuesInAllowedRange(Map<String, String> identifierMap) {
        for (String identifier : identifierMap.keySet()) {
            String value = StringUtils.checkNullAndTrim(identifierMap.get(identifier));
            switch (identifier) {
                case "EREF": 
                case "CRED": 
                case "MREF": 
                case "KREF": {
                    if (value.length() > 35) {
                        return false;
                    }
                }
                case "SVWZ": {
                    if (value.length() <= 140) break;
                    return false;
                }
            }
        }
        return true;
    }

    private static void setDataFromSGStructuredPurpose(CmBooking b, Map<String, String> identifierMap) {
        b.setBookingText(StringUtils.shorten(identifierMap.get("BL_BOOKING_TEXT"), 27));
        b.setEndToEndId(StringUtils.shorten(identifierMap.get("BL_END_TO_END_ID"), 35));
        b.setTransactionId(StringUtils.shorten(identifierMap.get("ROC"), 35));
        b.setInstrId(identifierMap.get("IREF"));
        b.setCounterParty(identifierMap.get("BL_COUNTER_PARTY"));
        b.setCounterPartyBankCode(identifierMap.get("BNK:"));
        b.setCounterPartyAccountNumber(identifierMap.get("ACT:"));
        String returnReason = StringUtils.checkNullAndTrim(identifierMap.get("RTRN"));
        if (returnReason.length() > 0) {
            b.setRejectionCauseCode(StringUtils.shorten(returnReason, 4));
            b.setReversal(true);
        }
        boolean hasPositiveAmount = b.getAmount().compareTo(BigDecimal.ZERO) > 0;
        String mandateReference = StringUtils.checkNullAndTrim(identifierMap.get("MARF"));
        String creditorId = StringUtils.checkNullAndTrim(identifierMap.get("CSID"));
        if (mandateReference.length() > 0 || creditorId.length() > 0) {
            if (hasPositiveAmount) {
                if (b.isReversal()) {
                    b.setLocalPartyMandateReference(mandateReference.length() > 0 ? mandateReference : null);
                    b.setCounterPartyCreditorId(creditorId.length() > 0 ? creditorId : null);
                } else {
                    b.setLocalPartyCreditorId(creditorId.length() > 0 ? creditorId : null);
                    b.setCounterPartyMandateReference(mandateReference.length() > 0 ? mandateReference : null);
                }
            } else if (b.isReversal()) {
                b.setLocalPartyCreditorId(creditorId.length() > 0 ? creditorId : null);
                b.setCounterPartyMandateReference(mandateReference.length() > 0 ? mandateReference : null);
            } else {
                b.setLocalPartyMandateReference(mandateReference.length() > 0 ? mandateReference : null);
                b.setCounterPartyCreditorId(creditorId.length() > 0 ? creditorId : null);
            }
            b.setDebit(true);
        }
        b.setPurpose(StringUtils.shorten(identifierMap.get("BL_TOTAL_PURPOSE"), 400));
        b.setPurposeOverview(StringUtils.shorten(identifierMap.get("BL_PURPOSE_OVERVIEW"), 140));
        b.setPurposeCode(StringUtils.shorten(identifierMap.get("PURP"), 35));
        try {
            String exch = identifierMap.get("/EXCH/");
            if (exch != null) {
                b.setExchangeRate(new BigDecimal(identifierMap.get("/EXCH/")));
            }
        }
        catch (Exception exch) {
            // empty catch block
        }
        try {
            String chgs = identifierMap.get("BL_CHGS");
            String chgsCurrency = identifierMap.get("BL_CHGS_CURRENCY");
            if (chgs != null) {
                b.setChargesAmount(new BigDecimal(chgs));
                if (chgsCurrency != null) {
                    b.setChargesCurrency(chgsCurrency);
                } else {
                    b.setChargesCurrency(b.getCurrencyCode());
                }
            }
        }
        catch (Exception chgs) {
            // empty catch block
        }
        try {
            String ocmt = identifierMap.get("BL_OCMT");
            String ocmtCurrency = identifierMap.get("BL_OCMT_CURRENCY");
            if (ocmt != null && ocmtCurrency != null) {
                b.setOriginalAmount(new BigDecimal(ocmt));
                b.setOriginalCurrency(ocmtCurrency);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String[] removeRedundantPurposeLines(String[] purposeLines) {
        if (purposeLines != null && purposeLines.length > 0) {
            ArrayList<String> remainingLines = new ArrayList<String>();
            boolean isOtherKnownIdentifier = false;
            for (String p : purposeLines) {
                if (p == null) continue;
                if (p.length() > 5 && p.charAt(4) == '+') {
                    String s = p.substring(0, 4);
                    if ("SVWZ".equals(s)) {
                        p = p.substring(5);
                        isOtherKnownIdentifier = false;
                    } else {
                        isOtherKnownIdentifier = StringUtils.isContainedInArray(p.substring(0, 4), otherEvaluatedIdentifiers);
                    }
                }
                if (isOtherKnownIdentifier) continue;
                remainingLines.add(p);
            }
            return remainingLines.toArray(new String[0]);
        }
        return purposeLines;
    }

    private File[] splitMixedData(InputStream in) throws IOException {
        File[] toReturn = new File[]{Util.createTempFile("STA-Stuff", ".STA", false), Util.createTempFile("VMK-Stuff", ".VMK", false)};
        boolean staWritten = false;
        boolean vmkWritten = false;
        BufferedWriter sta = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(toReturn[0]), new MT940()));
        BufferedWriter vmk = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(toReturn[1]), new MT940()));
        BufferedReader r = new BufferedReader(new InputStreamReader(in, new MT940()));
        String line = r.readLine();
        String previousLine = null;
        Boolean isSTA = null;
        boolean found13D = false;
        boolean found28C = false;
        boolean found34F = false;
        while (line != null) {
            if (line.equals("-\u00fc")) {
                line = "-";
            } else if (line.startsWith("\u00e41:")) {
                line = "";
            }
            if (line.startsWith(":20:STARTDISP") || line.startsWith(":20:INTRA-DAY")) {
                isSTA = Boolean.FALSE;
                found34F = false;
                found28C = false;
                found13D = false;
                if (previousLine != null && previousLine.startsWith(":")) {
                    vmk.newLine();
                }
            } else if (line.startsWith(":20:")) {
                isSTA = Boolean.TRUE;
                if (previousLine != null && previousLine.startsWith(":")) {
                    sta.newLine();
                }
            }
            if (isSTA != null) {
                if (isSTA.booleanValue()) {
                    sta.write(line);
                    sta.newLine();
                    staWritten = true;
                } else {
                    if (!found28C && line.startsWith(":28C:")) {
                        found28C = true;
                    } else if (!found34F && line.startsWith(":34F:")) {
                        if (!found28C) {
                            vmk.write(":28C:0");
                            vmk.newLine();
                            found28C = true;
                        }
                        found34F = true;
                    } else if (!found13D && (line.startsWith(":13:") || line.startsWith(":13D:"))) {
                        if (!found28C) {
                            vmk.write(":28C:0");
                            vmk.newLine();
                            found28C = true;
                        }
                        if (!found34F) {
                            vmk.write(":34F:EUR0,00");
                            vmk.newLine();
                            found34F = true;
                        }
                        found13D = true;
                    } else if (!(found13D && found28C && found34F || !line.startsWith(":61:"))) {
                        if (!found28C) {
                            vmk.write(":28C:0");
                            vmk.newLine();
                            found28C = true;
                        }
                        if (!found34F) {
                            vmk.write(":34F:EUR0,00");
                            vmk.newLine();
                            found34F = true;
                        }
                        if (!found13D) {
                            vmk.write(":13D:");
                            vmk.write(new SimpleDateFormat("yyMMddHHmmZ").format(new java.util.Date()));
                            vmk.newLine();
                            found13D = true;
                        }
                    }
                    vmk.write(line);
                    vmk.newLine();
                    vmkWritten = true;
                }
            }
            previousLine = line;
            line = r.readLine();
        }
        r.close();
        sta.close();
        vmk.close();
        if (!staWritten) {
            if (!toReturn[0].delete()) {
                toReturn[0].deleteOnExit();
            }
            toReturn[0] = null;
        }
        if (!vmkWritten) {
            if (!toReturn[1].delete()) {
                toReturn[1].deleteOnExit();
            }
            toReturn[1] = null;
        }
        return toReturn;
    }

    public static String transform(String in) {
        if (in == null) {
            return "";
        }
        return SystemUtils.toFilename(in);
    }
}

