/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CMUtil;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.CmCharge;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.task.Substitution;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class EclipseFreeHelper {
    public static boolean enrichWithParent = true;
    @Deprecated
    public static final File MT940_DIRECTORY = new File(Util.WORKSPACEDIR, "mt940");

    public static java.util.Date getValueDate(CmBooking t) {
        CmBooking parent;
        Date valueDate = t.getValueDate();
        if (valueDate == null && enrichWithParent && (parent = t.getParentBooking()) != null) {
            valueDate = parent.getValueDate();
        }
        return valueDate;
    }

    public static java.util.Date getBookingDate(CmBooking t) {
        CmBooking parent;
        Date bookingDate = t.getBookingDate();
        if (bookingDate == null && enrichWithParent && (parent = t.getParentBooking()) != null) {
            bookingDate = parent.getBookingDate();
        }
        return bookingDate;
    }

    public static BigDecimal getChargesAmount(CmBooking t) {
        BigDecimal chargesAmount = t.getChargesAmount();
        if (chargesAmount != null) {
            return chargesAmount;
        }
        List<CmCharge> charges = t.getCharges();
        if (charges != null && charges.size() == 1) {
            return charges.get(0).getAmount();
        }
        return null;
    }

    public static String getChargesCurrencyCode(CmBooking t) {
        String currencyCode = t.getChargesCurrencyCode();
        if (currencyCode != null && currencyCode.trim().length() > 0) {
            return currencyCode.trim();
        }
        List<CmCharge> charges = t.getCharges();
        if (charges != null && charges.size() == 1) {
            return charges.get(0).getCurrencyCode();
        }
        return null;
    }

    public static String getDisplayText(CmStatement stmt, Locale locale) {
        return CMUtil.getDisplayText(stmt, locale);
    }

    public static BigDecimal getBalance(CMAccount account) {
        return EclipseFreeHelper.getClosingBalance(account.getNewestStatement());
    }

    public static String getBalance(CMAccount account, Locale l) {
        BigDecimal d = EclipseFreeHelper.getBalance(account);
        if (d == null) {
            return "";
        }
        return PaymentUtils.formatAmount(d, account.getNewestStatement().getCurrency(), l);
    }

    @Deprecated
    public static BigDecimal getBalance(Account account, CmStatement newestStatement) {
        return EclipseFreeHelper.getClosingBalance(newestStatement);
    }

    public static String getBalance(CmBalance b, boolean balancesWithAdvices, Locale l) {
        BigDecimal d = EclipseFreeHelper.getBalance(b, balancesWithAdvices);
        if (d == null) {
            return "";
        }
        return PaymentUtils.formatAmount(d, Currency.getInstance(b.getAccount().getCurrency()), l);
    }

    public static BigDecimal getBalance(CmBalance b, boolean balancesWithAdvices) {
        return EclipseFreeHelper.getBalance(b, true, balancesWithAdvices);
    }

    public static BigDecimal getBalance(CmBalance b, boolean displayValueBalances, boolean balancesWithAdvices) {
        if (b == null) {
            return null;
        }
        BigDecimal toReturn = null;
        toReturn = displayValueBalances ? (balancesWithAdvices ? b.getValueBalanceWithAdvice() : b.getValueBalance()) : b.getBookingBalance();
        return toReturn;
    }

    public static BigDecimal getClosingBalance(CmStatement statement) {
        if (statement != null) {
            return statement.getClosingBalance();
        }
        return null;
    }

    public static BigDecimal getOpeningBalance(CmStatement statement) {
        if (statement != null) {
            return statement.getOpeningBalance();
        }
        return null;
    }

    public static BigDecimal getSumDebit(CmStatement statement) {
        if (statement != null) {
            return statement.getSumDebit();
        }
        return null;
    }

    public static BigDecimal getSumCredit(CmStatement statement) {
        if (statement != null) {
            return statement.getSumCredit();
        }
        return null;
    }

    public static BigDecimal getOpeningBalance(CmPage page) {
        if (page != null) {
            return page.getOpeningBalance();
        }
        return null;
    }

    public static BigDecimal getSumDebit(CmPage page) {
        if (page != null) {
            return page.getSumDebit();
        }
        return null;
    }

    public static BigDecimal getSumCredit(CmPage page) {
        if (page != null) {
            return page.getSumCredit();
        }
        return null;
    }

    public static String getCreditLimit(CMAccount a, Locale l) {
        BigDecimal creditLimit = a.getAccount().getCreditLimit();
        CmStatement stmt = a.getNewestStatement();
        if (creditLimit != null && stmt != null && stmt.getClosingBalance() != null) {
            return PaymentUtils.formatAmount(creditLimit, stmt.getCurrency(), l);
        }
        return "";
    }

    public static String getFreeLiquidity(CMAccount a, Locale l) {
        BigDecimal freeLiquidity = a.getFreeLiquidity();
        if (freeLiquidity != null && a.getNewestStatement() != null) {
            return PaymentUtils.formatAmount(freeLiquidity, a.getNewestStatement().getCurrency(), l);
        }
        return "";
    }

    public static File getDirectory(BankSettings bank) {
        return new File(WorkspaceFileSystem.CM_DIRECTORY, bank.getUniqueKey());
    }

    public static File getDTIDirectory(BankSettings bank) {
        return new File(WorkspaceFileSystem.DTI_DIRECTORY, bank.getUniqueKey());
    }

    public static String getDisplayText(CmPage page, Locale locale) {
        return CMUtil.getDisplayText(page, locale);
    }

    public static String getBookingTypeText(CmBookingFilter.BookingType bookingType, Locale locale) {
        return BankingApiMessages.getString(locale, "GeneralMessages.booking.type." + bookingType.name(), new Object[0]);
    }

    public static String getBookingDirectionText(CmBookingFilter.BookingDirection bookingDirection, Locale locale) {
        switch (bookingDirection) {
            case INCOMING: {
                return Messages.getString(locale, "BookingFilter.bookingDirection.incoming", new Object[0]);
            }
            case OUTGOING: {
                return Messages.getString(locale, "BookingFilter.bookingDirection.outgoing", new Object[0]);
            }
        }
        return Messages.getString(locale, "BookingFilter.bookingDirection.all", new Object[0]);
    }

    public static Locale getAutomaticExportLanguage(DatabasePreferenceStore preferences) {
        String language = preferences.getString(CmPreferenceConstants.AUTOMATIC_EXPORT_LANGUAGE);
        if (!"default".equals(language)) {
            if ("de".equals(language)) {
                return Locale.GERMAN;
            }
            if ("en".equals(language)) {
                return Locale.ENGLISH;
            }
            if ("fr".equals(language)) {
                return Locale.FRENCH;
            }
            return new Locale(language);
        }
        return Locale.getDefault();
    }

    public static Substitution getExampleSubstitionForC54Export() {
        Substitution s = new Substitution(new java.util.Date());
        s.addPlaceHolder("BANK", "Business-Logics Testbank");
        s.addPlaceHolder("ACCOUNT", "Testkonto");
        s.addPlaceHolder("IBAN", "DE87 1234 5678 1234 5678 90");
        s.addPlaceHolder("CURRENCY", "EUR");
        s.addPlaceHolder("FILENAME", String.format("%s_C54_DE87123456781234567890_EUR_000001.xml", new SimpleDateFormat("yyyy-mm-dd").format(new java.util.Date())));
        return s;
    }
}

