/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.transfer.api.PreScheduler;
import de.businesslogics.bcs.core.YYMMDD;
import java.util.HashSet;
import java.util.Set;

public class DtiPreScheduler
implements PreScheduler {
    @Override
    public Set<String> getOrderOrFileTypes(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        HashSet<String> result = new HashSet<String>();
        if (cmBank.isC54FetchActivated()) {
            result.add(cmBank.getC54FetchType());
        }
        return result;
    }

    @Override
    public YYMMDD getFromDate(Scheduler s) {
        CMBank cmBank = CMBank.get(s.getBank());
        if (CmBank.FetchMode.NEW.equals((Object)cmBank.getC54FetchMode())) {
            return null;
        }
        if (cmBank.getC54FetchMode() != null) {
            return new YYMMDD(cmBank.getLastC54FetchDate().getTime());
        }
        return new YYMMDD(System.currentTimeMillis() - 86400000L);
    }

    @Override
    public YYMMDD getToDate(Scheduler s) {
        return null;
    }

    @Override
    public void setLastFetchDate(Scheduler s, YYMMDD date) {
        CMBank cmBank = CMBank.get(s.getBank());
        cmBank.setLastC54FetchDate(date);
        cmBank.save();
    }
}

