/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.BaseDtaProcessing;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.CmReporterApi;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.format.dta.DTAUSExtractor;
import de.businesslogics.format.dta.DTAUSItem;
import de.businesslogics.format.dta.DTAUSLogicalFile;
import de.businesslogics.format.dta.DTAUSWriter;
import de.businesslogics.format.dta.InvalidFileException;
import de.businesslogics.format.dta.MCVConverter;
import de.businesslogics.format.dta.McvExtractor;
import de.businesslogics.io.Streams;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class DTIProcessingApi
extends BaseDtaProcessing
implements DTAUSExtractor.DTAUSListener {
    public static final String DTI = "DTI";
    private DTAUSWriter dtaw;
    private final List<DTAUSItem> items = new ArrayList<DTAUSItem>();
    private final List<StatementBookingReportHandler> reportHandlers;

    public DTIProcessingApi(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(logger, encrypt, preferences);
        this.reportHandlers = reportHandlers;
    }

    public DTIProcessingApi(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(bank, reporter, DTI, logger, encrypt, preferences);
        this.reportHandlers = reportHandlers;
    }

    public DTIProcessingApi(BankSettings bank, CmReporter reporter, String orderType, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(bank, reporter, orderType, logger, encrypt, preferences);
        this.reportHandlers = reportHandlers;
    }

    @Override
    protected OutputStream getExtractor() {
        if (DTI.equals(this.orderType)) {
            return new DTAUSExtractor(this);
        }
        return new McvExtractor(this);
    }

    @Override
    public void startLogicalFile(DTAUSLogicalFile logicalFile) {
        this.dtaw = null;
        this.items.clear();
        if (this.existingFile == null) {
            try {
                this.dtaw = new DTAUSWriter(this.getTempOutputStream());
                this.dtaw.startLogicalFile(logicalFile);
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
    }

    @Override
    public void handleItem(DTAUSItem i) {
        this.items.add(i);
        if (this.dtaw != null) {
            try {
                this.dtaw.write(i);
            }
            catch (Exception io) {
                this.setException(io);
            }
        }
    }

    @Override
    public void consumeError(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    @Override
    public void handleWarning(InvalidFileException ife) throws InvalidFileException {
        throw ife;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public void endLogicalFile(DTAUSLogicalFile logicalFile) {
        if (this.dtaw != null) {
            try {
                this.dtaw.closeLogicalFile();
                this.dtaw.close();
            }
            catch (Exception e) {
                this.setException(e);
            }
        }
        this.processLogicalFile(logicalFile);
    }

    @Override
    protected String getReferenceNumber(DTAUSLogicalFile logicalFile) {
        long referenceNumber = logicalFile.getReference();
        if (referenceNumber > 0L) {
            return String.valueOf(referenceNumber);
        }
        return String.valueOf(logicalFile.getFileNumber());
    }

    private BookingStatistics calculateStatistics(boolean isCreditFile, List<DTAUSItem> items) {
        BookingStatistics statistics = new BookingStatistics();
        for (DTAUSItem item : items) {
            BigDecimal amount = BigDecimal.valueOf(item.getAmount(), 2);
            if (!isCreditFile) {
                amount = amount.negate();
            }
            statistics.addBooking(amount);
        }
        return statistics;
    }

    @Override
    protected void processBookings(CmStatement s, DTAUSLogicalFile lf) {
        boolean isCreditFile = lf.isCredit();
        List<CmBooking> possibleParentBookings = CMProcessingDb.findParentBookings(s, s.getReference1(), this.preferences, this.logger);
        CmBooking parentBooking = null;
        ArrayList<CmBooking> parentBookings = null;
        BookingStatistics statistics = this.calculateStatistics(isCreditFile, this.items);
        statistics.storeStatistics(s);
        if (possibleParentBookings != null && (parentBooking = CMProcessingDb.findParentBooking(possibleParentBookings, s.getTotalSum(), s.getCreationDate(), this.preferences)) == null) {
            parentBookings = new ArrayList<CmBooking>();
        }
        int pos = 0;
        for (DTAUSItem item : this.items) {
            CmBooking b;
            if ((b = DTIProcessingApi.findBooking(s, null, ++pos)) == null) {
                b = new CmBooking();
                b.setPos(pos);
            }
            b.setCollective(false);
            b.setAccount(this.latestAccount);
            b.setStatement(s);
            b.setBookingDate(new Date(s.getCreationDate().getTime()));
            BigDecimal amount = BigDecimal.valueOf(item.getAmount(), 2);
            if (!isCreditFile) {
                amount = amount.negate();
            }
            b.setAmount(amount);
            b.setCurrency(EURO);
            b.setDebit(!isCreditFile);
            b.setLocalParty(StringUtils.getStringFromStringArray(item.getRecipient()));
            b.setLocalPartyBankCode(String.valueOf(item.getRecipientBankcode()));
            b.setLocalPartyAccountNumber(String.valueOf(item.getRecipientAccount()));
            b.setCounterParty(StringUtils.getStringFromStringArray(item.getCustomer()));
            b.setCounterPartyBankCode(String.valueOf(item.getOriginatorBankcode()));
            b.setCounterPartyAccountNumber(String.valueOf(item.getOriginatorAccount()));
            b.setPurpose(StringUtils.getStringFromStringArray(item.getPurpose(), "\n"));
            b.setPurposeOverview(b.getFirstLine(b.getPurpose()));
            if (parentBooking != null) {
                b.setParentBooking(parentBooking);
            } else if (parentBookings != null) {
                CmBooking parentBookingForSingle = CMProcessingDb.findParentBooking(possibleParentBookings, b.getAmount(), s.getCreationDate(), this.preferences);
                if (parentBookingForSingle != null) {
                    b.setParentBooking(parentBookingForSingle);
                    parentBookings.add(parentBookingForSingle);
                } else {
                    b.setParentBooking(null);
                }
            } else {
                b.setParentBooking(null);
            }
            if (b.getId() == null) {
                DB.save(b);
                continue;
            }
            DB.update(b);
        }
        if (parentBooking != null) {
            parentBooking.setCollective(true);
            DB.update(parentBooking);
        } else if (parentBookings != null) {
            for (CmBooking booking : parentBookings) {
                booking.setCollective(true);
                DB.update(booking);
            }
        }
        DTIProcessingApi.deleteHigherPositionedBookings(s, null, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void convertFiles() {
        if (this.targetFileMap != null && this.targetFileMap.keySet().size() > 0) {
            String fileExtension = DTI.equals(this.orderType) ? ".CONVERTED_MCV" : ".ORIGINAL";
            for (File dtiFile : this.targetFileMap.keySet()) {
                OutputStream out = null;
                InputStream in = null;
                try {
                    File mcvFile = new File(dtiFile.getParentFile(), dtiFile.getName() + fileExtension);
                    out = this.encrypt.openOutputStream(mcvFile);
                    in = this.encrypt.openInputStream(dtiFile);
                    MCVConverter converter = new MCVConverter(4, out);
                    DTAUSExtractor e = new DTAUSExtractor(converter);
                    Streams.copy(in, e);
                    if (!DTI.equals(this.orderType)) {
                        WorkspaceFile file = ((CmStatement)this.targetFileMap.get(dtiFile)).getFile();
                        String fileName = file.getPath();
                        file.setPath(fileName + ".ORIGINAL");
                        DB.update(file);
                    }
                    SystemUtils.close(in);
                }
                catch (Exception e) {
                    this.logger.logError("Exception while converting " + dtiFile.getAbsolutePath() + " to packed EBCDIC", e);
                    continue;
                }
                finally {
                    SystemUtils.close(in);
                    SystemUtils.close(out);
                    continue;
                }
                SystemUtils.close(out);
            }
        }
    }

    @Override
    protected CmReporter getReporter(String orderType) {
        return new CmReporterApi(CmReporter.Mode.FETCH_DTI, orderType, this.logger, this.encrypt, this.preferences.getUser(), this.reportHandlers);
    }
}

