/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.StatementsPeriodProvider;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import io.ebean.PagedList;
import io.ebean.Query;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class Converter
implements Closeable {
    private final Conversion vo;
    private final DatabasePreferenceStore store;
    private final Locale locale;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private final boolean doAppendLastSeparator = false;
    private final List<Conversion.Field> fieldsWithoutTextSeparator = null;
    private final PrintStream w;
    private final boolean mergeSheets;
    private final boolean exportSingleBookings;
    private final boolean exportSingleBookingsFromOtherStatements;

    private static PrintStream getPrintStream(File exportFile, boolean doAppend) throws FileNotFoundException {
        return new PrintStream(new FileOutputStream(exportFile, doAppend), false);
    }

    public Converter(Conversion vo, File exportFile, boolean append, DatabasePreferenceStore store, Locale locale) throws FileNotFoundException {
        this.vo = vo;
        this.store = store;
        this.locale = locale;
        String nf = vo.getNumberFormat();
        if (nf == null || nf.length() == 0) {
            this.numberFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(locale));
        } else {
            try {
                this.numberFormat = new DecimalFormat(nf, DecimalFormatSymbols.getInstance(locale));
            }
            catch (IllegalArgumentException invalidPattern) {
                this.numberFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(locale));
            }
        }
        String df = vo.getDateFormat();
        if (df == null || df.length() == 0) {
            this.dateFormat = DateFormat.getDateInstance(2, locale);
        } else {
            try {
                this.dateFormat = new SimpleDateFormat(df);
            }
            catch (IllegalArgumentException invalidPattern) {
                this.dateFormat = DateFormat.getDateInstance(2, locale);
            }
        }
        this.w = Converter.getPrintStream(exportFile, append);
        if (vo.isIncludeHeader() && (!append || exportFile.length() == 0L)) {
            this.w.println(this.getHeader());
        }
        this.mergeSheets = store.getBoolean(CmPreferenceConstants.MERGE_SHEETS_IN_STATEMENT_CONVERSION);
        this.exportSingleBookings = store.getBoolean(CmPreferenceConstants.EXPORT_SINGLE_BOOKINGS);
        this.exportSingleBookingsFromOtherStatements = store.getBoolean(CmPreferenceConstants.EXPORT_SINGLE_BOOKINGS_FROM_OTHER_STATEMENTS);
    }

    private String convertStatement(CmStatement statement) {
        StringBuffer sb = new StringBuffer(256);
        if (this.vo.getTextSeparator() != null && this.vo.getTextSeparator().length() > 0) {
            Iterator<Conversion.Field> i = this.vo.getFieldsAsList().iterator();
            while (i.hasNext()) {
                Conversion.Field field = i.next();
                if (this.addTextSeparator(field)) {
                    sb.append(this.vo.getTextSeparator());
                    this.appendStatementField(sb, field, statement);
                    sb.append(this.vo.getTextSeparator());
                } else {
                    this.appendStatementField(sb, field, statement);
                }
                if (!i.hasNext()) continue;
                sb.append(this.vo.getFieldSeparator());
            }
        } else {
            Iterator<Conversion.Field> i = this.vo.getFieldsAsList().iterator();
            while (i.hasNext()) {
                this.appendStatementField(sb, i.next(), statement);
                if (!i.hasNext()) continue;
                sb.append(this.vo.getFieldSeparator());
            }
        }
        return sb.toString();
    }

    private String convertPage(CmPage page) {
        StringBuffer sb = new StringBuffer(256);
        if (this.vo.getTextSeparator() != null && this.vo.getTextSeparator().length() > 0) {
            Iterator<Conversion.Field> i = this.vo.getFieldsAsList().iterator();
            while (i.hasNext()) {
                Conversion.Field field = i.next();
                if (this.addTextSeparator(field)) {
                    sb.append(this.vo.getTextSeparator());
                    this.appendStatementField(sb, field, page);
                    sb.append(this.vo.getTextSeparator());
                } else {
                    this.appendStatementField(sb, field, page);
                }
                if (!i.hasNext()) continue;
                sb.append(this.vo.getFieldSeparator());
            }
        } else {
            Iterator<Conversion.Field> i = this.vo.getFieldsAsList().iterator();
            while (i.hasNext()) {
                this.appendStatementField(sb, i.next(), page);
                if (!i.hasNext()) continue;
                sb.append(this.vo.getFieldSeparator());
            }
        }
        return sb.toString();
    }

    public void convert(CmStatement statement) {
        switch (this.vo.getType()) {
            case StatementType: 
            case StatementTypeCFONB120: {
                if (this.mergeSheets || CmStatement.Type.CFONB120.name().equals(statement.getFormatName())) {
                    this.w.println(this.convertStatement(statement));
                    break;
                }
                List<CmPage> pages = CmPage.findByStatement(statement, false);
                if (pages.isEmpty()) {
                    this.w.println(this.convertStatement(statement));
                    break;
                }
                for (CmPage p : pages) {
                    this.w.println(this.convertPage(p));
                }
                break;
            }
            case BookingType: 
            case BookingTypeCFONB120: {
                this.addBookings(CmBooking.findByStatement(statement, CmBooking.BookingSorting.UNMODIFIED, true));
            }
        }
    }

    public int convert(CMAccount account, StatementsPeriodProvider periodProvider) {
        PagedList<CmStatement> list;
        int page = 0;
        int countConverted = 0;
        do {
            list = CmStatement.findStatements(account.getAccount(), page++, 100, true, periodProvider.getStatementsPeriodStartDate(), periodProvider.getStatementsPeriodEndDate());
            for (CmStatement stmt : list.getList()) {
                this.convert(stmt);
                ++countConverted;
            }
        } while (list.hasNext());
        return countConverted;
    }

    public static int getCountStatementsToConvert(List<CMAccount> accounts, Date fromDate, Date toDate) {
        int countStatements = 0;
        for (CMAccount account : accounts) {
            countStatements += CmStatement.findCountStatements(account.getAccount(), fromDate, toDate);
        }
        return countStatements;
    }

    public void convert(CmPage page) {
        switch (this.vo.getType()) {
            case StatementType: 
            case StatementTypeCFONB120: {
                this.w.println(this.convertPage(page));
                break;
            }
            case BookingType: 
            case BookingTypeCFONB120: {
                this.addBookings(CmBooking.findByPage(page, CmBooking.BookingSorting.UNMODIFIED));
            }
        }
    }

    public void convert(CmBooking booking) {
        this.w.println(this.convertBooking(booking.getStatement(), booking.getPage(), booking));
    }

    private void addBookings(Query<CmBooking> query) {
        query.findEach(booking -> {
            CmBooking parent = booking.getParentBooking();
            if (parent != null && ((Object)parent.getStatement()).equals(booking.getStatement())) {
                return;
            }
            if (this.exportSingleBookings && booking.isCollective()) {
                List<CmBooking> singleBookings;
                List<CmBooking> list = singleBookings = this.exportSingleBookingsFromOtherStatements ? CmBooking.findSingleBookings(booking, true) : CmBooking.findSingleBookingsInSameStatement(booking, true);
                if (singleBookings.size() > 0) {
                    for (CmBooking singleBooking : singleBookings) {
                        this.w.println(this.convertBooking(booking.getStatement(), booking.getPage(), singleBooking));
                    }
                    return;
                }
            }
            this.w.println(this.convertBooking(booking.getStatement(), booking.getPage(), (CmBooking)booking));
        });
    }

    private String convertBooking(CmStatement statement, CmPage page, CmBooking booking) {
        StringBuffer sb = new StringBuffer(256);
        if (this.vo.getTextSeparator() != null && this.vo.getTextSeparator().length() > 0) {
            Iterator<Conversion.Field> iterator = this.vo.getFieldsAsList().iterator();
            while (iterator.hasNext()) {
                Conversion.Field field = iterator.next();
                if (this.addTextSeparator(field)) {
                    sb.append(this.vo.getTextSeparator());
                    this.appendBookingField(sb, field, statement, page, booking);
                    sb.append(this.vo.getTextSeparator());
                } else {
                    this.appendBookingField(sb, field, statement, page, booking);
                }
                if (!iterator.hasNext()) continue;
                sb.append(this.vo.getFieldSeparator());
            }
        } else {
            Iterator<Conversion.Field> iterator = this.vo.getFieldsAsList().iterator();
            while (iterator.hasNext()) {
                this.appendBookingField(sb, iterator.next(), statement, page, booking);
                if (!iterator.hasNext()) continue;
                sb.append(this.vo.getFieldSeparator());
            }
        }
        return sb.toString();
    }

    private String getHeader() {
        StringBuilder sb = new StringBuilder(256);
        Iterator<Conversion.Field> i = this.vo.getFieldsAsList().iterator();
        while (i.hasNext()) {
            Conversion.Field field = i.next();
            sb.append(Converter.getFieldName(field, this.locale));
            if (!i.hasNext()) continue;
            sb.append(this.vo.getFieldSeparator());
        }
        return sb.toString();
    }

    public static String getFieldName(Conversion.Field field, Locale locale) {
        switch (field) {
            case EMPTY: {
                return Messages.getString(locale, "Conversion.emptyField", new Object[0]);
            }
            case STATEMENT_FORMAT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.format", new Object[0]);
            }
            case STATEMENT_BANK_NAME: {
                return BankingApiMessages.getString(locale, "GeneralMessages.bankName", new Object[0]);
            }
            case STATEMENT_ACCOUNT_NAME: {
                return Messages.getString(locale, "Conversion.statementField.accountName", new Object[0]);
            }
            case STATEMENT_ACCOUNT_IDENTIFIER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]);
            }
            case STATEMENT_ACCOUNT_HOLDER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.accountOwner", new Object[0]);
            }
            case STATEMENT_BANK_CODE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.bankleitzahl", new Object[0]);
            }
            case STATEMENT_IBAN: {
                return BankingApiMessages.getString(locale, "GeneralMessages.iban", new Object[0]);
            }
            case STATEMENT_BIC: {
                return BankingApiMessages.getString(locale, "GeneralMessages.bic", new Object[0]);
            }
            case STATEMENT_BRANCH_CODE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.branchCode", new Object[0]);
            }
            case STATEMENT_RIB: {
                return BankingApiMessages.getString(locale, "GeneralMessages.rib", new Object[0]);
            }
            case STATEMENT_ACCOUNT_NUMBER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.accountNumber", new Object[0]);
            }
            case STATEMENT_CURRENCY: {
                return BankingApiMessages.getString(locale, "GeneralMessages.currency", new Object[0]);
            }
            case STATEMENT_DATE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.date", new Object[0]);
            }
            case STATEMENT_BALANCE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.balance", new Object[0]);
            }
            case STATEMENT_OPENING_DATE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.openingDate", new Object[0]);
            }
            case STATEMENT_OPENING_BALANCE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.openingBalance", new Object[0]);
            }
            case STATEMENT_NUMBER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.statementNumber", new Object[0]);
            }
            case STATEMENT_LEGAL_NUMBER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.legalNumber", new Object[0]);
            }
            case STATEMENT_SUB_NUMBER: {
                return Messages.getString(locale, "Conversion.statementField.subNumber", new Object[0]);
            }
            case STATEMENT_NUMBER_WITH_SUB_NUMBER: {
                return Messages.getString(locale, "Conversion.statementField.numberWithSubNumber", new Object[0]);
            }
            case STATEMENT_COUNT_BOOKINGS: {
                return BankingApiMessages.getString(locale, "GeneralMessages.countBookings", new Object[0]);
            }
            case STATEMENT_SUM_CREDITS: {
                return BankingApiMessages.getString(locale, "GeneralMessages.sumCredits", new Object[0]);
            }
            case STATEMENT_SUM_DEBITS: {
                return BankingApiMessages.getString(locale, "GeneralMessages.sumDebits", new Object[0]);
            }
            case STATEMENT_COUNT_CREDITS: {
                return BankingApiMessages.getString(locale, "GeneralMessages.stmt.countCredits", new Object[0]);
            }
            case STATEMENT_COUNT_DEBITS: {
                return BankingApiMessages.getString(locale, "GeneralMessages.stmt.countDebits", new Object[0]);
            }
            case STATEMENT_HIGHEST_CREDIT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.stmt.highestCredit", new Object[0]);
            }
            case STATEMENT_SMALLEST_CREDIT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.stmt.smallestCredit", new Object[0]);
            }
            case STATEMENT_HIGHEST_DEBIT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.stmt.highestDebit", new Object[0]);
            }
            case STATEMENT_SMALLEST_DEBIT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.stmt.smallestDebit", new Object[0]);
            }
            case STATEMENT_REFERENCE_1: {
                return BankingApiMessages.getString(locale, "GeneralMessages.messageId", new Object[0]);
            }
            case STATEMENT_REFERENCE_2: {
                return BankingApiMessages.getString(locale, "GeneralMessages.reference", new Object[0]);
            }
            case BOOKING_AMOUNT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]);
            }
            case BOOKING_ABSOLUTE_AMOUNT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.absoluteAmount", new Object[0]);
            }
            case BOOKING_AMOUNT_SIGN_FLAG: {
                return BankingApiMessages.getString(locale, "GeneralMessages.amountSignFlag", new Object[0]);
            }
            case BOOKING_VALUE_DATE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.valueDate", new Object[0]);
            }
            case BOOKING_BOOKING_DATE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.bookingDate2", new Object[0]);
            }
            case BOOKING_PURPOSE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose1", new Object[0]);
            }
            case BOOKING_TOTAL_PURPOSE: {
                return Messages.getString(locale, "Conversion.bookingField.totalPurpose", new Object[0]);
            }
            case BOOKING_REVERSAL: {
                return Messages.getString(locale, "Conversion.bookingField.reversal", new Object[0]);
            }
            case BOOKING_ORIGINAL_AMOUNT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.originalAmount2", new Object[0]);
            }
            case BOOKING_ORIGINAL_CURRENCY: {
                return Messages.getString(locale, "Conversion.bookingField.originalCurrency", new Object[0]);
            }
            case BOOKING_CHARGES_AMOUNT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.chargesAmount", new Object[0]);
            }
            case BOOKING_CHARGES_CURRENCY: {
                return Messages.getString(locale, "Conversion.bookingField.chargesCurrency", new Object[0]);
            }
            case BOOKING_LOCALPARTY: {
                return BankingApiMessages.getString(locale, "GeneralMessages.originator", new Object[0]);
            }
            case BOOKING_LOCALPARTY_BANK_CODE: {
                return Messages.getString(locale, "BookingDetailsView.origBankcode", new Object[0]);
            }
            case BOOKING_LOCALPARTY_BRANCH_CODE: {
                return Messages.getString(locale, "Conversion.bookingField.origBranchCode", new Object[0]);
            }
            case BOOKING_LOCALPARTY_ACCOUNT_NUMBER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.originatorAccountNumber", new Object[0]);
            }
            case BOOKING_LOCALPARTY_RIB: {
                return Messages.getString(locale, "Conversion.bookingField.origRIB", new Object[0]);
            }
            case BOOKING_COUNTERPARTY: {
                return BankingApiMessages.getString(locale, "GeneralMessages.recipient", new Object[0]);
            }
            case BOOKING_COUNTERPARTY_BANK_CODE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.recipBankCode", new Object[0]);
            }
            case BOOKING_COUNTERPARTY_BRANCH_CODE: {
                return Messages.getString(locale, "Conversion.bookingField.recipBranchCode", new Object[0]);
            }
            case BOOKING_COUNTERPARTY_ACCOUNT_NUMBER: {
                return BankingApiMessages.getString(locale, "GeneralMessages.recipientAccountNumber", new Object[0]);
            }
            case BOOKING_COUNTERPARTY_RIB: {
                return Messages.getString(locale, "Conversion.bookingField.recipRIB", new Object[0]);
            }
            case BOOKING_TRANSACTION_CODE: {
                return BankingApiMessages.getString(locale, "CFONB120.bnpParibasTransactionCode", new Object[0]);
            }
            case MT94X_BOOKING_BOOKING_KEY: {
                return BankingApiMessages.getString(locale, "GeneralMessages.booking.type.BOOKING_KEY", new Object[0]);
            }
            case MT94X_BOOKING_CUSTOMER_REFERENCE: {
                return Messages.getString(locale, "BookingDetailsView.customerReference", new Object[0]);
            }
            case MT94X_BOOKING_BANK_REFERENCE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.bankReference", new Object[0]);
            }
            case MT94X_BOOKING_ADDITIONAL_INFO: {
                return BankingApiMessages.getString(locale, "GeneralMessages.furtherInformation", new Object[0]);
            }
            case MT94X_BOOKING_FIELD_END_TO_END_ID: {
                return GeneralMessages.getInstance((Locale)locale).END_TO_END_REFERENCE;
            }
            case MT94X_BOOKING_FIELD_MANDATE_REFERENCE: {
                return GeneralMessages.getInstance((Locale)locale).MANDATE_REFERENCE;
            }
            case MT94X_BOOKING_FIELD_CREDITOR_ID: {
                return GeneralMessages.getInstance((Locale)locale).CREDITOR_ID;
            }
            case MT94X_BOOKING_GVC: {
                return BankingApiMessages.getString(locale, "GeneralMessages.booking.type.GVC", new Object[0]);
            }
            case MT94X_BOOKING_BOOKING_TEXT: {
                return BankingApiMessages.getString(locale, "GeneralMessages.bookingText", new Object[0]);
            }
            case MT94X_BOOKING_PRIMANOTA: {
                return BankingApiMessages.getString(locale, "GeneralMessages.primanota", new Object[0]);
            }
            case MT94X_BOOKING_TEXT_KEY_APPENDIX: {
                return BankingApiMessages.getString(locale, "GeneralMessages.textKeyAppendix", new Object[0]);
            }
            case BOOKING_ORIG_RECIP_1: {
                return Messages.getString(locale, "Conversion.bookingField.origRecipName1", new Object[0]);
            }
            case BOOKING_ORIG_RECIP_2: {
                return Messages.getString(locale, "Conversion.bookingField.origRecipName2", new Object[0]);
            }
            case BOOKING_PURPOSE_2: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose2", new Object[0]);
            }
            case BOOKING_PURPOSE_3: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose3", new Object[0]);
            }
            case BOOKING_PURPOSE_4: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose4", new Object[0]);
            }
            case BOOKING_PURPOSE_5: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose5", new Object[0]);
            }
            case BOOKING_PURPOSE_6: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose6", new Object[0]);
            }
            case BOOKING_PURPOSE_7: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose7", new Object[0]);
            }
            case BOOKING_PURPOSE_8: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose8", new Object[0]);
            }
            case BOOKING_PURPOSE_9: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose9", new Object[0]);
            }
            case BOOKING_PURPOSE_10: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose10", new Object[0]);
            }
            case BOOKING_PURPOSE_11: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose11", new Object[0]);
            }
            case BOOKING_PURPOSE_12: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose12", new Object[0]);
            }
            case BOOKING_PURPOSE_13: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose13", new Object[0]);
            }
            case BOOKING_PURPOSE_14: {
                return BankingApiMessages.getString(locale, "GeneralMessages.purpose14", new Object[0]);
            }
            case BOOKING_UNIQUE_ID: {
                return Messages.getString(locale, "Conversion.bookingField.uniqueId", new Object[0]);
            }
            case BOOKING_FEE_TYPE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.chargingScheme", new Object[0]);
            }
            case BOOKING_TRX_ID: {
                return BankingApiMessages.getString(locale, "GeneralMessages.transactionId", new Object[0]);
            }
            case BOOKING_PURPOSE_CODE: {
                return Messages.getString(locale, "BookingDetailsView.purposeCode", new Object[0]);
            }
            case BOOKING_CURRENT_BALANCE: {
                return BankingApiMessages.getString(locale, "GeneralMessages.currentBalance", new Object[0]);
            }
            case CFONB_BOOKING_BNP_PARIBAS_TRANSACTION_CODE: {
                return BankingApiMessages.getString(locale, "CFONB120.bnpParibasTransactionCode", new Object[0]);
            }
            case CFONB_BOOKING_INTERBANK_TRANSACTION_CODE: {
                return BankingApiMessages.getString(locale, "CFONB120.interbankTransactionCode", new Object[0]);
            }
            case CFONB_BOOKING_REJECTION_CAUSE_CODE: {
                return BankingApiMessages.getString(locale, "CFONB120.rejectionCauseCode", new Object[0]);
            }
            case CFONB_BOOKING_ENTRY_NUMBER: {
                return BankingApiMessages.getString(locale, "CFONB120.entryNumber", new Object[0]);
            }
            case CFONB_BOOKING_EXEMPTION: {
                return BankingApiMessages.getString(locale, "CFONB120.exemption", new Object[0]);
            }
            case CFONB_BOOKING_UNAVAILABILITY_RATING: {
                return BankingApiMessages.getString(locale, "CFONB120.unavailabilityRating", new Object[0]);
            }
        }
        return "";
    }

    private boolean addTextSeparator(Conversion.Field field) {
        if (this.fieldsWithoutTextSeparator != null) {
            for (Conversion.Field fieldWithoutTextSeparator : this.fieldsWithoutTextSeparator) {
                if (!fieldWithoutTextSeparator.equals((Object)field)) continue;
                return false;
            }
        }
        return true;
    }

    private void appendStatementField(StringBuffer sb, Conversion.Field field, CmStatement statement) {
        if (field.getId() > Conversion.Field.EMPTY.getId()) {
            sb.append(this.getField(field, statement, null, null));
        }
    }

    private void appendStatementField(StringBuffer sb, Conversion.Field field, CmPage page) {
        if (field.getId() > Conversion.Field.EMPTY.getId()) {
            sb.append(this.getField(field, page.getStatement(), page, null));
        }
    }

    private void appendBookingField(StringBuffer sb, Conversion.Field field, CmStatement statement, CmPage page, CmBooking booking) {
        if (!Conversion.Field.EMPTY.equals((Object)field)) {
            sb.append(this.getField(field, statement, page, booking));
        }
    }

    private boolean usePositveDebits() {
        return this.store.getBoolean(CmPreferenceConstants.CONVERSION_USE_POSITIVE_DEBITS);
    }

    private String getField(Conversion.Field field, CmStatement statement, CmPage page, CmBooking booking) {
        switch (field) {
            case EMPTY: {
                return "";
            }
            case STATEMENT_FORMAT: {
                return this.formatString(statement.getFormatName());
            }
            case STATEMENT_BANK_NAME: {
                return this.formatString(statement.getAccount().getBank().getDisplayName());
            }
            case STATEMENT_ACCOUNT_NAME: {
                return this.formatString(Account.getDefaultDisplayName(statement.getAccount()));
            }
            case STATEMENT_ACCOUNT_IDENTIFIER: {
                Account a = statement.getAccount();
                String s = a.getCmIdentification();
                if (s != null && s.length() > 0) {
                    return s;
                }
                s = a.getGermanAccountIdentifier();
                if (s != null && s.length() > 0) {
                    return a.getGermanBankCode() + "/" + a.getGermanAccountNumber();
                }
                s = a.getFrenchAccountIdentifier();
                if (s != null && s.length() > 0) {
                    return a.getFrenchBankCode() + "/" + a.getFrenchBranchCode() + "/" + a.getFrenchAccountNumber();
                }
                return a.getIban();
            }
            case STATEMENT_ACCOUNT_HOLDER: {
                return this.formatString(statement.getAccount().getAccountHolder());
            }
            case STATEMENT_BANK_CODE: {
                String bc = statement.getAccount().getGermanBankCode();
                if (bc == null && statement.getAccount().getIban() != null) {
                    bc = IbanUtil.getBankCode(statement.getAccount().getIban());
                }
                return this.formatString(bc);
            }
            case STATEMENT_BRANCH_CODE: {
                return this.formatString(statement.getAccount().getFrenchBranchCode());
            }
            case STATEMENT_RIB: {
                return this.formatString(statement.getAccount().getFrenchCheckCode());
            }
            case STATEMENT_ACCOUNT_NUMBER: {
                String s2 = statement.getAccount().getGermanAccountNumber();
                if (s2 == null && statement.getAccount().getIban() != null && (s2 = IbanUtil.getAccountNumber(statement.getAccount().getIban())) == null) {
                    s2 = statement.getAccount().getIban();
                }
                return this.formatString(s2);
            }
            case STATEMENT_IBAN: {
                return this.formatString(statement.getAccount().getIban());
            }
            case STATEMENT_BIC: {
                return this.formatString(statement.getAccount().getBic());
            }
            case STATEMENT_CURRENCY: {
                return this.formatCurrency(statement.getCurrency());
            }
            case STATEMENT_DATE: {
                return this.formatDate(statement.getClosingDate());
            }
            case STATEMENT_BALANCE: {
                if (page != null) {
                    return this.formatAmount(page.getClosingBalance());
                }
                return this.formatAmount(statement.getClosingBalance());
            }
            case STATEMENT_OPENING_DATE: {
                if (page != null) {
                    return this.formatDate(page.getOpeningDate());
                }
                return this.formatDate(statement.getOpeningDate());
            }
            case STATEMENT_OPENING_BALANCE: {
                if (page != null) {
                    return this.formatAmount(page.getOpeningBalance());
                }
                return this.formatAmount(statement.getOpeningBalance());
            }
            case STATEMENT_NUMBER: {
                return this.formatString(statement.getStatementNumber());
            }
            case STATEMENT_LEGAL_NUMBER: {
                return this.formatString(statement.getLegalNumber());
            }
            case STATEMENT_SUB_NUMBER: {
                if (page != null) {
                    return this.formatString(page.getPageNumber());
                }
                return this.formatString(statement.getPageNumber());
            }
            case STATEMENT_NUMBER_WITH_SUB_NUMBER: {
                Integer sub = statement.getPageNumber();
                if (page != null) {
                    sub = page.getPageNumber();
                }
                return this.formatString(statement.getStatementNumber()) + "/" + this.formatString(sub);
            }
            case STATEMENT_COUNT_BOOKINGS: {
                if (page != null) {
                    return String.valueOf(CmBooking.findCountByPage(page));
                }
                return String.valueOf(CmBooking.findCountByStatement(statement));
            }
            case STATEMENT_SUM_CREDITS: {
                if (page != null) {
                    return this.formatAmount(page.getSumCredit());
                }
                return this.formatAmount(statement.getSumCredit());
            }
            case STATEMENT_SUM_DEBITS: {
                BigDecimal b = page != null ? page.getSumDebit() : statement.getSumDebit();
                if (this.usePositveDebits()) {
                    return b != null ? this.formatAmount(b.abs()) : "";
                }
                return this.formatAmount(b);
            }
            case STATEMENT_COUNT_CREDITS: {
                if (page != null) {
                    return String.valueOf(page.getCountCredit());
                }
                return String.valueOf(statement.getCountCredit());
            }
            case STATEMENT_COUNT_DEBITS: {
                if (page != null) {
                    return String.valueOf(page.getCountDebit());
                }
                return String.valueOf(statement.getCountDebit());
            }
            case STATEMENT_HIGHEST_CREDIT: {
                if (page != null) {
                    return this.formatAmount(page.getMaxCredit());
                }
                return this.formatAmount(statement.getMaxCredit());
            }
            case STATEMENT_SMALLEST_CREDIT: {
                if (page != null) {
                    return this.formatAmount(page.getMinCredit());
                }
                return this.formatAmount(statement.getMinCredit());
            }
            case STATEMENT_HIGHEST_DEBIT: {
                BigDecimal b2 = page != null ? page.getMaxDebit() : statement.getMaxDebit();
                if (this.usePositveDebits()) {
                    return b2 != null ? this.formatAmount(b2.abs()) : "";
                }
                return this.formatAmount(b2);
            }
            case STATEMENT_SMALLEST_DEBIT: {
                BigDecimal b3 = page != null ? page.getMaxDebit() : statement.getMaxDebit();
                if (this.usePositveDebits()) {
                    return b3 != null ? this.formatAmount(b3.abs()) : "";
                }
                return this.formatAmount(b3);
            }
            case STATEMENT_REFERENCE_1: {
                if (page != null) {
                    return this.formatString(page.getReference1());
                }
                return this.formatString(statement.getReference1());
            }
            case STATEMENT_REFERENCE_2: {
                if (page != null) {
                    return this.formatString(page.getReference1());
                }
                return this.formatString(statement.getReference2());
            }
            case BOOKING_AMOUNT: {
                return this.formatAmount(booking.getAmount());
            }
            case BOOKING_ABSOLUTE_AMOUNT: {
                return this.formatAmount(booking.getAmount().abs());
            }
            case BOOKING_AMOUNT_SIGN_FLAG: {
                if (booking.getAmount() != null) {
                    if (booking.getAmount().signum() == -1) {
                        return "C";
                    }
                    if (booking.getAmount().signum() == 1) {
                        return "D";
                    }
                    return "";
                }
                return "";
            }
            case BOOKING_VALUE_DATE: {
                return this.formatDate(EclipseFreeHelper.getValueDate(booking));
            }
            case BOOKING_BOOKING_DATE: {
                return this.formatDate(EclipseFreeHelper.getBookingDate(booking));
            }
            case BOOKING_ORIG_RECIP_1: {
                return this.getArrayElement(booking.getCounterParty(), 0);
            }
            case BOOKING_ORIG_RECIP_2: {
                return this.getArrayElement(booking.getCounterParty(), 1);
            }
            case BOOKING_PURPOSE: {
                return this.getArrayElement(booking.getPurpose(), 0);
            }
            case BOOKING_TOTAL_PURPOSE: {
                return this.formatString(booking.getPurpose());
            }
            case BOOKING_PURPOSE_2: {
                return this.getArrayElement(booking.getPurpose(), 1);
            }
            case BOOKING_PURPOSE_3: {
                return this.getArrayElement(booking.getPurpose(), 2);
            }
            case BOOKING_PURPOSE_4: {
                return this.getArrayElement(booking.getPurpose(), 3);
            }
            case BOOKING_PURPOSE_5: {
                return this.getArrayElement(booking.getPurpose(), 4);
            }
            case BOOKING_PURPOSE_6: {
                return this.getArrayElement(booking.getPurpose(), 5);
            }
            case BOOKING_PURPOSE_7: {
                return this.getArrayElement(booking.getPurpose(), 6);
            }
            case BOOKING_PURPOSE_8: {
                return this.getArrayElement(booking.getPurpose(), 7);
            }
            case BOOKING_PURPOSE_9: {
                return this.getArrayElement(booking.getPurpose(), 8);
            }
            case BOOKING_PURPOSE_10: {
                return this.getArrayElement(booking.getPurpose(), 9);
            }
            case BOOKING_PURPOSE_11: {
                return this.getArrayElement(booking.getPurpose(), 10);
            }
            case BOOKING_PURPOSE_12: {
                return this.getArrayElement(booking.getPurpose(), 11);
            }
            case BOOKING_PURPOSE_13: {
                return this.getArrayElement(booking.getPurpose(), 12);
            }
            case BOOKING_PURPOSE_14: {
                return this.getArrayElement(booking.getPurpose(), 13);
            }
            case BOOKING_REVERSAL: {
                if (booking.isReversal()) {
                    return "true";
                }
                return "";
            }
            case BOOKING_ORIGINAL_AMOUNT: {
                return this.formatAmount(booking.getOriginalAmount());
            }
            case BOOKING_ORIGINAL_CURRENCY: {
                return this.formatCurrency(booking.getOriginalCurrency());
            }
            case BOOKING_CHARGES_AMOUNT: {
                return this.formatAmount(EclipseFreeHelper.getChargesAmount(booking));
            }
            case BOOKING_CHARGES_CURRENCY: {
                String currencyCode = EclipseFreeHelper.getChargesCurrencyCode(booking);
                return currencyCode != null ? currencyCode : "";
            }
            case BOOKING_COUNTERPARTY: {
                return this.formatString(booking.getCounterParty());
            }
            case BOOKING_COUNTERPARTY_BANK_CODE: {
                if (CmStatement.Type.CFONB120.name().equals(booking.getStatement().getFormatName())) {
                    return this.formatString(this.getArrayElement(booking.getCounterPartyAccountNumber(), "/", 0));
                }
                return this.formatString(booking.getCounterPartyBankCode());
            }
            case BOOKING_COUNTERPARTY_BRANCH_CODE: {
                return this.formatString(this.getArrayElement(booking.getCounterPartyAccountNumber(), "/", 1));
            }
            case BOOKING_COUNTERPARTY_ACCOUNT_NUMBER: {
                if (CmStatement.Type.CFONB120.name().equals(booking.getStatement().getFormatName())) {
                    return this.formatString(this.getArrayElement(booking.getCounterPartyAccountNumber(), "/", 2));
                }
                return this.formatString(booking.getCounterPartyAccountNumber());
            }
            case BOOKING_COUNTERPARTY_RIB: {
                return this.formatString(booking.getCounterPartyAccountNumber());
            }
            case BOOKING_LOCALPARTY: {
                return this.formatString(booking.getLocalParty());
            }
            case BOOKING_LOCALPARTY_BANK_CODE: {
                if (CmStatement.Type.CFONB120.name().equals(booking.getStatement().getFormatName())) {
                    return this.formatString(this.getArrayElement(booking.getLocalPartyAccountNumber(), "/", 0));
                }
                return this.formatString(booking.getLocalPartyBankCode());
            }
            case BOOKING_LOCALPARTY_BRANCH_CODE: {
                return this.formatString(this.getArrayElement(booking.getLocalPartyAccountNumber(), "/", 1));
            }
            case BOOKING_LOCALPARTY_ACCOUNT_NUMBER: {
                if (CmStatement.Type.CFONB120.name().equals(booking.getStatement().getFormatName())) {
                    return this.formatString(this.getArrayElement(booking.getLocalPartyAccountNumber(), "/", 2));
                }
                return this.formatString(booking.getLocalPartyAccountNumber());
            }
            case BOOKING_LOCALPARTY_RIB: {
                return this.formatString(booking.getLocalPartyAccountNumber());
            }
            case BOOKING_TRANSACTION_CODE: {
                return this.formatString(booking.getTransactionCode());
            }
            case MT94X_BOOKING_BOOKING_KEY: {
                return this.formatString(booking.getBookingKey());
            }
            case MT94X_BOOKING_CUSTOMER_REFERENCE: {
                return this.formatString(booking.getCustomerReferenceOrPmtInfId());
            }
            case MT94X_BOOKING_BANK_REFERENCE: {
                return this.formatString(booking.getBankReference());
            }
            case MT94X_BOOKING_ADDITIONAL_INFO: {
                return this.formatString(booking.getAdditionalInformation());
            }
            case MT94X_BOOKING_FIELD_END_TO_END_ID: {
                return this.formatString(booking.getEndToEndId());
            }
            case MT94X_BOOKING_FIELD_MANDATE_REFERENCE: {
                return this.formatString(booking.getLocalPartyMandateReference());
            }
            case MT94X_BOOKING_FIELD_CREDITOR_ID: {
                return this.formatString(booking.getCounterPartyCreditorId());
            }
            case MT94X_BOOKING_GVC: {
                return this.formatString(booking.getGvc());
            }
            case MT94X_BOOKING_BOOKING_TEXT: {
                return this.formatString(booking.getBookingText());
            }
            case MT94X_BOOKING_PRIMANOTA: {
                return this.formatString(booking.getPrimanota());
            }
            case MT94X_BOOKING_TEXT_KEY_APPENDIX: {
                return this.formatString(booking.getTextKeyAppendix());
            }
            case BOOKING_UNIQUE_ID: {
                return String.valueOf(booking.getId());
            }
            case BOOKING_FEE_TYPE: {
                return this.formatString(booking.getFeeType());
            }
            case BOOKING_TRX_ID: {
                return this.formatString(booking.getTransactionId());
            }
            case BOOKING_PURPOSE_CODE: {
                return this.formatString(booking.getPurposeCode());
            }
            case BOOKING_CURRENT_BALANCE: {
                return this.formatAmount(booking.getBalance());
            }
            case CFONB_BOOKING_INTERBANK_TRANSACTION_CODE: {
                return this.formatString(booking.getInterbankTransactionCode());
            }
            case CFONB_BOOKING_REJECTION_CAUSE_CODE: {
                return this.formatString(booking.getRejectionCauseCode());
            }
            case CFONB_BOOKING_ENTRY_NUMBER: {
                return this.formatString(booking.getEntryNumber());
            }
            case CFONB_BOOKING_EXEMPTION: {
                Boolean exemption = booking.getExemption();
                if (exemption != null) {
                    return exemption.toString();
                }
                return "";
            }
            case CFONB_BOOKING_UNAVAILABILITY_RATING: {
                Boolean rating = booking.getUnavailabiltyRating();
                if (rating != null) {
                    return rating.toString();
                }
                return "";
            }
        }
        return "";
    }

    private String formatString(Integer i) {
        if (i == null) {
            return "";
        }
        return String.valueOf(i);
    }

    private String formatString(String s) {
        if (s != null) {
            s = s.replace("\n", "");
            if (this.vo.getTextSeparator() != null) {
                return s.replace(this.vo.getTextSeparator(), this.vo.getTextSeparator() + this.vo.getTextSeparator());
            }
            return s;
        }
        return "";
    }

    private String formatDate(java.util.Date date) {
        if (date != null) {
            return this.dateFormat.format(date);
        }
        return "";
    }

    private String formatAmount(BigDecimal amount) {
        if (amount != null) {
            return this.numberFormat.format(amount);
        }
        return "";
    }

    private String formatCurrency(Currency currency) {
        if (currency != null) {
            return currency.getCurrencyCode();
        }
        return "";
    }

    private String getArrayElement(String in, int index) {
        return this.getArrayElement(in, "\n", index);
    }

    private String getArrayElement(String in, String split, int index) {
        if (in == null) {
            return "";
        }
        String[] sArr = StringUtils.getStringArrayFromString(in, split);
        if (sArr != null && sArr.length > index) {
            return this.formatString(sArr[index]);
        }
        return "";
    }

    @Override
    public void close() {
        this.w.close();
    }
}

