/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.Tenant;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class ConversionHelper {
    private static final String DEFAULT_STATEMENT_CONVERSION_NAME = "Auszug.txt";
    private static final String DEFAULT_BOOKING_CONVERSION_NAME = "Umsatz.txt";
    private static final String DEFAULT_BALANCE_CONVERSION_NAME = "Salden.txt";
    private static final Set<String> GERMAN_DEFAULT_CONVERSION_NAMES = new HashSet<String>();
    private static final String DEFAULT_FRENCH_STATEMENT_CONVERSION_NAME = "Conversion de relev\u00e9s";
    private static final String DEFAULT_FRENCH_BOOKING_CONVERSION_NAME = "Conversion d'op\u00e9rations";
    private static final Set<String> FRENCH_DEFAULT_CONVERSION_NAMES = new HashSet<String>();
    private static final String PROP_NAME = "Name";
    private static final String PROP_TYPE = "Type";
    private static final String PROP_INCLUDE_HEADER = "IncludeHeader";
    private static final String PROP_FIELD_SEPARATOR = "FieldSeparator";
    private static final String PROP_TEXT_SEPARATOR = "TextSeparator";
    private static final String PROP_DATE_FORMAT = "DateFormat";
    private static final String PROP_NUMBER_FORMAT = "NumberFormat";
    private static final String PROP_FIELDS = "Fields";
    public static final String DEFAULT_SEPARATOR = ";";
    public static final String BLANK = " ";
    public static final String TAB = "\t";
    public static final String[] FIELD_SEPARATORS = new String[]{";", ",", " ", "\t"};
    public static final String DEFAULT_NUMBER_FORMAT = "0.00";
    public static final String DEFAULT_TEXT_SEPARATOR = "\"";
    public static final String[] TEXT_SEPARATORS = new String[]{"\"", "'"};
    public static final List<Conversion.Field> statementFields;
    public static final List<Conversion.Field> bookingFields;

    public static String getDefaultDateFormat(Locale locale) {
        DateFormat df = DateFormat.getDateInstance(2, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        return "";
    }

    public static String blankString(Locale locale) {
        return BankingApiMessages.getString(locale, "GeneralMessages.csvcolumnseparator.space", new Object[0]);
    }

    public static String tabString(Locale locale) {
        return BankingApiMessages.getString(locale, "GeneralMessages.csvcolumnseparator.tab", new Object[0]);
    }

    public static String setSeparator(String separator, Locale locale) {
        String blankDisplayString = BankingApiMessages.getString(locale, "GeneralMessages.csvcolumnseparator.space", new Object[0]);
        String tabDisplayString = BankingApiMessages.getString(locale, "GeneralMessages.csvcolumnseparator.tab", new Object[0]);
        if (BLANK.equals(separator)) {
            return blankDisplayString;
        }
        if (TAB.equals(separator)) {
            return tabDisplayString;
        }
        return separator;
    }

    public static String getSeparator(String separator, Locale locale) {
        String blankDisplayString = BankingApiMessages.getString(locale, "GeneralMessages.csvcolumnseparator.space", new Object[0]);
        String tabDisplayString = BankingApiMessages.getString(locale, "GeneralMessages.csvcolumnseparator.tab", new Object[0]);
        if (separator != null) {
            if (blankDisplayString.equals(separator)) {
                return BLANK;
            }
            if (tabDisplayString.equals(separator)) {
                return TAB;
            }
            return separator;
        }
        return "";
    }

    public static boolean defaultConversionsExist(List<Tenant> tenants, boolean french) {
        boolean toReturn = true;
        for (Tenant tenant : tenants) {
            if (french) {
                toReturn &= Conversion.exists(FRENCH_DEFAULT_CONVERSION_NAMES, tenant);
                continue;
            }
            toReturn &= Conversion.exists(GERMAN_DEFAULT_CONVERSION_NAMES, tenant);
        }
        return toReturn;
    }

    public static void createDefaultConversions(List<Tenant> tenants, boolean french, Locale locale) {
        for (Tenant tenant : tenants) {
            Conversion c;
            if (french) {
                if (!Conversion.exists(DEFAULT_FRENCH_STATEMENT_CONVERSION_NAME, tenant)) {
                    c = new Conversion();
                    c.setDateFormat(ConversionHelper.getDefaultDateFormat(locale));
                    c.setFields("3,5,31,6,7,8,9,10,11,15,18,16,19,17");
                    c.setFieldSeparator(DEFAULT_SEPARATOR);
                    c.setIncludeHeader(false);
                    c.setName(DEFAULT_FRENCH_STATEMENT_CONVERSION_NAME);
                    c.setNumberFormat(DEFAULT_NUMBER_FORMAT);
                    c.setTextSeparator(DEFAULT_TEXT_SEPARATOR);
                    c.setType(Conversion.Type.StatementType);
                    c.setTenant(tenant);
                    c.save();
                }
                if (Conversion.exists(DEFAULT_FRENCH_BOOKING_CONVERSION_NAME, tenant)) continue;
                c = new Conversion();
                c.setDateFormat(ConversionHelper.getDefaultDateFormat(locale));
                c.setFields("3,5,31,6,7,101,103,104,8,106");
                c.setFieldSeparator(DEFAULT_SEPARATOR);
                c.setIncludeHeader(false);
                c.setName(DEFAULT_FRENCH_BOOKING_CONVERSION_NAME);
                c.setNumberFormat(DEFAULT_NUMBER_FORMAT);
                c.setTextSeparator(DEFAULT_TEXT_SEPARATOR);
                c.setType(Conversion.Type.BookingType);
                c.setTenant(tenant);
                c.save();
                continue;
            }
            if (!Conversion.exists(DEFAULT_STATEMENT_CONVERSION_NAME, tenant)) {
                c = new Conversion();
                c.setDateFormat(ConversionHelper.getDefaultDateFormat(locale));
                c.setFields("5,6,12,8,7,11,17,16,9,0,3,0,0,15");
                c.setFieldSeparator(DEFAULT_SEPARATOR);
                c.setIncludeHeader(false);
                c.setName(DEFAULT_STATEMENT_CONVERSION_NAME);
                c.setNumberFormat(DEFAULT_NUMBER_FORMAT);
                c.setTextSeparator(DEFAULT_TEXT_SEPARATOR);
                c.setType(Conversion.Type.StatementType);
                c.setTenant(tenant);
                c.save();
            }
            if (!Conversion.exists(DEFAULT_BOOKING_CONVERSION_NAME, tenant)) {
                c = new Conversion();
                c.setDateFormat(ConversionHelper.getDefaultDateFormat(locale));
                c.setFields("5,6,12,103,163,105,162,0,164,152,101,0,0,104,0,0,171,172,173,174,175,176,177,178,179,180,181,182,183,165,166,112,113,161,107");
                c.setFieldSeparator(DEFAULT_SEPARATOR);
                c.setIncludeHeader(false);
                c.setName(DEFAULT_BOOKING_CONVERSION_NAME);
                c.setNumberFormat(DEFAULT_NUMBER_FORMAT);
                c.setTextSeparator(DEFAULT_TEXT_SEPARATOR);
                c.setType(Conversion.Type.BookingType);
                c.setTenant(tenant);
                c.save();
            }
            if (Conversion.exists(DEFAULT_BALANCE_CONVERSION_NAME, tenant)) continue;
            c = new Conversion();
            c.setDateFormat(ConversionHelper.getDefaultDateFormat(locale));
            c.setFields("3,2,5,6,33,34,12,10,11,16,17,8,7,9");
            c.setFieldSeparator(DEFAULT_SEPARATOR);
            c.setIncludeHeader(false);
            c.setName(DEFAULT_BALANCE_CONVERSION_NAME);
            c.setNumberFormat(DEFAULT_NUMBER_FORMAT);
            c.setTextSeparator(DEFAULT_TEXT_SEPARATOR);
            c.setType(Conversion.Type.StatementType);
            c.setTenant(tenant);
            c.save();
        }
    }

    public static byte[] exportConversion(Conversion conversion) throws IOException {
        Properties properties = ConversionHelper.getProperties(conversion);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        properties.storeToXML(out, conversion.getName());
        return out.toByteArray();
    }

    public static Conversion importConversion(File file, Tenant tenant) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Properties properties = new Properties();
        properties.loadFromXML(in);
        Conversion conversion = ConversionHelper.getFromProperties(properties, tenant);
        HashSet<String> conversionNames = new HashSet<String>();
        for (Conversion c : Conversion.findAll(tenant)) {
            conversionNames.add(c.getName());
        }
        int i = 0;
        String name = conversion.getName();
        while (conversionNames.contains(conversion.getName())) {
            conversion.setName(name + "_" + ++i);
        }
        return conversion;
    }

    private static Properties getProperties(Conversion conversion) {
        Properties properties = new Properties();
        if (conversion.getName() != null) {
            properties.put(PROP_NAME, conversion.getName());
        }
        if (conversion.getType() != null) {
            properties.put(PROP_TYPE, conversion.getType().name());
        }
        properties.put(PROP_INCLUDE_HEADER, String.valueOf(conversion.isIncludeHeader()));
        if (conversion.getFieldSeparator() != null) {
            properties.put(PROP_FIELD_SEPARATOR, conversion.getFieldSeparator());
        }
        if (conversion.getTextSeparator() != null) {
            properties.put(PROP_TEXT_SEPARATOR, conversion.getTextSeparator());
        }
        if (conversion.getDateFormat() != null) {
            properties.put(PROP_DATE_FORMAT, conversion.getDateFormat());
        }
        if (conversion.getNumberFormat() != null) {
            properties.put(PROP_NUMBER_FORMAT, conversion.getNumberFormat());
        }
        if (conversion.getFields() != null) {
            properties.put(PROP_FIELDS, conversion.getFields());
        }
        return properties;
    }

    private static Conversion getFromProperties(Properties properties, Tenant tenant) {
        Conversion conversion = new Conversion();
        conversion.setName(properties.getProperty(PROP_NAME));
        String typeString = properties.getProperty(PROP_TYPE);
        if (typeString != null) {
            conversion.setType(Conversion.Type.valueOf(typeString));
        }
        conversion.setIncludeHeader(Boolean.parseBoolean(properties.getProperty(PROP_INCLUDE_HEADER)));
        conversion.setFieldSeparator(properties.getProperty(PROP_FIELD_SEPARATOR));
        conversion.setTextSeparator(properties.getProperty(PROP_TEXT_SEPARATOR));
        conversion.setDateFormat(properties.getProperty(PROP_DATE_FORMAT));
        conversion.setNumberFormat(properties.getProperty(PROP_NUMBER_FORMAT));
        conversion.setFields(properties.getProperty(PROP_FIELDS));
        conversion.setTenant(tenant);
        return conversion;
    }

    private ConversionHelper() {
    }

    static {
        GERMAN_DEFAULT_CONVERSION_NAMES.add(DEFAULT_STATEMENT_CONVERSION_NAME);
        GERMAN_DEFAULT_CONVERSION_NAMES.add(DEFAULT_BOOKING_CONVERSION_NAME);
        GERMAN_DEFAULT_CONVERSION_NAMES.add(DEFAULT_BALANCE_CONVERSION_NAME);
        FRENCH_DEFAULT_CONVERSION_NAMES.add(DEFAULT_FRENCH_STATEMENT_CONVERSION_NAME);
        FRENCH_DEFAULT_CONVERSION_NAMES.add(DEFAULT_FRENCH_BOOKING_CONVERSION_NAME);
        ArrayList<Conversion.Field> tmp = new ArrayList<Conversion.Field>();
        tmp.add(Conversion.Field.STATEMENT_FORMAT);
        tmp.add(Conversion.Field.STATEMENT_BANK_NAME);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_NAME);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_IDENTIFIER);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_HOLDER);
        tmp.add(Conversion.Field.STATEMENT_BANK_CODE);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_CURRENCY);
        tmp.add(Conversion.Field.STATEMENT_DATE);
        tmp.add(Conversion.Field.STATEMENT_BALANCE);
        tmp.add(Conversion.Field.STATEMENT_OPENING_DATE);
        tmp.add(Conversion.Field.STATEMENT_OPENING_BALANCE);
        tmp.add(Conversion.Field.STATEMENT_LEGAL_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_SUB_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_NUMBER_WITH_SUB_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_COUNT_BOOKINGS);
        tmp.add(Conversion.Field.STATEMENT_SUM_CREDITS);
        tmp.add(Conversion.Field.STATEMENT_SUM_DEBITS);
        tmp.add(Conversion.Field.STATEMENT_COUNT_CREDITS);
        tmp.add(Conversion.Field.STATEMENT_COUNT_DEBITS);
        tmp.add(Conversion.Field.STATEMENT_HIGHEST_CREDIT);
        tmp.add(Conversion.Field.STATEMENT_SMALLEST_CREDIT);
        tmp.add(Conversion.Field.STATEMENT_HIGHEST_DEBIT);
        tmp.add(Conversion.Field.STATEMENT_SMALLEST_DEBIT);
        tmp.add(Conversion.Field.STATEMENT_REFERENCE_1);
        tmp.add(Conversion.Field.STATEMENT_REFERENCE_2);
        tmp.add(Conversion.Field.STATEMENT_IBAN);
        tmp.add(Conversion.Field.STATEMENT_BIC);
        tmp.add(Conversion.Field.STATEMENT_BRANCH_CODE);
        tmp.add(Conversion.Field.STATEMENT_RIB);
        statementFields = Collections.unmodifiableList(tmp);
        tmp = new ArrayList();
        tmp.add(Conversion.Field.STATEMENT_FORMAT);
        tmp.add(Conversion.Field.STATEMENT_BANK_NAME);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_NAME);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_IDENTIFIER);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_HOLDER);
        tmp.add(Conversion.Field.STATEMENT_BANK_CODE);
        tmp.add(Conversion.Field.STATEMENT_IBAN);
        tmp.add(Conversion.Field.STATEMENT_BIC);
        tmp.add(Conversion.Field.STATEMENT_ACCOUNT_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_CURRENCY);
        tmp.add(Conversion.Field.STATEMENT_DATE);
        tmp.add(Conversion.Field.STATEMENT_BALANCE);
        tmp.add(Conversion.Field.STATEMENT_OPENING_DATE);
        tmp.add(Conversion.Field.STATEMENT_OPENING_BALANCE);
        tmp.add(Conversion.Field.STATEMENT_LEGAL_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_SUB_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_NUMBER_WITH_SUB_NUMBER);
        tmp.add(Conversion.Field.STATEMENT_REFERENCE_1);
        tmp.add(Conversion.Field.STATEMENT_REFERENCE_2);
        tmp.add(Conversion.Field.BOOKING_AMOUNT);
        tmp.add(Conversion.Field.BOOKING_ABSOLUTE_AMOUNT);
        tmp.add(Conversion.Field.BOOKING_AMOUNT_SIGN_FLAG);
        tmp.add(Conversion.Field.BOOKING_VALUE_DATE);
        tmp.add(Conversion.Field.BOOKING_BOOKING_DATE);
        tmp.add(Conversion.Field.BOOKING_TOTAL_PURPOSE);
        tmp.add(Conversion.Field.BOOKING_PURPOSE);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_2);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_3);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_4);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_5);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_6);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_7);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_8);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_9);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_10);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_11);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_12);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_13);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_14);
        tmp.add(Conversion.Field.BOOKING_REVERSAL);
        tmp.add(Conversion.Field.BOOKING_COUNTERPARTY);
        tmp.add(Conversion.Field.BOOKING_LOCALPARTY);
        tmp.add(Conversion.Field.BOOKING_ORIG_RECIP_1);
        tmp.add(Conversion.Field.BOOKING_ORIG_RECIP_2);
        tmp.add(Conversion.Field.BOOKING_COUNTERPARTY_BANK_CODE);
        tmp.add(Conversion.Field.BOOKING_COUNTERPARTY_ACCOUNT_NUMBER);
        tmp.add(Conversion.Field.BOOKING_LOCALPARTY_BANK_CODE);
        tmp.add(Conversion.Field.BOOKING_LOCALPARTY_ACCOUNT_NUMBER);
        tmp.add(Conversion.Field.BOOKING_ORIGINAL_AMOUNT);
        tmp.add(Conversion.Field.BOOKING_ORIGINAL_CURRENCY);
        tmp.add(Conversion.Field.BOOKING_CHARGES_AMOUNT);
        tmp.add(Conversion.Field.BOOKING_CHARGES_CURRENCY);
        tmp.add(Conversion.Field.BOOKING_UNIQUE_ID);
        tmp.add(Conversion.Field.BOOKING_FEE_TYPE);
        tmp.add(Conversion.Field.BOOKING_TRX_ID);
        tmp.add(Conversion.Field.BOOKING_PURPOSE_CODE);
        tmp.add(Conversion.Field.BOOKING_CURRENT_BALANCE);
        tmp.add(Conversion.Field.BOOKING_TRANSACTION_CODE);
        tmp.add(Conversion.Field.MT94X_BOOKING_BOOKING_KEY);
        tmp.add(Conversion.Field.MT94X_BOOKING_CUSTOMER_REFERENCE);
        tmp.add(Conversion.Field.MT94X_BOOKING_BANK_REFERENCE);
        tmp.add(Conversion.Field.MT94X_BOOKING_ADDITIONAL_INFO);
        tmp.add(Conversion.Field.MT94X_BOOKING_FIELD_END_TO_END_ID);
        tmp.add(Conversion.Field.MT94X_BOOKING_FIELD_MANDATE_REFERENCE);
        tmp.add(Conversion.Field.MT94X_BOOKING_FIELD_CREDITOR_ID);
        tmp.add(Conversion.Field.MT94X_BOOKING_GVC);
        tmp.add(Conversion.Field.MT94X_BOOKING_BOOKING_TEXT);
        tmp.add(Conversion.Field.MT94X_BOOKING_PRIMANOTA);
        tmp.add(Conversion.Field.MT94X_BOOKING_TEXT_KEY_APPENDIX);
        tmp.add(Conversion.Field.STATEMENT_BRANCH_CODE);
        tmp.add(Conversion.Field.STATEMENT_RIB);
        tmp.add(Conversion.Field.BOOKING_COUNTERPARTY_BRANCH_CODE);
        tmp.add(Conversion.Field.BOOKING_COUNTERPARTY_RIB);
        tmp.add(Conversion.Field.BOOKING_LOCALPARTY_BRANCH_CODE);
        tmp.add(Conversion.Field.BOOKING_LOCALPARTY_RIB);
        tmp.add(Conversion.Field.CFONB_BOOKING_BNP_PARIBAS_TRANSACTION_CODE);
        tmp.add(Conversion.Field.CFONB_BOOKING_INTERBANK_TRANSACTION_CODE);
        tmp.add(Conversion.Field.CFONB_BOOKING_REJECTION_CAUSE_CODE);
        tmp.add(Conversion.Field.CFONB_BOOKING_ENTRY_NUMBER);
        tmp.add(Conversion.Field.CFONB_BOOKING_EXEMPTION);
        tmp.add(Conversion.Field.CFONB_BOOKING_UNAVAILABILITY_RATING);
        bookingFields = Collections.unmodifiableList(tmp);
    }
}

