/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.AutomaticExporterApi;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.util.BLLogger;
import java.util.Collection;
import java.util.List;

public class CmReporterApi
extends CmReporter {
    private final BLLogger logger;
    private final EncryptData encrypt;
    private final User user;

    public CmReporterApi(CmReporter.Mode mode, BLLogger logger, EncryptData encrypt, User user, List<StatementBookingReportHandler> reportHandlers) {
        this(mode, null, logger, encrypt, user, reportHandlers);
    }

    public CmReporterApi(CmReporter.Mode mode, String format, BLLogger logger, EncryptData encrypt, User user, List<StatementBookingReportHandler> reportHandlers) {
        this.mode = mode;
        this.format = format;
        this.logger = logger;
        this.encrypt = encrypt;
        this.user = user;
        this.reportHandlers = reportHandlers;
    }

    public int getNewStatementsCount() {
        return this.newStatements.size() + this.newPages.size();
    }

    @Override
    public CmReporter getAdviceSubReporter() {
        if (this.adviceSubReporter == null) {
            switch (this.mode) {
                case FETCH_STATEMENT: {
                    this.adviceSubReporter = new CmReporterApi(CmReporter.Mode.FETCH_ADVICE, this.logger, this.encrypt, this.user, this.reportHandlers);
                    break;
                }
                case IMPORT_STATEMENT: {
                    this.adviceSubReporter = new CmReporterApi(CmReporter.Mode.IMPORT_ADVICE, this.logger, this.encrypt, this.user, this.reportHandlers);
                    break;
                }
                default: {
                    this.adviceSubReporter = this;
                }
            }
        }
        return this.adviceSubReporter;
    }

    @Override
    protected void doExport(Collection<AutomaticExport> exports, List<CmStatement> statements, List<CmPage> pages) {
        AutomaticExporterApi exporter = new AutomaticExporterApi(exports, statements, pages, "", this.logger, this.encrypt, this.user);
        exporter.doExport(false);
    }

    @Override
    protected void handleStatus(Throwable t) {
        this.logger.logError(t.getMessage(), t);
    }

    @Override
    protected void newStatementsFetched() {
    }

    @Override
    protected void newStatementsImported() {
    }

    @Override
    protected void newAdvicesFetched() {
    }

    @Override
    protected void newAdvicesImported() {
    }

    @Override
    protected void newDtiFilesFetched() {
    }

    @Override
    protected void newDtiFilesImported() {
    }

    @Override
    protected void refreshStatementView() {
    }

    @Override
    protected void refreshDTIView() {
    }

    @Override
    protected void refreshValueBalanceView() {
    }

    @Override
    protected void refreshValueBalancesView() {
    }
}

