/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import io.ebean.Query;
import io.ebean.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class CmReporter {
    protected LinkedHashSet<CmStatement> newStatements = new LinkedHashSet();
    protected LinkedHashSet<CmPage> newPages = new LinkedHashSet();
    protected Mode mode = null;
    protected String format = null;
    protected boolean doAutomaticExports = true;
    protected boolean recalculateValueBalances = true;
    protected List<StatementBookingReportHandler> reportHandlers;
    protected CmReporter adviceSubReporter = null;

    public void newStatement(CmStatement s, CmPage p) {
        if (p == null) {
            this.newStatements.add(s);
        } else if (!this.newStatements.contains(s)) {
            this.newPages.add(p);
        }
        if (!this.reportHandlers.isEmpty()) {
            Query<CmBooking> query = DB.find(CmBooking.class);
            if (p == null) {
                query.where().eq("statement", (Object)s);
            } else {
                query.where().eq("statement", (Object)s).eq("page", (Object)p);
            }
            List iterate = query.findList();
            for (CmBooking cmBooking : iterate) {
                for (StatementBookingReportHandler handler : this.reportHandlers) {
                    try {
                        handler.handle(cmBooking);
                    }
                    catch (Throwable t) {
                        this.handleStatus(t);
                    }
                }
            }
        }
    }

    protected abstract void handleStatus(Throwable var1);

    public void finishProcessing(boolean deleteOldAdvices) {
        try (Transaction t = DB.beginTransaction();){
            LinkedHashSet<CmPage> tmp = this.newPages;
            this.newPages = new LinkedHashSet();
            for (CmPage page : tmp) {
                CmPage fresh = DB.find(CmPage.class, page.getId());
                if (fresh == null) continue;
                this.newPages.add(fresh);
            }
            LinkedHashSet<CmStatement> tmp2 = this.newStatements;
            this.newStatements = new LinkedHashSet();
            for (CmStatement stmt : tmp2) {
                CmStatement fresh = DB.find(CmStatement.class, stmt.getId());
                if (fresh == null) continue;
                this.newStatements.add(fresh);
            }
            t.commit();
        }
        if (this.adviceSubReporter != null && !this.adviceSubReporter.equals(this)) {
            this.adviceSubReporter.finishProcessing(deleteOldAdvices);
        }
        switch (this.mode.ordinal()) {
            case 1: {
                this.automaticExports();
                this.valueBalances(deleteOldAdvices);
                this.refreshStatementView();
                this.newStatementsFetched();
                break;
            }
            case 0: {
                this.automaticExports();
                this.valueBalances(deleteOldAdvices);
                this.refreshStatementView();
                this.newStatementsImported();
                break;
            }
            case 4: {
                this.automaticExports();
                this.valueBalances(deleteOldAdvices);
                this.refreshStatementView();
                this.newAdvicesFetched();
                return;
            }
            case 3: {
                this.automaticExports();
                this.valueBalances(deleteOldAdvices);
                this.refreshStatementView();
                this.newAdvicesImported();
                return;
            }
            case 2: {
                this.valueBalances(deleteOldAdvices);
                this.refreshStatementView();
                return;
            }
            case 6: {
                this.automaticExports();
                this.refreshDTIView();
                this.newDtiFilesFetched();
                break;
            }
            case 5: {
                this.automaticExports();
                this.refreshDTIView();
                this.newDtiFilesImported();
            }
        }
        if (this.size() > 0) {
            for (StatementBookingReportHandler handler : this.reportHandlers) {
                handler.showInfoMessage();
            }
        }
    }

    private void automaticExports() {
        Tuple tuple;
        Tenant tenant;
        if (!this.doAutomaticExports) {
            return;
        }
        HashMap<Tenant, Tuple> map = new HashMap<Tenant, Tuple>();
        for (CmStatement s : this.newStatements) {
            tenant = s.getAccount().getBank().getTenant();
            tuple = (Tuple)map.get(tenant);
            if (tuple == null) {
                tuple = new Tuple();
                map.put(tenant, tuple);
            }
            tuple.statements.add(s);
        }
        for (CmPage p : this.newPages) {
            tenant = p.getStatement().getAccount().getBank().getTenant();
            tuple = (Tuple)map.get(tenant);
            if (tuple == null) {
                tuple = new Tuple();
                map.put(tenant, tuple);
            }
            tuple.pages.add(p);
        }
        for (Tenant t : map.keySet()) {
            List<AutomaticExport> list = AutomaticExport.findActive(t);
            if (list.isEmpty()) continue;
            tuple = (Tuple)map.get(t);
            this.doExport(list, tuple.statements, tuple.pages);
        }
    }

    protected abstract void doExport(Collection<AutomaticExport> var1, List<CmStatement> var2, List<CmPage> var3);

    private void valueBalances(boolean deleteOldAdvices) {
        if (!this.recalculateValueBalances) {
            return;
        }
        switch (this.mode.ordinal()) {
            case 2: {
                ValueBalanceCalculator.updateFull(this.newStatements, this.newPages);
                this.refreshValueBalanceView();
                this.refreshValueBalancesView();
                break;
            }
            case 3: 
            case 4: {
                ValueBalanceCalculator.updateAdvices(this.newStatements, this.newPages, deleteOldAdvices);
                this.refreshValueBalanceView();
                this.refreshValueBalancesView();
                break;
            }
            case 0: 
            case 1: {
                ValueBalanceCalculator.updateStatements(this.newStatements, this.newPages, deleteOldAdvices);
                this.refreshValueBalanceView();
                this.refreshValueBalancesView();
                break;
            }
        }
    }

    public int size() {
        return this.newStatements.size() + this.newPages.size();
    }

    public boolean isImportMode() {
        return this.mode != null && (Mode.IMPORT_STATEMENT.equals((Object)this.mode) || Mode.IMPORT_ADVICE.equals((Object)this.mode) || Mode.IMPORT_DTI.equals((Object)this.mode));
    }

    protected abstract void refreshStatementView();

    protected abstract void refreshDTIView();

    protected abstract void refreshValueBalanceView();

    protected abstract void refreshValueBalancesView();

    protected abstract void newStatementsFetched();

    protected abstract void newStatementsImported();

    protected abstract void newAdvicesFetched();

    protected abstract void newAdvicesImported();

    protected abstract void newDtiFilesFetched();

    protected abstract void newDtiFilesImported();

    public abstract CmReporter getAdviceSubReporter();

    public boolean isDoAutomaticExports() {
        return this.doAutomaticExports;
    }

    public void setDoAutomaticExports(boolean doAutomaticExports) {
        this.doAutomaticExports = doAutomaticExports;
    }

    public boolean isRecalculateValueBalances() {
        return this.recalculateValueBalances;
    }

    public void setRecalculateValueBalances(boolean recalculateValueBalances) {
        this.recalculateValueBalances = recalculateValueBalances;
    }

    protected boolean containOnlyCreditAdvices(Collection<CmStatement> statements, Collection<CmPage> pages) {
        for (CmStatement statement : statements) {
            if (statement.isCreditAdvice()) continue;
            return false;
        }
        for (CmPage page : pages) {
            if (page.getStatement().isCreditAdvice()) continue;
            return false;
        }
        return true;
    }

    public static enum Mode {
        IMPORT_STATEMENT,
        FETCH_STATEMENT,
        MIGRATE,
        IMPORT_ADVICE,
        FETCH_ADVICE,
        IMPORT_DTI,
        FETCH_DTI;

    }

    private static class Tuple {
        List<CmStatement> statements = new ArrayList<CmStatement>();
        List<CmPage> pages = new ArrayList<CmPage>();

        private Tuple() {
        }
    }
}

