/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMAccount;
import de.businesslogics.util.Currency;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class CmOverviewCsvExport
extends AbstractCsvExport<CMAccount> {
    private final Locale locale;

    public CmOverviewCsvExport(Locale locale) {
        this.locale = locale;
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.account", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.standardName", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.currency", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.accountStatement", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.statementDate", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.openingBalance", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sumCredits", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.sumDebits", new Object[0]));
        this.addCell(writer, BankingApiMessages.getString(this.locale, "GeneralMessages.bookingBalance", new Object[0]));
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, CMAccount cmAccount) throws IOException {
        this.addCell(writer, cmAccount.getAccount().getName());
        this.addCell(writer, Account.getCmDisplayName(cmAccount.getAccount()));
        this.addCell(writer, cmAccount.getAccount().getCurrency());
        Currency currency = Currency.getInstance(cmAccount.getAccount().getCurrency());
        CmStatement newest = cmAccount.getNewestStatement();
        this.addCell(writer, this.getStatementNumber(newest));
        this.addCell(writer, this.formatDate(this.getClosingDate(newest), this.locale));
        this.addCell(writer, this.formatAmount(this.getOpeningBalance(newest), currency, this.locale), true);
        this.addCell(writer, this.formatAmount(this.getSumCredit(newest), currency, this.locale), true);
        this.addCell(writer, this.formatAmount(this.getSumDebit(newest), currency, this.locale), true);
        this.addCell(writer, this.formatAmount(this.getClosingBalance(newest), currency, this.locale), true);
        return true;
    }

    private String getStatementNumber(CmStatement stmt) {
        if (stmt != null && stmt.getStatementNumberToDisplay() != null) {
            return stmt.getStatementNumberToDisplay().toString();
        }
        return null;
    }

    private Date getClosingDate(CmStatement stmt) {
        if (stmt != null) {
            return stmt.getClosingDate();
        }
        return null;
    }

    private BigDecimal getOpeningBalance(CmStatement stmt) {
        if (stmt != null) {
            return stmt.getOpeningBalance();
        }
        return null;
    }

    private BigDecimal getSumCredit(CmStatement stmt) {
        if (stmt != null) {
            return stmt.getSumCredit();
        }
        return null;
    }

    private BigDecimal getSumDebit(CmStatement stmt) {
        if (stmt != null) {
            return stmt.getSumDebit();
        }
        return null;
    }

    private BigDecimal getClosingBalance(CmStatement stmt) {
        if (stmt != null) {
            return stmt.getClosingBalance();
        }
        return null;
    }
}

