/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.BLLogger;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class CmLogger {
    private static CmLogger myInstance;
    private final BLLogger logger;
    private final Set<Account> accounts;
    private final User user;

    private CmLogger(BLLogger logger, Set<Account> accounts, User user) {
        this.logger = logger;
        this.accounts = accounts;
        this.user = user;
        if (this.accounts == null) {
            this.logger.logInfo("Created CmLogger for ALL accounts for user " + user.getName());
        } else {
            this.logger.logInfo("Created CmLogger for " + accounts.size() + " accounts for user " + user.getName());
            for (Account account : accounts) {
                this.logger.logInfo(this.getAccountInfo(account).toString());
            }
        }
    }

    public boolean contains(Account account) {
        return this.accounts == null || this.accounts.contains(account);
    }

    private StringBuilder getAccountInfo(Account a) {
        return new StringBuilder("CmLogger. User '" + this.user.getName() + "' Account with id=").append(a.getId()).append(" name='").append(a.getName()).append("' cmIdentification=").append(a.getCmIdentification()).append(" type=" + String.valueOf((Object)a.getType())).append("   ");
    }

    public void logInfo(Account account, String message) {
        this.logger.logInfo(this.getAccountInfo(account).append(message).toString());
    }

    public void logWarning(Account account, String message) {
        this.logger.logWarning(this.getAccountInfo(account).append(message).toString());
    }

    public void logWarning(Account account, String message, Throwable t) {
        this.logger.logWarning(this.getAccountInfo(account).append(message).toString(), t);
    }

    public void logError(Account account, String message) {
        this.logger.logError(this.getAccountInfo(account).append(message).toString());
    }

    public void logError(Account account, String message, Throwable t) {
        this.logger.logError(this.getAccountInfo(account).append(message).toString(), t);
    }

    public static void createCmLogger(BLLogger logger, User user) {
        String prefValue = new DatabasePreferenceStore(Preference.ApplicationId.CM, null).getString(CmPreferenceConstants.CM_LOGGER);
        if (prefValue != null) {
            if ("ALL_ACCOUNTS".equals(prefValue)) {
                myInstance = new CmLogger(logger, null, user);
            } else {
                StringTokenizer st = new StringTokenizer(prefValue, ",");
                HashSet<Account> accounts = new HashSet<Account>();
                while (st.hasMoreTokens()) {
                    try {
                        int accountId = Integer.parseInt(st.nextToken());
                        Account a = Account.findById(accountId);
                        if (a == null) continue;
                        accounts.add(a);
                    }
                    catch (Exception e) {
                        logger.logError("getCmLogger: Unexpected accountId in " + prefValue, e);
                    }
                }
                if (accounts.size() > 0) {
                    myInstance = new CmLogger(logger, accounts, user);
                } else {
                    logger.logError("getCmLogger: No accounts found, no logger instance created.");
                }
            }
        }
    }

    public static CmLogger getCmLogger() {
        return myInstance;
    }
}

