/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBalance;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmCharge;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BundesbankOrderTypes;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebean.Update;
import java.io.File;
import java.util.List;

public class CmDeleter {
    public static void delete(CmStatement s) {
        CmBooking parentBooking;
        Expression expr1 = Expr.eq((String)"statement", (Object)s);
        Expression expr2 = Expr.eq((String)"collective", (Object)true);
        Expression expr = Expr.and((Expression)expr1, (Expression)expr2);
        AwzelEntry.removeBookingReferences(DB.find(CmBooking.class).where(expr1).findIds());
        CmDeleter.removeParentBookingReferences(DB.find(CmBooking.class).where(expr).findIds());
        Expression expr3 = Expr.eq((String)"signedPayments", (Object)true);
        Expression expr4 = Expr.and((Expression)expr1, (Expression)expr3);
        CmDeleter.removeReferencesInSignedPaymentTable(DB.find(CmBooking.class).where(expr4).findIds());
        if (s.isDtiFile() && (parentBooking = CmDeleter.getParentBooking(s)) != null && CmBooking.findChildStatementTypes(parentBooking).size() <= 1) {
            parentBooking.setCollective(false);
            DB.update(parentBooking);
        }
        Update<CmCharge> deleteCharges = DB.createUpdate(CmCharge.class, "DELETE FROM CmCharge WHERE statement=:statement");
        deleteCharges.setParameter("statement", (Object)s.getId());
        deleteCharges.execute();
        Update<CmBooking> deleteBooking = DB.createUpdate(CmBooking.class, "DELETE FROM CmBooking WHERE statement=:statement");
        deleteBooking.setParameter("statement", (Object)s.getId());
        deleteBooking.execute();
        if (s.isHasPages()) {
            for (CmPage p : CmPage.findByStatement(s, true)) {
                CmDeleter.delete(p);
            }
        } else if (s.getFile() != null) {
            if (s.isDtiFile()) {
                File otherFile;
                File workspaceFile = WorkspaceFileSystem.getFile(s.getFile());
                String fileName = workspaceFile.getName();
                Object otherFileName = null;
                if (fileName.endsWith(".ORIGINAL")) {
                    otherFileName = fileName.substring(0, fileName.lastIndexOf("."));
                } else if (fileName.lastIndexOf(".") > 0) {
                    String orderType = fileName.substring(fileName.lastIndexOf(".") + 1);
                    if ("DTI".equals(orderType)) {
                        otherFileName = fileName + ".CONVERTED_MCV";
                    } else if (BundesbankOrderTypes.isValidDtaOrderType(orderType)) {
                        otherFileName = fileName + ".CONVERTED";
                    }
                }
                if (otherFileName != null && !(otherFile = new File(workspaceFile.getParentFile(), (String)otherFileName)).delete()) {
                    otherFile.deleteOnExit();
                }
            }
            WorkspaceFileSystem.delete(s.getFile());
        }
        Update<CmCheck> deleteCheck = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE statement=:statement");
        deleteCheck.setParameter("statement", (Object)s.getId());
        deleteCheck.execute();
        DB.delete(CmStatement.class, s.getId());
    }

    public static void delete(CmPage p) {
        Expression expr1 = Expr.eq((String)"page", (Object)p);
        Expression expr2 = Expr.eq((String)"collective", (Object)true);
        Expression expr = Expr.and((Expression)expr1, (Expression)expr2);
        AwzelEntry.removeBookingReferences(DB.find(CmBooking.class).where(expr1).findIds());
        CmDeleter.removeParentBookingReferences(DB.find(CmBooking.class).where(expr).findIds());
        WorkspaceFileSystem.delete(p.getFile());
        Update<CmCharge> deleteCharges = DB.createUpdate(CmCharge.class, "DELETE FROM CmCharge WHERE page=:page");
        deleteCharges.setParameter("page", (Object)p.getId());
        deleteCharges.execute();
        Update<CmBooking> delete = DB.createUpdate(CmBooking.class, "DELETE FROM CmBooking WHERE page=:page");
        delete.setParameter("page", (Object)p.getId());
        delete.execute();
        Update<CmCheck> delete2 = DB.createUpdate(CmCheck.class, "DELETE FROM CmCheck WHERE page=:page");
        delete2.setParameter("page", (Object)p.getId());
        delete2.execute();
        DB.delete(CmPage.class, p.getId());
    }

    private static void removeParentBookingReferences(List<Object> parentBookingIds) {
        SqlUpdate update = DB.sqlUpdate("update cm_booking set parent_booking_id=null where parent_booking_id=:id");
        for (Object bookingId : parentBookingIds) {
            update.setParameter("id", bookingId);
            update.execute();
        }
    }

    private static void removeReferencesInSignedPaymentTable(List<Object> parentBookingIds) {
        SqlUpdate update = DB.sqlUpdate("update pmt_signed set booking_id=null where booking_id=:id");
        for (Object bookingId : parentBookingIds) {
            update.setParameter("id", bookingId);
            update.execute();
        }
    }

    private static CmBooking getParentBooking(CmStatement s) {
        CmBooking booking = (CmBooking)DB.find(CmBooking.class).where().eq("statement", (Object)s).setMaxRows(1).findOne();
        if (booking != null) {
            return booking.getParentBooking();
        }
        return null;
    }

    public static void deleteObsoleteAdvices(List<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        try (Transaction t = DB.beginTransaction();){
            for (Integer id : ids) {
                CmStatement statement = DB.find(CmStatement.class, id);
                if (statement == null) continue;
                CmDeleter.delete(statement);
            }
            t.commit();
        }
    }

    public static boolean deleteBank(BankSettings bank, IProgressMonitorWrapper progress) {
        List statementList;
        do {
            if ((statementList = CmStatement.findByBank(bank).setMaxRows(100).findList()).isEmpty()) continue;
            for (CmStatement statement : statementList) {
                CmDeleter.delete(statement);
                if (!progress.isCanceled()) continue;
                return false;
            }
        } while (!statementList.isEmpty());
        List<Account> list = Account.findAccountsForBank(bank);
        for (Account a : list) {
            Update<CmBalance> update = DB.createUpdate(CmBalance.class, "DELETE FROM CmBalance WHERE account=:account");
            update.setParameter("account", (Object)a.getId());
            update.execute();
        }
        CmBank.deleteAll(bank);
        return true;
    }
}

