/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.CmPdfStatement;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CmDeleter;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.IProgressMonitorWrapper;
import io.ebean.Query;
import io.ebean.Transaction;
import java.io.File;
import java.sql.Date;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CmCleanUp {
    private int countStatements = 0;
    private int countAdvices = 0;
    private int countDtiFiles = 0;
    private int countBkaStatements = 0;
    private int countExportedFiles = 0;
    private boolean refreshAccountOverview = false;
    private boolean refreshDTIOverview = false;
    private boolean refreshBkaView = false;
    private final Set<Integer> allStatementIds = new HashSet<Integer>();
    private Query<CmPdfStatement> bkaQuery;
    private Query<ExportFile> exportFileQuery;
    private boolean findDataWasCalled = false;

    public void findDataToDelete(DatabasePreferenceStore store) {
        Date oldest;
        int age;
        CmStatement.CleanupDateType cleanupDateType;
        this.findDataWasCalled = true;
        try {
            cleanupDateType = CmStatement.CleanupDateType.valueOf(store.getString(CmPreferenceConstants.CLEANUP_DATE_TYPE));
        }
        catch (Exception e) {
            cleanupDateType = CmStatement.CleanupDateType.STATEMENT_DATE;
        }
        this.countStatements = 0;
        this.countAdvices = 0;
        this.countDtiFiles = 0;
        this.countBkaStatements = 0;
        if (store.getBoolean(CmPreferenceConstants.CLEAN_STATEMENTS)) {
            int unit = store.getInt(CmPreferenceConstants.CLEAN_STATEMENTS_UNIT);
            age = store.getInt(CmPreferenceConstants.CLEAN_STATEMENTS_AGE);
            oldest = new Date(Util.computeFromNow(age, unit).getTimeInMillis());
            Set<Integer> statementIds = CmStatement.findOldStatementIds(cleanupDateType, oldest, CmStatement.StatementTypes);
            this.countStatements = statementIds.size();
            this.allStatementIds.addAll(statementIds);
            boolean bl = this.refreshAccountOverview = this.countStatements > 0;
        }
        if (store.getBoolean(CmPreferenceConstants.CLEAN_ADVICES)) {
            int unit = store.getInt(CmPreferenceConstants.CLEAN_ADVICES_UNIT);
            age = store.getInt(CmPreferenceConstants.CLEAN_ADVICES_AGE);
            oldest = new Date(Util.computeFromNow(age, unit).getTimeInMillis());
            Set<Integer> adviceIds = CmStatement.findOldStatementIds(cleanupDateType, oldest, CmStatement.AdviceTypes);
            this.countAdvices = adviceIds.size();
            this.allStatementIds.addAll(adviceIds);
            boolean bl = this.refreshAccountOverview = this.refreshAccountOverview || this.countAdvices > 0;
        }
        if (store.getBoolean(CmPreferenceConstants.CLEAN_DTI_FILES)) {
            int unit = store.getInt(CmPreferenceConstants.CLEAN_DTI_FILES_UNIT);
            age = store.getInt(CmPreferenceConstants.CLEAN_DTI_FILES_AGE);
            oldest = new Date(Util.computeFromNow(age, unit).getTimeInMillis());
            Set<Integer> dtiIds = CmStatement.findOldStatementIds(cleanupDateType, oldest, CmStatement.DtiTypes);
            this.countDtiFiles = dtiIds.size();
            this.allStatementIds.addAll(dtiIds);
            boolean bl = this.refreshDTIOverview = this.countDtiFiles > 0;
        }
        if (store.getBoolean(CmPreferenceConstants.CLEAN_BKA_STATEMENTS)) {
            int unit = store.getInt(CmPreferenceConstants.CLEAN_BKA_STATEMENTS_UNIT);
            age = store.getInt(CmPreferenceConstants.CLEAN_BKA_STATEMENTS_AGE);
            oldest = new Date(Util.computeFromNow(age, unit).getTimeInMillis());
            this.bkaQuery = CmPdfStatement.findOldStatements(oldest);
            this.countBkaStatements = this.bkaQuery.findCount();
            this.refreshBkaView = this.countBkaStatements > 0;
        } else {
            this.bkaQuery = null;
        }
        if (store.getBoolean(CmPreferenceConstants.CLEAN_EXPORTED_FILES)) {
            int unit = store.getInt(CmPreferenceConstants.CLEAN_EXPORTED_FILES_UNIT);
            age = store.getInt(CmPreferenceConstants.CLEAN_EXPORTED_FILES_AGE);
            oldest = new Date(Util.computeFromNow(age, unit).getTimeInMillis());
            this.exportFileQuery = ExportFile.findOldFiles(oldest);
            this.countExportedFiles = this.exportFileQuery.findCount();
        } else {
            this.exportFileQuery = null;
        }
    }

    public boolean doCleanup(DatabasePreferenceStore store, IProgressMonitorWrapper monitor) {
        if (!this.findDataWasCalled) {
            this.findDataToDelete(store);
        }
        monitor.beginTask(Messages.getString("PreferencePage.cleanUp.title", new Object[0]), this.countStatements + this.countAdvices + this.countDtiFiles + this.countBkaStatements + this.countExportedFiles);
        if (!this.deleteStatements(monitor, this.allStatementIds)) {
            return false;
        }
        if (!this.deletePdfStatements(monitor, this.bkaQuery)) {
            return false;
        }
        if (!this.deleteExportedFiles(monitor, this.exportFileQuery)) {
            return false;
        }
        if (store.getBoolean(CmPreferenceConstants.CLEAN_EMPTY_DIRECTORIES)) {
            CmCleanUp.removeEmptyDirectories(WorkspaceFileSystem.CM_DIRECTORY);
            CmCleanUp.removeEmptyDirectories(WorkspaceFileSystem.DTI_DIRECTORY);
        }
        this.findDataWasCalled = false;
        return true;
    }

    private boolean deleteExportedFiles(IProgressMonitorWrapper monitor, Query<ExportFile> exportFileQuery) {
        if (exportFileQuery == null) {
            return true;
        }
        List files = exportFileQuery.findList();
        for (ExportFile ef : files) {
            WorkspaceFileSystem.delete(ef.getWorkspaceFile());
        }
        DB.deleteAll(files);
        try (Transaction t = DB.beginTransaction();){
            List list = DB.find(ExportFile.class).findList();
            for (ExportFile e : list) {
                File tmp = WorkspaceFileSystem.toFile(e.getWorkspaceFile());
                if (tmp.exists()) continue;
                CmCleanUp.delete(e);
            }
            t.commit();
        }
        return true;
    }

    public static void deleteDBOnly(ExportFile e) {
        if (e != null) {
            e.setWorkspaceFile(null);
            e.getExports().clear();
            e.getAccounts().clear();
            e.save();
            DB.delete(e);
        }
    }

    public static void delete(ExportFile e) {
        if (e != null) {
            WorkspaceFileSystem.delete(e.getWorkspaceFile());
            CmCleanUp.deleteDBOnly(e);
        }
    }

    private boolean deleteStatements(IProgressMonitorWrapper monitor, Set<Integer> ids) {
        if (ids == null || ids.size() == 0) {
            return true;
        }
        for (Integer id : ids) {
            CmStatement statement = CmStatement.findById(id);
            if (statement == null) continue;
            if (monitor.isCanceled()) {
                return false;
            }
            CmDeleter.delete(statement);
            monitor.worked(1);
        }
        return true;
    }

    public boolean deleteStatements(IProgressMonitorWrapper monitor, Collection<CmStatement> statements) {
        if (statements == null || statements.size() == 0) {
            return true;
        }
        monitor.beginTask(Messages.getString("PreferencePage.cleanUp.title", new Object[0]), statements.size());
        for (CmStatement statement : statements) {
            if (statement == null) continue;
            if (monitor.isCanceled()) {
                return false;
            }
            CmDeleter.delete(statement);
            ++this.countStatements;
            monitor.worked(1);
        }
        return true;
    }

    private boolean deletePdfStatements(IProgressMonitorWrapper monitor, Query<CmPdfStatement> query) {
        List statementsList;
        if (query == null) {
            return true;
        }
        do {
            statementsList = query.setMaxRows(100).findList();
            for (CmPdfStatement statement : statementsList) {
                if (monitor.isCanceled()) {
                    return false;
                }
                WorkspaceFileSystem.delete(statement.getLocalFile());
                DB.delete(statement);
                monitor.worked(1);
            }
        } while (!statementsList.isEmpty());
        return true;
    }

    private static boolean removeEmptyDirectories(File directory) {
        File[] subdir = directory.listFiles();
        if (subdir == null || subdir.length == 0) {
            return directory.delete();
        }
        boolean allDeleted = true;
        for (File f : subdir) {
            allDeleted = f.isDirectory() ? CmCleanUp.removeEmptyDirectories(f) && allDeleted : false;
        }
        if (allDeleted) {
            return directory.delete();
        }
        return false;
    }

    public int getCountStatements() {
        return this.countStatements;
    }

    public int getCountAdvices() {
        return this.countAdvices;
    }

    public int getCountDtiFiles() {
        return this.countDtiFiles;
    }

    public int getCountBkaStatements() {
        return this.countBkaStatements;
    }

    public int getCountExportedFiles() {
        return this.countExportedFiles;
    }

    public boolean isRefreshAccountOverview() {
        return this.refreshAccountOverview;
    }

    public boolean isRefreshDTIOverview() {
        return this.refreshDTIOverview;
    }

    public boolean isRefreshBkaView() {
        return this.refreshBkaView;
    }
}

