/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmCharge;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.format.camt05x.Booking;
import de.businesslogics.format.camt05x.ChargeRecord;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.List;

public abstract class Camt05XProcessing
extends CMProcessingDb
implements ZipProcessing {
    protected String originalFilename;
    private ZipProcessingResult processingResult;

    public ZipProcessingResult getProcessingResult() {
        return this.processingResult;
    }

    protected Camt05XProcessing(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(logger, encrypt, preferences);
    }

    protected Camt05XProcessing(CmStatement.Type type, BankSettings bank, CmReporter reporter, String formatDirName, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(bank, reporter, formatDirName, logger, encrypt, preferences);
    }

    protected Account findOrCreateAccount(String accountIdentifier, Currency currency) throws IOException {
        this.accountIdentifier = accountIdentifier;
        this.currency = currency;
        return this.findOrCreateAccount();
    }

    @Override
    protected Account findOrCreateAccount() {
        if (IbanUtil.checkIban(this.accountIdentifier)) {
            return Camt05XProcessing.findOrCreateAccountByIban(this.bank, this.accountIdentifier, this.currency);
        }
        return Camt05XProcessing.findOrCreateAccountByCmIdentifier(this.bank, this.accountIdentifier, this.currency);
    }

    @Override
    public void process(InputStream in) throws Exception {
        ZipHandler zipHandler = new ZipHandler(this, this.logger);
        zipHandler.process(in);
        this.processingResult = zipHandler.getProcessingResult();
    }

    protected CmBooking findOrCreateBooking(CmStatement s, CmPage page, int pos, Booking booking, CmBooking parent, boolean collective) {
        CmBooking b = CMProcessingDb.findBooking(s, page, pos);
        if (b == null) {
            b = new CmBooking();
            b.setPos(pos);
        }
        this.processBookingData(b, s, page, booking, parent, collective);
        if (b.getId() == null) {
            DB.save(b);
        } else {
            DB.update(b);
        }
        return b;
    }

    protected abstract void processBookingData(CmBooking var1, CmStatement var2, CmPage var3, Booking var4, CmBooking var5, boolean var6);

    protected final void setBookingData(CmBooking b, CmStatement s, CmPage page, Booking booking, CmBooking parentBooking, boolean collective) {
        String purposeCode;
        Currency convertedCurrency;
        java.util.Date date;
        b.setAccount(this.latestAccount);
        b.setStatement(s);
        b.setPage(page);
        b.setParentBooking(parentBooking);
        b.setCollective(collective);
        b.setAmount(booking.getAmount());
        if (booking.getCurrency() != null) {
            b.setCurrency(booking.getCurrency());
        }
        if (booking.getBookingDate() != null) {
            b.setBookingDate(new Date(booking.getBookingDate().getTime()));
        } else {
            b.setBookingDate(this.getBookingDateFromStatement(s));
        }
        if (booking.getValueDate() != null) {
            b.setValueDate(new Date(booking.getValueDate().getTime()));
        }
        b.setSts(booking.getStatus());
        b.setTransactionCode(booking.getTransactionCode());
        b.setBookingKey(booking.getBookingKey());
        b.setGvc(booking.getGvc());
        b.setPrimanota(booking.getPrimanota());
        b.setTextKeyAppendix(booking.getTextKeyAppendix());
        b.setDomainCode(booking.getDomainCode());
        b.setFamilyCode(booking.getFamilyCode());
        b.setSubFamilyCode(booking.getSubFamilyCode());
        String customerRef = booking.getDtiReference();
        if (customerRef != null && customerRef.length() > 19 && PaymentUtils.isBIC(customerRef.substring(0, 11)) && (date = CMProcessingDb.startsWithYYYYMMDD(customerRef = customerRef.substring(11))) != null) {
            b.setCustomerReferenceDate(new Date(date.getTime()));
            customerRef = customerRef.substring(8);
        }
        b.setCustomerReference(customerRef);
        b.setMsgId(booking.getMsgId());
        b.setPmtInfId(booking.getPmtInfId());
        b.setEndToEndId(booking.getEndToEndId());
        b.setTransactionId(booking.getTransactionId());
        b.setInstrId(booking.getInstructionId());
        b.setBankReference(booking.getBankReference());
        b.setAdditionalInformation(booking.getAdditionalInformation());
        Currency originalCurrency = booking.getOriginalCurrency();
        if (originalCurrency != null) {
            b.setOriginalAmount(booking.getOriginalAmount());
            b.setOriginalCurrency(originalCurrency.getCurrencyCode());
        }
        if ((convertedCurrency = booking.getConvertedCurrency()) != null) {
            b.setConvertedAmount(booking.getConvertedAmount());
            b.setConvertedCurrency(convertedCurrency.getCurrencyCode());
        }
        b.setExchangeRate(booking.getExchangeRate());
        if (booking.getTotalChargesCurrencyCode() != null) {
            b.setChargesAmount(booking.getTotalChargesAmount());
            b.setChargesCurrency(booking.getTotalChargesCurrencyCode());
        } else if (booking.getCalculatedTotalChargesCurrencyCode() != null) {
            b.setChargesAmount(booking.getCalculatedTotalChargesAmount());
            b.setChargesCurrency(booking.getCalculatedTotalChargesCurrencyCode());
        }
        b.setCounterParty(booking.getCounterParty());
        b.setCounterPartyAccountNumber(booking.getCounterPartyAccount());
        b.setCounterPartyBankCode(booking.getCounterPartyBankCode());
        b.setUltimateCounterParty(booking.getUltimateCounterParty());
        b.setLocalParty(booking.getLocalParty());
        b.setLocalPartyAccountNumber(booking.getLocalPartyAccount());
        b.setLocalPartyBankCode(booking.getLocalPartyBankCode());
        b.setUltimateLocalParty(booking.getUltimateLocalParty());
        String[] purpose = booking.getPurpose();
        b.setPurpose(StringUtils.shorten(StringUtils.getStringFromStringArray(purpose, "\n"), 400));
        if (purpose != null) {
            b.setPurposeOverview(StringUtils.shorten(purpose[0], 140));
        }
        if ((purposeCode = booking.getPurposeCode()) != null) {
            b.setPurposeCode(purposeCode);
        }
        b.setReversal(booking.isReversal());
        if (booking.getRejectionCode() != null) {
            b.setRejectionCauseCode(booking.getRejectionCode());
        }
        String mandateReference = StringUtils.checkNullAndTrim(booking.getMandateId());
        String counterPartyCreditorId = StringUtils.checkNullAndTrim(booking.getCounterPartyCreditorId());
        String localPartyCreditorId = StringUtils.checkNullAndTrim(booking.getLocalPartyCreditorId());
        if (counterPartyCreditorId.length() > 0) {
            b.setCounterPartyCreditorId(counterPartyCreditorId);
            if (mandateReference.length() > 0) {
                b.setLocalPartyMandateReference(mandateReference);
            }
        }
        if (localPartyCreditorId.length() > 0) {
            b.setLocalPartyCreditorId(localPartyCreditorId);
            if (mandateReference.length() > 0) {
                b.setCounterPartyMandateReference(mandateReference);
            }
        }
        b.setDebit(booking.isDirectDebit());
        b.setNtryRef(booking.getNtryRef());
        b.setCountTransactions(booking.getNbOfTxs());
    }

    protected abstract Date getBookingDateFromStatement(CmStatement var1);

    protected void createChargeRecords(CmBooking b, CmStatement s, CmPage p, List<ChargeRecord> chargeRecords) {
        for (ChargeRecord chargeRecord : chargeRecords) {
            this.createChargeRecord(b, s, p, chargeRecord);
        }
    }

    protected void createChargeRecord(CmBooking b, CmStatement s, CmPage p, ChargeRecord chargeRecord) {
        CmCharge c = new CmCharge();
        c.setBooking(b);
        c.setStatement(s);
        c.setPage(p);
        c.setAmount(chargeRecord.getAmount());
        c.setCurrencyCode(chargeRecord.getCurrencyCode());
        c.setRate(chargeRecord.getRate());
        c.setIncluded(chargeRecord.isIncluded());
        c.setBankIdentification(chargeRecord.getBankIdentification());
        c.setType(chargeRecord.getType());
        c.setChargeBearerType(chargeRecord.getChargeBearerType());
        c.setTaxIdentification(chargeRecord.getTaxIdentification());
        c.setTaxAmount(chargeRecord.getTaxAmount());
        c.setTaxCurrencyCode(chargeRecord.getTaxCurrencyCode());
        c.setTaxRate(chargeRecord.getTaxRate());
        DB.save(c);
    }

    public static String shorten(String in, int maxLengh) {
        if (in == null) {
            return null;
        }
        if (in.length() <= maxLengh) {
            return in;
        }
        return in.substring(0, maxLengh);
    }
}

