/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.ZipHandler;
import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.mt940.api.Camt053Processing;
import de.businesslogics.banking.mt940.api.Camt054ProcessingApi;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt053.Camt05300104Statement;
import de.businesslogics.format.camt053.Camt05300108Statement;
import de.businesslogics.format.camt053.Camt053Statement;
import de.businesslogics.format.camt054.Camt05400104Statement;
import de.businesslogics.format.camt054.Camt05400108Statement;
import de.businesslogics.format.camt054.Camt054Statement;
import de.businesslogics.format.iso20022.camt05400104.Document;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class Camt05XAutomaticImportProcessing
implements ZipProcessing {
    private static final String logPrefix = "Automatic Import - ";
    private static final String camt05300108 = "camt.053.001.08";
    private static final String camt05300104 = "camt.053.001.04";
    private static final String camt05300102 = "camt.053.001.02";
    private static final String camt05400108 = "camt.054.001.08";
    private static final String camt05400104 = "camt.054.001.04";
    private static final String camt05400102 = "camt.054.001.02";
    private boolean importedFileCompletely;
    private final BLLogger logger;
    private final EncryptData encrypt;
    private final DatabasePreferenceStore preferences;
    private final Set<Account> userAccounts;
    private final CmReporter c53Reporter;
    private final CmReporter c54Reporter;
    final List<StatementBookingReportHandler> reportHandlers;
    private String fileName;
    private String zipEntryName;
    private String scheme;
    private ZipProcessingResult processingResult;

    public ZipProcessingResult getProcessingResult() {
        return this.processingResult;
    }

    public Camt05XAutomaticImportProcessing(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, Set<Account> userAccounts, CmReporter c53Reporter, CmReporter c54Reporter, List<StatementBookingReportHandler> reportHandlers) {
        this.logger = logger;
        this.encrypt = encrypt;
        this.preferences = preferences;
        this.userAccounts = userAccounts;
        this.c53Reporter = c53Reporter;
        this.c54Reporter = c54Reporter;
        this.reportHandlers = reportHandlers;
    }

    public void process(InputStream in, File file) throws Exception {
        this.fileName = file.getAbsolutePath();
        this.zipEntryName = null;
        this.importedFileCompletely = true;
        try {
            ZipHandler zipHandler = new ZipHandler(this, this.logger);
            zipHandler.process(in);
            this.processingResult = zipHandler.getProcessingResult();
        }
        catch (Exception e) {
            this.importedFileCompletely = false;
            if (this.logger != null) {
                this.logger.logError("Automatic Import - Error during import processing of file " + file.getAbsolutePath(), e);
            }
            throw e;
        }
    }

    public boolean importedFileCompletely() {
        return this.importedFileCompletely;
    }

    @Override
    public void processUnzipped(String zipEntryName, InputStream in) throws Exception {
        this.zipEntryName = zipEntryName;
        EbicsElement e = this.getDocument(in);
        if (e instanceof de.businesslogics.format.iso20022.camt05300108.Document) {
            this.scheme = camt05300108;
            this.importCamt05300108(Camt05300108Statement.loadStatements((de.businesslogics.format.iso20022.camt05300108.Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05300104.Document) {
            this.scheme = camt05300104;
            this.importCamt05300104(Camt05300104Statement.loadStatements((de.businesslogics.format.iso20022.camt05300104.Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05300102.Document) {
            this.scheme = camt05300102;
            this.importCamt05300102(Camt053Statement.loadStatements((de.businesslogics.format.iso20022.camt05300102.Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05400108.Document) {
            this.scheme = camt05400108;
            this.importCamt05400108(Camt05400108Statement.loadStatements((de.businesslogics.format.iso20022.camt05400108.Document)e));
        } else if (e instanceof Document) {
            this.scheme = camt05400104;
            this.importCamt05400104(Camt05400104Statement.loadStatements((Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05400102.Document) {
            this.scheme = camt05400102;
            this.importCamt05400102(Camt054Statement.loadStatements((de.businesslogics.format.iso20022.camt05400102.Document)e));
        } else {
            throw new IOException("Unsupported camt.05x version");
        }
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05300108.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05300104.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05300102.Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05400108.Document.class);
        p.addPossibleRoot(Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05400102.Document.class);
        return EbicsHandler.parse(in, p);
    }

    private void importCamt05300108(List<Camt05300108Statement> statements) {
        HashMap bankStatementsMap = new HashMap();
        for (Camt05300108Statement statement : statements) {
            Account account = this.getAccountForImport(statement.getAccountIdentifier(), statement.getCurrency(), statement.getMessageId());
            if (account != null) {
                this.addToBankStatementsMap(account.getBank(), statement, bankStatementsMap);
                continue;
            }
            this.importedFileCompletely = false;
        }
        int oldCount = this.c53Reporter.size();
        for (BankSettings bank : bankStatementsMap.keySet()) {
            Camt053Processing processing = new Camt053Processing(bank, this.c53Reporter, this.logger, this.encrypt, this.preferences);
            List statementList = (List)bankStatementsMap.get(bank);
            try {
                processing.processCamt05300108(statementList);
                this.writeImportLog(this.c53Reporter.size() - oldCount);
            }
            catch (Exception e) {
                this.writeErrorLog(e);
                this.importedFileCompletely = false;
            }
        }
    }

    private void importCamt05300104(List<Camt05300104Statement> statements) {
        HashMap bankStatementsMap = new HashMap();
        for (Camt05300104Statement statement : statements) {
            Account account = this.getAccountForImport(statement.getAccountIdentifier(), statement.getCurrency(), statement.getMessageId());
            if (account != null) {
                this.addToBankStatementsMap(account.getBank(), statement, bankStatementsMap);
                continue;
            }
            this.importedFileCompletely = false;
        }
        int oldCount = this.c53Reporter.size();
        for (BankSettings bank : bankStatementsMap.keySet()) {
            Camt053Processing processing = new Camt053Processing(bank, this.c53Reporter, this.logger, this.encrypt, this.preferences);
            List statementList = (List)bankStatementsMap.get(bank);
            try {
                processing.processCamt05300104(statementList);
                this.writeImportLog(this.c53Reporter.size() - oldCount);
            }
            catch (Exception e) {
                this.writeErrorLog(e);
                this.importedFileCompletely = false;
            }
        }
    }

    private void importCamt05300102(List<Camt053Statement> statements) {
        HashMap bankStatementsMap = new HashMap();
        for (Camt053Statement statement : statements) {
            Account account = this.getAccountForImport(statement.getAccountIdentifier(), statement.getCurrency(), statement.getMessageId());
            if (account != null) {
                this.addToBankStatementsMap(account.getBank(), statement, bankStatementsMap);
                continue;
            }
            this.importedFileCompletely = false;
        }
        int oldCount = this.c53Reporter.size();
        for (BankSettings bank : bankStatementsMap.keySet()) {
            Camt053Processing processing = new Camt053Processing(bank, this.c53Reporter, this.logger, this.encrypt, this.preferences);
            List statementList = (List)bankStatementsMap.get(bank);
            try {
                processing.processCamt05300102(statementList);
                this.writeImportLog(this.c53Reporter.size() - oldCount);
            }
            catch (Exception e) {
                this.writeErrorLog(e);
                this.importedFileCompletely = false;
            }
        }
    }

    private void importCamt05400108(List<Camt05400108Statement> statements) {
        HashMap bankStatementsMap = new HashMap();
        for (Camt05400108Statement statement : statements) {
            Account account = this.getAccountForImport(statement.getAccountIdentifier(), statement.getCurrency(), statement.getMessageId());
            if (account != null) {
                this.addToBankStatementsMap(account.getBank(), statement, bankStatementsMap);
                continue;
            }
            this.importedFileCompletely = false;
        }
        int oldCount = this.c54Reporter.size();
        for (BankSettings bank : bankStatementsMap.keySet()) {
            Camt054ProcessingApi processing = new Camt054ProcessingApi(bank, this.c54Reporter, this.logger, this.encrypt, this.preferences, this.reportHandlers);
            List statementList = (List)bankStatementsMap.get(bank);
            try {
                processing.processCamt05400108(statementList);
                this.writeImportLog(this.c54Reporter.size() - oldCount);
            }
            catch (Exception e) {
                this.writeErrorLog(e);
                this.importedFileCompletely = false;
            }
        }
    }

    private void importCamt05400104(List<Camt05400104Statement> statements) {
        HashMap bankStatementsMap = new HashMap();
        for (Camt05400104Statement statement : statements) {
            Account account = this.getAccountForImport(statement.getAccountIdentifier(), statement.getCurrency(), statement.getMessageId());
            if (account != null) {
                this.addToBankStatementsMap(account.getBank(), statement, bankStatementsMap);
                continue;
            }
            this.importedFileCompletely = false;
        }
        int oldCount = this.c54Reporter.size();
        for (BankSettings bank : bankStatementsMap.keySet()) {
            Camt054ProcessingApi processing = new Camt054ProcessingApi(bank, this.c54Reporter, this.logger, this.encrypt, this.preferences, this.reportHandlers);
            List statementList = (List)bankStatementsMap.get(bank);
            try {
                processing.processCamt05400104(statementList);
                this.writeImportLog(this.c54Reporter.size() - oldCount);
            }
            catch (Exception e) {
                this.writeErrorLog(e);
                this.importedFileCompletely = false;
            }
        }
    }

    private void importCamt05400102(List<Camt054Statement> statements) {
        HashMap bankStatementsMap = new HashMap();
        for (Camt054Statement statement : statements) {
            Account account = this.getAccountForImport(statement.getAccountIdentifier(), statement.getCurrency(), statement.getMessageId());
            if (account != null) {
                this.addToBankStatementsMap(account.getBank(), statement, bankStatementsMap);
                continue;
            }
            this.importedFileCompletely = false;
        }
        int oldCount = this.c54Reporter.size();
        for (BankSettings bank : bankStatementsMap.keySet()) {
            Camt054ProcessingApi processing = new Camt054ProcessingApi(bank, this.c54Reporter, this.logger, this.encrypt, this.preferences, this.reportHandlers);
            List statementList = (List)bankStatementsMap.get(bank);
            try {
                processing.processCamt05400102(statementList);
                this.writeImportLog(this.c54Reporter.size() - oldCount);
            }
            catch (Exception e) {
                this.writeErrorLog(e);
                this.importedFileCompletely = false;
            }
        }
    }

    private <T> void addToBankStatementsMap(BankSettings bank, T statement, Map<BankSettings, List<T>> bankStatementsMap) {
        List<T> statements = bankStatementsMap.get(bank);
        if (statements == null) {
            statements = new ArrayList<T>();
            bankStatementsMap.put(bank, statements);
        }
        statements.add(statement);
    }

    private Account getAccountForImport(String iban, Currency c, String statementIdentifier) {
        String currency = c != null ? c.getCurrencyCode() : null;
        List<Account> accounts = Account.findAccountsByIban(iban, currency);
        if (accounts == null || accounts.size() == 0) {
            if (currency != null) {
                this.logger.logWarning(logPrefix + this.scheme + " statement from " + this.getFileInfo() + " could not be imported. Account with IBAN " + iban + " and currency " + currency + " does not exist.");
            } else {
                this.logger.logWarning(logPrefix + this.scheme + " statement from file " + this.fileName + " could not be imported. Account with IBAN " + iban + " does not exist.");
            }
            return null;
        }
        if (accounts.size() > 1) {
            if (currency != null) {
                this.logger.logWarning(logPrefix + this.scheme + " statement from " + this.getFileInfo() + " could not be imported. Multiple accounts with IBAN " + iban + " and currency " + currency + " exist (at different banks).");
            } else {
                this.logger.logWarning(logPrefix + this.scheme + " statement with msgId " + statementIdentifier + " from " + this.getFileInfo() + " could not be imported. Multiple accounts with IBAN " + iban + " and currency " + currency + " exist (at different banks).");
            }
            return null;
        }
        Account account = accounts.get(0);
        if (this.userAccounts.contains(account)) {
            return account;
        }
        this.logger.logWarning(logPrefix + this.scheme + " statement with msgId " + statementIdentifier + " from " + this.getFileInfo() + " could not be imported. User has no permission for account with IBAN " + iban);
        return null;
    }

    private void writeImportLog(int countImportedStatements) {
        if (countImportedStatements > 0) {
            this.logger.logInfo("Automatic Import - Imported " + countImportedStatements + " " + this.scheme + " statements from " + this.getFileInfo());
        }
    }

    private void writeErrorLog(Exception e) {
        this.logger.logError("Automatic Import - Error during import of " + this.getFileInfo(), e);
    }

    private String getFileInfo() {
        if (this.zipEntryName != null) {
            return this.zipEntryName + " of zip-File " + this.fileName;
        }
        return this.fileName;
    }
}

