/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.Camt05400104Writer;
import de.businesslogics.banking.mt940.api.Camt05400108Writer;
import de.businesslogics.banking.mt940.api.Camt054Writer;
import de.businesslogics.banking.mt940.api.Camt05XProcessing;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.CmReporterApi;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt054.Camt05400104Booking;
import de.businesslogics.format.camt054.Camt05400104Statement;
import de.businesslogics.format.camt054.Camt05400108Booking;
import de.businesslogics.format.camt054.Camt05400108Statement;
import de.businesslogics.format.camt054.Camt054Booking;
import de.businesslogics.format.camt054.Camt054Statement;
import de.businesslogics.format.camt05x.Booking;
import de.businesslogics.format.iso20022.camt05400102.EntryDetails1;
import de.businesslogics.format.iso20022.camt05400102.EntryTransaction2;
import de.businesslogics.format.iso20022.camt05400102.ReportEntry2;
import de.businesslogics.format.iso20022.camt05400104.Document;
import de.businesslogics.format.iso20022.camt05400104.EntryDetails3;
import de.businesslogics.format.iso20022.camt05400104.EntryTransaction4;
import de.businesslogics.format.iso20022.camt05400104.ReportEntry4;
import de.businesslogics.format.iso20022.camt05400108.EntryDetails9;
import de.businesslogics.format.iso20022.camt05400108.EntryTransaction10;
import de.businesslogics.format.iso20022.camt05400108.ReportEntry10;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.io.Streams;
import de.businesslogics.task.Substitution;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.SystemUtils;
import io.ebean.Transaction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt054ProcessingApi
extends Camt05XProcessing
implements Processing {
    public static final String C54 = "C54";
    public static final String FORMAT_NAME = "camt.054";
    private final SimpleDateFormat yyyyMMddHHmmFormat = new SimpleDateFormat("yyyyMMddHHmm");
    private final List<StatementBookingReportHandler> reportHandlers;

    public Camt054ProcessingApi(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(logger, encrypt, preferences);
        this.setNamePrefix(WorkspaceFileSystem.DTI_DIRECTORY.toString());
        this.reportHandlers = reportHandlers;
    }

    public Camt054ProcessingApi(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences, List<StatementBookingReportHandler> reportHandlers) {
        super(logger, encrypt, preferences);
        this.setNamePrefix(WorkspaceFileSystem.DTI_DIRECTORY.toString());
        this.initialize(bank, reporter);
        this.reportHandlers = reportHandlers;
    }

    private void initialize(BankSettings bank, CmReporter reporter) {
        this.bank = bank;
        this.reporter = reporter;
        this.accountParentDir = new File(WorkspaceFileSystem.DTI_DIRECTORY, bank.getUniqueKey());
        this.accountParentDir.mkdirs();
    }

    protected CmReporter getReporter() {
        return new CmReporterApi(CmReporter.Mode.FETCH_DTI, FORMAT_NAME, this.logger, this.encrypt, this.preferences.getUser(), this.reportHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        InputStream in = null;
        try (Transaction t = DB.beginTransaction();){
            this.initialize(item.getBank(), this.getReporter());
            Util.writeCMStatisticLog(this.logger);
            long startTime = System.currentTimeMillis();
            in = this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));
            this.process(in);
            Util.writePerformanceLogStartTime(this.logger, this.getClass(), "doPostProcessing-process", startTime);
            startTime = System.currentTimeMillis();
            t.commit();
            Util.writePerformanceLogStartTime(this.logger, this.getClass(), "doPostProcessing-commit", startTime);
            Util.writeCMStatisticLog(this.logger);
        }
        catch (Throwable throwable) {
            Util.closeStream(in);
            throw throwable;
        }
        Util.closeStream(in);
        this.reporter.finishProcessing(this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES));
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        this.originalFilename = originalFilename;
        EbicsElement e = this.getDocument(in);
        if (e instanceof de.businesslogics.format.iso20022.camt05400102.Document) {
            this.processCamt05400102(Camt054Statement.loadStatements((de.businesslogics.format.iso20022.camt05400102.Document)e));
        } else if (e instanceof Document) {
            this.processCamt05400104(Camt05400104Statement.loadStatements((Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05400108.Document) {
            this.processCamt05400108(Camt05400108Statement.loadStatements((de.businesslogics.format.iso20022.camt05400108.Document)e));
        } else {
            throw new IOException("Unsupported Camt053 version");
        }
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05400102.Document.class);
        p.addPossibleRoot(Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05400108.Document.class);
        return EbicsHandler.parse(in, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCamt05400102(List<Camt054Statement> statements) throws Exception {
        long startTime = System.currentTimeMillis();
        int countStatements = statements.size();
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processUnzipped - loading of " + countStatements + " statements from file", startTime);
        startTime = System.currentTimeMillis();
        if (this.existingFile != null) {
            for (Camt054Statement s : statements) {
                this.processCamt054(s, countStatements);
            }
        } else {
            Camt054Writer w = new Camt054Writer();
            for (Camt054Statement s : statements) {
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    w.write(s, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processCamt054(s, countStatements);
            }
        }
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processUnzipped - processing of statements", startTime);
    }

    private void processCamt054(Camt054Statement statement, int countStatements) throws IOException {
        String uniqueId;
        CmStatement c;
        this.latestAccount = this.findOrCreateAccount(statement.getAccountIdentifier(), statement.getCurrency());
        if (this.existingFile == null) {
            this.createAccountDir(this.accountIdentifier);
            this.targetFile = new File(this.accountDir, this.getTargetFileName(statement, countStatements));
        }
        if ((c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId = this.getDbFileNameWithoutPage(statement.getPageNumber()))) == null) {
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            c = this.createStatement(statement, uniqueId);
            this.createExportFile(c);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, statement.getPageNumber(), new Timestamp(statement.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile();
                }
                this.createPage(c, statement);
                this.createExportFile(c);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile();
                }
                this.updatePage(c, cmPage, statement);
                this.createExportFile(c);
            }
        } else if (this.isSecondPage(c, statement.getPageNumber(), statement.getCreationDate())) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            this.createPage(c, statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            this.updateStatement(c, statement);
            this.createExportFile(c);
        }
    }

    private void createPage(CmStatement s, Camt054Statement statement) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, statement);
        DB.save(p);
        this.processBookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void setPageData(CmPage p, Camt054Statement statement) {
        this.setFile(p);
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(statement.getPageNumber());
        p.setReference1(statement.getMessageId());
        p.setReference2(statement.getReference());
        p.setCurrency(statement.getCurrency());
    }

    private void updatePage(CmStatement s, CmPage p, Camt054Statement statement) {
        this.setPageData(p, statement);
        DB.update(p);
        this.processBookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private CmStatement createStatement(Camt054Statement statement, String uniqueId) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CAMT054, this.latestAccount);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processBookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
        return c;
    }

    private void updateStatement(CmStatement c, Camt054Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processBookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void setStatementData(CmStatement c, Camt054Statement statement) {
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        c.setPageNumberAsInt(statement.getPageNumber());
        c.setCurrency(statement.getCurrency());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private String getTargetFileName(Camt054Statement statement, int countStatements) {
        int pageNumber;
        java.util.Date date = statement.getCreationDate();
        String prefix = ((SimpleDateFormat)YYMMDD.get()).format(date);
        StringBuilder sb = new StringBuilder(".");
        sb.append(statement.getMessageId());
        if (countStatements > 1) {
            sb.append("-");
            sb.append(statement.getReference());
        }
        if ((pageNumber = statement.getPageNumber()) > 0) {
            sb.append("_");
            sb.append(pageNumber);
        }
        sb.append(".");
        sb.append(C54);
        String suffix = sb.toString();
        return MT940Processing.transform(prefix + suffix);
    }

    private BookingStatistics calculateStatistics(List<ReportEntry2> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        for (ReportEntry2 ntry : bookings) {
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    Camt054Booking booking = new Camt054Booking(ntry, details, transaction);
                    statistics.addBooking(booking.getAmount());
                }
            }
        }
        return statistics;
    }

    private void processBookings(CmStatement s, CmPage p, List<ReportEntry2> bookings) {
        java.util.Date date;
        long startTime;
        long totalStartTime = startTime = System.currentTimeMillis();
        String reference = s.getReference1();
        if (reference != null && reference.length() > 19 && PaymentUtils.isBIC(reference.substring(0, 11)) && (date = CMProcessingDb.startsWithYYYYMMDD(reference = reference.substring(11))) != null) {
            reference = reference.substring(8);
        }
        List<CmBooking> possibleParentBookings = CMProcessingDb.findParentBookings(s, reference, this.preferences, this.logger);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - find possible parent bookings", startTime);
        startTime = System.currentTimeMillis();
        CmBooking parentBooking = null;
        ArrayList<CmBooking> parentBookings = null;
        BookingStatistics statistics = this.calculateStatistics(bookings);
        Camt054ProcessingApi.storeStatistics(s, p, statistics);
        if (possibleParentBookings != null && (parentBooking = CMProcessingDb.findParentBooking(possibleParentBookings, s.getTotalSum(), s.getCreationDate(), this.preferences)) == null) {
            parentBookings = new ArrayList<CmBooking>();
        }
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - before loop", startTime);
        startTime = System.currentTimeMillis();
        long bookingIime = 0L;
        long parentBookingIime = 0L;
        int pos = 0;
        for (ReportEntry2 ntry : bookings) {
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    long startTime1 = System.currentTimeMillis();
                    Camt054Booking booking = new Camt054Booking(ntry, details, transaction);
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parentBooking, false);
                    bookingIime = bookingIime + System.currentTimeMillis() - startTime1;
                    if (parentBookings != null) {
                        long startIime2 = System.currentTimeMillis();
                        CmBooking parentBookingForSingle = CMProcessingDb.findParentBooking(possibleParentBookings, b.getAmount(), s.getCreationDate(), this.preferences);
                        if (parentBookingForSingle != null) {
                            parentBookings.add(parentBookingForSingle);
                        }
                        parentBookingIime = parentBookingIime + System.currentTimeMillis() - startIime2;
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Util.writePerformanceLogTotalTime(this.logger, this.getClass(), "processBookings - loop - booking part", bookingIime);
        Util.writePerformanceLogTotalTime(this.logger, this.getClass(), "processBookings - loop - parent part", parentBookingIime);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - total loop", startTime);
        startTime = System.currentTimeMillis();
        if (parentBooking != null) {
            parentBooking.setCollective(true);
            DB.update(parentBooking);
        } else if (parentBookings != null) {
            for (CmBooking booking : parentBookings) {
                booking.setCollective(true);
                DB.update(booking);
            }
        }
        Camt054ProcessingApi.deleteHigherPositionedBookings(s, p, pos);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - after loop", startTime);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings (total)", totalStartTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCamt05400104(List<Camt05400104Statement> statements) throws Exception {
        long startTime = System.currentTimeMillis();
        int countStatements = statements.size();
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processUnzipped - loading of " + countStatements + " statements from file", startTime);
        startTime = System.currentTimeMillis();
        if (this.existingFile != null) {
            for (Camt05400104Statement s : statements) {
                this.processStatement(s, countStatements);
            }
        } else {
            Camt05400104Writer w = new Camt05400104Writer();
            for (Camt05400104Statement s : statements) {
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    w.write(s, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(s, countStatements);
            }
        }
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processUnzipped - processing of statements", startTime);
    }

    private void processStatement(Camt05400104Statement statement, int countStatements) throws IOException {
        String uniqueId;
        CmStatement c;
        this.latestAccount = this.findOrCreateAccount(statement.getAccountIdentifier(), statement.getCurrency());
        if (this.existingFile == null) {
            this.createAccountDir(this.accountIdentifier);
            this.targetFile = new File(this.accountDir, this.getTargetFileName(statement, countStatements));
        }
        if ((c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId = this.getDbFileNameWithoutPage(statement.getPageNumber()))) == null) {
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            c = this.createStatement(statement, uniqueId);
            this.createExportFile(c);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, statement.getPageNumber(), new Timestamp(statement.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile();
                }
                this.createPage(c, statement);
                this.createExportFile(c);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile();
                }
                this.updatePage(c, cmPage, statement);
                this.createExportFile(c);
            }
        } else if (this.isSecondPage(c, statement.getPageNumber(), statement.getCreationDate())) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            this.createPage(c, statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            this.updateStatement(c, statement);
            this.createExportFile(c);
        }
    }

    private void createPage(CmStatement s, Camt05400104Statement statement) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, statement);
        DB.save(p);
        this.processCamt05400104Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void setPageData(CmPage p, Camt05400104Statement statement) {
        this.setFile(p);
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(statement.getPageNumber());
        p.setReference1(statement.getMessageId());
        p.setReference2(statement.getReference());
        p.setCurrency(statement.getCurrency());
    }

    private void updatePage(CmStatement s, CmPage p, Camt05400104Statement statement) {
        this.setPageData(p, statement);
        DB.update(p);
        this.processCamt05400104Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private CmStatement createStatement(Camt05400104Statement statement, String uniqueId) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CAMT054, this.latestAccount);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05400104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
        return c;
    }

    private void updateStatement(CmStatement c, Camt05400104Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05400104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void setStatementData(CmStatement c, Camt05400104Statement statement) {
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        c.setPageNumberAsInt(statement.getPageNumber());
        c.setCurrency(statement.getCurrency());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private String getTargetFileName(Camt05400104Statement statement, int countStatements) {
        int pageNumber;
        java.util.Date date = statement.getCreationDate();
        String prefix = ((SimpleDateFormat)YYMMDD.get()).format(date);
        StringBuilder sb = new StringBuilder(".");
        sb.append(statement.getMessageId());
        if (countStatements > 1) {
            sb.append("-");
            sb.append(statement.getReference());
        }
        if ((pageNumber = statement.getPageNumber()) > 0) {
            sb.append("_");
            sb.append(pageNumber);
        }
        sb.append(".");
        sb.append(C54);
        String suffix = sb.toString();
        return MT940Processing.transform(prefix + suffix);
    }

    private BookingStatistics calculateStatisticsForCamt05400104(List<ReportEntry4> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        for (ReportEntry4 ntry : bookings) {
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    Camt05400104Booking booking = new Camt05400104Booking(ntry, details, transaction);
                    statistics.addBooking(booking.getAmount());
                }
            }
        }
        return statistics;
    }

    private void processCamt05400104Bookings(CmStatement s, CmPage p, List<ReportEntry4> bookings) {
        java.util.Date date;
        long startTime;
        long totalStartTime = startTime = System.currentTimeMillis();
        String reference = s.getReference1();
        if (reference != null && reference.length() > 19 && PaymentUtils.isBIC(reference.substring(0, 11)) && (date = CMProcessingDb.startsWithYYYYMMDD(reference = reference.substring(11))) != null) {
            reference = reference.substring(8);
        }
        List<CmBooking> possibleParentBookings = CMProcessingDb.findParentBookings(s, reference, this.preferences, this.logger);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - find possible parent bookings", startTime);
        startTime = System.currentTimeMillis();
        CmBooking parentBooking = null;
        ArrayList<CmBooking> parentBookings = null;
        BookingStatistics statistics = this.calculateStatisticsForCamt05400104(bookings);
        Camt054ProcessingApi.storeStatistics(s, p, statistics);
        if (possibleParentBookings != null && (parentBooking = CMProcessingDb.findParentBooking(possibleParentBookings, s.getTotalSum(), s.getCreationDate(), this.preferences)) == null) {
            parentBookings = new ArrayList<CmBooking>();
        }
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - before loop", startTime);
        startTime = System.currentTimeMillis();
        long bookingIime = 0L;
        long parentBookingIime = 0L;
        int pos = 0;
        for (ReportEntry4 ntry : bookings) {
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    long startTime1 = System.currentTimeMillis();
                    Camt05400104Booking booking = new Camt05400104Booking(ntry, details, transaction);
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parentBooking, false);
                    bookingIime = bookingIime + System.currentTimeMillis() - startTime1;
                    if (parentBookings != null) {
                        long startIime2 = System.currentTimeMillis();
                        CmBooking parentBookingForSingle = CMProcessingDb.findParentBooking(possibleParentBookings, b.getAmount(), s.getCreationDate(), this.preferences);
                        if (parentBookingForSingle != null) {
                            parentBookings.add(parentBookingForSingle);
                        }
                        parentBookingIime = parentBookingIime + System.currentTimeMillis() - startIime2;
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Util.writePerformanceLogTotalTime(this.logger, this.getClass(), "processBookings - loop - booking part", bookingIime);
        Util.writePerformanceLogTotalTime(this.logger, this.getClass(), "processBookings - loop - parent part", parentBookingIime);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - total loop", startTime);
        startTime = System.currentTimeMillis();
        if (parentBooking != null) {
            parentBooking.setCollective(true);
            DB.update(parentBooking);
        } else if (parentBookings != null) {
            for (CmBooking booking : parentBookings) {
                booking.setCollective(true);
                DB.update(booking);
            }
        }
        Camt054ProcessingApi.deleteHigherPositionedBookings(s, p, pos);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - after loop", startTime);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings (total)", totalStartTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCamt05400108(List<Camt05400108Statement> statements) throws Exception {
        long startTime = System.currentTimeMillis();
        int countStatements = statements.size();
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processUnzipped - loading of " + countStatements + " statements from file", startTime);
        startTime = System.currentTimeMillis();
        if (this.existingFile != null) {
            for (Camt05400108Statement s : statements) {
                this.processStatement(s, countStatements);
            }
        } else {
            Camt05400108Writer w = new Camt05400108Writer();
            for (Camt05400108Statement s : statements) {
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    w.write(s, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(s, countStatements);
            }
        }
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processUnzipped - processing of statements", startTime);
    }

    private void processStatement(Camt05400108Statement statement, int countStatements) throws IOException {
        String uniqueId;
        CmStatement c;
        this.latestAccount = this.findOrCreateAccount(statement.getAccountIdentifier(), statement.getCurrency());
        if (this.existingFile == null) {
            this.createAccountDir(this.accountIdentifier);
            this.targetFile = new File(this.accountDir, this.getTargetFileName(statement, countStatements));
        }
        if ((c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId = this.getDbFileNameWithoutPage(statement.getPageNumber()))) == null) {
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            c = this.createStatement(statement, uniqueId);
            this.createExportFile(c);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, statement.getPageNumber(), new Timestamp(statement.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile();
                }
                this.createPage(c, statement);
                this.createExportFile(c);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile();
                }
                this.updatePage(c, cmPage, statement);
                this.createExportFile(c);
            }
        } else if (this.isSecondPage(c, statement.getPageNumber(), statement.getCreationDate())) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            this.createPage(c, statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile();
            }
            this.updateStatement(c, statement);
            this.createExportFile(c);
        }
    }

    private void createPage(CmStatement s, Camt05400108Statement statement) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, statement);
        DB.save(p);
        this.processCamt05400108Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void setPageData(CmPage p, Camt05400108Statement statement) {
        this.setFile(p);
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(statement.getPageNumber());
        p.setReference1(statement.getMessageId());
        p.setReference2(statement.getReference());
        p.setCurrency(statement.getCurrency());
    }

    private void updatePage(CmStatement s, CmPage p, Camt05400108Statement statement) {
        this.setPageData(p, statement);
        DB.update(p);
        this.processCamt05400108Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private CmStatement createStatement(Camt05400108Statement statement, String uniqueId) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CAMT054, this.latestAccount);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05400108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
        return c;
    }

    private void updateStatement(CmStatement c, Camt05400108Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05400108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void setStatementData(CmStatement c, Camt05400108Statement statement) {
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        c.setPageNumberAsInt(statement.getPageNumber());
        c.setCurrency(statement.getCurrency());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private String getTargetFileName(Camt05400108Statement statement, int countStatements) {
        int pageNumber;
        java.util.Date date = statement.getCreationDate();
        String prefix = ((SimpleDateFormat)YYMMDD.get()).format(date);
        StringBuilder sb = new StringBuilder(".");
        sb.append(statement.getMessageId());
        if (countStatements > 1) {
            sb.append("-");
            sb.append(statement.getReference());
        }
        if ((pageNumber = statement.getPageNumber()) > 0) {
            sb.append("_");
            sb.append(pageNumber);
        }
        sb.append(".");
        sb.append(C54);
        String suffix = sb.toString();
        return MT940Processing.transform(prefix + suffix);
    }

    private BookingStatistics calculateStatisticsForCamt05400108(List<ReportEntry10> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        for (ReportEntry10 ntry : bookings) {
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    Camt05400108Booking booking = new Camt05400108Booking(ntry, details, transaction);
                    statistics.addBooking(booking.getAmount());
                }
            }
        }
        return statistics;
    }

    private void processCamt05400108Bookings(CmStatement s, CmPage p, List<ReportEntry10> bookings) {
        java.util.Date date;
        long startTime;
        long totalStartTime = startTime = System.currentTimeMillis();
        String reference = s.getReference1();
        if (reference != null && reference.length() > 19 && PaymentUtils.isBIC(reference.substring(0, 11)) && (date = CMProcessingDb.startsWithYYYYMMDD(reference = reference.substring(11))) != null) {
            reference = reference.substring(8);
        }
        List<CmBooking> possibleParentBookings = CMProcessingDb.findParentBookings(s, reference, this.preferences, this.logger);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - find possible parent bookings", startTime);
        startTime = System.currentTimeMillis();
        CmBooking parentBooking = null;
        ArrayList<CmBooking> parentBookings = null;
        BookingStatistics statistics = this.calculateStatisticsForCamt05400108(bookings);
        Camt054ProcessingApi.storeStatistics(s, p, statistics);
        if (possibleParentBookings != null && (parentBooking = CMProcessingDb.findParentBooking(possibleParentBookings, s.getTotalSum(), s.getCreationDate(), this.preferences)) == null) {
            parentBookings = new ArrayList<CmBooking>();
        }
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - before loop", startTime);
        startTime = System.currentTimeMillis();
        long bookingIime = 0L;
        long parentBookingIime = 0L;
        int pos = 0;
        for (ReportEntry10 ntry : bookings) {
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    long startTime1 = System.currentTimeMillis();
                    Camt05400108Booking booking = new Camt05400108Booking(ntry, details, transaction);
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parentBooking, false);
                    bookingIime = bookingIime + System.currentTimeMillis() - startTime1;
                    if (parentBookings != null) {
                        long startTime2 = System.currentTimeMillis();
                        CmBooking parentBookingForSingle = CMProcessingDb.findParentBooking(possibleParentBookings, b.getAmount(), s.getCreationDate(), this.preferences);
                        if (parentBookingForSingle != null) {
                            parentBookings.add(parentBookingForSingle);
                        }
                        parentBookingIime = parentBookingIime + System.currentTimeMillis() - startTime2;
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Util.writePerformanceLogTotalTime(this.logger, this.getClass(), "processBookings - loop - booking part", bookingIime);
        Util.writePerformanceLogTotalTime(this.logger, this.getClass(), "processBookings - loop - parent part", parentBookingIime);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - total loop", startTime);
        startTime = System.currentTimeMillis();
        if (parentBooking != null) {
            parentBooking.setCollective(true);
            DB.update(parentBooking);
        } else if (parentBookings != null) {
            for (CmBooking booking : parentBookings) {
                booking.setCollective(true);
                DB.update(booking);
            }
        }
        Camt054ProcessingApi.deleteHigherPositionedBookings(s, p, pos);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings - after loop", startTime);
        Util.writePerformanceLogStartTime(this.logger, this.getClass(), "processBookings (total)", totalStartTime);
    }

    @Override
    protected void processBookingData(CmBooking b, CmStatement s, CmPage page, Booking booking, CmBooking parent, boolean collective) {
        this.setBookingData(b, s, page, booking, parent, collective);
    }

    @Override
    protected Date getBookingDateFromStatement(CmStatement statement) {
        return null;
    }

    private void createExportFile(CmStatement stmt) throws IOException {
        String exportDirectory = new DatabasePreferenceStore(Preference.ApplicationId.CM, null).getString(CmPreferenceConstants.C54_EXPORT_DIRECTORY);
        if (exportDirectory != null) {
            File exportFile = this.getExportFileName(stmt, exportDirectory);
            if (this.isC54OrXmlExtension(exportFile)) {
                exportFile.getParentFile().mkdirs();
            } else {
                exportFile.mkdirs();
                exportFile = new File(exportFile, stmt.getOriginalFilename());
            }
            exportFile = Camt054ProcessingApi.uniqueFilename(exportFile);
            FileOutputStream fos = new FileOutputStream(exportFile);
            InputStream fin = this.encrypt.openInputStream(this.targetFile);
            Streams.copy(fin, fos);
        }
    }

    private File getExportFileName(CmStatement stmt, String exportDirectory) {
        Substitution s = new Substitution(stmt.getCreationDate());
        s.addPlaceHolder("BANK", MT940Processing.transform(stmt.getAccount().getBank().getDisplayName()));
        s.addPlaceHolder("ACCOUNT", MT940Processing.transform(Account.getDefaultDisplayName(stmt.getAccount())));
        s.addPlaceHolder("IBAN", MT940Processing.transform(IbanUtil.formatIBAN(stmt.getAccount().getIban())));
        s.addPlaceHolder("CURRENCY", stmt.getAccount().getCurrency());
        s.addPlaceHolder("FILENAME", stmt.getOriginalFilename());
        return new File(s.substitute(exportDirectory));
    }

    private boolean isC54OrXmlExtension(File file) {
        if (file == null) {
            return false;
        }
        int lastDot = file.getPath().lastIndexOf(46);
        String suffix = file.getPath().substring(lastDot + 1);
        return C54.equalsIgnoreCase(suffix) || "xml".equalsIgnoreCase(suffix);
    }

    public static File uniqueFilename(File file) {
        int j;
        if (file == null) {
            return null;
        }
        int k = file.getPath().lastIndexOf(46);
        String start = k > (j = Math.max(file.getPath().lastIndexOf(47), file.getPath().lastIndexOf(92))) ? file.getPath().substring(0, k) : file.getPath();
        String extension = k > j ? file.getPath().substring(k) : "";
        int index = 0;
        while (file.exists()) {
            String newPath = String.format("%s_%03d%s", start, ++index, extension);
            file = new File(newPath);
        }
        return file;
    }

    private boolean isSecondPage(CmStatement c, int pageNumber, java.util.Date creationDate) {
        String timeStampDb;
        if (c.getPageNumber() == null) {
            return false;
        }
        if (pageNumber != c.getPageNumberAsInt()) {
            return true;
        }
        String timeStamp = this.yyyyMMddHHmmFormat.format(creationDate);
        return !timeStamp.equals(timeStampDb = this.yyyyMMddHHmmFormat.format(c.getCreationDate()));
    }

    private void setOldFlagForPages(CmStatement s) {
        CmPage.markOtherAsOld(s);
    }

    private String getDbFileNameWithoutPage(int pageNumber) {
        Object dbFileName = this.getDbFileName();
        if (pageNumber > 0) {
            int index = ((String)dbFileName).lastIndexOf("_" + pageNumber);
            dbFileName = ((String)dbFileName).substring(0, index) + ".C54";
        }
        return dbFileName;
    }
}

