/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.Camt05400104Writer;
import de.businesslogics.banking.mt940.api.Camt05400108Writer;
import de.businesslogics.banking.mt940.api.Camt054Writer;
import de.businesslogics.banking.mt940.api.Camt05XProcessing;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt054.Camt05400104Booking;
import de.businesslogics.format.camt054.Camt05400104Statement;
import de.businesslogics.format.camt054.Camt05400108Booking;
import de.businesslogics.format.camt054.Camt05400108Statement;
import de.businesslogics.format.camt054.Camt054Booking;
import de.businesslogics.format.camt054.Camt054Statement;
import de.businesslogics.format.camt05x.Booking;
import de.businesslogics.format.iso20022.camt05400102.EntryDetails1;
import de.businesslogics.format.iso20022.camt05400102.EntryTransaction2;
import de.businesslogics.format.iso20022.camt05400102.ReportEntry2;
import de.businesslogics.format.iso20022.camt05400104.Document;
import de.businesslogics.format.iso20022.camt05400104.EntryDetails3;
import de.businesslogics.format.iso20022.camt05400104.EntryTransaction4;
import de.businesslogics.format.iso20022.camt05400104.ReportEntry4;
import de.businesslogics.format.iso20022.camt05400108.EntryDetails9;
import de.businesslogics.format.iso20022.camt05400108.EntryTransaction10;
import de.businesslogics.format.iso20022.camt05400108.ReportEntry10;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt054AdviceProcessing
extends Camt05XProcessing {
    private final SimpleDateFormat yyyyMMddHHmmFormat = new SimpleDateFormat("yyyyMMddHHmm");

    public Camt054AdviceProcessing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(CmStatement.Type.CAMT054Advice, bank, reporter, "camt053", logger, encrypt, preferences);
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        this.originalFilename = originalFilename;
        EbicsElement e = this.getDocument(in);
        if (e instanceof de.businesslogics.format.iso20022.camt05400102.Document) {
            this.processCamt05400102(Camt054Statement.loadStatements((de.businesslogics.format.iso20022.camt05400102.Document)e));
        } else if (e instanceof Document) {
            this.processCamt05400104(Camt05400104Statement.loadStatements((Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05400108.Document) {
            this.processCamt05400108(Camt05400108Statement.loadStatements((de.businesslogics.format.iso20022.camt05400108.Document)e));
        } else {
            throw new IOException("Unsupported Camt053 version");
        }
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05400102.Document.class);
        p.addPossibleRoot(Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05400108.Document.class);
        return EbicsHandler.parse(in, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCamt05400102(List<Camt054Statement> statements) throws Exception {
        boolean ignoreOldAdvices = this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
        Camt054Writer w = new Camt054Writer();
        for (Camt054Statement s : statements) {
            this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
            if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                return;
            }
            if (ignoreOldAdvices && !this.hasNewBookings(s, this.latestAccount)) continue;
            this.createAccountDir(s.getAccountIdentifier());
            OutputStream out = null;
            try {
                out = this.getTempOutputStream();
                w.write(s, out);
            }
            finally {
                SystemUtils.close(out);
            }
            this.processCamt054(s);
        }
    }

    public boolean hasNewBookings(Camt054Statement advice, Account a) {
        Date obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(a);
        if (obsoleteDate == null) {
            return true;
        }
        java.util.Date defaultBookingDate = advice.getCreationDate();
        for (ReportEntry2 ntry : advice.getStatement().getNtrys()) {
            Camt054Booking tmpParent;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails > 1 && !this.getBookingDate((tmpParent = new Camt054Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                return true;
            }
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                Camt054Booking tmpParent2;
                int countTransactions = details.getTxDtlss().size();
                if (countTransactions > 1 && !this.getBookingDate((tmpParent2 = new Camt054Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                    return true;
                }
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    Camt054Booking booking = new Camt054Booking(ntry, details, transaction);
                    if (this.getBookingDate(booking.getBookingDate(), defaultBookingDate).before(obsoleteDate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processCamt054(Camt054Statement advice) {
        java.util.Date creationDate = advice.getCreationDate();
        String uniqueId = CMProcessingDb.getUniqueAdviceId(creationDate, advice.getNumber(), "_C54");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createStatement(advice, uniqueId);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, advice.getPageNumber(), new Timestamp(advice.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.createPage(c, advice);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.updatePage(c, cmPage, advice);
            }
        } else if (this.isSecondPage(c, advice.getPageNumber(), creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createPage(c, advice);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.updateStatement(c, advice);
        }
    }

    private void createTargetFile(Camt054Statement advice) {
        String timeStamp = ((SimpleDateFormat)YYMMDDHHmm.get()).format(advice.getCreationDate());
        Object commonPart = timeStamp.substring(0, 6);
        String time = timeStamp.substring(6);
        String number = advice.getNumber();
        int pageNumber = advice.getPageNumber();
        if (number != null && number.trim().length() > 0) {
            commonPart = (String)commonPart + "_" + number.trim();
        }
        String dirName = (String)commonPart + ".camt054";
        String fileName = pageNumber > 0 ? (String)commonPart + "_" + pageNumber + "-" + time + ".camt054" : (String)commonPart + "-" + time + ".camt054";
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    protected void createStatement(Camt054Statement statement, String uniqueId) {
        CmStatement c = new CmStatement();
        c.setUniqueId(uniqueId);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processBookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    protected void updateStatement(CmStatement c, Camt054Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processBookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt054Statement advice) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, advice);
        DB.save(p);
        this.processBookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void updatePage(CmStatement s, CmPage p, Camt054Statement advice) {
        this.setPageData(p, advice);
        DB.update(p);
        this.processBookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt054Statement statement) {
        c.setType(CmStatement.Type.CAMT054Advice);
        c.setAccount(this.latestAccount);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            if (statement.getNumber() != null) {
                c.setStatementNumber(Integer.valueOf(statement.getNumber()));
            }
        }
        catch (Exception e) {
            this.logger.logError("Camt054Procesing: Could not parse " + statement.getNumber() + " to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setCurrency(statement.getCurrency());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt054Statement advice) {
        this.setFile(p);
        java.util.Date creationDate = advice.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(advice.getPageNumber());
        p.setReference1(advice.getMessageId());
        p.setReference2(advice.getReference());
        p.setCurrency(advice.getCurrency());
    }

    protected void processBookings(CmStatement s, CmPage p, List<ReportEntry2> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        for (ReportEntry2 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt054Booking tmpParent = new Camt054Booking(ntry, null, null);
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt054Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt054Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt054Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 1);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    Camt054Booking booking = new Camt054Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, null, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt054AdviceProcessing.deleteHigherPositionedBookings(s, p, pos);
        Camt054AdviceProcessing.storeStatistics(s, p, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCamt05400104(List<Camt05400104Statement> statements) throws Exception {
        boolean ignoreOldAdvices = this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
        Camt05400104Writer w = new Camt05400104Writer();
        for (Camt05400104Statement s : statements) {
            this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
            if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                return;
            }
            if (ignoreOldAdvices && !this.hasNewBookings(s, this.latestAccount)) continue;
            this.createAccountDir(s.getAccountIdentifier());
            OutputStream out = null;
            try {
                out = this.getTempOutputStream();
                w.write(s, out);
            }
            finally {
                SystemUtils.close(out);
            }
            this.processCamt054(s);
        }
    }

    public boolean hasNewBookings(Camt05400104Statement advice, Account a) {
        Date obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(a);
        if (obsoleteDate == null) {
            return true;
        }
        java.util.Date defaultBookingDate = advice.getCreationDate();
        for (ReportEntry4 ntry : advice.getStatement().getNtrys()) {
            Camt05400104Booking tmpParent;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails > 1 && !this.getBookingDate((tmpParent = new Camt05400104Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                return true;
            }
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                Camt05400104Booking tmpParent2;
                int countTransactions = details.getTxDtlss().size();
                if (countTransactions > 1 && !this.getBookingDate((tmpParent2 = new Camt05400104Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                    return true;
                }
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    Camt05400104Booking booking = new Camt05400104Booking(ntry, details, transaction);
                    if (this.getBookingDate(booking.getBookingDate(), defaultBookingDate).before(obsoleteDate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processCamt054(Camt05400104Statement advice) {
        java.util.Date creationDate = advice.getCreationDate();
        String uniqueId = CMProcessingDb.getUniqueAdviceId(creationDate, advice.getNumber(), "_C54");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createStatement(advice, uniqueId);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, advice.getPageNumber(), new Timestamp(advice.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.createPage(c, advice);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.updatePage(c, cmPage, advice);
            }
        } else if (this.isSecondPage(c, advice.getPageNumber(), creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createPage(c, advice);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.updateStatement(c, advice);
        }
    }

    private void createTargetFile(Camt05400104Statement advice) {
        String timeStamp = ((SimpleDateFormat)YYMMDDHHmm.get()).format(advice.getCreationDate());
        Object commonPart = timeStamp.substring(0, 6);
        String time = timeStamp.substring(6);
        String number = advice.getNumber();
        int pageNumber = advice.getPageNumber();
        if (number != null && number.trim().length() > 0) {
            commonPart = (String)commonPart + "_" + number.trim();
        }
        String dirName = (String)commonPart + ".camt054";
        String fileName = pageNumber > 0 ? (String)commonPart + "_" + pageNumber + "-" + time + ".camt054" : (String)commonPart + "-" + time + ".camt054";
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    protected void createStatement(Camt05400104Statement statement, String uniqueId) {
        CmStatement c = new CmStatement();
        c.setUniqueId(uniqueId);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05400104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    protected void updateStatement(CmStatement c, Camt05400104Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05400104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt05400104Statement advice) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, advice);
        DB.save(p);
        this.processCamt05400104Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void updatePage(CmStatement s, CmPage p, Camt05400104Statement advice) {
        this.setPageData(p, advice);
        DB.update(p);
        this.processCamt05400104Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt05400104Statement statement) {
        c.setType(CmStatement.Type.CAMT054Advice);
        c.setAccount(this.latestAccount);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            if (statement.getNumber() != null) {
                c.setStatementNumber(Integer.valueOf(statement.getNumber()));
            }
        }
        catch (Exception e) {
            this.logger.logError("Camt054Procesing: Could not parse " + statement.getNumber() + " to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setCurrency(statement.getCurrency());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt05400104Statement advice) {
        this.setFile(p);
        java.util.Date creationDate = advice.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(advice.getPageNumber());
        p.setReference1(advice.getMessageId());
        p.setReference2(advice.getReference());
        p.setCurrency(advice.getCurrency());
    }

    protected void processCamt05400104Bookings(CmStatement s, CmPage p, List<ReportEntry4> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        for (ReportEntry4 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt05400104Booking tmpParent = new Camt05400104Booking(ntry, null, null);
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt05400104Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt05400104Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt05400104Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 1);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    Camt05400104Booking booking = new Camt05400104Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt054AdviceProcessing.deleteHigherPositionedBookings(s, p, pos);
        Camt054AdviceProcessing.storeStatistics(s, p, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCamt05400108(List<Camt05400108Statement> statements) throws Exception {
        boolean ignoreOldAdvices = this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
        Camt05400108Writer w = new Camt05400108Writer();
        for (Camt05400108Statement s : statements) {
            this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
            if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                return;
            }
            if (ignoreOldAdvices && !this.hasNewBookings(s, this.latestAccount)) continue;
            this.createAccountDir(s.getAccountIdentifier());
            OutputStream out = null;
            try {
                out = this.getTempOutputStream();
                w.write(s, out);
            }
            finally {
                SystemUtils.close(out);
            }
            this.processCamt054(s);
        }
    }

    public boolean hasNewBookings(Camt05400108Statement advice, Account a) {
        Date obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(a);
        if (obsoleteDate == null) {
            return true;
        }
        java.util.Date defaultBookingDate = advice.getCreationDate();
        for (ReportEntry10 ntry : advice.getStatement().getNtrys()) {
            Camt05400108Booking tmpParent;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails > 1 && !this.getBookingDate((tmpParent = new Camt05400108Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                return true;
            }
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                Camt05400108Booking tmpParent2;
                int countTransactions = details.getTxDtlss().size();
                if (countTransactions > 1 && !this.getBookingDate((tmpParent2 = new Camt05400108Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                    return true;
                }
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    Camt05400108Booking booking = new Camt05400108Booking(ntry, details, transaction);
                    if (this.getBookingDate(booking.getBookingDate(), defaultBookingDate).before(obsoleteDate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processCamt054(Camt05400108Statement advice) {
        java.util.Date creationDate = advice.getCreationDate();
        String uniqueId = CMProcessingDb.getUniqueAdviceId(creationDate, advice.getNumber(), "_C54");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createStatement(advice, uniqueId);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, advice.getPageNumber(), new Timestamp(advice.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.createPage(c, advice);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.updatePage(c, cmPage, advice);
            }
        } else if (this.isSecondPage(c, advice.getPageNumber(), creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createPage(c, advice);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.updateStatement(c, advice);
        }
    }

    private void createTargetFile(Camt05400108Statement advice) {
        String timeStamp = ((SimpleDateFormat)YYMMDDHHmm.get()).format(advice.getCreationDate());
        Object commonPart = timeStamp.substring(0, 6);
        String time = timeStamp.substring(6);
        String number = advice.getNumber();
        int pageNumber = advice.getPageNumber();
        if (number != null && number.trim().length() > 0) {
            commonPart = (String)commonPart + "_" + number.trim();
        }
        String dirName = (String)commonPart + ".camt054";
        String fileName = pageNumber > 0 ? (String)commonPart + "_" + pageNumber + "-" + time + ".camt054" : (String)commonPart + "-" + time + ".camt054";
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    protected void createStatement(Camt05400108Statement statement, String uniqueId) {
        CmStatement c = new CmStatement();
        c.setUniqueId(uniqueId);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05400108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    protected void updateStatement(CmStatement c, Camt05400108Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05400108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt05400108Statement advice) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, advice);
        DB.save(p);
        this.processCamt05400108Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void updatePage(CmStatement s, CmPage p, Camt05400108Statement advice) {
        this.setPageData(p, advice);
        DB.update(p);
        this.processCamt05400108Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt05400108Statement statement) {
        c.setType(CmStatement.Type.CAMT054Advice);
        c.setAccount(this.latestAccount);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            if (statement.getNumber() != null) {
                c.setStatementNumber(Integer.valueOf(statement.getNumber()));
            }
        }
        catch (Exception e) {
            this.logger.logError("Camt054Procesing: Could not parse " + statement.getNumber() + " to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setCurrency(statement.getCurrency());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt05400108Statement advice) {
        this.setFile(p);
        java.util.Date creationDate = advice.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(advice.getPageNumber());
        p.setReference1(advice.getMessageId());
        p.setReference2(advice.getReference());
        p.setCurrency(advice.getCurrency());
    }

    protected void processCamt05400108Bookings(CmStatement s, CmPage p, List<ReportEntry10> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        for (ReportEntry10 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt05400108Booking tmpParent = new Camt05400108Booking(ntry, null, null);
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt05400108Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt05400108Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt05400108Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 1);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    Camt05400108Booking booking = new Camt05400108Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt054AdviceProcessing.deleteHigherPositionedBookings(s, p, pos);
        Camt054AdviceProcessing.storeStatistics(s, p, statistics);
    }

    @Override
    protected void processBookingData(CmBooking b, CmStatement s, CmPage page, Booking booking, CmBooking parent, boolean collective) {
        this.setBookingData(b, s, page, booking, parent, collective);
    }

    @Override
    protected Date getBookingDateFromStatement(CmStatement statement) {
        if (statement.getCreationDate() != null) {
            return new Date(statement.getCreationDate().getTime());
        }
        return null;
    }

    private java.util.Date getBookingDate(java.util.Date bookingDate, java.util.Date defaultBookingDate) {
        if (bookingDate != null) {
            return bookingDate;
        }
        return defaultBookingDate;
    }

    private boolean isSecondPage(CmStatement s, int pageNumber, java.util.Date creationDate) {
        String timeStampDb;
        if (pageNumber != s.getPageNumberAsInt()) {
            return true;
        }
        String timeStamp = this.yyyyMMddHHmmFormat.format(creationDate);
        return !timeStamp.equals(timeStampDb = this.yyyyMMddHHmmFormat.format(s.getCreationDate()));
    }

    private void setOldFlagForPages(CmStatement advice) {
        CmPage.markOtherAsOld(advice);
    }
}

