/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.Camt05300104Writer;
import de.businesslogics.banking.mt940.api.Camt05300108Writer;
import de.businesslogics.banking.mt940.api.Camt053Writer;
import de.businesslogics.banking.mt940.api.Camt05XProcessing;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt053.Camt05300104Booking;
import de.businesslogics.format.camt053.Camt05300104Statement;
import de.businesslogics.format.camt053.Camt05300108Booking;
import de.businesslogics.format.camt053.Camt05300108Statement;
import de.businesslogics.format.camt053.Camt053Booking;
import de.businesslogics.format.camt053.Camt053Statement;
import de.businesslogics.format.camt05x.Booking;
import de.businesslogics.format.iso20022.camt05300102.EntryDetails1;
import de.businesslogics.format.iso20022.camt05300102.EntryTransaction2;
import de.businesslogics.format.iso20022.camt05300102.ReportEntry2;
import de.businesslogics.format.iso20022.camt05300104.Document;
import de.businesslogics.format.iso20022.camt05300104.EntryDetails3;
import de.businesslogics.format.iso20022.camt05300104.EntryTransaction4;
import de.businesslogics.format.iso20022.camt05300104.ReportEntry4;
import de.businesslogics.format.iso20022.camt05300108.EntryDetails9;
import de.businesslogics.format.iso20022.camt05300108.EntryTransaction10;
import de.businesslogics.format.iso20022.camt05300108.ReportEntry10;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt053Processing
extends Camt05XProcessing {
    protected static final String DIR_NAME = "camt053";
    private BigDecimal currentBalance;
    private BigDecimal collectiveCurrentBalance;

    public Camt053Processing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(CmStatement.Type.CAMT053, bank, reporter, DIR_NAME, logger, encrypt, preferences);
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        this.originalFilename = originalFilename;
        EbicsElement e = this.getDocument(in);
        if (e instanceof de.businesslogics.format.iso20022.camt05300102.Document) {
            this.processCamt05300102(Camt053Statement.loadStatements((de.businesslogics.format.iso20022.camt05300102.Document)e));
        } else if (e instanceof Document) {
            this.processCamt05300104(Camt05300104Statement.loadStatements((Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05300108.Document) {
            this.processCamt05300108(Camt05300108Statement.loadStatements((de.businesslogics.format.iso20022.camt05300108.Document)e));
        } else {
            throw new IOException("Unsupported Camt053 version");
        }
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05300102.Document.class);
        p.addPossibleRoot("ISO:camt.053.001.02:APC:STUZZA:payments:004", "Document", de.businesslogics.format.iso20022.camt05300102.Document.class);
        p.addPossibleRoot("ISO:camt.053.001.02:APC:STUZZA:payments:003", "Document", de.businesslogics.format.iso20022.camt05300102.Document.class);
        p.addPossibleRoot(Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05300108.Document.class);
        return EbicsHandler.parse(in, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCamt05300102(List<Camt053Statement> statements) throws Exception {
        if (this.existingFile != null) {
            if (statements.size() == 1) {
                Camt053Statement statement = statements.get(0);
                this.processStatement(statement);
            } else {
                this.logMigrationError(this.existingFile);
            }
        } else {
            for (Camt053Statement statement : statements) {
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    Camt053Writer.write(statement, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(statement);
            }
        }
    }

    private void processStatement(Camt053Statement statement) throws IOException {
        String statementNumber;
        java.util.Date date;
        this.latestAccount = this.findOrCreateAccount(statement.getAccountIdentifier(), statement.getCurrency());
        if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
            return;
        }
        if (this.existingFile == null) {
            this.createAccountDir(statement.getAccountIdentifier());
        }
        if (this.mt940StatementExists(date = statement.getClosingDate() != null ? statement.getClosingDate() : statement.getCreationDate(), statementNumber = statement.getNumber())) {
            return;
        }
        String uniqueId = CMProcessingDb.getUniqueStatementId(date, statementNumber, "_C53");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.createStatement(uniqueId, statement);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumber(c, statement.getPageNumber());
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(statement);
                }
                this.createPage(c, statement);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(statement);
                }
                this.updatePage(c, cmPage, statement);
            }
        } else if (statement.getPageNumber() != 0 && statement.getPageNumber() != c.getPageNumberAsInt()) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.createPage(c, statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.updateStatement(c, statement);
        }
    }

    private void createTargetFile(Camt053Statement statement) {
        java.util.Date date = statement.getClosingDate() != null ? statement.getClosingDate() : statement.getCreationDate();
        String commonPart = ((SimpleDateFormat)YYMMDD.get()).format(date) + "_" + statement.getNumber();
        String dirName = commonPart + ".camt053";
        String fileName = statement.getPageNumber() > 0 ? commonPart + "_" + statement.getPageNumber() + ".camt053" : dirName;
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    private void createStatement(String uniqueId, Camt053Statement statement) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CAMT053, this.latestAccount);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05300102Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void updateStatement(CmStatement c, Camt053Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05300102Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt053Statement statement) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, statement);
        DB.save(p);
        this.updateStatementByPage(s, p);
        this.processCamt05300102Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void updatePage(CmStatement s, CmPage p, Camt053Statement statement) {
        this.setPageData(p, statement);
        DB.update(p);
        this.updateStatementByPage(s, p);
        this.processCamt05300102Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt053Statement statement) {
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            c.setStatementNumber(Integer.valueOf(statement.getNumber()));
        }
        catch (Exception e) {
            this.logger.logError("Camt053Procesing: Could not parse statement number '" + statement.getNumber() + "' to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        if (statement.getLegalNumber() != null) {
            try {
                c.setLegalNumber(Integer.valueOf(statement.getLegalNumber()));
            }
            catch (Exception e) {
                this.logger.logError("Camt053Procesing: Could not parse legal number '" + statement.getLegalNumber() + "' to integer", e);
            }
        } else {
            c.setLegalNumber(null);
        }
        c.setCurrency(statement.getCurrency());
        c.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date openingDate = statement.getOpeningDate();
        if (openingDate != null) {
            c.setOpeningDate(new Date(openingDate.getTime()));
        }
        c.setOpeningFinal(statement.isFirstPage());
        c.setClosingBalance(statement.getClosingBalance());
        java.util.Date closingDate = statement.getClosingDate();
        if (closingDate != null) {
            c.setClosingDate(new Date(statement.getClosingDate().getTime()));
        }
        c.setClosingFinal(statement.isLastPage());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt053Statement statement) {
        this.setFile(p);
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(statement.getPageNumber());
        p.setReference1(statement.getMessageId());
        p.setReference2(statement.getReference());
        p.setCurrency(statement.getCurrency());
        p.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date openingDate = statement.getOpeningDate();
        if (openingDate != null) {
            p.setOpeningDate(new Date(openingDate.getTime()));
        }
        p.setOpeningFinal(statement.isFirstPage());
        p.setClosingBalance(statement.getClosingBalance());
        java.util.Date closingDate = statement.getClosingDate();
        if (closingDate != null) {
            p.setClosingDate(new Date(statement.getClosingDate().getTime()));
        }
        p.setClosingFinal(statement.isLastPage());
    }

    private void updateStatementByPage(CmStatement c, CmPage p) {
        if (p.getPageNumberAsInt() >= c.getPageNumberAsInt()) {
            c.setClosingBalance(p.getClosingBalance());
            c.setClosingFinal(p.isClosingFinal());
            c.setClosingDate(p.getClosingDate());
            c.setCreationDate(p.getCreationDate());
            c.setPageNumber(p.getPageNumber());
        }
        if (p.isOpeningFinal()) {
            c.setOpeningBalance(p.getOpeningBalance());
            c.setOpeningFinal(true);
            Date openingDate = p.getOpeningDate();
            if (openingDate != null) {
                c.setOpeningDate(new Date(openingDate.getTime()));
            } else {
                c.setOpeningDate(null);
            }
        }
    }

    private void processCamt05300102Bookings(CmStatement s, CmPage p, List<ReportEntry2> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        this.currentBalance = p != null ? p.getOpeningBalance() : s.getOpeningBalance();
        if (this.currentBalance == null) {
            this.currentBalance = BigDecimal.ZERO;
        }
        for (ReportEntry2 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt053Booking tmpParent = new Camt053Booking(ntry, null, null);
                this.collectiveCurrentBalance = this.currentBalance;
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt053Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt053Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt053Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    this.collectiveCurrentBalance = this.currentBalance;
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 0);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    Camt053Booking booking = new Camt053Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        CMProcessingDb.connectToSingleBookings(b, b.getCustomerReference(), this.preferences);
                        try {
                            CMProcessingDb.connectToSignedPayments(b, this.logger);
                        }
                        catch (Exception e) {
                            this.logger.logError("Error connecting the booking to signedPayments", e);
                        }
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt053Processing.deleteHigherPositionedBookings(s, p, pos);
        Camt053Processing.storeStatistics(s, p, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCamt05300104(List<Camt05300104Statement> statements) throws Exception {
        if (this.existingFile != null) {
            if (statements.size() == 1) {
                Camt05300104Statement statement = statements.get(0);
                this.processStatement(statement);
            } else {
                this.logMigrationError(this.existingFile);
            }
        } else {
            for (Camt05300104Statement statement : statements) {
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    Camt05300104Writer.write(statement, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(statement);
            }
        }
    }

    private void processStatement(Camt05300104Statement statement) throws IOException {
        String statementNumber;
        java.util.Date date;
        this.latestAccount = this.findOrCreateAccount(statement.getAccountIdentifier(), statement.getCurrency());
        if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
            return;
        }
        if (this.existingFile == null) {
            this.createAccountDir(statement.getAccountIdentifier());
        }
        if (this.mt940StatementExists(date = statement.getClosingDate() != null ? statement.getClosingDate() : statement.getCreationDate(), statementNumber = statement.getNumber())) {
            return;
        }
        String uniqueId = CMProcessingDb.getUniqueStatementId(date, statementNumber, "_C53");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.createStatement(uniqueId, statement);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumber(c, statement.getPageNumber());
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(statement);
                }
                this.createPage(c, statement);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(statement);
                }
                this.updatePage(c, cmPage, statement);
            }
        } else if (statement.getPageNumber() != 0 && statement.getPageNumber() != c.getPageNumberAsInt()) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.createPage(c, statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.updateStatement(c, statement);
        }
    }

    private void createTargetFile(Camt05300104Statement statement) {
        java.util.Date date = statement.getClosingDate() != null ? statement.getClosingDate() : statement.getCreationDate();
        String commonPart = ((SimpleDateFormat)YYMMDD.get()).format(date) + "_" + statement.getNumber();
        String dirName = commonPart + ".camt053";
        String fileName = statement.getPageNumber() > 0 ? commonPart + "_" + statement.getPageNumber() + ".camt053" : dirName;
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    private void createStatement(String uniqueId, Camt05300104Statement statement) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CAMT053, this.latestAccount);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05300104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void updateStatement(CmStatement c, Camt05300104Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05300104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt05300104Statement statement) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, statement);
        DB.save(p);
        this.updateStatementByPage(s, p);
        this.processCamt05300104Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void updatePage(CmStatement s, CmPage p, Camt05300104Statement statement) {
        this.setPageData(p, statement);
        DB.update(p);
        this.updateStatementByPage(s, p);
        this.processCamt05300104Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt05300104Statement statement) {
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            c.setStatementNumber(Integer.valueOf(statement.getNumber()));
        }
        catch (Exception e) {
            this.logger.logError("Camt053Procesing: Could not parse statement number '" + statement.getNumber() + "' to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        if (statement.getLegalNumber() != null) {
            try {
                c.setLegalNumber(Integer.valueOf(statement.getLegalNumber()));
            }
            catch (Exception e) {
                this.logger.logError("Camt053Procesing: Could not parse legal number '" + statement.getLegalNumber() + "' to integer", e);
            }
        } else {
            c.setLegalNumber(null);
        }
        c.setCurrency(statement.getCurrency());
        c.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date openingDate = statement.getOpeningDate();
        if (openingDate != null) {
            c.setOpeningDate(new Date(openingDate.getTime()));
        }
        c.setOpeningFinal(statement.isFirstPage());
        c.setClosingBalance(statement.getClosingBalance());
        java.util.Date closingDate = statement.getClosingDate();
        if (closingDate != null) {
            c.setClosingDate(new Date(statement.getClosingDate().getTime()));
        }
        c.setClosingFinal(statement.isLastPage());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt05300104Statement statement) {
        this.setFile(p);
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(statement.getPageNumber());
        p.setReference1(statement.getMessageId());
        p.setReference2(statement.getReference());
        p.setCurrency(statement.getCurrency());
        p.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date openingDate = statement.getOpeningDate();
        if (openingDate != null) {
            p.setOpeningDate(new Date(openingDate.getTime()));
        }
        p.setOpeningFinal(statement.isFirstPage());
        p.setClosingBalance(statement.getClosingBalance());
        java.util.Date closingDate = statement.getClosingDate();
        if (closingDate != null) {
            p.setClosingDate(new Date(statement.getClosingDate().getTime()));
        }
        p.setClosingFinal(statement.isLastPage());
    }

    private void processCamt05300104Bookings(CmStatement s, CmPage p, List<ReportEntry4> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        this.currentBalance = p != null ? p.getOpeningBalance() : s.getOpeningBalance();
        if (this.currentBalance == null) {
            this.currentBalance = BigDecimal.ZERO;
        }
        for (ReportEntry4 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt05300104Booking tmpParent = new Camt05300104Booking(ntry, null, null);
                this.collectiveCurrentBalance = this.currentBalance;
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt05300104Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt05300104Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt05300104Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    this.collectiveCurrentBalance = this.currentBalance;
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 0);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    Camt05300104Booking booking = new Camt05300104Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        CMProcessingDb.connectToSingleBookings(b, b.getCustomerReference(), this.preferences);
                        try {
                            CMProcessingDb.connectToSignedPayments(b, this.logger);
                        }
                        catch (Exception e) {
                            this.logger.logError("Error connecting the booking to signedPayments", e);
                        }
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt053Processing.deleteHigherPositionedBookings(s, p, pos);
        Camt053Processing.storeStatistics(s, p, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCamt05300108(List<Camt05300108Statement> statements) throws Exception {
        if (this.existingFile != null) {
            if (statements.size() == 1) {
                Camt05300108Statement statement = statements.get(0);
                this.processStatement(statement);
            } else {
                this.logMigrationError(this.existingFile);
            }
        } else {
            for (Camt05300108Statement statement : statements) {
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    Camt05300108Writer.write(statement, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(statement);
            }
        }
    }

    private void processStatement(Camt05300108Statement statement) throws IOException {
        String statementNumber;
        java.util.Date date;
        this.latestAccount = this.findOrCreateAccount(statement.getAccountIdentifier(), statement.getCurrency());
        if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
            return;
        }
        if (this.existingFile == null) {
            this.createAccountDir(statement.getAccountIdentifier());
        }
        if (this.mt940StatementExists(date = statement.getClosingDate() != null ? statement.getClosingDate() : statement.getCreationDate(), statementNumber = statement.getNumber())) {
            return;
        }
        String uniqueId = CMProcessingDb.getUniqueStatementId(date, statementNumber, "_C53");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.createStatement(uniqueId, statement);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumber(c, statement.getPageNumber());
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(statement);
                }
                this.createPage(c, statement);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(statement);
                }
                this.updatePage(c, cmPage, statement);
            }
        } else if (statement.getPageNumber() != 0 && statement.getPageNumber() != c.getPageNumberAsInt()) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.createPage(c, statement);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(statement);
            }
            this.updateStatement(c, statement);
        }
    }

    private void createTargetFile(Camt05300108Statement statement) {
        java.util.Date date = statement.getClosingDate() != null ? statement.getClosingDate() : statement.getCreationDate();
        String commonPart = ((SimpleDateFormat)YYMMDD.get()).format(date) + "_" + statement.getNumber();
        String dirName = commonPart + ".camt053";
        String fileName = statement.getPageNumber() > 0 ? commonPart + "_" + statement.getPageNumber() + ".camt053" : dirName;
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    private void createStatement(String uniqueId, Camt05300108Statement statement) {
        CmStatement c = CMProcessingDb.createStatement(uniqueId, CmStatement.Type.CAMT053, this.latestAccount);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05300108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void updateStatement(CmStatement c, Camt05300108Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05300108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt05300108Statement statement) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, statement);
        DB.save(p);
        this.updateStatementByPage(s, p);
        this.processCamt05300108Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void updatePage(CmStatement s, CmPage p, Camt05300108Statement statement) {
        this.setPageData(p, statement);
        DB.update(p);
        this.updateStatementByPage(s, p);
        this.processCamt05300108Bookings(s, p, statement.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt05300108Statement statement) {
        this.setFile(c);
        c.setOriginalFilename(this.originalFilename);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            c.setStatementNumber(Integer.valueOf(statement.getNumber()));
        }
        catch (Exception e) {
            this.logger.logError("Camt053Procesing: Could not parse statement number '" + statement.getNumber() + "' to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        if (statement.getLegalNumber() != null) {
            try {
                c.setLegalNumber(Integer.valueOf(statement.getLegalNumber()));
            }
            catch (Exception e) {
                this.logger.logError("Camt053Procesing: Could not parse legal number '" + statement.getLegalNumber() + "' to integer", e);
            }
        } else {
            c.setLegalNumber(null);
        }
        c.setCurrency(statement.getCurrency());
        c.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date openingDate = statement.getOpeningDate();
        if (openingDate != null) {
            c.setOpeningDate(new Date(openingDate.getTime()));
        }
        c.setOpeningFinal(statement.isFirstPage());
        c.setClosingBalance(statement.getClosingBalance());
        java.util.Date closingDate = statement.getClosingDate();
        if (closingDate != null) {
            c.setClosingDate(new Date(statement.getClosingDate().getTime()));
        }
        c.setClosingFinal(statement.isLastPage());
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt05300108Statement statement) {
        this.setFile(p);
        java.util.Date creationDate = statement.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(statement.getPageNumber());
        p.setReference1(statement.getMessageId());
        p.setReference2(statement.getReference());
        p.setCurrency(statement.getCurrency());
        p.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date openingDate = statement.getOpeningDate();
        if (openingDate != null) {
            p.setOpeningDate(new Date(openingDate.getTime()));
        }
        p.setOpeningFinal(statement.isFirstPage());
        p.setClosingBalance(statement.getClosingBalance());
        java.util.Date closingDate = statement.getClosingDate();
        if (closingDate != null) {
            p.setClosingDate(new Date(statement.getClosingDate().getTime()));
        }
        p.setClosingFinal(statement.isLastPage());
    }

    private void processCamt05300108Bookings(CmStatement s, CmPage p, List<ReportEntry10> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        this.currentBalance = p != null ? p.getOpeningBalance() : s.getOpeningBalance();
        if (this.currentBalance == null) {
            this.currentBalance = BigDecimal.ZERO;
        }
        for (ReportEntry10 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt05300108Booking tmpParent = new Camt05300108Booking(ntry, null, null);
                this.collectiveCurrentBalance = this.currentBalance;
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt05300108Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt05300108Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt05300108Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    this.collectiveCurrentBalance = this.currentBalance;
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 0);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    Camt05300108Booking booking = new Camt05300108Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        CMProcessingDb.connectToSingleBookings(b, b.getCustomerReference(), this.preferences);
                        try {
                            CMProcessingDb.connectToSignedPayments(b, this.logger);
                        }
                        catch (Exception e) {
                            this.logger.logError("Error connecting the booking to signedPayments", e);
                        }
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt053Processing.deleteHigherPositionedBookings(s, p, pos);
        Camt053Processing.storeStatistics(s, p, statistics);
    }

    @Override
    protected void processBookingData(CmBooking b, CmStatement s, CmPage page, Booking booking, CmBooking parentBooking, boolean collective) {
        this.setBookingData(b, s, page, booking, parentBooking, collective);
        if (this.currentBalance != null && parentBooking == null) {
            this.currentBalance = this.currentBalance.add(b.getAmount());
            b.setBalance(this.currentBalance);
        } else if (this.collectiveCurrentBalance != null && parentBooking != null) {
            this.collectiveCurrentBalance = this.collectiveCurrentBalance.add(b.getAmount());
            b.setBalance(this.collectiveCurrentBalance);
        }
    }

    @Override
    protected Date getBookingDateFromStatement(CmStatement statement) {
        return statement.getClosingDate();
    }

    private boolean mt940StatementExists(java.util.Date date, String statementNumber) {
        String uniqueMT940Id = CMProcessingDb.getUniqueStatementId(date, statementNumber, "_STA");
        if (CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueMT940Id) != null) {
            if (this.logger != null) {
                this.logger.logInfo("No processing of camt.053-file since corresponding MT940 statement " + uniqueMT940Id + " exists.");
            }
            return true;
        }
        return false;
    }
}

