/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.api.CMProcessingDb;
import de.businesslogics.banking.mt940.api.Camt05200104Writer;
import de.businesslogics.banking.mt940.api.Camt05200108Writer;
import de.businesslogics.banking.mt940.api.Camt052Writer;
import de.businesslogics.banking.mt940.api.Camt05XProcessing;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.RootChoiceParser;
import de.businesslogics.format.camt052.Camt05200104Booking;
import de.businesslogics.format.camt052.Camt05200104Statement;
import de.businesslogics.format.camt052.Camt05200108Booking;
import de.businesslogics.format.camt052.Camt05200108Statement;
import de.businesslogics.format.camt052.Camt052Booking;
import de.businesslogics.format.camt052.Camt052Statement;
import de.businesslogics.format.camt05x.Booking;
import de.businesslogics.format.iso20022.camt05200102.EntryDetails1;
import de.businesslogics.format.iso20022.camt05200102.EntryTransaction2;
import de.businesslogics.format.iso20022.camt05200102.ReportEntry2;
import de.businesslogics.format.iso20022.camt05200104.Document;
import de.businesslogics.format.iso20022.camt05200104.EntryDetails3;
import de.businesslogics.format.iso20022.camt05200104.EntryTransaction4;
import de.businesslogics.format.iso20022.camt05200104.ReportEntry4;
import de.businesslogics.format.iso20022.camt05200108.EntryDetails9;
import de.businesslogics.format.iso20022.camt05200108.EntryTransaction10;
import de.businesslogics.format.iso20022.camt05200108.ReportEntry10;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import org.xml.sax.SAXException;

public class Camt052Processing
extends Camt05XProcessing {
    private final SimpleDateFormat yyyyMMddHHmmFormat = new SimpleDateFormat("yyyyMMddHHmm");

    public Camt052Processing(BankSettings bank, CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        super(CmStatement.Type.CAMT052, bank, reporter, "camt053", logger, encrypt, preferences);
    }

    @Override
    public void processUnzipped(String originalFilename, InputStream in) throws Exception {
        this.originalFilename = originalFilename;
        EbicsElement e = this.getDocument(in);
        if (e instanceof de.businesslogics.format.iso20022.camt05200102.Document) {
            this.processCamt05200102(Camt052Statement.loadStatements((de.businesslogics.format.iso20022.camt05200102.Document)e));
        } else if (e instanceof Document) {
            this.processCamt05200104(Camt05200104Statement.loadStatements((Document)e));
        } else if (e instanceof de.businesslogics.format.iso20022.camt05200108.Document) {
            this.processCamt05200108(Camt05200108Statement.loadStatements((de.businesslogics.format.iso20022.camt05200108.Document)e));
        } else {
            throw new IOException("Unsupported camt.052 version");
        }
    }

    private EbicsElement getDocument(InputStream in) throws IOException, SAXException {
        RootChoiceParser p = new RootChoiceParser();
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05200102.Document.class);
        p.addPossibleRoot("ISO:camt.052.001.02:APC:STUZZA:payments:003", "Document", de.businesslogics.format.iso20022.camt05200102.Document.class);
        p.addPossibleRoot(Document.class);
        p.addPossibleRoot(de.businesslogics.format.iso20022.camt05200108.Document.class);
        return EbicsHandler.parse(in, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCamt05200102(List<Camt052Statement> statements) throws Exception {
        boolean ignoreOldAdvices = this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
        if (this.existingFile != null) {
            if (statements.size() == 1) {
                Camt052Statement s = statements.get(0);
                this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
                if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                    return;
                }
                this.processCamt052(s);
            } else {
                this.logMigrationError(this.existingFile);
            }
        } else {
            Camt052Writer w = new Camt052Writer();
            for (Camt052Statement s : statements) {
                this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
                if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                    return;
                }
                if (ignoreOldAdvices && !this.hasNewBookings(s, this.latestAccount)) continue;
                this.createAccountDir(s.getAccountIdentifier());
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    w.write(s, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processCamt052(s);
            }
        }
    }

    public boolean hasNewBookings(Camt052Statement advice, Account a) {
        Date obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(a);
        if (obsoleteDate == null) {
            return true;
        }
        java.util.Date defaultBookingDate = advice.getCreationDate();
        CmStatement stmt = CmStatement.findNewestStatement(a, (Date)null);
        if (stmt != null && stmt.getCreationDate().before(advice.getCreationDate())) {
            return true;
        }
        if (defaultBookingDate.after(obsoleteDate)) {
            return true;
        }
        for (ReportEntry2 ntry : advice.getStatement().getNtrys()) {
            Camt052Booking tmpParent;
            Object parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails > 1 && !this.getBookingDate((tmpParent = new Camt052Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                return true;
            }
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                Camt052Booking tmpParent2;
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions > 1 && !this.getBookingDate((tmpParent2 = new Camt052Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                    return true;
                }
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    Camt052Booking booking = new Camt052Booking(ntry, details, transaction);
                    if (this.getBookingDate(booking.getBookingDate(), defaultBookingDate).before(obsoleteDate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processCamt052(Camt052Statement advice) {
        java.util.Date creationDate = advice.getCreationDate();
        String uniqueId = CMProcessingDb.getUniqueAdviceId(creationDate, advice.getNumber(), "_C52");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createStatement(advice, uniqueId);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, advice.getPageNumber(), new Timestamp(advice.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.createPage(c, advice);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.updatePage(c, cmPage, advice);
            }
        } else if (this.isSecondPage(c, advice.getPageNumber(), creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createPage(c, advice);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.updateStatement(c, advice);
        }
    }

    private void createTargetFile(Camt052Statement advice) {
        String timeStamp = ((SimpleDateFormat)YYMMDDHHmm.get()).format(advice.getCreationDate());
        Object commonPart = timeStamp.substring(0, 6);
        String time = timeStamp.substring(6);
        String number = advice.getNumber();
        int pageNumber = advice.getPageNumber();
        if (number != null && number.trim().length() > 0) {
            commonPart = (String)commonPart + "_" + number.trim();
        }
        String dirName = (String)commonPart + ".camt052";
        String fileName = pageNumber > 0 ? (String)commonPart + "_" + pageNumber + "-" + time + ".camt052" : (String)commonPart + "-" + time + ".camt052";
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    protected void createStatement(Camt052Statement statement, String uniqueId) {
        CmStatement c = new CmStatement();
        c.setUniqueId(uniqueId);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processBookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    protected void updateStatement(CmStatement c, Camt052Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processBookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt052Statement advice) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, advice);
        DB.save(p);
        this.processBookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void updatePage(CmStatement s, CmPage p, Camt052Statement advice) {
        this.setPageData(p, advice);
        DB.update(p);
        this.processBookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt052Statement statement) {
        java.util.Date creationDate;
        c.setType(CmStatement.Type.CAMT052);
        c.setAccount(this.latestAccount);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            if (statement.getNumber() != null) {
                c.setStatementNumber(Integer.valueOf(statement.getNumber()));
            }
        }
        catch (Exception e) {
            this.logger.logError("Camt052Procesing: Could not parse " + statement.getNumber() + " to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        c.setOriginalFilename(this.originalFilename);
        this.setFile(c);
        c.setCurrency(statement.getCurrency());
        c.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date date = statement.getOpeningDate();
        if (date != null) {
            c.setOpeningDate(new Date(date.getTime()));
        }
        c.setClosingBalance(statement.getClosingBalance());
        date = statement.getClosingDate();
        if (date != null) {
            c.setClosingDate(new Date(date.getTime()));
        }
        if ((creationDate = statement.getCreationDate()) != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt052Statement advice) {
        this.setFile(p);
        java.util.Date creationDate = advice.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(advice.getPageNumber());
        p.setReference1(advice.getMessageId());
        p.setReference2(advice.getReference());
        p.setCurrency(advice.getCurrency());
    }

    protected void processBookings(CmStatement s, CmPage p, List<ReportEntry2> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        for (ReportEntry2 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt052Booking tmpParent = new Camt052Booking(ntry, null, null);
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails1 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt052Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt052Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt052Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 0);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction2 transaction : details.getTxDtlss()) {
                    Camt052Booking booking = new Camt052Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        CMProcessingDb.connectToSingleBookings(b, b.getCustomerReference(), this.preferences);
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt052Processing.deleteHigherPositionedBookings(s, p, pos);
        Camt052Processing.storeStatistics(s, p, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCamt05200104(List<Camt05200104Statement> statements) throws Exception {
        boolean ignoreOldAdvices = this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
        if (this.existingFile != null) {
            if (statements.size() == 1) {
                Camt05200104Statement s = statements.get(0);
                this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
                if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                    return;
                }
                this.processStatement(s);
            } else {
                this.logMigrationError(this.existingFile);
            }
        } else {
            Camt05200104Writer w = new Camt05200104Writer();
            for (Camt05200104Statement s : statements) {
                this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
                if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                    return;
                }
                if (ignoreOldAdvices && !this.hasNewBookings(s, this.latestAccount)) continue;
                this.createAccountDir(s.getAccountIdentifier());
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    w.write(s, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(s);
            }
        }
    }

    public boolean hasNewBookings(Camt05200104Statement advice, Account a) {
        Date obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(a);
        if (obsoleteDate == null) {
            return true;
        }
        java.util.Date defaultBookingDate = advice.getCreationDate();
        CmStatement stmt = CmStatement.findNewestStatement(a, (Date)null);
        if (stmt != null && stmt.getCreationDate().before(advice.getCreationDate())) {
            return true;
        }
        if (defaultBookingDate.after(obsoleteDate)) {
            return true;
        }
        for (ReportEntry4 ntry : advice.getStatement().getNtrys()) {
            Camt05200104Booking tmpParent;
            Object parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails > 1 && !this.getBookingDate((tmpParent = new Camt05200104Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                return true;
            }
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                Camt05200104Booking tmpParent2;
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions > 1 && !this.getBookingDate((tmpParent2 = new Camt05200104Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                    return true;
                }
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    Camt05200104Booking booking = new Camt05200104Booking(ntry, details, transaction);
                    if (this.getBookingDate(booking.getBookingDate(), defaultBookingDate).before(obsoleteDate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processStatement(Camt05200104Statement advice) {
        java.util.Date creationDate = advice.getCreationDate();
        String uniqueId = CMProcessingDb.getUniqueAdviceId(creationDate, advice.getNumber(), "_C52");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createStatement(advice, uniqueId);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, advice.getPageNumber(), new Timestamp(advice.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.createPage(c, advice);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.updatePage(c, cmPage, advice);
            }
        } else if (this.isSecondPage(c, advice.getPageNumber(), creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createPage(c, advice);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.updateStatement(c, advice);
        }
    }

    private void createTargetFile(Camt05200104Statement advice) {
        String timeStamp = ((SimpleDateFormat)YYMMDDHHmm.get()).format(advice.getCreationDate());
        Object commonPart = timeStamp.substring(0, 6);
        String time = timeStamp.substring(6);
        String number = advice.getNumber();
        int pageNumber = advice.getPageNumber();
        if (number != null && number.trim().length() > 0) {
            commonPart = (String)commonPart + "_" + number.trim();
        }
        String dirName = (String)commonPart + ".camt052";
        String fileName = pageNumber > 0 ? (String)commonPart + "_" + pageNumber + "-" + time + ".camt052" : (String)commonPart + "-" + time + ".camt052";
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    protected void createStatement(Camt05200104Statement statement, String uniqueId) {
        CmStatement c = new CmStatement();
        c.setUniqueId(uniqueId);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05200104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    protected void updateStatement(CmStatement c, Camt05200104Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05200104Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt05200104Statement advice) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, advice);
        DB.save(p);
        this.processCamt05200104Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void updatePage(CmStatement s, CmPage p, Camt05200104Statement advice) {
        this.setPageData(p, advice);
        DB.update(p);
        this.processCamt05200104Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt05200104Statement statement) {
        java.util.Date creationDate;
        c.setType(CmStatement.Type.CAMT052);
        c.setAccount(this.latestAccount);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            if (statement.getNumber() != null) {
                c.setStatementNumber(Integer.valueOf(statement.getNumber()));
            }
        }
        catch (Exception e) {
            this.logger.logError("Camt052Procesing: Could not parse " + statement.getNumber() + " to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        c.setOriginalFilename(this.originalFilename);
        this.setFile(c);
        c.setCurrency(statement.getCurrency());
        c.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date date = statement.getOpeningDate();
        if (date != null) {
            c.setOpeningDate(new Date(date.getTime()));
        }
        c.setClosingBalance(statement.getClosingBalance());
        date = statement.getClosingDate();
        if (date != null) {
            c.setClosingDate(new Date(date.getTime()));
        }
        if ((creationDate = statement.getCreationDate()) != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt05200104Statement advice) {
        this.setFile(p);
        java.util.Date creationDate = advice.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(advice.getPageNumber());
        p.setReference1(advice.getMessageId());
        p.setReference2(advice.getReference());
        p.setCurrency(advice.getCurrency());
    }

    protected void processCamt05200104Bookings(CmStatement s, CmPage p, List<ReportEntry4> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        for (ReportEntry4 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt05200104Booking tmpParent = new Camt05200104Booking(ntry, null, null);
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails3 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt05200104Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt05200104Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt05200104Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 0);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction4 transaction : details.getTxDtlss()) {
                    Camt05200104Booking booking = new Camt05200104Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        CMProcessingDb.connectToSingleBookings(b, b.getCustomerReference(), this.preferences);
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt052Processing.deleteHigherPositionedBookings(s, p, pos);
        Camt052Processing.storeStatistics(s, p, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCamt05200108(List<Camt05200108Statement> statements) throws Exception {
        boolean ignoreOldAdvices = this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES);
        if (this.existingFile != null) {
            if (statements.size() == 1) {
                Camt05200108Statement s = statements.get(0);
                this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
                if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                    return;
                }
                this.processStatement(s);
            } else {
                this.logMigrationError(this.existingFile);
            }
        } else {
            Camt05200108Writer w = new Camt05200108Writer();
            for (Camt05200108Statement s : statements) {
                this.latestAccount = this.findOrCreateAccount(s.getAccountIdentifier(), s.getCurrency());
                if (this.latestAccount.getIgnoreAccountInformation() && !this.reporter.isImportMode()) {
                    return;
                }
                if (ignoreOldAdvices && !this.hasNewBookings(s, this.latestAccount)) continue;
                this.createAccountDir(s.getAccountIdentifier());
                OutputStream out = null;
                try {
                    out = this.getTempOutputStream();
                    w.write(s, out);
                }
                finally {
                    SystemUtils.close(out);
                }
                this.processStatement(s);
            }
        }
    }

    public boolean hasNewBookings(Camt05200108Statement advice, Account a) {
        Date obsoleteDate = ValueBalanceCalculator.getObsoleteDateForAdvices(a);
        if (obsoleteDate == null) {
            return true;
        }
        java.util.Date defaultBookingDate = advice.getCreationDate();
        CmStatement stmt = CmStatement.findNewestStatement(a, (Date)null);
        if (stmt != null && stmt.getCreationDate().before(advice.getCreationDate())) {
            return true;
        }
        if (defaultBookingDate.after(obsoleteDate)) {
            return true;
        }
        for (ReportEntry10 ntry : advice.getStatement().getNtrys()) {
            Camt05200108Booking tmpParent;
            Object parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails > 1 && !this.getBookingDate((tmpParent = new Camt05200108Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                return true;
            }
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                Camt05200108Booking tmpParent2;
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions > 1 && !this.getBookingDate((tmpParent2 = new Camt05200108Booking(ntry, null, null)).getBookingDate(), defaultBookingDate).before(obsoleteDate)) {
                    return true;
                }
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    Camt05200108Booking booking = new Camt05200108Booking(ntry, details, transaction);
                    if (this.getBookingDate(booking.getBookingDate(), defaultBookingDate).before(obsoleteDate)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void processStatement(Camt05200108Statement advice) {
        java.util.Date creationDate = advice.getCreationDate();
        String uniqueId = CMProcessingDb.getUniqueAdviceId(creationDate, advice.getNumber(), "_C52");
        CmStatement c = CmStatement.findByAccountAndUniqueId(this.latestAccount, uniqueId);
        if (c == null) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createStatement(advice, uniqueId);
        } else if (c.isHasPages()) {
            CmPage cmPage = CmPage.findByPageNumberAndCreationDate(c, advice.getPageNumber(), new Timestamp(advice.getCreationDate().getTime()));
            if (cmPage == null) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.createPage(c, advice);
            } else if (this.hasDifferentContent(this.getMD5Hash(), cmPage.getMd5Hash())) {
                if (this.existingFile == null) {
                    this.createTargetFile(advice);
                }
                this.updatePage(c, cmPage, advice);
            }
        } else if (this.isSecondPage(c, advice.getPageNumber(), creationDate)) {
            CMProcessingDb.createPageFromStatement(c);
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.createPage(c, advice);
        } else if (this.hasDifferentContent(this.getMD5Hash(), c.getMd5Hash())) {
            if (this.existingFile == null) {
                this.createTargetFile(advice);
            }
            this.updateStatement(c, advice);
        }
    }

    private void createTargetFile(Camt05200108Statement advice) {
        String timeStamp = ((SimpleDateFormat)YYMMDDHHmm.get()).format(advice.getCreationDate());
        Object commonPart = timeStamp.substring(0, 6);
        String time = timeStamp.substring(6);
        String number = advice.getNumber();
        int pageNumber = advice.getPageNumber();
        if (number != null && number.trim().length() > 0) {
            commonPart = (String)commonPart + "_" + number.trim();
        }
        String dirName = (String)commonPart + ".camt052";
        String fileName = pageNumber > 0 ? (String)commonPart + "_" + pageNumber + "-" + time + ".camt052" : (String)commonPart + "-" + time + ".camt052";
        File targetDir = new File(this.accountDir, dirName);
        this.createTargetFile(targetDir, fileName);
    }

    protected void createStatement(Camt05200108Statement statement, String uniqueId) {
        CmStatement c = new CmStatement();
        c.setUniqueId(uniqueId);
        this.setStatementData(c, statement);
        DB.save(c);
        this.processCamt05200108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    protected void updateStatement(CmStatement c, Camt05200108Statement statement) {
        this.setStatementData(c, statement);
        DB.update(c);
        this.processCamt05200108Bookings(c, null, statement.getStatement().getNtrys());
        this.reporter.newStatement(c, null);
    }

    private void createPage(CmStatement s, Camt05200108Statement advice) {
        CmPage p = CMProcessingDb.createPage(s);
        this.setPageData(p, advice);
        DB.save(p);
        this.processCamt05200108Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
        this.setOldFlagForPages(s);
    }

    private void updatePage(CmStatement s, CmPage p, Camt05200108Statement advice) {
        this.setPageData(p, advice);
        DB.update(p);
        this.processCamt05200108Bookings(s, p, advice.getStatement().getNtrys());
        this.reporter.newStatement(s, p);
    }

    private void setStatementData(CmStatement c, Camt05200108Statement statement) {
        java.util.Date creationDate;
        c.setType(CmStatement.Type.CAMT052);
        c.setAccount(this.latestAccount);
        c.setReference1(statement.getMessageId());
        c.setReference2(statement.getReference());
        try {
            if (statement.getNumber() != null) {
                c.setStatementNumber(Integer.valueOf(statement.getNumber()));
            }
        }
        catch (Exception e) {
            this.logger.logError("Camt052Procesing: Could not parse " + statement.getNumber() + " to integer", e);
        }
        c.setPageNumberAsInt(statement.getPageNumber());
        c.setOriginalFilename(this.originalFilename);
        this.setFile(c);
        c.setCurrency(statement.getCurrency());
        c.setOpeningBalance(statement.getOpeningBalance());
        java.util.Date date = statement.getOpeningDate();
        if (date != null) {
            c.setOpeningDate(new Date(date.getTime()));
        }
        c.setClosingBalance(statement.getClosingBalance());
        date = statement.getClosingDate();
        if (date != null) {
            c.setClosingDate(new Date(date.getTime()));
        }
        if ((creationDate = statement.getCreationDate()) != null) {
            c.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        c.setAdditionalInformation(statement.getAdditionalInfo());
    }

    private void setPageData(CmPage p, Camt05200108Statement advice) {
        this.setFile(p);
        java.util.Date creationDate = advice.getCreationDate();
        if (creationDate != null) {
            p.setCreationDate(new Timestamp(creationDate.getTime()));
        }
        p.setPageNumberAsInt(advice.getPageNumber());
        p.setReference1(advice.getMessageId());
        p.setReference2(advice.getReference());
        p.setCurrency(advice.getCurrency());
    }

    protected void processCamt05200108Bookings(CmStatement s, CmPage p, List<ReportEntry10> bookings) {
        BookingStatistics statistics = new BookingStatistics();
        int pos = 0;
        for (ReportEntry10 ntry : bookings) {
            CmBooking parent = null;
            int countDetails = ntry.getNtryDtlss().size();
            if (countDetails != 1) {
                Camt05200108Booking tmpParent = new Camt05200108Booking(ntry, null, null);
                parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countDetails > 1);
                statistics.addBooking(parent.getAmount());
                this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
            }
            for (EntryDetails9 details : ntry.getNtryDtlss()) {
                int countTransactions = details.getTxDtlss().size();
                if (parent == null && countTransactions != 1) {
                    Camt05200108Booking tmpParent;
                    if (countTransactions == 0) {
                        tmpParent = new Camt05200108Booking(ntry, details, null);
                    } else {
                        tmpParent = new Camt05200108Booking(ntry, null, null);
                        tmpParent.setNbOfTxs(countTransactions);
                    }
                    parent = this.findOrCreateBooking(s, p, pos++, tmpParent, null, countTransactions > 0);
                    statistics.addBooking(parent.getAmount());
                    this.createChargeRecords(parent, s, p, tmpParent.getChargesRecordsOnNtryLevel());
                }
                for (EntryTransaction10 transaction : details.getTxDtlss()) {
                    Camt05200108Booking booking = new Camt05200108Booking(ntry, details, transaction);
                    if (countTransactions != 1) {
                        booking.setNbOfTxs(null);
                    }
                    CmBooking b = this.findOrCreateBooking(s, p, pos++, booking, parent, false);
                    if (parent == null) {
                        CMProcessingDb.connectToSingleBookings(b, b.getCustomerReference(), this.preferences);
                        statistics.addBooking(b.getAmount());
                        this.createChargeRecords(b, s, p, booking.getChargesRecordsOnNtryLevel());
                    }
                    this.createChargeRecords(b, s, p, booking.getChargesRecordsOnTxLevel());
                }
            }
        }
        Camt052Processing.deleteHigherPositionedBookings(s, p, pos);
        Camt052Processing.storeStatistics(s, p, statistics);
    }

    @Override
    protected void processBookingData(CmBooking b, CmStatement s, CmPage page, Booking booking, CmBooking parentBooking, boolean collective) {
        this.setBookingData(b, s, page, booking, parentBooking, collective);
    }

    @Override
    protected Date getBookingDateFromStatement(CmStatement statement) {
        if (statement.getCreationDate() != null) {
            return new Date(statement.getCreationDate().getTime());
        }
        return null;
    }

    private java.util.Date getBookingDate(java.util.Date bookingDate, java.util.Date defaultBookingDate) {
        if (bookingDate != null) {
            return bookingDate;
        }
        return defaultBookingDate;
    }

    private boolean isSecondPage(CmStatement s, int pageNumber, java.util.Date creationDate) {
        String timeStampDb;
        if (pageNumber != s.getPageNumberAsInt()) {
            return true;
        }
        String timeStamp = this.yyyyMMddHHmmFormat.format(creationDate);
        return !timeStamp.equals(timeStampDb = this.yyyyMMddHHmmFormat.format(s.getCreationDate()));
    }

    private void setOldFlagForPages(CmStatement advice) {
        CmPage.markOtherAsOld(advice);
    }
}

