/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PreferenceUtil;
import de.businesslogics.banking.api.SignedPaymentsUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmCheck;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.mt940.BookingStatistics;
import de.businesslogics.banking.mt940.StreamHandler;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.Update;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public abstract class CMProcessingDb {
    private static final int SKIP_MATCHING = 99;
    private static final long DAY_IN_MILLISECONDS = 86400000L;
    protected static final String EUR = "EUR";
    protected static final Currency EURO = Currency.getInstance("EUR");
    protected static final ThreadLocal<SimpleDateFormat> YYMMDD = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyMMdd"));
    protected static final ThreadLocal<SimpleDateFormat> YYYYMMDD = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));
    protected static final ThreadLocal<SimpleDateFormat> YYMMDDHHmm = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyMMddHHmm"));
    protected BankSettings bank;
    protected String accountIdentifier;
    protected Currency currency;
    protected CmReporter reporter = null;
    protected final BLLogger logger;
    protected final EncryptData encrypt;
    protected final DatabasePreferenceStore preferences;
    private String namePrefix = WorkspaceFileSystem.CM_DIRECTORY.toString();
    protected File accountParentDir;
    protected File accountDir;
    protected Account latestAccount = null;
    protected File existingFile;
    private File tempFile;
    protected File targetFile;
    private final StreamHandler streamHandler;

    protected CMProcessingDb(BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        this.streamHandler = new StreamHandler();
        this.logger = logger;
        this.encrypt = encrypt;
        this.preferences = preferences;
    }

    protected CMProcessingDb(BankSettings bank, CmReporter reporter, String formatDirName, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        this.bank = bank;
        this.reporter = reporter;
        this.logger = logger;
        this.encrypt = encrypt;
        this.preferences = preferences;
        this.streamHandler = new StreamHandler();
        this.accountParentDir = new File(new File(WorkspaceFileSystem.CM_DIRECTORY, bank.getUniqueKey()), formatDirName);
        this.accountParentDir.mkdirs();
    }

    protected void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    protected final OutputStream getTempOutputStream() throws IOException {
        this.tempFile = Util.createTempFile("Temp", "dti", false);
        return this.streamHandler.createTempFileOutputStream(this.tempFile, this.encrypt);
    }

    public final Account importExistingFile(File file) throws Exception {
        this.existingFile = file;
        InputStream in = null;
        try {
            in = this.streamHandler.createExistingFileInputStream(this.existingFile, this.encrypt);
            this.process(in);
        }
        catch (Throwable throwable) {
            SystemUtils.close(in);
            throw throwable;
        }
        SystemUtils.close(in);
        this.existingFile = null;
        return this.latestAccount;
    }

    protected void createTargetFile(File targetDir, String targetFileName) {
        targetDir.mkdirs();
        this.targetFile = new File(targetDir, targetFileName);
        try {
            SystemUtils.renameFile(this.tempFile, this.targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createTargetFile() {
        try {
            SystemUtils.renameFile(this.tempFile, this.targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setFile(CmStatement s) {
        long fileSize = this.streamHandler.getFileSize();
        String hash = this.streamHandler.getMD5Hash();
        WorkspaceFile file = s.isDtiFile() ? WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.DTI, this.getDbFile(), fileSize, hash, null) : WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.CM, this.getDbFile(), fileSize, hash, null);
        s.setFile(file);
    }

    protected void setFile(CmPage p) {
        long fileSize = this.streamHandler.getFileSize();
        String hash = this.streamHandler.getMD5Hash();
        WorkspaceFile file = p.getStatement().isDtiFile() ? WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.DTI, this.getDbFile(), fileSize, hash, null) : WorkspaceFileSystem.createFile(WorkspaceFile.Prefix.CM, this.getDbFile(), fileSize, hash, null);
        p.setFile(file);
    }

    protected String getMD5Hash() {
        return this.streamHandler.getMD5Hash();
    }

    protected boolean hasDifferentContent(String newHash, String oldHash) {
        if (newHash.equals(oldHash)) {
            if (this.tempFile != null && !this.tempFile.delete()) {
                this.tempFile.deleteOnExit();
            }
            return false;
        }
        return true;
    }

    protected void createAccountDir(String accountIdentifier) throws IOException {
        String accountDirName = MT940Processing.transform(accountIdentifier);
        this.accountDir = new File(this.accountParentDir, accountDirName);
        this.accountDir.mkdirs();
    }

    protected abstract void process(InputStream var1) throws Exception;

    protected String getDbFileName() {
        return this.getDbFile().getAbsolutePath().substring(this.namePrefix.length());
    }

    private File getDbFile() {
        return this.targetFile == null ? this.existingFile : this.targetFile;
    }

    protected void logMigrationError(File file) {
        this.logger.logError("Could not migrate file '" + file.getAbsolutePath() + "' into the database.", null);
    }

    protected abstract Account findOrCreateAccount();

    public static Account findOrCreateAccountByIban(BankSettings bank, String iban, Currency c) {
        String currency = CMProcessingDb.getCurrency(c);
        Account account = Account.findAccountByIban(bank, iban, currency);
        if (account == null) {
            account = new Account();
            account.setBank(bank);
            account.setIban(iban);
            account.setCurrency(currency);
            account.setType(Account.Type.CASH_MANAGEMENT);
            account.save();
            AccountPermission.createPermissionForAllUsers(account);
        }
        return account;
    }

    public static Account findOrCreateAccountByCmIdentifier(BankSettings bank, String accountIdentifier, Currency c) {
        Account account = Account.findAccountByCmIdentification(bank, accountIdentifier);
        if (account == null) {
            String blz = null;
            String kto = null;
            SEPABankConnection sepa = null;
            int index = accountIdentifier.indexOf(47);
            if (index > 0) {
                String left = accountIdentifier.substring(0, index);
                String right = accountIdentifier.substring(index + 1);
                if (Pattern.matches("\\d+\\D{3}", right)) {
                    right = right.substring(0, right.length() - 3);
                }
                if (PaymentUtils.isGermanBLZ(left) && PaymentUtils.isGermanAccountNumber(right)) {
                    account = Account.findAccountByGermanAccountNumberBic(bank, right, left, c.getCurrencyCode());
                    if (account != null) {
                        account.setCmIdentification(accountIdentifier);
                        account.save();
                        return account;
                    }
                    blz = left;
                    kto = right;
                    sepa = BLZCache.CACHE.getSEPABankConnection(left, right);
                    if (sepa != null && (account = Account.findAccountByIban(bank, sepa.getIban(), c.getCurrencyCode())) != null) {
                        account.setCmIdentification(accountIdentifier);
                        account.save();
                        return account;
                    }
                }
            }
            account = new Account();
            account.setBank(bank);
            account.setCurrency(CMProcessingDb.getCurrency(c));
            account.setCmIdentification(accountIdentifier);
            account.setType(Account.Type.CASH_MANAGEMENT);
            account.setGermanBankCode(blz);
            account.setGermanAccountNumber(kto);
            if (sepa != null) {
                account.setIban(sepa.getIban());
                account.setBic(sepa.getBic());
            }
            account.save();
            AccountPermission.createPermissionForAllUsers(account);
        }
        return account;
    }

    private static String getCurrency(Currency c) {
        return c != null ? c.getCurrencyCode() : EUR;
    }

    public static Account findOrCreateGermanAccount(BankSettings bank, String blz, String accNumber, String currency) {
        Account a = Account.findGermanAccount(bank, blz, accNumber, currency);
        if (a != null) {
            return a;
        }
        SEPABankConnection c = BLZCache.CACHE.getSEPABankConnection(blz, accNumber);
        if (c != null && (a = Account.findAccountByIban(bank, c.getIban(), currency)) != null) {
            if (a.getGermanAccountIdentifier() == null) {
                a.setGermanAccountNumber(accNumber);
                a.setGermanBankCode(blz);
                a.save();
            }
            return a;
        }
        a = new Account();
        a.setBank(bank);
        if (c != null) {
            a.setIban(c.getIban());
            a.setBic(c.getBic());
        }
        a.setGermanAccountNumber(accNumber);
        a.setGermanBankCode(blz);
        a.setCurrency(currency);
        a.setType(Account.Type.CASH_MANAGEMENT);
        a.save();
        return a;
    }

    public static Account findOrCreateFrenchAccount(BankSettings bank, String bankCode, String branchCode, String accountNumber, String currencyCode) {
        Account a = Account.findFrenchAccount(bank, bankCode, branchCode, accountNumber, currencyCode);
        if (a != null) {
            return a;
        }
        a = new Account();
        a.setBank(bank);
        a.setFrenchBankCode(bankCode);
        a.setFrenchBranchCode(branchCode);
        a.setFrenchAccountNumber(accountNumber);
        StringBuilder sb = new StringBuilder();
        int key = PaymentUtils.calculateRibKey(bankCode, branchCode, accountNumber);
        if (key < 10) {
            sb.append('0');
        }
        sb.append(key);
        a.setFrenchCheckCode(sb.toString());
        a.setCurrency(currencyCode);
        a.setType(Account.Type.CASH_MANAGEMENT);
        a.save();
        return a;
    }

    public static String getUniqueStatementId(java.util.Date date, String number, String formatSuffix) {
        StringBuilder uniqueId = new StringBuilder();
        uniqueId.append(YYMMDD.get().format(date));
        if (number != null) {
            uniqueId.append("_");
            uniqueId.append(number);
        }
        uniqueId.append(formatSuffix);
        return uniqueId.toString();
    }

    public static String getUniqueAdviceId(java.util.Date creationDate, String number, String formatSuffix) {
        return YYMMDDHHmm.get().format(creationDate) + "_" + number + formatSuffix;
    }

    public static CmBooking findBooking(CmStatement statement, CmPage page, int position) {
        if (page != null) {
            return (CmBooking)DB.find(CmBooking.class).where().eq("page", (Object)page).eq("pos", (Object)position).findOne();
        }
        return (CmBooking)DB.find(CmBooking.class).where().eq("statement", (Object)statement).eq("pos", (Object)position).findOne();
    }

    protected static void connectToSingleBookings(CmBooking b, String reference, DatabasePreferenceStore preferences) {
        if (reference != null && reference.trim().length() > 0) {
            Query<CmStatement> dtiFilesQuery;
            long referenceDate;
            int toleranceInDays = preferences.getInt(CmPreferenceConstants.TOLERANCE_DTI_MT940_MATCHING);
            Date refDate = b.getCustomerReferenceDate();
            if (refDate == null) {
                refDate = b.getBookingDate();
            }
            long from = referenceDate = refDate.getTime();
            long to = referenceDate + 86400000L - 1L;
            long dateToleranceMs = 0L;
            if (toleranceInDays > 0) {
                dateToleranceMs = (long)toleranceInDays * 86400000L;
                from -= dateToleranceMs;
                to += dateToleranceMs;
            }
            if ((dtiFilesQuery = CmStatement.findDtiFiles(b.getAccount(), reference, new Timestamp(from), new Timestamp(to))) != null && dtiFilesQuery.findCount() > 0) {
                CmBooking booking;
                boolean doAmountCheck = preferences.getBoolean(CmPreferenceConstants.DTI_MT940_MATCHING_WITH_AMOUNT);
                MyConsumer consumer = new MyConsumer(doAmountCheck, dateToleranceMs, referenceDate, b.getAmount());
                dtiFilesQuery.findEach((Consumer)consumer);
                if (consumer.nearestDtiFile != null) {
                    int count = CmBooking.setParentBooking(consumer.nearestDtiFile, b);
                    if (count > 0) {
                        b.setCollective(true);
                        DB.update(b);
                    }
                } else if (doAmountCheck && (booking = CmBooking.findFirstByReferenceTimeAndAmount(CmStatement.DtiTypes, b.getAccount(), reference, new Timestamp(from), new Timestamp(to), b.getAmount())) != null) {
                    CmBooking.setParentBooking(booking, b);
                    b.setCollective(true);
                    DB.update(b);
                }
            }
        }
    }

    protected static void connectToSignedPayments(CmBooking b, BLLogger logger) {
        if (SignedPaymentsUtil.connectPaymentsWithBooking()) {
            Send sendItem;
            String msgId = StringUtils.checkNullAndTrim(b.getMsgId());
            String pmtInfId = StringUtils.checkNullAndTrim(b.getPmtInfId());
            if (msgId.length() > 0 && pmtInfId.length() > 0 && (sendItem = SignedPaymentsUtil.findPossibleSendItem(b, msgId, logger)) != null) {
                SignedPaymentsUtil.connectSignedPaymentsToBooking(b, sendItem, SignedPaymentsUtil.createVirtualStatements());
            }
        }
    }

    public static List<CmBooking> findParentBookings(CmStatement s, String reference, DatabasePreferenceStore preferences, BLLogger logger) {
        if (reference != null) {
            int toleranceInDays = preferences.getInt(CmPreferenceConstants.TOLERANCE_DTI_MT940_MATCHING);
            if (toleranceInDays == 99) {
                return null;
            }
            long resetCreationTime = CMProcessingDb.getResetTime(s.getCreationDate().getTime());
            Date creationDate = new Date(resetCreationTime);
            Date fromDate = null;
            Date toDate = null;
            if (toleranceInDays > 0) {
                long dateToleranceMs = (long)toleranceInDays * 86400000L;
                fromDate = new Date(resetCreationTime - dateToleranceMs);
                toDate = new Date(resetCreationTime + dateToleranceMs);
            }
            long startTime = System.currentTimeMillis();
            List<CmBooking> parentBookings = CmBooking.findParentBookings(s.getAccount(), reference, creationDate, fromDate, toDate);
            if (PreferenceUtil.logPerformance()) {
                StringBuilder sb = new StringBuilder();
                if (parentBookings != null) {
                    sb.append("Finding of ");
                    sb.append(parentBookings.size());
                    sb.append(" possible parent bookings for accountId=");
                } else {
                    sb.append("Search of possible parent bookings for accountId=");
                }
                sb.append(s.getAccount().getId());
                sb.append(", reference=");
                sb.append(reference);
                if (fromDate != null) {
                    sb.append(", fromDate=");
                    sb.append(fromDate);
                    sb.append(" and toDate=");
                    sb.append(toDate);
                } else {
                    sb.append(" and date=");
                    sb.append(creationDate);
                }
                Util.writePerformanceLogStartTime(logger, CMProcessingDb.class, sb.toString(), startTime);
            }
            if (parentBookings != null && parentBookings.size() > 0) {
                return parentBookings;
            }
        }
        return null;
    }

    public static CmBooking findParentBooking(List<CmBooking> bookings, BigDecimal amount, Timestamp creationTimestamp, DatabasePreferenceStore preferences) {
        boolean doAmountCheck = preferences.getBoolean(CmPreferenceConstants.DTI_MT940_MATCHING_WITH_AMOUNT);
        CmBooking nearestParentBooking = null;
        long smallestDifference = 0L;
        long creationDate = CMProcessingDb.getResetTime(creationTimestamp.getTime());
        CmBooking bookingFromAdviceWithRefDate = null;
        CmBooking bookingFromAdviceWithSameDate = null;
        for (CmBooking b : bookings) {
            if (doAmountCheck && b.getAmount().compareTo(amount) != 0) continue;
            boolean isAdvice = b.getStatement().isAdvice();
            if (b.getCustomerReferenceDate() != null) {
                if (isAdvice) {
                    bookingFromAdviceWithRefDate = b;
                    continue;
                }
                return b;
            }
            long difference = Math.abs(creationDate - b.getBookingDate().getTime());
            if (difference == 0L) {
                if (isAdvice) {
                    bookingFromAdviceWithSameDate = b;
                    continue;
                }
                return b;
            }
            if (nearestParentBooking != null && difference >= smallestDifference) continue;
            nearestParentBooking = b;
            smallestDifference = difference;
        }
        if (bookingFromAdviceWithRefDate != null) {
            return bookingFromAdviceWithRefDate;
        }
        if (bookingFromAdviceWithSameDate != null) {
            return bookingFromAdviceWithSameDate;
        }
        return nearestParentBooking;
    }

    private static long getResetTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    protected static void deleteHigherPositionedBookings(CmStatement s, CmPage p, int pos) {
        SqlUpdate u;
        if (p != null) {
            u = DB.sqlUpdate("DELETE FROM cm_booking WHERE page_id=:page AND pos > :pos");
            u.setParameter("page", (Object)p.getId());
        } else {
            u = DB.sqlUpdate("DELETE FROM cm_booking WHERE statement_id=:statement AND pos > :pos");
            u.setParameter("statement", (Object)s.getId());
        }
        u.setParameter("pos", (Object)pos);
        u.execute();
    }

    protected static void storeStatistics(CmStatement s, CmPage p, BookingStatistics statistics) {
        if (p != null) {
            Update<CmCheck> update = DB.createUpdate(CmCheck.class, "UPDATE CmCheck SET checked=NULL WHERE statement=:stmt AND page IS NULL");
            update.setParameter("stmt", (Object)s.getId());
            update.execute();
            statistics.storeStatistics(p);
            List<CmPage> pages = CmPage.findByStatement(s, true);
            if (pages.size() > 1) {
                statistics = new BookingStatistics();
                for (CmPage cm : pages) {
                    if (cm.getId().equals(p.getId())) {
                        cm = p;
                    }
                    statistics.addPage(cm);
                }
            }
        }
        statistics.storeStatistics(s);
    }

    protected OutputStream openOutputStream(File file) throws IOException {
        return this.encrypt.openOutputStream(file);
    }

    public static java.util.Date startsWithYYYYMMDD(String reference) {
        if (reference != null && reference.length() > 8) {
            try {
                String dateString = reference.substring(0, 8);
                if (dateString.matches("2\\d{3}[01]\\d[0123]\\d")) {
                    return YYYYMMDD.get().parse(dateString);
                }
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public static CmStatement createStatement(String uniqueId, CmStatement.Type type, Account account) {
        return CmStatement.createStatement(uniqueId, type, account);
    }

    public static CmPage createPage(CmStatement statement) {
        CmPage page = new CmPage();
        page.setStatement(statement);
        return page;
    }

    public static CmPage createPageFromStatement(CmStatement c) {
        CmPage first = new CmPage();
        first.setClosingBalance(c.getClosingBalance());
        first.setClosingDate(c.getClosingDate());
        first.setClosingFinal(c.isClosingFinal());
        first.setCountCredit(c.getCountCredit());
        first.setCountDebit(c.getCountDebit());
        first.setCreationDate(c.getCreationDate());
        first.setPageNumber(c.getPageNumber());
        first.setCurrency(c.getCurrency());
        first.setFile(c.getFile());
        first.setMaxCredit(c.getMaxCredit());
        first.setMaxDebit(c.getMaxDebit());
        first.setMinCredit(c.getMinCredit());
        first.setMinDebit(c.getMinDebit());
        first.setOpeningBalance(c.getOpeningBalance());
        first.setOpeningDate(c.getOpeningDate());
        first.setOpeningFinal(c.isOpeningFinal());
        first.setReference1(c.getReference1());
        first.setReference2(c.getReference2());
        first.setStatement(c);
        first.setSumCredit(c.getSumCredit());
        first.setSumDebit(c.getSumDebit());
        DB.save(first);
        c.setFile(null);
        DB.update(c);
        List list = DB.find(CmCheck.class).where().eq("statement", (Object)c).isNull("page").findList();
        if (!list.isEmpty()) {
            for (CmCheck check : list) {
                check.setPage(first);
                DB.update(check);
                CmCheck check2 = new CmCheck();
                check2.setChecked(check.isGrayed() ? null : Boolean.valueOf(check.isChecked()));
                check2.setLogin(check.getLogin());
                check2.setStatement(c);
                DB.save(check2);
            }
        }
        SqlUpdate u = DB.sqlUpdate("UPDATE cm_booking SET page_id=:page WHERE statement_id=:statement");
        u.setParameter("page", (Object)first.getId());
        u.setParameter("statement", (Object)c.getId());
        u.execute();
        return first;
    }

    private static class MyConsumer
    implements Consumer<CmStatement> {
        long smallestDifference;
        final BigDecimal amount;
        final boolean doAmountCheck;
        final long referenceDate;
        CmStatement nearestDtiFile;

        public MyConsumer(boolean doAmountCheck, long smallestDifference, long referenceDate, BigDecimal amount) {
            this.smallestDifference = smallestDifference;
            this.amount = amount;
            this.doAmountCheck = doAmountCheck;
            this.referenceDate = referenceDate;
        }

        @Override
        public void accept(CmStatement dtiFile) {
            BigDecimal dtiAmount = dtiFile.getTotalSum();
            if (!this.doAmountCheck || dtiAmount != null && dtiAmount.compareTo(this.amount) == 0) {
                long difference = Math.abs(this.referenceDate - CMProcessingDb.getResetTime(dtiFile.getCreationDate().getTime()));
                if (this.nearestDtiFile == null || difference < this.smallestDifference) {
                    this.nearestDtiFile = dtiFile;
                    this.smallestDifference = difference;
                }
            }
        }
    }
}

