/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.mt940.api.CFONB120Processing;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.Camt052Processing;
import de.businesslogics.banking.mt940.api.Camt053Processing;
import de.businesslogics.banking.mt940.api.Camt054AdviceProcessing;
import de.businesslogics.banking.mt940.api.Camt054ProcessingApi;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.banking.mt940.api.MT942Processing;
import de.businesslogics.banking.mt940.report.api.StatementBookingReportHandler;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;

public abstract class CMPostProcessing
implements Processing {
    protected CmReporter reporter;
    protected final BLLogger logger;
    protected final EncryptData encrypt;
    protected final DatabasePreferenceStore preferences;
    private Locale locale;
    private boolean workDone = false;

    public CMPostProcessing(CmReporter reporter, BLLogger logger, EncryptData encrypt, DatabasePreferenceStore preferences) {
        this.reporter = reporter;
        this.logger = logger;
        this.encrypt = encrypt;
        this.preferences = preferences;
        this.locale = Locale.getDefault();
    }

    @Override
    public void doPostProcessing(Fetch item) throws Exception {
        if (item == null) {
            return;
        }
        String fetchType = item.getFetchType();
        if (fetchType == null) {
            return;
        }
        BankSettings bank = item.getBank();
        CMBank cmBank = CMBank.get(bank);
        if (!(fetchType.equals(cmBank.getStatementFetchType()) || fetchType.equals(cmBank.getAdviceFetchType()) || fetchType.equals(cmBank.getCreditAdviceFetchType()) || fetchType.equals(cmBank.getC54FetchType()))) {
            return;
        }
        boolean isMyOwnReporter = false;
        if (this.reporter == null) {
            isMyOwnReporter = true;
            CmReporter.Mode mode = CmReporter.Mode.FETCH_STATEMENT;
            if (fetchType.equals(cmBank.getAdviceFetchType()) || fetchType.equals(cmBank.getCreditAdviceFetchType())) {
                mode = CmReporter.Mode.FETCH_ADVICE;
            } else if (fetchType.equals(cmBank.getC54FetchType())) {
                mode = CmReporter.Mode.FETCH_DTI;
            }
            this.reporter = this.getNewReporter(mode);
        }
        Util.writeCMStatisticLog(this.logger);
        long startTime = System.currentTimeMillis();
        ZipProcessingResult zipProcessingResult = null;
        try (Transaction t = DB.beginTransaction();){
            if (fetchType.equals(cmBank.getStatementFetchType())) {
                zipProcessingResult = this.doStatementProcessing(bank, cmBank.getStatementFormat(), item);
            } else if (fetchType.equals(cmBank.getAdviceFetchType())) {
                zipProcessingResult = this.doAdviceProcessing(bank, cmBank.getAdviceFormat(), item);
            } else if (fetchType.equals(cmBank.getCreditAdviceFetchType())) {
                zipProcessingResult = this.doCreditAdviceProcessing(bank, item);
            } else if (fetchType.equals(cmBank.getC54FetchType())) {
                this.reporter.format = "camt.054";
                zipProcessingResult = this.doCamt054Processing(bank, item);
            }
            Util.writePerformanceLogStartTime(this.logger, this.getClass(), "doPostProcessing-process", startTime);
            startTime = System.currentTimeMillis();
            t.commit();
            Util.writePerformanceLogStartTime(this.logger, this.getClass(), "doPostProcessing-commit", startTime);
            Util.writeCMStatisticLog(this.logger);
        }
        if (isMyOwnReporter) {
            this.reporter.finishProcessing(this.preferences.getBoolean(CmPreferenceConstants.DELETE_OLD_ADVICES));
        }
        this.workDone = true;
        if (zipProcessingResult != null && zipProcessingResult.hasErrors()) {
            zipProcessingResult.evaluateResult(this.logger, this.locale);
        }
    }

    protected abstract CmReporter getNewReporter(CmReporter.Mode var1);

    private ZipProcessingResult doStatementProcessing(BankSettings bank, CMBank.StatementFormat format, Fetch item) throws Exception {
        try (InputStream in = this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));){
            switch (format) {
                case MT940: {
                    new MT940Processing(bank, this.reporter, this.logger, this.encrypt, this.preferences).process(in);
                    ZipProcessingResult zipProcessingResult = null;
                    return zipProcessingResult;
                }
                case CAMT053: {
                    Camt053Processing processing = new Camt053Processing(bank, this.reporter, this.logger, this.encrypt, this.preferences);
                    processing.process(in);
                    ZipProcessingResult zipProcessingResult = processing.getProcessingResult();
                    return zipProcessingResult;
                }
                case CFONB120: {
                    new CFONB120Processing(bank, this.reporter, this.logger, this.encrypt, this.preferences).process(in);
                    ZipProcessingResult zipProcessingResult = null;
                    return zipProcessingResult;
                }
            }
            this.logger.logError("No processing for statement format '" + String.valueOf((Object)format) + "'", null);
            ZipProcessingResult zipProcessingResult = null;
            return zipProcessingResult;
        }
    }

    private ZipProcessingResult doAdviceProcessing(BankSettings bank, CMBank.AdviceFormat format, Fetch item) throws Exception {
        try (InputStream in = this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));){
            switch (format) {
                case MT942: {
                    new MT942Processing(bank, this.reporter, this.logger, this.encrypt, this.preferences).process(in);
                    ZipProcessingResult zipProcessingResult = null;
                    return zipProcessingResult;
                }
                case CAMT052: {
                    Camt052Processing processing = new Camt052Processing(bank, this.reporter, this.logger, this.encrypt, this.preferences);
                    processing.process(in);
                    ZipProcessingResult zipProcessingResult = processing.getProcessingResult();
                    return zipProcessingResult;
                }
            }
            this.logger.logError("No processing for statement format '" + String.valueOf((Object)format) + "'", null);
            ZipProcessingResult zipProcessingResult = null;
            return zipProcessingResult;
        }
    }

    private ZipProcessingResult doCreditAdviceProcessing(BankSettings bank, Fetch item) throws Exception {
        try (InputStream in = this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));){
            Camt054AdviceProcessing processing = new Camt054AdviceProcessing(bank, this.reporter, this.logger, this.encrypt, this.preferences);
            processing.process(in);
            ZipProcessingResult zipProcessingResult = processing.getProcessingResult();
            return zipProcessingResult;
        }
    }

    private ZipProcessingResult doCamt054Processing(BankSettings bank, Fetch item) throws Exception {
        try (InputStream in = this.encrypt.openInputStream(WorkspaceFileSystem.getFile(item.getFile()));){
            Camt054ProcessingApi processing = new Camt054ProcessingApi(bank, this.reporter, this.logger, this.encrypt, this.preferences, this.getReportHandlers());
            processing.process(in);
            ZipProcessingResult zipProcessingResult = processing.getProcessingResult();
            return zipProcessingResult;
        }
    }

    protected abstract List<StatementBookingReportHandler> getReportHandlers();

    public boolean isWorkDone() {
        return this.workDone;
    }
}

