/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.mt940.api;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.CmBooking;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.mt940.api.CMAccount;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CMCollection {
    private Set<CMAccount> accounts = new LinkedHashSet<CMAccount>();
    private Set<Account> dtiAccounts = new LinkedHashSet<Account>();
    private Set<CmStatement> statements = new LinkedHashSet<CmStatement>();
    private Set<CmPage> pages = new LinkedHashSet<CmPage>();
    private Map<CmStatement, Collection<CmBooking>> statementBookingMap = new LinkedHashMap<CmStatement, Collection<CmBooking>>();

    public static Map<BankSettings, CMCollection> splitPerBank(Set<CMAccount> accounts, Set<Account> dtiAccounts, Set<CmStatement> statements, Set<CmPage> pages, Map<CmStatement, Collection<CmBooking>> statementBookingMap) {
        CMCollection c;
        BankSettings bank;
        LinkedHashMap<BankSettings, CMCollection> bankStatementCollectionMap = new LinkedHashMap<BankSettings, CMCollection>();
        if (accounts != null) {
            for (CMAccount account : accounts) {
                bank = account.getAccount().getBank();
                c = (CMCollection)bankStatementCollectionMap.get(bank);
                if (c == null) {
                    c = new CMCollection();
                    bankStatementCollectionMap.put(bank, c);
                }
                c.accounts.add(account);
            }
        }
        if (dtiAccounts != null) {
            for (Account a : dtiAccounts) {
                bank = a.getBank();
                c = (CMCollection)bankStatementCollectionMap.get(bank);
                if (c == null) {
                    c = new CMCollection();
                    bankStatementCollectionMap.put(bank, c);
                }
                c.dtiAccounts.add(a);
            }
        }
        if (statements != null) {
            for (CmStatement statement : statements) {
                bank = statement.getAccount().getBank();
                c = (CMCollection)bankStatementCollectionMap.get(bank);
                if (c == null) {
                    c = new CMCollection();
                    bankStatementCollectionMap.put(bank, c);
                }
                c.statements.add(statement);
            }
        }
        if (pages != null) {
            for (CmPage page : pages) {
                bank = page.getStatement().getAccount().getBank();
                c = (CMCollection)bankStatementCollectionMap.get(bank);
                if (c == null) {
                    c = new CMCollection();
                    bankStatementCollectionMap.put(bank, c);
                }
                c.pages.add(page);
            }
        }
        if (statementBookingMap != null) {
            for (CmStatement statement : statementBookingMap.keySet()) {
                bank = statement.getAccount().getBank();
                c = (CMCollection)bankStatementCollectionMap.get(bank);
                if (c == null) {
                    c = new CMCollection();
                    bankStatementCollectionMap.put(bank, c);
                }
                c.statementBookingMap.put(statement, statementBookingMap.get(statement));
            }
        }
        return bankStatementCollectionMap;
    }

    private CMCollection() {
    }

    public Set<CMAccount> getAccounts() {
        return this.accounts;
    }

    public Set<Account> getDtiAccounts() {
        return this.dtiAccounts;
    }

    public Set<CmStatement> getStatements() {
        return this.statements;
    }

    public Set<CmPage> getPages() {
        return this.pages;
    }

    public Map<CmStatement, Collection<CmBooking>> getStatementBookingMap() {
        return this.statementBookingMap;
    }
}

